/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Context;
import androidx.compose.ui.platform.AndroidClipboardManager_androidKt;
import androidx.compose.ui.platform.ClipboardManager;
import androidx.compose.ui.text.AnnotatedString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/compose/ui/platform/AndroidClipboardManager;", "Landroidx/compose/ui/platform/ClipboardManager;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "clipboardManager", "Landroid/content/ClipboardManager;", "(Landroid/content/ClipboardManager;)V", "getText", "Landroidx/compose/ui/text/AnnotatedString;", "hasText", "", "setText", "", "annotatedString", "ui_release"})
public final class AndroidClipboardManager
implements ClipboardManager {
    @NotNull
    private final android.content.ClipboardManager clipboardManager;

    public AndroidClipboardManager(@NotNull android.content.ClipboardManager clipboardManager) {
        Intrinsics.checkNotNullParameter((Object)clipboardManager, (String)"clipboardManager");
        this.clipboardManager = clipboardManager;
    }

    public AndroidClipboardManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("clipboard");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.ClipboardManager");
        this((android.content.ClipboardManager)object);
    }

    @Override
    public void setText(@NotNull AnnotatedString annotatedString) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"annotatedString");
        this.clipboardManager.setPrimaryClip(ClipData.newPlainText((CharSequence)"plain text", (CharSequence)AndroidClipboardManager_androidKt.convertToCharSequence(annotatedString)));
    }

    @Override
    @Nullable
    public AnnotatedString getText() {
        AnnotatedString annotatedString;
        ClipData clipData = this.clipboardManager.getPrimaryClip();
        if (clipData != null) {
            ClipData primaryClip = clipData;
            boolean bl = false;
            if (primaryClip.getItemCount() > 0) {
                ClipData.Item item = primaryClip.getItemAt(0);
                annotatedString = AndroidClipboardManager_androidKt.convertToAnnotatedString(item != null ? item.getText() : null);
            } else {
                annotatedString = null;
            }
        } else {
            annotatedString = null;
        }
        return annotatedString;
    }

    @Override
    public boolean hasText() {
        ClipDescription clipDescription = this.clipboardManager.getPrimaryClipDescription();
        return clipDescription != null ? clipDescription.hasMimeType("text/*") : false;
    }
}

