/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import android.os.Build;
import android.util.SparseBooleanArray;
import android.util.SparseLongArray;
import android.view.MotionEvent;
import androidx.annotation.VisibleForTesting;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.MotionEventHelper;
import androidx.compose.ui.input.pointer.PointerId;
import androidx.compose.ui.input.pointer.PointerInputEvent;
import androidx.compose.ui.input.pointer.PointerInputEventData;
import androidx.compose.ui.input.pointer.PointerType;
import androidx.compose.ui.input.pointer.PositionCalculator;
import androidx.compose.ui.input.pointer.util.VelocityTrackerKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ(\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0010J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0010H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010(\u001a\u00020\u001f*\u00020\u00152\u0006\u0010!\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Landroidx/compose/ui/input/pointer/MotionEventAdapter;", "", "()V", "canHover", "Landroid/util/SparseBooleanArray;", "motionEventToComposePointerIdMap", "Landroid/util/SparseLongArray;", "getMotionEventToComposePointerIdMap$ui_release$annotations", "getMotionEventToComposePointerIdMap$ui_release", "()Landroid/util/SparseLongArray;", "nextId", "", "pointers", "", "Landroidx/compose/ui/input/pointer/PointerInputEventData;", "previousSource", "", "previousToolType", "addFreshIds", "", "motionEvent", "Landroid/view/MotionEvent;", "clearOnDeviceChange", "convertToPointerInputEvent", "Landroidx/compose/ui/input/pointer/PointerInputEvent;", "positionCalculator", "Landroidx/compose/ui/input/pointer/PositionCalculator;", "convertToPointerInputEvent$ui_release", "createPointerInputEventData", "index", "pressed", "", "endStream", "pointerId", "getComposePointerId", "Landroidx/compose/ui/input/pointer/PointerId;", "motionEventPointerId", "getComposePointerId-_I2yYro", "(I)J", "removeStaleIds", "hasPointerId", "ui_release"})
public final class MotionEventAdapter {
    private long nextId;
    @NotNull
    private final SparseLongArray motionEventToComposePointerIdMap = new SparseLongArray();
    @NotNull
    private final SparseBooleanArray canHover = new SparseBooleanArray();
    @NotNull
    private final List<PointerInputEventData> pointers = new ArrayList();
    private int previousToolType = -1;
    private int previousSource = -1;

    @NotNull
    public final SparseLongArray getMotionEventToComposePointerIdMap$ui_release() {
        return this.motionEventToComposePointerIdMap;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMotionEventToComposePointerIdMap$ui_release$annotations() {
    }

    @Nullable
    public final PointerInputEvent convertToPointerInputEvent$ui_release(@NotNull MotionEvent motionEvent, @NotNull PositionCalculator positionCalculator) {
        int n;
        boolean isScroll;
        Intrinsics.checkNotNullParameter((Object)motionEvent, (String)"motionEvent");
        Intrinsics.checkNotNullParameter((Object)positionCalculator, (String)"positionCalculator");
        int action = motionEvent.getActionMasked();
        if (action == 3) {
            this.motionEventToComposePointerIdMap.clear();
            this.canHover.clear();
            return null;
        }
        this.clearOnDeviceChange(motionEvent);
        this.addFreshIds(motionEvent);
        boolean isHover = action == 10 || action == 7 || action == 9;
        boolean bl = isScroll = action == 8;
        if (isHover) {
            int hoverId = motionEvent.getPointerId(motionEvent.getActionIndex());
            this.canHover.put(hoverId, true);
        }
        switch (action) {
            case 1: {
                n = 0;
                break;
            }
            case 6: {
                n = motionEvent.getActionIndex();
                break;
            }
            default: {
                n = -1;
            }
        }
        int upIndex = n;
        this.pointers.clear();
        int n2 = motionEvent.getPointerCount();
        for (int i = 0; i < n2; ++i) {
            this.pointers.add(this.createPointerInputEventData(positionCalculator, motionEvent, i, !isHover && i != upIndex && (!isScroll || motionEvent.getButtonState() != 0)));
        }
        this.removeStaleIds(motionEvent);
        return new PointerInputEvent(motionEvent.getEventTime(), this.pointers, motionEvent);
    }

    public final void endStream(int pointerId) {
        this.canHover.delete(pointerId);
        this.motionEventToComposePointerIdMap.delete(pointerId);
    }

    private final void addFreshIds(MotionEvent motionEvent) {
        switch (motionEvent.getActionMasked()) {
            case 9: {
                int pointerId = motionEvent.getPointerId(0);
                if (this.motionEventToComposePointerIdMap.indexOfKey(pointerId) >= 0) break;
                long l = this.nextId;
                this.nextId = l + 1L;
                this.motionEventToComposePointerIdMap.put(pointerId, l);
                break;
            }
            case 0: 
            case 5: {
                int actionIndex = motionEvent.getActionIndex();
                int pointerId = motionEvent.getPointerId(actionIndex);
                if (this.motionEventToComposePointerIdMap.indexOfKey(pointerId) >= 0) break;
                long l = this.nextId;
                this.nextId = l + 1L;
                this.motionEventToComposePointerIdMap.put(pointerId, l);
                if (motionEvent.getToolType(actionIndex) != 3) break;
                this.canHover.put(pointerId, true);
            }
        }
    }

    private final void removeStaleIds(MotionEvent motionEvent) {
        switch (motionEvent.getActionMasked()) {
            case 1: 
            case 6: {
                int actionIndex = motionEvent.getActionIndex();
                int pointerId = motionEvent.getPointerId(actionIndex);
                if (this.canHover.get(pointerId, false)) break;
                this.motionEventToComposePointerIdMap.delete(pointerId);
                this.canHover.delete(pointerId);
            }
        }
        if (this.motionEventToComposePointerIdMap.size() > motionEvent.getPointerCount()) {
            for (int i = this.motionEventToComposePointerIdMap.size() - 1; -1 < i; --i) {
                int pointerId = this.motionEventToComposePointerIdMap.keyAt(i);
                if (this.hasPointerId(motionEvent, pointerId)) continue;
                this.motionEventToComposePointerIdMap.removeAt(i);
                this.canHover.delete(pointerId);
            }
        }
    }

    private final boolean hasPointerId(MotionEvent $this$hasPointerId, int pointerId) {
        int n = $this$hasPointerId.getPointerCount();
        for (int i = 0; i < n; ++i) {
            if ($this$hasPointerId.getPointerId(i) != pointerId) continue;
            return true;
        }
        return false;
    }

    private final long getComposePointerId-_I2yYro(int motionEventPointerId) {
        long l;
        int pointerIndex = this.motionEventToComposePointerIdMap.indexOfKey(motionEventPointerId);
        if (pointerIndex >= 0) {
            l = this.motionEventToComposePointerIdMap.valueAt(pointerIndex);
        } else {
            long l2 = this.nextId;
            this.nextId = l2 + 1L;
            long newId = l2;
            this.motionEventToComposePointerIdMap.put(motionEventPointerId, newId);
            l = newId;
        }
        long id = l;
        return PointerId.constructor-impl(id);
    }

    private final void clearOnDeviceChange(MotionEvent motionEvent) {
        if (motionEvent.getPointerCount() != 1) {
            return;
        }
        int toolType = motionEvent.getToolType(0);
        int source = motionEvent.getSource();
        if (toolType != this.previousToolType || source != this.previousSource) {
            this.previousToolType = toolType;
            this.previousSource = source;
            this.canHover.clear();
            this.motionEventToComposePointerIdMap.clear();
        }
    }

    private final PointerInputEventData createPointerInputEventData(PositionCalculator positionCalculator, MotionEvent motionEvent, int index, boolean pressed) {
        long l;
        int n;
        int motionEventPointerId = motionEvent.getPointerId(index);
        long pointerId = this.getComposePointerId-_I2yYro(motionEventPointerId);
        float pressure = motionEvent.getPressure(index);
        long position = OffsetKt.Offset((float)motionEvent.getX(index), (float)motionEvent.getY(index));
        long rawPosition = 0L;
        if (index == 0) {
            rawPosition = OffsetKt.Offset((float)motionEvent.getRawX(), (float)motionEvent.getRawY());
            position = positionCalculator.screenToLocal-MK-Hz9U(rawPosition);
        } else if (Build.VERSION.SDK_INT >= 29) {
            rawPosition = MotionEventHelper.INSTANCE.toRawOffset-dBAh8RU(motionEvent, index);
            position = positionCalculator.screenToLocal-MK-Hz9U(rawPosition);
        } else {
            rawPosition = positionCalculator.localToScreen-MK-Hz9U(position);
        }
        switch (motionEvent.getToolType(index)) {
            case 0: {
                n = PointerType.Companion.getUnknown-T8wyACA();
                break;
            }
            case 1: {
                n = PointerType.Companion.getTouch-T8wyACA();
                break;
            }
            case 2: {
                n = PointerType.Companion.getStylus-T8wyACA();
                break;
            }
            case 3: {
                n = PointerType.Companion.getMouse-T8wyACA();
                break;
            }
            case 4: {
                n = PointerType.Companion.getEraser-T8wyACA();
                break;
            }
            default: {
                n = PointerType.Companion.getUnknown-T8wyACA();
            }
        }
        int toolType = n;
        ArrayList<HistoricalChange> historical = new ArrayList<HistoricalChange>(motionEvent.getHistorySize());
        MotionEvent $this$createPointerInputEventData_u24lambda_u241 = motionEvent;
        boolean bl = false;
        int n2 = $this$createPointerInputEventData_u24lambda_u241.getHistorySize();
        for (int i = 0; i < n2; ++i) {
            int pos = i;
            boolean bl2 = false;
            float x = $this$createPointerInputEventData_u24lambda_u241.getHistoricalX(index, pos);
            float y = $this$createPointerInputEventData_u24lambda_u241.getHistoricalY(index, pos);
            float f = x;
            if (!(!Float.isInfinite(f) && !Float.isNaN(f)) || !(!Float.isInfinite(f = y) && !Float.isNaN(f))) continue;
            HistoricalChange historicalChange = new HistoricalChange($this$createPointerInputEventData_u24lambda_u241.getHistoricalEventTime(pos), VelocityTrackerKt.getVelocityTrackerAddPointsFix() ? positionCalculator.screenToLocal-MK-Hz9U(OffsetKt.Offset((float)x, (float)y)) : OffsetKt.Offset((float)x, (float)y), null);
            historical.add(historicalChange);
        }
        if (motionEvent.getActionMasked() == 8) {
            float x = motionEvent.getAxisValue(10);
            float y = motionEvent.getAxisValue(9);
            l = OffsetKt.Offset((float)x, (float)(-y + 0.0f));
        } else {
            l = Offset.Companion.getZero-F1C5BW0();
        }
        long scrollDelta = l;
        boolean issuesEnterExit = this.canHover.get(motionEvent.getPointerId(index), false);
        return new PointerInputEventData(pointerId, motionEvent.getEventTime(), rawPosition, position, pressed, pressure, toolType, issuesEnterExit, historical, scrollDelta, null);
    }
}

