/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.viewinterop;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Build;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.compose.runtime.ComposeNodeLifecycleCallback;
import androidx.compose.runtime.CompositionContext;
import androidx.compose.runtime.snapshots.SnapshotStateObserver;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.draw.DrawModifierKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.graphics.AndroidCanvas_androidKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.input.nestedscroll.NestedScrollDispatcher;
import androidx.compose.ui.input.nestedscroll.NestedScrollModifierKt;
import androidx.compose.ui.input.pointer.PointerInteropFilter_androidKt;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasurePolicy;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.OnGloballyPositionedModifierKt;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.platform.AndroidComposeView;
import androidx.compose.ui.platform.NestedScrollInteropConnectionKt;
import androidx.compose.ui.platform.WindowRecomposer_androidKt;
import androidx.compose.ui.semantics.SemanticsModifierKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.compose.ui.unit.Velocity;
import androidx.compose.ui.unit.VelocityKt;
import androidx.compose.ui.viewinterop.AndroidViewHolder;
import androidx.compose.ui.viewinterop.AndroidViewHolder_androidKt;
import androidx.core.view.NestedScrollingParent3;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewTreeLifecycleOwner;
import androidx.savedstate.SavedStateRegistryOwner;
import androidx.savedstate.ViewTreeSavedStateRegistryOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0007\n\u0002\b\u0019\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010V\u001a\u00020\u00172\b\u0010W\u001a\u0004\u0018\u00010XH\u0016J\u000e\u0010Y\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`ZJ\n\u0010[\u001a\u0004\u0018\u00010\\H\u0016J\b\u0010]\u001a\u00020\tH\u0016J\u001e\u0010^\u001a\u0004\u0018\u00010_2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010`\u001a\u0004\u0018\u00010aH\u0016J\u0006\u0010b\u001a\u000201J\b\u0010c\u001a\u00020\u0017H\u0016J \u0010d\u001a\u00020\t2\u0006\u0010e\u001a\u00020\t2\u0006\u0010f\u001a\u00020\t2\u0006\u0010g\u001a\u00020\tH\u0002J\b\u0010h\u001a\u000201H\u0014J\b\u0010i\u001a\u000201H\u0016J\u0018\u0010j\u001a\u0002012\u0006\u0010k\u001a\u00020\r2\u0006\u0010l\u001a\u00020\rH\u0016J\b\u0010m\u001a\u000201H\u0014J0\u0010n\u001a\u0002012\u0006\u0010o\u001a\u00020\u00172\u0006\u0010p\u001a\u00020\t2\u0006\u0010q\u001a\u00020\t2\u0006\u0010r\u001a\u00020\t2\u0006\u0010s\u001a\u00020\tH\u0014J\u0018\u0010t\u001a\u0002012\u0006\u0010u\u001a\u00020\t2\u0006\u0010v\u001a\u00020\tH\u0014J(\u0010w\u001a\u00020\u00172\u0006\u0010l\u001a\u00020\r2\u0006\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020y2\u0006\u0010{\u001a\u00020\u0017H\u0016J \u0010|\u001a\u00020\u00172\u0006\u0010l\u001a\u00020\r2\u0006\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020yH\u0016J1\u0010}\u001a\u0002012\u0006\u0010l\u001a\u00020\r2\u0006\u0010~\u001a\u00020\t2\u0006\u0010\u007f\u001a\u00020\t2\u0006\u0010{\u001a\u00020&2\u0007\u0010\u0080\u0001\u001a\u00020\tH\u0016J>\u0010\u0081\u0001\u001a\u0002012\u0006\u0010l\u001a\u00020\r2\u0007\u0010\u0082\u0001\u001a\u00020\t2\u0007\u0010\u0083\u0001\u001a\u00020\t2\u0007\u0010\u0084\u0001\u001a\u00020\t2\u0007\u0010\u0085\u0001\u001a\u00020\t2\u0007\u0010\u0080\u0001\u001a\u00020\tH\u0016JF\u0010\u0081\u0001\u001a\u0002012\u0006\u0010l\u001a\u00020\r2\u0007\u0010\u0082\u0001\u001a\u00020\t2\u0007\u0010\u0083\u0001\u001a\u00020\t2\u0007\u0010\u0084\u0001\u001a\u00020\t2\u0007\u0010\u0085\u0001\u001a\u00020\t2\u0007\u0010\u0080\u0001\u001a\u00020\t2\u0006\u0010{\u001a\u00020&H\u0016J+\u0010\u0086\u0001\u001a\u0002012\u0006\u0010k\u001a\u00020\r2\u0006\u0010l\u001a\u00020\r2\u0007\u0010\u0087\u0001\u001a\u00020\t2\u0007\u0010\u0080\u0001\u001a\u00020\tH\u0016J\t\u0010\u0088\u0001\u001a\u000201H\u0016J\t\u0010\u0089\u0001\u001a\u000201H\u0016J+\u0010\u008a\u0001\u001a\u00020\u00172\u0006\u0010k\u001a\u00020\r2\u0006\u0010l\u001a\u00020\r2\u0007\u0010\u0087\u0001\u001a\u00020\t2\u0007\u0010\u0080\u0001\u001a\u00020\tH\u0016J\u001a\u0010\u008b\u0001\u001a\u0002012\u0006\u0010l\u001a\u00020\r2\u0007\u0010\u0080\u0001\u001a\u00020\tH\u0016J\u0012\u0010\u008c\u0001\u001a\u0002012\u0007\u0010\u008d\u0001\u001a\u00020\tH\u0014J\u0007\u0010\u008e\u0001\u001a\u000201J\u0012\u0010\u008f\u0001\u001a\u0002012\u0007\u0010\u0090\u0001\u001a\u00020\u0017H\u0016J\t\u0010\u0091\u0001\u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR(\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020'@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020100X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u000201\u0018\u000100X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R(\u00107\u001a\u0010\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u000201\u0018\u000100X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00104\"\u0004\b9\u00106R(\u0010:\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u000201\u0018\u000100X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00104\"\u0004\b<\u00106R0\u0010?\u001a\b\u0012\u0004\u0012\u0002010>2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002010>@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR0\u0010D\u001a\b\u0012\u0004\u0012\u0002010>2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002010>@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010A\"\u0004\bF\u0010CR\u0014\u0010G\u001a\b\u0012\u0004\u0012\u0002010>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010H\u001a\b\u0012\u0004\u0012\u0002010>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010J\u001a\u0004\u0018\u00010I2\b\u0010\u000f\u001a\u0004\u0018\u00010I@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u000e\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010Q\u001a\b\u0012\u0004\u0012\u0002010>2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002010>@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010A\"\u0004\bS\u0010CR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010U\u00a8\u0006\u0092\u0001"}, d2={"Landroidx/compose/ui/viewinterop/AndroidViewHolder;", "Landroid/view/ViewGroup;", "Landroidx/core/view/NestedScrollingParent3;", "Landroidx/compose/runtime/ComposeNodeLifecycleCallback;", "context", "Landroid/content/Context;", "parentContext", "Landroidx/compose/runtime/CompositionContext;", "compositeKeyHash", "", "dispatcher", "Landroidx/compose/ui/input/nestedscroll/NestedScrollDispatcher;", "view", "Landroid/view/View;", "(Landroid/content/Context;Landroidx/compose/runtime/CompositionContext;ILandroidx/compose/ui/input/nestedscroll/NestedScrollDispatcher;Landroid/view/View;)V", "value", "Landroidx/compose/ui/unit/Density;", "density", "getDensity", "()Landroidx/compose/ui/unit/Density;", "setDensity", "(Landroidx/compose/ui/unit/Density;)V", "hasUpdateBlock", "", "isDrawing", "lastHeightMeasureSpec", "lastWidthMeasureSpec", "layoutNode", "Landroidx/compose/ui/node/LayoutNode;", "getLayoutNode", "()Landroidx/compose/ui/node/LayoutNode;", "Landroidx/lifecycle/LifecycleOwner;", "lifecycleOwner", "getLifecycleOwner", "()Landroidx/lifecycle/LifecycleOwner;", "setLifecycleOwner", "(Landroidx/lifecycle/LifecycleOwner;)V", "location", "", "Landroidx/compose/ui/Modifier;", "modifier", "getModifier", "()Landroidx/compose/ui/Modifier;", "setModifier", "(Landroidx/compose/ui/Modifier;)V", "nestedScrollingParentHelper", "Landroidx/core/view/NestedScrollingParentHelper;", "onCommitAffectingUpdate", "Lkotlin/Function1;", "", "onDensityChanged", "getOnDensityChanged$ui_release", "()Lkotlin/jvm/functions/Function1;", "setOnDensityChanged$ui_release", "(Lkotlin/jvm/functions/Function1;)V", "onModifierChanged", "getOnModifierChanged$ui_release", "setOnModifierChanged$ui_release", "onRequestDisallowInterceptTouchEvent", "getOnRequestDisallowInterceptTouchEvent$ui_release", "setOnRequestDisallowInterceptTouchEvent$ui_release", "<set-?>", "Lkotlin/Function0;", "release", "getRelease", "()Lkotlin/jvm/functions/Function0;", "setRelease", "(Lkotlin/jvm/functions/Function0;)V", "reset", "getReset", "setReset", "runInvalidate", "runUpdate", "Landroidx/savedstate/SavedStateRegistryOwner;", "savedStateRegistryOwner", "getSavedStateRegistryOwner", "()Landroidx/savedstate/SavedStateRegistryOwner;", "setSavedStateRegistryOwner", "(Landroidx/savedstate/SavedStateRegistryOwner;)V", "snapshotObserver", "Landroidx/compose/runtime/snapshots/SnapshotStateObserver;", "update", "getUpdate", "setUpdate", "getView", "()Landroid/view/View;", "gatherTransparentRegion", "region", "Landroid/graphics/Region;", "getInteropView", "Landroidx/compose/ui/viewinterop/InteropView;", "getLayoutParams", "Landroid/view/ViewGroup$LayoutParams;", "getNestedScrollAxes", "invalidateChildInParent", "Landroid/view/ViewParent;", "dirty", "Landroid/graphics/Rect;", "invalidateOrDefer", "isNestedScrollingEnabled", "obtainMeasureSpec", "min", "max", "preferred", "onAttachedToWindow", "onDeactivate", "onDescendantInvalidated", "child", "target", "onDetachedFromWindow", "onLayout", "changed", "l", "t", "r", "b", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onNestedFling", "velocityX", "", "velocityY", "consumed", "onNestedPreFling", "onNestedPreScroll", "dx", "dy", "type", "onNestedScroll", "dxConsumed", "dyConsumed", "dxUnconsumed", "dyUnconsumed", "onNestedScrollAccepted", "axes", "onRelease", "onReuse", "onStartNestedScroll", "onStopNestedScroll", "onWindowVisibilityChanged", "visibility", "remeasure", "requestDisallowInterceptTouchEvent", "disallowIntercept", "shouldDelayChildPressedState", "ui_release"})
public class AndroidViewHolder
extends ViewGroup
implements NestedScrollingParent3,
ComposeNodeLifecycleCallback {
    private final int compositeKeyHash;
    @NotNull
    private final NestedScrollDispatcher dispatcher;
    @NotNull
    private final View view;
    @NotNull
    private Function0<Unit> update;
    private boolean hasUpdateBlock;
    @NotNull
    private Function0<Unit> reset;
    @NotNull
    private Function0<Unit> release;
    @NotNull
    private Modifier modifier;
    @Nullable
    private Function1<? super Modifier, Unit> onModifierChanged;
    @NotNull
    private Density density;
    @Nullable
    private Function1<? super Density, Unit> onDensityChanged;
    @Nullable
    private LifecycleOwner lifecycleOwner;
    @Nullable
    private SavedStateRegistryOwner savedStateRegistryOwner;
    @NotNull
    private final SnapshotStateObserver snapshotObserver;
    @NotNull
    private final Function1<AndroidViewHolder, Unit> onCommitAffectingUpdate;
    @NotNull
    private final Function0<Unit> runUpdate;
    @NotNull
    private final Function0<Unit> runInvalidate;
    @Nullable
    private Function1<? super Boolean, Unit> onRequestDisallowInterceptTouchEvent;
    @NotNull
    private final int[] location;
    private int lastWidthMeasureSpec;
    private int lastHeightMeasureSpec;
    @NotNull
    private final NestedScrollingParentHelper nestedScrollingParentHelper;
    private boolean isDrawing;
    @NotNull
    private final LayoutNode layoutNode;

    /*
     * WARNING - void declaration
     */
    public AndroidViewHolder(@NotNull Context context, @Nullable CompositionContext parentContext, int compositeKeyHash, @NotNull NestedScrollDispatcher dispatcher2, @NotNull View view) {
        void $this$layoutNode_u24lambda_u242;
        Object it;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dispatcher2, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super(context);
        this.compositeKeyHash = compositeKeyHash;
        this.dispatcher = dispatcher2;
        this.view = view;
        CompositionContext compositionContext = parentContext;
        if (compositionContext != null) {
            it = compositionContext;
            boolean bl = false;
            WindowRecomposer_androidKt.setCompositionContext((View)this, it);
        }
        this.setSaveFromParentEnabled(false);
        this.addView(this.view);
        this.update = update.1.INSTANCE;
        this.reset = reset.1.INSTANCE;
        this.release = release.1.INSTANCE;
        this.modifier = Modifier.Companion;
        this.density = DensityKt.Density$default((float)1.0f, (float)0.0f, (int)2, null);
        this.snapshotObserver = new SnapshotStateObserver((Function1)new Function1<Function0<? extends Unit>, Unit>(this){
            final /* synthetic */ AndroidViewHolder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Function0<Unit> command) {
                Intrinsics.checkNotNullParameter(command, (String)"command");
                if (this.this$0.getHandler().getLooper() == Looper.myLooper()) {
                    command.invoke();
                } else {
                    this.this$0.getHandler().post(() -> snapshotObserver.1.invoke$lambda$0(command));
                }
            }

            private static final void invoke$lambda$0(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke();
            }
        });
        this.onCommitAffectingUpdate = (Function1)new Function1<AndroidViewHolder, Unit>(this){
            final /* synthetic */ AndroidViewHolder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AndroidViewHolder it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                this.this$0.getHandler().post(() -> onCommitAffectingUpdate.1.invoke$lambda$0(AndroidViewHolder.access$getRunUpdate$p(this.this$0)));
            }

            private static final void invoke$lambda$0(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke();
            }
        };
        this.runUpdate = (Function0)new Function0<Unit>(this){
            final /* synthetic */ AndroidViewHolder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (AndroidViewHolder.access$getHasUpdateBlock$p(this.this$0)) {
                    AndroidViewHolder.access$getSnapshotObserver$p(this.this$0).observeReads((Object)((Object)this.this$0), AndroidViewHolder.access$getOnCommitAffectingUpdate$p(this.this$0), this.this$0.getUpdate());
                }
            }
        };
        this.runInvalidate = (Function0)new Function0<Unit>(this){
            final /* synthetic */ AndroidViewHolder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getLayoutNode().invalidateLayer$ui_release();
            }
        };
        this.location = new int[2];
        this.lastWidthMeasureSpec = Integer.MIN_VALUE;
        this.lastHeightMeasureSpec = Integer.MIN_VALUE;
        this.nestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        it = this;
        AndroidViewHolder androidViewHolder = this;
        boolean bl = false;
        LayoutNode layoutNode2 = new LayoutNode(false, 0, 3, null);
        layoutNode2.setInteropViewFactoryHolder$ui_release(this);
        Modifier coreModifier2 = OnGloballyPositionedModifierKt.onGloballyPositioned(DrawModifierKt.drawBehind(PointerInteropFilter_androidKt.pointerInteropFilter(SemanticsModifierKt.semantics(NestedScrollModifierKt.nestedScroll(Modifier.Companion, AndroidViewHolder_androidKt.access$getNoOpScrollConnection$p(), $this$layoutNode_u24lambda_u242.dispatcher), true, (Function1<? super SemanticsPropertyReceiver, Unit>)((Function1)layoutNode.1.coreModifier.1.INSTANCE)), (AndroidViewHolder)$this$layoutNode_u24lambda_u242), (Function1<? super DrawScope, Unit>)((Function1)new Function1<DrawScope, Unit>((AndroidViewHolder)$this$layoutNode_u24lambda_u242, layoutNode2, this){
            final /* synthetic */ AndroidViewHolder $this_run;
            final /* synthetic */ LayoutNode $layoutNode;
            final /* synthetic */ AndroidViewHolder this$0;
            {
                this.$this_run = $receiver;
                this.$layoutNode = $layoutNode;
                this.this$0 = $receiver2;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DrawScope $this$drawBehind) {
                AndroidComposeView androidComposeView;
                void $this$drawIntoCanvas$iv;
                Intrinsics.checkNotNullParameter((Object)$this$drawBehind, (String)"$this$drawBehind");
                DrawScope drawScope = $this$drawBehind;
                AndroidViewHolder androidViewHolder = this.$this_run;
                LayoutNode layoutNode2 = this.$layoutNode;
                AndroidViewHolder androidViewHolder2 = this.this$0;
                boolean $i$f$drawIntoCanvas = false;
                Canvas canvas = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
                boolean bl = false;
                AndroidViewHolder.access$setDrawing$p(androidViewHolder, true);
                Owner owner = layoutNode2.getOwner$ui_release();
                AndroidComposeView androidComposeView2 = androidComposeView = owner instanceof AndroidComposeView ? (AndroidComposeView)owner : null;
                if (androidComposeView != null) {
                    androidComposeView.drawAndroidView(androidViewHolder2, AndroidCanvas_androidKt.getNativeCanvas((Canvas)canvas));
                }
                AndroidViewHolder.access$setDrawing$p(androidViewHolder, false);
            }
        })), (Function1<? super LayoutCoordinates, Unit>)((Function1)new Function1<LayoutCoordinates, Unit>((AndroidViewHolder)$this$layoutNode_u24lambda_u242, layoutNode2){
            final /* synthetic */ AndroidViewHolder $this_run;
            final /* synthetic */ LayoutNode $layoutNode;
            {
                this.$this_run = $receiver;
                this.$layoutNode = $layoutNode;
                super(1);
            }

            public final void invoke(@NotNull LayoutCoordinates it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AndroidViewHolder_androidKt.access$layoutAccordingTo((View)this.$this_run, this.$layoutNode);
            }
        }));
        layoutNode2.setCompositeKeyHash($this$layoutNode_u24lambda_u242.compositeKeyHash);
        layoutNode2.setModifier($this$layoutNode_u24lambda_u242.modifier.then(coreModifier2));
        $this$layoutNode_u24lambda_u242.onModifierChanged = (Function1)new Function1<Modifier, Unit>(layoutNode2, coreModifier2){
            final /* synthetic */ LayoutNode $layoutNode;
            final /* synthetic */ Modifier $coreModifier;
            {
                this.$layoutNode = $layoutNode;
                this.$coreModifier = $coreModifier;
                super(1);
            }

            public final void invoke(@NotNull Modifier it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$layoutNode.setModifier(it.then(this.$coreModifier));
            }
        };
        layoutNode2.setDensity($this$layoutNode_u24lambda_u242.density);
        $this$layoutNode_u24lambda_u242.onDensityChanged = (Function1)new Function1<Density, Unit>(layoutNode2){
            final /* synthetic */ LayoutNode $layoutNode;
            {
                this.$layoutNode = $layoutNode;
                super(1);
            }

            public final void invoke(@NotNull Density it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$layoutNode.setDensity(it);
            }
        };
        layoutNode2.setOnAttach$ui_release((Function1<? super Owner, Unit>)((Function1)new Function1<Owner, Unit>((AndroidViewHolder)$this$layoutNode_u24lambda_u242, layoutNode2){
            final /* synthetic */ AndroidViewHolder $this_run;
            final /* synthetic */ LayoutNode $layoutNode;
            {
                this.$this_run = $receiver;
                this.$layoutNode = $layoutNode;
                super(1);
            }

            public final void invoke(@NotNull Owner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                AndroidComposeView androidComposeView = owner instanceof AndroidComposeView ? (AndroidComposeView)owner : null;
                if (androidComposeView != null) {
                    androidComposeView.addAndroidView(this.$this_run, this.$layoutNode);
                }
                if (this.$this_run.getView().getParent() != this.$this_run) {
                    this.$this_run.addView(this.$this_run.getView());
                }
            }
        }));
        layoutNode2.setOnDetach$ui_release((Function1<? super Owner, Unit>)((Function1)new Function1<Owner, Unit>((AndroidViewHolder)$this$layoutNode_u24lambda_u242){
            final /* synthetic */ AndroidViewHolder $this_run;
            {
                this.$this_run = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Owner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                AndroidComposeView androidComposeView = owner instanceof AndroidComposeView ? (AndroidComposeView)owner : null;
                if (androidComposeView != null) {
                    androidComposeView.removeAndroidView(this.$this_run);
                }
                this.$this_run.removeAllViewsInLayout();
            }
        }));
        layoutNode2.setMeasurePolicy(new MeasurePolicy((AndroidViewHolder)$this$layoutNode_u24lambda_u242, layoutNode2){
            final /* synthetic */ AndroidViewHolder $this_run;
            final /* synthetic */ LayoutNode $layoutNode;
            {
                this.$this_run = $receiver;
                this.$layoutNode = $layoutNode;
            }

            @NotNull
            public MeasureResult measure-3p2s80s(@NotNull MeasureScope $this$measure_u2d3p2s80s, @NotNull List<? extends Measurable> measurables, long constraints) {
                Intrinsics.checkNotNullParameter((Object)$this$measure_u2d3p2s80s, (String)"$this$measure");
                Intrinsics.checkNotNullParameter(measurables, (String)"measurables");
                if (this.$this_run.getChildCount() == 0) {
                    return MeasureScope.layout$default($this$measure_u2d3p2s80s, Constraints.getMinWidth-impl((long)constraints), Constraints.getMinHeight-impl((long)constraints), null, layoutNode.1.measure.1.INSTANCE, 4, null);
                }
                if (Constraints.getMinWidth-impl((long)constraints) != 0) {
                    this.$this_run.getChildAt(0).setMinimumWidth(Constraints.getMinWidth-impl((long)constraints));
                }
                if (Constraints.getMinHeight-impl((long)constraints) != 0) {
                    this.$this_run.getChildAt(0).setMinimumHeight(Constraints.getMinHeight-impl((long)constraints));
                }
                int n = Constraints.getMinWidth-impl((long)constraints);
                int n2 = Constraints.getMaxWidth-impl((long)constraints);
                ViewGroup.LayoutParams layoutParams = this.$this_run.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams);
                int n3 = AndroidViewHolder.access$obtainMeasureSpec(this.$this_run, n, n2, layoutParams.width);
                int n4 = Constraints.getMinHeight-impl((long)constraints);
                int n5 = Constraints.getMaxHeight-impl((long)constraints);
                ViewGroup.LayoutParams layoutParams2 = this.$this_run.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams2);
                this.$this_run.measure(n3, AndroidViewHolder.access$obtainMeasureSpec(this.$this_run, n4, n5, layoutParams2.height));
                return MeasureScope.layout$default($this$measure_u2d3p2s80s, this.$this_run.getMeasuredWidth(), this.$this_run.getMeasuredHeight(), null, (Function1)new Function1<Placeable.PlacementScope, Unit>(this.$this_run, this.$layoutNode){
                    final /* synthetic */ AndroidViewHolder $this_run;
                    final /* synthetic */ LayoutNode $layoutNode;
                    {
                        this.$this_run = $receiver;
                        this.$layoutNode = $layoutNode;
                        super(1);
                    }

                    public final void invoke(@NotNull Placeable.PlacementScope $this$layout) {
                        Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                        AndroidViewHolder_androidKt.access$layoutAccordingTo((View)this.$this_run, this.$layoutNode);
                    }
                }, 4, null);
            }

            public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull List<? extends IntrinsicMeasurable> measurables, int height) {
                Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicWidth, (String)"<this>");
                Intrinsics.checkNotNullParameter(measurables, (String)"measurables");
                return this.intrinsicWidth(height);
            }

            public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull List<? extends IntrinsicMeasurable> measurables, int height) {
                Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicWidth, (String)"<this>");
                Intrinsics.checkNotNullParameter(measurables, (String)"measurables");
                return this.intrinsicWidth(height);
            }

            private final int intrinsicWidth(int height) {
                int n = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                ViewGroup.LayoutParams layoutParams = this.$this_run.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams);
                this.$this_run.measure(n, AndroidViewHolder.access$obtainMeasureSpec(this.$this_run, 0, height, layoutParams.height));
                return this.$this_run.getMeasuredWidth();
            }

            public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull List<? extends IntrinsicMeasurable> measurables, int width) {
                Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicHeight, (String)"<this>");
                Intrinsics.checkNotNullParameter(measurables, (String)"measurables");
                return this.intrinsicHeight(width);
            }

            public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull List<? extends IntrinsicMeasurable> measurables, int width) {
                Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicHeight, (String)"<this>");
                Intrinsics.checkNotNullParameter(measurables, (String)"measurables");
                return this.intrinsicHeight(width);
            }

            private final int intrinsicHeight(int width) {
                ViewGroup.LayoutParams layoutParams = this.$this_run.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams);
                this.$this_run.measure(AndroidViewHolder.access$obtainMeasureSpec(this.$this_run, 0, width, layoutParams.width), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                return this.$this_run.getMeasuredHeight();
            }
        });
        androidViewHolder.layoutNode = layoutNode2;
    }

    @NotNull
    public final View getView() {
        return this.view;
    }

    @Nullable
    public final View getInteropView() {
        return this.view;
    }

    @NotNull
    public final Function0<Unit> getUpdate() {
        return this.update;
    }

    protected final void setUpdate(@NotNull Function0<Unit> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.update = value;
        this.hasUpdateBlock = true;
        this.runUpdate.invoke();
    }

    @NotNull
    public final Function0<Unit> getReset() {
        return this.reset;
    }

    protected final void setReset(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.reset = function0;
    }

    @NotNull
    public final Function0<Unit> getRelease() {
        return this.release;
    }

    protected final void setRelease(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.release = function0;
    }

    @NotNull
    public final Modifier getModifier() {
        return this.modifier;
    }

    public final void setModifier(@NotNull Modifier value) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value == this.modifier) break block1;
            this.modifier = value;
            Function1<? super Modifier, Unit> function1 = this.onModifierChanged;
            if (function1 != null) {
                function1.invoke((Object)value);
            }
        }
    }

    @Nullable
    public final Function1<Modifier, Unit> getOnModifierChanged$ui_release() {
        return this.onModifierChanged;
    }

    public final void setOnModifierChanged$ui_release(@Nullable Function1<? super Modifier, Unit> function1) {
        this.onModifierChanged = function1;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    public final void setDensity(@NotNull Density value) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value == this.density) break block1;
            this.density = value;
            Function1<? super Density, Unit> function1 = this.onDensityChanged;
            if (function1 != null) {
                function1.invoke((Object)value);
            }
        }
    }

    @Nullable
    public final Function1<Density, Unit> getOnDensityChanged$ui_release() {
        return this.onDensityChanged;
    }

    public final void setOnDensityChanged$ui_release(@Nullable Function1<? super Density, Unit> function1) {
        this.onDensityChanged = function1;
    }

    @Nullable
    public final LifecycleOwner getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    public final void setLifecycleOwner(@Nullable LifecycleOwner value) {
        if (value != this.lifecycleOwner) {
            this.lifecycleOwner = value;
            ViewTreeLifecycleOwner.set((View)((View)this), (LifecycleOwner)value);
        }
    }

    @Nullable
    public final SavedStateRegistryOwner getSavedStateRegistryOwner() {
        return this.savedStateRegistryOwner;
    }

    public final void setSavedStateRegistryOwner(@Nullable SavedStateRegistryOwner value) {
        if (value != this.savedStateRegistryOwner) {
            this.savedStateRegistryOwner = value;
            ViewTreeSavedStateRegistryOwner.set((View)((View)this), (SavedStateRegistryOwner)value);
        }
    }

    @Nullable
    public final Function1<Boolean, Unit> getOnRequestDisallowInterceptTouchEvent$ui_release() {
        return this.onRequestDisallowInterceptTouchEvent;
    }

    public final void setOnRequestDisallowInterceptTouchEvent$ui_release(@Nullable Function1<? super Boolean, Unit> function1) {
        this.onRequestDisallowInterceptTouchEvent = function1;
    }

    public void onReuse() {
        if (this.view.getParent() != this) {
            this.addView(this.view);
        } else {
            this.reset.invoke();
        }
    }

    public void onDeactivate() {
        this.reset.invoke();
        this.removeAllViewsInLayout();
    }

    public void onRelease() {
        this.release.invoke();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.view.getParent() != this) {
            this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
            return;
        }
        this.view.measure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.view.getMeasuredWidth(), this.view.getMeasuredHeight());
        this.lastWidthMeasureSpec = widthMeasureSpec;
        this.lastHeightMeasureSpec = heightMeasureSpec;
    }

    public final void remeasure() {
        if (this.lastWidthMeasureSpec == Integer.MIN_VALUE || this.lastHeightMeasureSpec == Integer.MIN_VALUE) {
            return;
        }
        this.measure(this.lastWidthMeasureSpec, this.lastHeightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.view.layout(0, 0, r - l, b - t);
    }

    @Nullable
    public ViewGroup.LayoutParams getLayoutParams() {
        ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new ViewGroup.LayoutParams(-1, -1);
        }
        return layoutParams;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        Function1<? super Boolean, Unit> function1 = this.onRequestDisallowInterceptTouchEvent;
        if (function1 != null) {
            function1.invoke((Object)disallowIntercept);
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.snapshotObserver.start();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.snapshotObserver.stop();
        this.snapshotObserver.clear();
    }

    @Nullable
    public ViewParent invalidateChildInParent(@Nullable int[] location, @Nullable Rect dirty) {
        super.invalidateChildInParent(location, dirty);
        this.invalidateOrDefer();
        return null;
    }

    public void onDescendantInvalidated(@NotNull View child, @NotNull View target) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super.onDescendantInvalidated(child, target);
        this.invalidateOrDefer();
    }

    public final void invalidateOrDefer() {
        if (this.isDrawing) {
            this.view.postOnAnimation(() -> AndroidViewHolder.invalidateOrDefer$lambda$1(this.runInvalidate));
        } else {
            this.layoutNode.invalidateLayer$ui_release();
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (Build.VERSION.SDK_INT < 23 && visibility == 0) {
            this.layoutNode.invalidateLayer$ui_release();
        }
    }

    public boolean gatherTransparentRegion(@Nullable Region region) {
        if (region == null) {
            return true;
        }
        this.getLocationInWindow(this.location);
        region.op(this.location[0], this.location[1], this.location[0] + this.getWidth(), this.location[1] + this.getHeight(), Region.Op.DIFFERENCE);
        return true;
    }

    @NotNull
    public final LayoutNode getLayoutNode() {
        return this.layoutNode;
    }

    private final int obtainMeasureSpec(int min, int max, int preferred) {
        return preferred >= 0 || min == max ? View.MeasureSpec.makeMeasureSpec((int)RangesKt.coerceIn((int)preferred, (int)min, (int)max), (int)0x40000000) : (preferred == -2 && max != Integer.MAX_VALUE ? View.MeasureSpec.makeMeasureSpec((int)max, (int)Integer.MIN_VALUE) : (preferred == -1 && max != Integer.MAX_VALUE ? View.MeasureSpec.makeMeasureSpec((int)max, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0)));
    }

    public boolean shouldDelayChildPressedState() {
        return true;
    }

    public boolean onStartNestedScroll(@NotNull View child, @NotNull View target, int axes, int type) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return (axes & 2) != 0 || (axes & 1) != 0;
    }

    public int getNestedScrollAxes() {
        return this.nestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void onNestedScrollAccepted(@NotNull View child, @NotNull View target, int axes, int type) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.nestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes, type);
    }

    public void onStopNestedScroll(@NotNull View target, int type) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.nestedScrollingParentHelper.onStopNestedScroll(target, type);
    }

    public void onNestedScroll(@NotNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @NotNull int[] consumed) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)consumed, (String)"consumed");
        if (!this.isNestedScrollingEnabled()) {
            return;
        }
        long consumedByParent = this.dispatcher.dispatchPostScroll-DzOQY0M(OffsetKt.Offset((float)AndroidViewHolder_androidKt.access$toComposeOffset(dxConsumed), (float)AndroidViewHolder_androidKt.access$toComposeOffset(dyConsumed)), OffsetKt.Offset((float)AndroidViewHolder_androidKt.access$toComposeOffset(dxUnconsumed), (float)AndroidViewHolder_androidKt.access$toComposeOffset(dyUnconsumed)), AndroidViewHolder_androidKt.access$toNestedScrollSource(type));
        consumed[0] = NestedScrollInteropConnectionKt.composeToViewOffset(Offset.getX-impl((long)consumedByParent));
        consumed[1] = NestedScrollInteropConnectionKt.composeToViewOffset(Offset.getY-impl((long)consumedByParent));
    }

    public void onNestedScroll(@NotNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.isNestedScrollingEnabled()) {
            return;
        }
        this.dispatcher.dispatchPostScroll-DzOQY0M(OffsetKt.Offset((float)AndroidViewHolder_androidKt.access$toComposeOffset(dxConsumed), (float)AndroidViewHolder_androidKt.access$toComposeOffset(dyConsumed)), OffsetKt.Offset((float)AndroidViewHolder_androidKt.access$toComposeOffset(dxUnconsumed), (float)AndroidViewHolder_androidKt.access$toComposeOffset(dyUnconsumed)), AndroidViewHolder_androidKt.access$toNestedScrollSource(type));
    }

    public void onNestedPreScroll(@NotNull View target, int dx, int dy, @NotNull int[] consumed, int type) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)consumed, (String)"consumed");
        if (!this.isNestedScrollingEnabled()) {
            return;
        }
        long consumedByParent = this.dispatcher.dispatchPreScroll-OzD1aCk(OffsetKt.Offset((float)AndroidViewHolder_androidKt.access$toComposeOffset(dx), (float)AndroidViewHolder_androidKt.access$toComposeOffset(dy)), AndroidViewHolder_androidKt.access$toNestedScrollSource(type));
        consumed[0] = NestedScrollInteropConnectionKt.composeToViewOffset(Offset.getX-impl((long)consumedByParent));
        consumed[1] = NestedScrollInteropConnectionKt.composeToViewOffset(Offset.getY-impl((long)consumedByParent));
    }

    public boolean onNestedFling(@NotNull View target, float velocityX, float velocityY, boolean consumed) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.isNestedScrollingEnabled()) {
            return false;
        }
        long viewVelocity = VelocityKt.Velocity((float)AndroidViewHolder_androidKt.access$toComposeVelocity(velocityX), (float)AndroidViewHolder_androidKt.access$toComposeVelocity(velocityY));
        BuildersKt.launch$default((CoroutineScope)this.dispatcher.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(consumed, this, viewVelocity, null){
            int label;
            final /* synthetic */ boolean $consumed;
            final /* synthetic */ AndroidViewHolder this$0;
            final /* synthetic */ long $viewVelocity;
            {
                this.$consumed = $consumed;
                this.this$0 = $receiver;
                this.$viewVelocity = $viewVelocity;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void $result;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (this.$consumed) break;
                        this.label = 1;
                        Object object3 = AndroidViewHolder.access$getDispatcher$p(this.this$0).dispatchPostFling-RZ2iAVY(Velocity.Companion.getZero-9UxMQ8M(), this.$viewVelocity, (Continuation<? super Velocity>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                this.label = 2;
                Object object4 = AndroidViewHolder.access$getDispatcher$p(this.this$0).dispatchPostFling-RZ2iAVY(this.$viewVelocity, Velocity.Companion.getZero-9UxMQ8M(), (Continuation<? super Velocity>)((Continuation)this));
                if (object4 != object2) return Unit.INSTANCE;
                return object2;
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return false;
    }

    public boolean onNestedPreFling(@NotNull View target, float velocityX, float velocityY) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.isNestedScrollingEnabled()) {
            return false;
        }
        long toBeConsumed = VelocityKt.Velocity((float)AndroidViewHolder_androidKt.access$toComposeVelocity(velocityX), (float)AndroidViewHolder_androidKt.access$toComposeVelocity(velocityY));
        BuildersKt.launch$default((CoroutineScope)this.dispatcher.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, toBeConsumed, null){
            int label;
            final /* synthetic */ AndroidViewHolder this$0;
            final /* synthetic */ long $toBeConsumed;
            {
                this.this$0 = $receiver;
                this.$toBeConsumed = $toBeConsumed;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = AndroidViewHolder.access$getDispatcher$p(this.this$0).dispatchPreFling-QWom1Mo(this.$toBeConsumed, (Continuation<? super Velocity>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return false;
    }

    public boolean isNestedScrollingEnabled() {
        return this.view.isNestedScrollingEnabled();
    }

    private static final void invalidateOrDefer$lambda$1(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ NestedScrollDispatcher access$getDispatcher$p(AndroidViewHolder $this) {
        return $this.dispatcher;
    }

    public static final /* synthetic */ Function0 access$getRunUpdate$p(AndroidViewHolder $this) {
        return $this.runUpdate;
    }

    public static final /* synthetic */ boolean access$getHasUpdateBlock$p(AndroidViewHolder $this) {
        return $this.hasUpdateBlock;
    }

    public static final /* synthetic */ SnapshotStateObserver access$getSnapshotObserver$p(AndroidViewHolder $this) {
        return $this.snapshotObserver;
    }

    public static final /* synthetic */ Function1 access$getOnCommitAffectingUpdate$p(AndroidViewHolder $this) {
        return $this.onCommitAffectingUpdate;
    }

    public static final /* synthetic */ void access$setDrawing$p(AndroidViewHolder $this, boolean bl) {
        $this.isDrawing = bl;
    }

    public static final /* synthetic */ int access$obtainMeasureSpec(AndroidViewHolder $this, int min, int max, int preferred) {
        return $this.obtainMeasureSpec(min, max, preferred);
    }
}

