/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import android.graphics.Region;
import android.view.View;
import androidx.compose.ui.TempListUtilsKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.platform.AndroidComposeViewAccessibilityDelegateCompat;
import androidx.compose.ui.platform.AndroidComposeViewAccessibilityDelegateCompat_androidKt;
import androidx.compose.ui.platform.AndroidViewsHandler;
import androidx.compose.ui.platform.ScrollObservationScope;
import androidx.compose.ui.platform.SemanticsNodeWithAdjustedBounds;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsOwner;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.viewinterop.AndroidViewHolder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0014\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u001a\f\u0010\u0018\u001a\u00020\b*\u00020\u0004H\u0002\u001a\f\u0010\u0019\u001a\u00020\b*\u00020\u0004H\u0002\u001a\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\b\u0012\u0004\u0012\u00020\u001b0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\"\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\b0\"H\u0002\u001a\u0018\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020%0$*\u00020&H\u0000\u001a\u000e\u0010'\u001a\u0004\u0018\u00010\u0003*\u00020\u0004H\u0002\u001a\f\u0010(\u001a\u00020\b*\u00020\u0004H\u0002\u001a\u0014\u0010)\u001a\u00020\b*\u00020\u00042\u0006\u0010*\u001a\u00020+H\u0002\u001a\u0016\u0010,\u001a\u0004\u0018\u00010-*\u00020.2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u001b\u0010/\u001a\u0004\u0018\u00010\u0003*\u000200H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b1\u00102\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0019\u0010\u0007\u001a\u00020\b*\u00020\u00048\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0019\u0010\n\u001a\u00020\b*\u00020\u00048\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\t\"\u0019\u0010\u000b\u001a\u00020\b*\u00020\u00048\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0019\u0010\f\u001a\u00020\b*\u00020\u00048\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\t\"\u001e\u0010\r\u001a\u00020\b*\u00020\u00048BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\t\"\u0019\u0010\u0010\u001a\u00020\u0011*\u00020\u00048\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00063"}, d2={"DefaultFakeNodeBounds", "Landroidx/compose/ui/geometry/Rect;", "infoContentDescriptionOrNull", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "getInfoContentDescriptionOrNull", "(Landroidx/compose/ui/semantics/SemanticsNode;)Ljava/lang/String;", "isPassword", "", "(Landroidx/compose/ui/semantics/SemanticsNode;)Z", "isRtl", "isTextField", "isTraversalGroup", "isVisible", "isVisible$annotations", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "traversalIndex", "", "getTraversalIndex", "(Landroidx/compose/ui/semantics/SemanticsNode;)F", "accessibilityEquals", "Landroidx/compose/ui/semantics/AccessibilityAction;", "other", "", "enabled", "excludeLineAndPageGranularities", "findById", "Landroidx/compose/ui/platform/ScrollObservationScope;", "", "id", "", "findClosestParentNode", "Landroidx/compose/ui/node/LayoutNode;", "selector", "Lkotlin/Function1;", "getAllUncoveredSemanticsNodesToMap", "", "Landroidx/compose/ui/platform/SemanticsNodeWithAdjustedBounds;", "Landroidx/compose/ui/semantics/SemanticsOwner;", "getTextForTranslation", "hasPaneTitle", "propertiesDeleted", "oldNode", "Landroidx/compose/ui/platform/AndroidComposeViewAccessibilityDelegateCompat$SemanticsNodeCopy;", "semanticsIdToView", "Landroid/view/View;", "Landroidx/compose/ui/platform/AndroidViewsHandler;", "toLegacyClassName", "Landroidx/compose/ui/semantics/Role;", "toLegacyClassName-V4PA4sw", "(I)Ljava/lang/String;", "ui_release"})
@SourceDebugExtension(value={"SMAP\nAndroidComposeViewAccessibilityDelegateCompat.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidComposeViewAccessibilityDelegateCompat.android.kt\nandroidx/compose/ui/platform/AndroidComposeViewAccessibilityDelegateCompat_androidKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,3621:1\n3437#1:3622\n288#2,2:3623\n*S KotlinDebug\n*F\n+ 1 AndroidComposeViewAccessibilityDelegateCompat.android.kt\nandroidx/compose/ui/platform/AndroidComposeViewAccessibilityDelegateCompat_androidKt\n*L\n3452#1:3622\n3620#1:3623,2\n*E\n"})
public final class AndroidComposeViewAccessibilityDelegateCompat_androidKt {
    @NotNull
    private static final Rect DefaultFakeNodeBounds = new Rect(0.0f, 0.0f, 10.0f, 10.0f);

    private static final LayoutNode findClosestParentNode(LayoutNode $this$findClosestParentNode, Function1<? super LayoutNode, Boolean> selector) {
        for (LayoutNode currentParent = $this$findClosestParentNode.getParent$ui_release(); currentParent != null; currentParent = currentParent.getParent$ui_release()) {
            if (!((Boolean)selector.invoke((Object)currentParent)).booleanValue()) continue;
            return currentParent;
        }
        return null;
    }

    private static final boolean enabled(SemanticsNode $this$enabled) {
        return SemanticsConfigurationKt.getOrNull($this$enabled.getConfig(), SemanticsProperties.INSTANCE.getDisabled()) == null;
    }

    private static final boolean isVisible(SemanticsNode $this$isVisible) {
        return !$this$isVisible.isTransparent$ui_release() && !$this$isVisible.getUnmergedConfig$ui_release().contains(SemanticsProperties.INSTANCE.getInvisibleToUser());
    }

    private static /* synthetic */ void isVisible$annotations(SemanticsNode semanticsNode2) {
    }

    private static final boolean propertiesDeleted(SemanticsNode $this$propertiesDeleted, AndroidComposeViewAccessibilityDelegateCompat.SemanticsNodeCopy oldNode) {
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : oldNode.getUnmergedConfig()) {
            if ($this$propertiesDeleted.getConfig().contains(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private static final boolean hasPaneTitle(SemanticsNode $this$hasPaneTitle) {
        return $this$hasPaneTitle.getConfig().contains(SemanticsProperties.INSTANCE.getPaneTitle());
    }

    private static final boolean isPassword(SemanticsNode $this$isPassword) {
        boolean $i$f$isPassword = false;
        return $this$isPassword.getConfig().contains(SemanticsProperties.INSTANCE.getPassword());
    }

    private static final boolean isTextField(SemanticsNode $this$isTextField) {
        boolean $i$f$isTextField = false;
        return $this$isTextField.getUnmergedConfig$ui_release().contains(SemanticsActions.INSTANCE.getSetText());
    }

    private static final boolean isRtl(SemanticsNode $this$isRtl) {
        boolean $i$f$isRtl = false;
        return $this$isRtl.getLayoutInfo().getLayoutDirection() == LayoutDirection.Rtl;
    }

    private static final boolean isTraversalGroup(SemanticsNode $this$isTraversalGroup) {
        boolean $i$f$isTraversalGroup = false;
        return $this$isTraversalGroup.getConfig().getOrElse(SemanticsProperties.INSTANCE.getIsTraversalGroup(), isTraversalGroup.1.INSTANCE);
    }

    private static final float getTraversalIndex(SemanticsNode $this$traversalIndex) {
        boolean $i$f$getTraversalIndex = false;
        return ((Number)$this$traversalIndex.getConfig().getOrElse(SemanticsProperties.INSTANCE.getTraversalIndex(), traversalIndex.1.INSTANCE)).floatValue();
    }

    private static final String getInfoContentDescriptionOrNull(SemanticsNode $this$infoContentDescriptionOrNull) {
        List<String> list = SemanticsConfigurationKt.getOrNull($this$infoContentDescriptionOrNull.getUnmergedConfig$ui_release(), SemanticsProperties.INSTANCE.getContentDescription());
        return list != null ? (String)CollectionsKt.firstOrNull(list) : null;
    }

    private static final String getTextForTranslation(SemanticsNode $this$getTextForTranslation) {
        List<AnnotatedString> list = SemanticsConfigurationKt.getOrNull($this$getTextForTranslation.getUnmergedConfig$ui_release(), SemanticsProperties.INSTANCE.getText());
        return list != null ? TempListUtilsKt.fastJoinToString$default(list, "\n", null, null, 0, null, null, 62, null) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean excludeLineAndPageGranularities(SemanticsNode $this$excludeLineAndPageGranularities) {
        SemanticsNode $this$isTextField$iv = $this$excludeLineAndPageGranularities;
        boolean $i$f$isTextField = false;
        if ($this$isTextField$iv.getUnmergedConfig$ui_release().contains(SemanticsActions.INSTANCE.getSetText()) && !Intrinsics.areEqual((Object)SemanticsConfigurationKt.getOrNull($this$excludeLineAndPageGranularities.getUnmergedConfig$ui_release(), SemanticsProperties.INSTANCE.getFocused()), (Object)true)) {
            return true;
        }
        LayoutNode ancestor2 = AndroidComposeViewAccessibilityDelegateCompat_androidKt.findClosestParentNode($this$excludeLineAndPageGranularities.getLayoutNode$ui_release(), (Function1<? super LayoutNode, Boolean>)((Function1)excludeLineAndPageGranularities.ancestor.1.INSTANCE));
        if (ancestor2 == null) return false;
        SemanticsConfiguration semanticsConfiguration = ancestor2.getCollapsedSemantics$ui_release();
        if (semanticsConfiguration == null) return true;
        boolean bl = Intrinsics.areEqual((Object)SemanticsConfigurationKt.getOrNull(semanticsConfiguration, SemanticsProperties.INSTANCE.getFocused()), (Object)true);
        if (bl) return false;
        return true;
    }

    private static final boolean accessibilityEquals(AccessibilityAction<?> $this$accessibilityEquals, Object other) {
        if ($this$accessibilityEquals == other) {
            return true;
        }
        if (!(other instanceof AccessibilityAction)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$accessibilityEquals.getLabel(), (Object)((AccessibilityAction)other).getLabel())) {
            return false;
        }
        if ($this$accessibilityEquals.getAction() == null && ((AccessibilityAction)other).getAction() != null) {
            return false;
        }
        return $this$accessibilityEquals.getAction() == null || ((AccessibilityAction)other).getAction() != null;
    }

    @NotNull
    public static final Map<Integer, SemanticsNodeWithAdjustedBounds> getAllUncoveredSemanticsNodesToMap(@NotNull SemanticsOwner $this$getAllUncoveredSemanticsNodesToMap) {
        SemanticsNode root2 = $this$getAllUncoveredSemanticsNodesToMap.getUnmergedRootSemanticsNode();
        Map nodes = new LinkedHashMap();
        if (!root2.getLayoutNode$ui_release().isPlaced() || !root2.getLayoutNode$ui_release().isAttached()) {
            return nodes;
        }
        Rect $this$getAllUncoveredSemanticsNodesToMap_u24lambda_u240 = root2.getBoundsInRoot();
        boolean bl = false;
        Region unaccountedSpace = new Region(MathKt.roundToInt((float)$this$getAllUncoveredSemanticsNodesToMap_u24lambda_u240.getLeft()), MathKt.roundToInt((float)$this$getAllUncoveredSemanticsNodesToMap_u24lambda_u240.getTop()), MathKt.roundToInt((float)$this$getAllUncoveredSemanticsNodesToMap_u24lambda_u240.getRight()), MathKt.roundToInt((float)$this$getAllUncoveredSemanticsNodesToMap_u24lambda_u240.getBottom()));
        AndroidComposeViewAccessibilityDelegateCompat_androidKt.getAllUncoveredSemanticsNodesToMap$findAllSemanticNodesRecursive(unaccountedSpace, root2, nodes, root2, new Region());
        return nodes;
    }

    @Nullable
    public static final ScrollObservationScope findById(@NotNull List<ScrollObservationScope> $this$findById, int id2) {
        int n = $this$findById.size();
        for (int index = 0; index < n; ++index) {
            if ($this$findById.get(index).getSemanticsNodeId() != id2) continue;
            return $this$findById.get(index);
        }
        return null;
    }

    private static final String toLegacyClassName-V4PA4sw(int $this$toLegacyClassName_u2dV4PA4sw) {
        int n = $this$toLegacyClassName_u2dV4PA4sw;
        return Role.equals-impl0(n, Role.Companion.getButton-o7Vup1c()) ? "android.widget.Button" : (Role.equals-impl0(n, Role.Companion.getCheckbox-o7Vup1c()) ? "android.widget.CheckBox" : (Role.equals-impl0(n, Role.Companion.getRadioButton-o7Vup1c()) ? "android.widget.RadioButton" : (Role.equals-impl0(n, Role.Companion.getImage-o7Vup1c()) ? "android.widget.ImageView" : (Role.equals-impl0(n, Role.Companion.getDropdownList-o7Vup1c()) ? "android.widget.Spinner" : null))));
    }

    @Nullable
    public static final View semanticsIdToView(@NotNull AndroidViewsHandler $this$semanticsIdToView, int id2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$semanticsIdToView.getLayoutNodeToHolder().entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!(((LayoutNode)it.getKey()).getSemanticsId() == id2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return (View)(entry != null ? (AndroidViewHolder)entry.getValue() : null);
    }

    private static final void getAllUncoveredSemanticsNodesToMap$findAllSemanticNodesRecursive(Region unaccountedSpace, SemanticsNode root2, Map<Integer, SemanticsNodeWithAdjustedBounds> nodes, SemanticsNode currentNode, Region region) {
        int virtualViewId;
        boolean notAttachedOrPlaced;
        boolean bl = notAttachedOrPlaced = !currentNode.getLayoutNode$ui_release().isPlaced() || !currentNode.getLayoutNode$ui_release().isAttached();
        if (unaccountedSpace.isEmpty() && currentNode.getId() != root2.getId() || notAttachedOrPlaced && !currentNode.isFake$ui_release()) {
            return;
        }
        Rect touchBoundsInRoot = currentNode.getTouchBoundsInRoot();
        int left = MathKt.roundToInt((float)touchBoundsInRoot.getLeft());
        int top = MathKt.roundToInt((float)touchBoundsInRoot.getTop());
        int right = MathKt.roundToInt((float)touchBoundsInRoot.getRight());
        int bottom = MathKt.roundToInt((float)touchBoundsInRoot.getBottom());
        region.set(left, top, right, bottom);
        int n = virtualViewId = currentNode.getId() == root2.getId() ? -1 : currentNode.getId();
        if (region.op(unaccountedSpace, Region.Op.INTERSECT)) {
            Integer n2 = virtualViewId;
            nodes.put(n2, new SemanticsNodeWithAdjustedBounds(currentNode, region.getBounds()));
            List<SemanticsNode> children = currentNode.getReplacedChildren$ui_release();
            for (int i = children.size() - 1; -1 < i; --i) {
                AndroidComposeViewAccessibilityDelegateCompat_androidKt.getAllUncoveredSemanticsNodesToMap$findAllSemanticNodesRecursive(unaccountedSpace, root2, nodes, children.get(i), region);
            }
            unaccountedSpace.op(left, top, right, bottom, Region.Op.DIFFERENCE);
        } else if (currentNode.isFake$ui_release()) {
            SemanticsNode parentNode = currentNode.getParent();
            Object object = parentNode;
            Rect boundsForFakeNode = (object != null && (object = ((SemanticsNode)object).getLayoutInfo()) != null ? object.isPlaced() : false) ? parentNode.getBoundsInRoot() : DefaultFakeNodeBounds;
            Integer n3 = virtualViewId;
            nodes.put(n3, new SemanticsNodeWithAdjustedBounds(currentNode, new android.graphics.Rect(MathKt.roundToInt((float)boundsForFakeNode.getLeft()), MathKt.roundToInt((float)boundsForFakeNode.getTop()), MathKt.roundToInt((float)boundsForFakeNode.getRight()), MathKt.roundToInt((float)boundsForFakeNode.getBottom()))));
        } else if (virtualViewId == -1) {
            Integer n4 = virtualViewId;
            nodes.put(n4, new SemanticsNodeWithAdjustedBounds(currentNode, region.getBounds()));
        }
    }

    public static final /* synthetic */ String access$getInfoContentDescriptionOrNull(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.getInfoContentDescriptionOrNull($receiver);
    }

    public static final /* synthetic */ boolean access$enabled(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.enabled($receiver);
    }

    public static final /* synthetic */ boolean access$isVisible(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.isVisible($receiver);
    }

    public static final /* synthetic */ boolean access$excludeLineAndPageGranularities(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.excludeLineAndPageGranularities($receiver);
    }

    public static final /* synthetic */ LayoutNode access$findClosestParentNode(LayoutNode $receiver, Function1 selector) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.findClosestParentNode($receiver, (Function1<? super LayoutNode, Boolean>)selector);
    }

    public static final /* synthetic */ boolean access$hasPaneTitle(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.hasPaneTitle($receiver);
    }

    public static final /* synthetic */ boolean access$accessibilityEquals(AccessibilityAction $receiver, Object other) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.accessibilityEquals($receiver, other);
    }

    public static final /* synthetic */ boolean access$propertiesDeleted(SemanticsNode $receiver, AndroidComposeViewAccessibilityDelegateCompat.SemanticsNodeCopy oldNode) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.propertiesDeleted($receiver, oldNode);
    }

    public static final /* synthetic */ String access$toLegacyClassName-V4PA4sw(int $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.toLegacyClassName-V4PA4sw($receiver);
    }

    public static final /* synthetic */ String access$getTextForTranslation(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.getTextForTranslation($receiver);
    }
}

