/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import android.graphics.Matrix;
import android.view.inputmethod.CursorAnchorInfo;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.input.CursorAnchorInfoBuilderKt;
import androidx.compose.ui.text.input.InputMethodManager;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ6\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\b\u0010 \u001a\u00020\u001cH\u0002JC\u0010!\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\"\u0010#R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006$"}, d2={"Landroidx/compose/ui/text/input/CursorAnchorInfoController;", "", "inputMethodManager", "Landroidx/compose/ui/text/input/InputMethodManager;", "(Landroidx/compose/ui/text/input/InputMethodManager;)V", "builder", "Landroid/view/inputmethod/CursorAnchorInfo$Builder;", "decorationBoxBounds", "Landroidx/compose/ui/geometry/Rect;", "hasPendingImmediateRequest", "", "includeCharacterBounds", "includeEditorBounds", "includeInsertionMarker", "includeLineBounds", "innerTextFieldBounds", "matrix", "Landroid/graphics/Matrix;", "monitorEnabled", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "textFieldValue", "Landroidx/compose/ui/text/input/TextFieldValue;", "textLayoutPositionInWindow", "Landroidx/compose/ui/geometry/Offset;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "invalidate", "", "requestUpdate", "immediate", "monitor", "updateCursorAnchorInfo", "updateTextLayoutResult", "updateTextLayoutResult-F0iM_J4", "(Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/ui/text/input/OffsetMapping;Landroidx/compose/ui/text/TextLayoutResult;JLandroidx/compose/ui/geometry/Rect;Landroidx/compose/ui/geometry/Rect;)V", "ui_release"})
public final class CursorAnchorInfoController {
    @NotNull
    private final InputMethodManager inputMethodManager;
    private boolean monitorEnabled;
    private boolean hasPendingImmediateRequest;
    private boolean includeInsertionMarker;
    private boolean includeCharacterBounds;
    private boolean includeEditorBounds;
    private boolean includeLineBounds;
    @Nullable
    private TextFieldValue textFieldValue;
    @Nullable
    private TextLayoutResult textLayoutResult;
    @Nullable
    private OffsetMapping offsetMapping;
    @Nullable
    private Offset textLayoutPositionInWindow;
    @Nullable
    private Rect innerTextFieldBounds;
    @Nullable
    private Rect decorationBoxBounds;
    @NotNull
    private final CursorAnchorInfo.Builder builder;
    @NotNull
    private final Matrix matrix;

    public CursorAnchorInfoController(@NotNull InputMethodManager inputMethodManager) {
        this.inputMethodManager = inputMethodManager;
        this.builder = new CursorAnchorInfo.Builder();
        this.matrix = new Matrix();
    }

    public final void requestUpdate(boolean immediate, boolean monitor, boolean includeInsertionMarker, boolean includeCharacterBounds, boolean includeEditorBounds, boolean includeLineBounds) {
        this.includeInsertionMarker = includeInsertionMarker;
        this.includeCharacterBounds = includeCharacterBounds;
        this.includeEditorBounds = includeEditorBounds;
        this.includeLineBounds = includeLineBounds;
        if (immediate) {
            this.hasPendingImmediateRequest = true;
            if (this.textFieldValue != null) {
                this.updateCursorAnchorInfo();
            }
        }
        this.monitorEnabled = monitor;
    }

    public final void updateTextLayoutResult-F0iM_J4(@NotNull TextFieldValue textFieldValue, @NotNull OffsetMapping offsetMapping, @NotNull TextLayoutResult textLayoutResult, long textLayoutPositionInWindow, @NotNull Rect innerTextFieldBounds, @NotNull Rect decorationBoxBounds) {
        this.textFieldValue = textFieldValue;
        this.offsetMapping = offsetMapping;
        this.textLayoutResult = textLayoutResult;
        this.textLayoutPositionInWindow = Offset.box-impl((long)textLayoutPositionInWindow);
        this.innerTextFieldBounds = innerTextFieldBounds;
        this.decorationBoxBounds = decorationBoxBounds;
        if (this.hasPendingImmediateRequest || this.monitorEnabled) {
            this.updateCursorAnchorInfo();
        }
    }

    public final void invalidate() {
        this.textFieldValue = null;
        this.offsetMapping = null;
        this.textLayoutResult = null;
        this.textLayoutPositionInWindow = null;
        this.innerTextFieldBounds = null;
        this.decorationBoxBounds = null;
    }

    private final void updateCursorAnchorInfo() {
        if (!this.inputMethodManager.isActive()) {
            return;
        }
        this.matrix.reset();
        Offset offset = this.textLayoutPositionInWindow;
        Intrinsics.checkNotNull((Object)offset);
        float f = Offset.getX-impl((long)offset.unbox-impl());
        Offset offset2 = this.textLayoutPositionInWindow;
        Intrinsics.checkNotNull((Object)offset2);
        this.matrix.postTranslate(f, Offset.getY-impl((long)offset2.unbox-impl()));
        TextFieldValue textFieldValue = this.textFieldValue;
        Intrinsics.checkNotNull((Object)textFieldValue);
        OffsetMapping offsetMapping = this.offsetMapping;
        Intrinsics.checkNotNull((Object)offsetMapping);
        TextLayoutResult textLayoutResult = this.textLayoutResult;
        Intrinsics.checkNotNull((Object)textLayoutResult);
        Rect rect = this.innerTextFieldBounds;
        Intrinsics.checkNotNull((Object)rect);
        Rect rect2 = this.decorationBoxBounds;
        Intrinsics.checkNotNull((Object)rect2);
        this.inputMethodManager.updateCursorAnchorInfo(CursorAnchorInfoBuilderKt.build(this.builder, textFieldValue, offsetMapping, textLayoutResult, this.matrix, rect, rect2, this.includeInsertionMarker, this.includeCharacterBounds, this.includeEditorBounds, this.includeLineBounds));
        this.hasPendingImmediateRequest = false;
    }
}

