/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u001a(\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u00122\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0082\b\u00a2\u0006\u0002\u0010\u0017\u001a(\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0007H\u0002\u001a\u0011\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0082\b\u001a2\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u00012\b\b\u0002\u0010#\u001a\u00020\u0013H\u0000\u001a\u0012\u0010$\u001a\u00020%*\u00020&2\u0006\u0010'\u001a\u00020(\u001a\u0014\u0010)\u001a\u00020%*\u00020&2\u0006\u0010'\u001a\u00020(H\u0002\u001a\u0014\u0010*\u001a\u00020%*\u00020&2\u0006\u0010'\u001a\u00020(H\u0002\u001a\u0014\u0010+\u001a\u00020\u0003*\u00020\u00132\u0006\u0010,\u001a\u00020\u0013H\u0002\u001a,\u0010-\u001a\u00020\u0003*\f\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`.2\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u00020\u0001H\u0082\n\u00a2\u0006\u0002\u00101\u001a\r\u00102\u001a\u00020\u0003*\u00020\u0013H\u0082\b\u001a4\u00103\u001a\u00020%*\f\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`.2\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u00020\u00012\u0006\u00104\u001a\u00020\u0003H\u0082\n\u00a2\u0006\u0002\u00105\u001a1\u00103\u001a\u00020%*\n\u0012\u0006\u0012\u0004\u0018\u0001060\u00122\u0006\u00107\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u0002082\u0006\u00109\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010:\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"1\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078G@GX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e*\u0018\b\u0002\u0010\u0011\"\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0012\u0004\u0012\u00020\u00130\u0012*\f\b\u0002\u0010;\"\u00020\u00132\u00020\u0013\u00a8\u0006<"}, d2={"AssumePointerMoveStoppedMilliseconds", "", "DefaultWeight", "", "HistorySize", "HorizonMilliseconds", "<set-?>", "", "VelocityTrackerAddPointsFix", "getVelocityTrackerAddPointsFix$annotations", "()V", "getVelocityTrackerAddPointsFix", "()Z", "setVelocityTrackerAddPointsFix", "(Z)V", "VelocityTrackerAddPointsFix$delegate", "Landroidx/compose/runtime/MutableState;", "Matrix", "", "", "Landroidx/compose/ui/input/pointer/util/Vector;", "rows", "cols", "(II)[[F", "calculateImpulseVelocity", "dataPoints", "time", "sampleCount", "isDataDifferential", "kineticEnergyToVelocity", "kineticEnergy", "polyFitLeastSquares", "x", "y", "degree", "coefficients", "addPointerInputChange", "", "Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "event", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "addPointerInputChangeLegacy", "addPointerInputChangeWithFix", "dot", "a", "get", "Landroidx/compose/ui/input/pointer/util/Matrix;", "row", "col", "([[FII)F", "norm", "set", "value", "([[FIIF)V", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "index", "", "dataPoint", "([Landroidx/compose/ui/input/pointer/util/DataPointAtTime;IJF)V", "Vector", "ui_release"})
@SourceDebugExtension(value={"SMAP\nVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,690:1\n668#1:703\n675#1,2:704\n671#1,6:706\n668#1:712\n668#1:713\n663#1:714\n671#1:715\n671#1:716\n649#1:717\n649#1:718\n33#2,6:691\n33#2,6:697\n81#3:719\n107#3,2:720\n*S KotlinDebug\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n*L\n449#1:703\n451#1:704,2\n453#1:706,6\n460#1:712\n462#1:713\n477#1:714\n519#1:715\n521#1:716\n629#1:717\n639#1:718\n332#1:691,6\n381#1:697,6\n689#1:719\n689#1:720,2\n*E\n"})
public final class VelocityTrackerKt {
    private static final int AssumePointerMoveStoppedMilliseconds = 40;
    private static final int HistorySize = 20;
    private static final int HorizonMilliseconds = 100;
    private static final float DefaultWeight = 1.0f;
    @NotNull
    private static final MutableState VelocityTrackerAddPointsFix$delegate = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);

    private static final void set(DataPointAtTime[] $this$set, int index, long time, float dataPoint) {
        DataPointAtTime currentEntry = $this$set[index];
        if (currentEntry == null) {
            $this$set[index] = new DataPointAtTime(time, dataPoint);
        } else {
            currentEntry.setTime(time);
            currentEntry.setDataPoint(dataPoint);
        }
    }

    public static final void addPointerInputChange(@NotNull VelocityTracker $this$addPointerInputChange, @NotNull PointerInputChange event) {
        if (VelocityTrackerKt.getVelocityTrackerAddPointsFix()) {
            VelocityTrackerKt.addPointerInputChangeWithFix($this$addPointerInputChange, event);
        } else {
            VelocityTrackerKt.addPointerInputChangeLegacy($this$addPointerInputChange, event);
        }
    }

    private static final void addPointerInputChangeLegacy(VelocityTracker $this$addPointerInputChangeLegacy, PointerInputChange event) {
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChangeLegacy.setCurrentPointerPositionAccumulator-k-4lQ0M$ui_release(event.getPosition-F1C5BW0());
            $this$addPointerInputChangeLegacy.resetTracking();
        }
        long previousPointerPosition = 0L;
        previousPointerPosition = event.getPreviousPosition-F1C5BW0();
        List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            HistoricalChange item$iv;
            HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            long historicalDelta = Offset.minus-MK-Hz9U((long)it.getPosition-F1C5BW0(), (long)previousPointerPosition);
            previousPointerPosition = it.getPosition-F1C5BW0();
            $this$addPointerInputChangeLegacy.setCurrentPointerPositionAccumulator-k-4lQ0M$ui_release(Offset.plus-MK-Hz9U((long)$this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui_release(), (long)historicalDelta));
            $this$addPointerInputChangeLegacy.addPosition-Uv8p0NA(it.getUptimeMillis(), $this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui_release());
        }
        long delta = Offset.minus-MK-Hz9U((long)event.getPosition-F1C5BW0(), (long)previousPointerPosition);
        $this$addPointerInputChangeLegacy.setCurrentPointerPositionAccumulator-k-4lQ0M$ui_release(Offset.plus-MK-Hz9U((long)$this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui_release(), (long)delta));
        $this$addPointerInputChangeLegacy.addPosition-Uv8p0NA(event.getUptimeMillis(), $this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui_release());
    }

    private static final void addPointerInputChangeWithFix(VelocityTracker $this$addPointerInputChangeWithFix, PointerInputChange event) {
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChangeWithFix.setLastMoveEventTimeStamp$ui_release(0L);
            $this$addPointerInputChangeWithFix.setCurrentPointerPositionAccumulator-k-4lQ0M$ui_release(event.getPosition-F1C5BW0());
            $this$addPointerInputChangeWithFix.resetTracking();
            return;
        }
        if (!PointerEventKt.changedToUpIgnoreConsumed(event) && !PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChangeWithFix.setLastMoveEventTimeStamp$ui_release(event.getUptimeMillis());
            if (event.getHistorical().isEmpty()) {
                long delta = Offset.minus-MK-Hz9U((long)event.getPosition-F1C5BW0(), (long)$this$addPointerInputChangeWithFix.getCurrentPointerPositionAccumulator-F1C5BW0$ui_release());
                $this$addPointerInputChangeWithFix.setCurrentPointerPositionAccumulator-k-4lQ0M$ui_release(Offset.plus-MK-Hz9U((long)$this$addPointerInputChangeWithFix.getCurrentPointerPositionAccumulator-F1C5BW0$ui_release(), (long)delta));
                $this$addPointerInputChangeWithFix.addPosition-Uv8p0NA(event.getUptimeMillis(), $this$addPointerInputChangeWithFix.getCurrentPointerPositionAccumulator-F1C5BW0$ui_release());
            } else {
                List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    HistoricalChange item$iv;
                    HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl = false;
                    long historicalDelta = Offset.minus-MK-Hz9U((long)it.getPosition-F1C5BW0(), (long)$this$addPointerInputChangeWithFix.getCurrentPointerPositionAccumulator-F1C5BW0$ui_release());
                    $this$addPointerInputChangeWithFix.setCurrentPointerPositionAccumulator-k-4lQ0M$ui_release(Offset.plus-MK-Hz9U((long)$this$addPointerInputChangeWithFix.getCurrentPointerPositionAccumulator-F1C5BW0$ui_release(), (long)historicalDelta));
                    $this$addPointerInputChangeWithFix.addPosition-Uv8p0NA(it.getUptimeMillis(), $this$addPointerInputChangeWithFix.getCurrentPointerPositionAccumulator-F1C5BW0$ui_release());
                }
            }
        }
        if (PointerEventKt.changedToUpIgnoreConsumed(event) && event.getUptimeMillis() - $this$addPointerInputChangeWithFix.getLastMoveEventTimeStamp$ui_release() > 40L) {
            $this$addPointerInputChangeWithFix.resetTracking();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final float[] polyFitLeastSquares(@NotNull float[] x, @NotNull float[] y, int sampleCount, int degree, @NotNull float[] coefficients) {
        int $i$f$get;
        int $i$f$set;
        if (degree < 1) {
            throw new IllegalArgumentException("The degree must be at positive integer");
        }
        if (sampleCount == 0) {
            throw new IllegalArgumentException("At least one point must be provided");
        }
        int truncatedDegree = degree >= sampleCount ? sampleCount - 1 : degree;
        int m = sampleCount;
        int n = truncatedDegree + 1;
        boolean $i$f$Matrix = false;
        int n2 = 0;
        float[][] fArrayArray = new float[n][];
        while (n2 < n) {
            int n3 = n2++;
            fArrayArray[n3] = new float[m];
        }
        float[][] a = fArrayArray;
        for (int h = 0; h < m; ++h) {
            float[][] fArrayArray2 = a;
            boolean bl = false;
            float value$iv22 = 1.0f;
            $i$f$set = 0;
            $this$set$iv[row$iv][h] = value$iv22;
            for (int i = 1; i < n; ++i) {
                void $this$get$iv;
                float[][] row$iv = a;
                float[][] value$iv22 = a;
                int row$iv2 = i - 1;
                $i$f$get = 0;
                value$iv22 = $this$get$iv[row$iv2][h] * x[h];
                $i$f$set = 0;
                $this$set$iv[i][h] = value$iv22;
            }
        }
        boolean $i$f$Matrix2 = false;
        int $this$set$iv = 0;
        float[][] value$iv32 = new float[n][];
        while ($this$set$iv < n) {
            $i$f$set = $this$set$iv++;
            value$iv32[$i$f$set] = new float[m];
        }
        float[][] q = value$iv32;
        boolean $i$f$Matrix3 = false;
        int value$iv32 = 0;
        float[][] $i$f$set2 = new float[n][];
        while (value$iv32 < n) {
            $i$f$get = value$iv32++;
            $i$f$set2[$i$f$get] = new float[n];
        }
        float[][] r = $i$f$set2;
        for (int j = 0; j < n; ++j) {
            int h;
            float[] w = q[j];
            float[] aw = a[j];
            for (int h2 = 0; h2 < m; ++h2) {
                w[h2] = aw[h2];
            }
            for (int i = 0; i < j; ++i) {
                float[] z = q[i];
                float dot = VelocityTrackerKt.dot(w, z);
                for (h = 0; h < m; ++h) {
                    int n4 = h;
                    w[n4] = w[n4] - dot * z[h];
                }
            }
            float[] $this$norm$iv = w;
            boolean $i$f$norm = false;
            float norm = (float)Math.sqrt(VelocityTrackerKt.dot($this$norm$iv, $this$norm$iv));
            if (norm < 1.0E-6f) {
                throw new IllegalArgumentException("Vectors are linearly dependent or zero so no solution. TODO(shepshapard), actually determine what this means");
            }
            float inverseNorm = 1.0f / norm;
            int h3 = 0;
            while (h3 < m) {
                h = h3++;
                w[h] = w[h] * inverseNorm;
            }
            float[] v = r[j];
            for (int i = 0; i < n; ++i) {
                v[i] = i < j ? 0.0f : VelocityTrackerKt.dot(w, a[i]);
            }
        }
        float[] wy = y;
        for (int i = n - 1; -1 < i; --i) {
            coefficients[i] = VelocityTrackerKt.dot(q[i], wy);
            int norm = i + 1;
            int j = n - 1;
            if (norm <= j) {
                while (true) {
                    int inverseNorm = i;
                    float[][] $this$get$iv = r;
                    boolean $i$f$get2 = false;
                    coefficients[inverseNorm] = coefficients[inverseNorm] - $this$get$iv[i][j] * coefficients[j];
                    if (j == norm) break;
                    --j;
                }
            }
            int n5 = i;
            float[][] $this$get$iv = r;
            boolean $i$f$get3 = false;
            coefficients[n5] = coefficients[n5] / $this$get$iv[i][i];
        }
        return coefficients;
    }

    public static /* synthetic */ float[] polyFitLeastSquares$default(float[] fArray, float[] fArray2, int n, int n2, float[] fArray3, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            fArray3 = new float[RangesKt.coerceAtLeast((int)(n2 + 1), (int)0)];
        }
        return VelocityTrackerKt.polyFitLeastSquares(fArray, fArray2, n, n2, fArray3);
    }

    private static final float calculateImpulseVelocity(float[] dataPoints, float[] time, int sampleCount, boolean isDataDifferential) {
        if (sampleCount < 2) {
            return 0.0f;
        }
        if (sampleCount == 2) {
            if (time[0] == time[1]) {
                return 0.0f;
            }
            float dataPointsDelta = isDataDifferential ? dataPoints[0] : dataPoints[0] - dataPoints[1];
            return dataPointsDelta / (time[0] - time[1]);
        }
        float work = 0.0f;
        for (int i = sampleCount - 1; 0 < i; --i) {
            if (time[i] == time[i - 1]) continue;
            boolean $i$f$kineticEnergyToVelocity = false;
            float vPrev = Math.signum(work) * (float)Math.sqrt((float)2 * Math.abs(work));
            float dataPointsDelta = isDataDifferential ? -dataPoints[i - 1] : dataPoints[i] - dataPoints[i - 1];
            float vCurr = dataPointsDelta / (time[i] - time[i - 1]);
            work += (vCurr - vPrev) * Math.abs(vCurr);
            if (i != sampleCount - 1) continue;
            work *= 0.5f;
        }
        boolean $i$f$kineticEnergyToVelocity = false;
        return Math.signum(work) * (float)Math.sqrt((float)2 * Math.abs(work));
    }

    private static final float kineticEnergyToVelocity(float kineticEnergy) {
        boolean $i$f$kineticEnergyToVelocity = false;
        return Math.signum(kineticEnergy) * (float)Math.sqrt((float)2 * Math.abs(kineticEnergy));
    }

    private static final float dot(float[] $this$dot, float[] a) {
        float result2 = 0.0f;
        int n = $this$dot.length;
        for (int i = 0; i < n; ++i) {
            result2 += $this$dot[i] * a[i];
        }
        return result2;
    }

    private static final float norm(float[] $this$norm) {
        boolean $i$f$norm = false;
        return (float)Math.sqrt(VelocityTrackerKt.dot($this$norm, $this$norm));
    }

    private static final float[][] Matrix(int rows, int cols) {
        boolean $i$f$Matrix = false;
        int n = 0;
        float[][] fArrayArray = new float[rows][];
        while (n < rows) {
            int n2 = n++;
            fArrayArray[n2] = new float[cols];
        }
        return fArrayArray;
    }

    private static final float get(float[][] $this$get, int row, int col) {
        boolean $i$f$get = false;
        return $this$get[row][col];
    }

    private static final void set(float[][] $this$set, int row, int col, float value) {
        boolean $i$f$set = false;
        $this$set[row][col] = value;
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalComposeUiApi
    public static final boolean getVelocityTrackerAddPointsFix() {
        void $this$getValue$iv;
        State state = (State)VelocityTrackerAddPointsFix$delegate;
        Object var1_1 = null;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalComposeUiApi
    public static final void setVelocityTrackerAddPointsFix(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = VelocityTrackerAddPointsFix$delegate;
        Object var2_2 = null;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getVelocityTrackerAddPointsFix$annotations() {
    }

    public static final /* synthetic */ void access$set(DataPointAtTime[] $receiver, int index, long time, float dataPoint) {
        VelocityTrackerKt.set($receiver, index, time, dataPoint);
    }

    public static final /* synthetic */ float access$calculateImpulseVelocity(float[] dataPoints, float[] time, int sampleCount, boolean isDataDifferential) {
        return VelocityTrackerKt.calculateImpulseVelocity(dataPoints, time, sampleCount, isDataDifferential);
    }
}

