/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import android.graphics.Matrix;
import android.os.Build;
import android.view.inputmethod.CursorAnchorInfo;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.CursorAnchorInfoApi33Helper;
import androidx.compose.ui.text.input.CursorAnchorInfoApi34Helper;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a4\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001ad\u0010\u000b\u001a\u00020\f*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u0013H\u0000\u001a!\u0010\u0017\u001a\u00020\u0013*\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a,\u0010\u001c\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"addCharacterBounds", "Landroid/view/inputmethod/CursorAnchorInfo$Builder;", "startOffset", "", "endOffset", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "innerTextFieldBounds", "Landroidx/compose/ui/geometry/Rect;", "build", "Landroid/view/inputmethod/CursorAnchorInfo;", "textFieldValue", "Landroidx/compose/ui/text/input/TextFieldValue;", "matrix", "Landroid/graphics/Matrix;", "decorationBoxBounds", "includeInsertionMarker", "", "includeCharacterBounds", "includeEditorBounds", "includeLineBounds", "containsInclusive", "offset", "Landroidx/compose/ui/geometry/Offset;", "containsInclusive-Uv8p0NA", "(Landroidx/compose/ui/geometry/Rect;J)Z", "setInsertionMarker", "selectionStart", "ui_release"})
public final class CursorAnchorInfoBuilderKt {
    @NotNull
    public static final CursorAnchorInfo build(@NotNull CursorAnchorInfo.Builder $this$build, @NotNull TextFieldValue textFieldValue, @NotNull OffsetMapping offsetMapping, @NotNull TextLayoutResult textLayoutResult, @NotNull Matrix matrix, @NotNull Rect innerTextFieldBounds, @NotNull Rect decorationBoxBounds, boolean includeInsertionMarker, boolean includeCharacterBounds, boolean includeEditorBounds, boolean includeLineBounds) {
        $this$build.reset();
        $this$build.setMatrix(matrix);
        int selectionStart = TextRange.getMin-impl((long)textFieldValue.getSelection-d9O1mEE());
        int selectionEnd = TextRange.getMax-impl((long)textFieldValue.getSelection-d9O1mEE());
        $this$build.setSelectionRange(selectionStart, selectionEnd);
        if (includeInsertionMarker) {
            CursorAnchorInfoBuilderKt.setInsertionMarker($this$build, selectionStart, offsetMapping, textLayoutResult, innerTextFieldBounds);
        }
        if (includeCharacterBounds) {
            int compositionEnd;
            TextRange textRange = textFieldValue.getComposition-MzsxiRA();
            int compositionStart = textRange != null ? TextRange.getMin-impl((long)textRange.unbox-impl()) : -1;
            TextRange textRange2 = textFieldValue.getComposition-MzsxiRA();
            int n = compositionEnd = textRange2 != null ? TextRange.getMax-impl((long)textRange2.unbox-impl()) : -1;
            boolean bl = 0 <= compositionStart ? compositionStart < compositionEnd : false;
            if (bl) {
                $this$build.setComposingText(compositionStart, textFieldValue.getText().subSequence(compositionStart, compositionEnd));
                CursorAnchorInfoBuilderKt.addCharacterBounds($this$build, compositionStart, compositionEnd, offsetMapping, textLayoutResult, innerTextFieldBounds);
            }
        }
        if (Build.VERSION.SDK_INT >= 33 && includeEditorBounds) {
            CursorAnchorInfoApi33Helper.setEditorBoundsInfo($this$build, decorationBoxBounds);
        }
        if (Build.VERSION.SDK_INT >= 34 && includeLineBounds) {
            CursorAnchorInfoApi34Helper.addVisibleLineBounds($this$build, textLayoutResult, innerTextFieldBounds);
        }
        return $this$build.build();
    }

    public static /* synthetic */ CursorAnchorInfo build$default(CursorAnchorInfo.Builder builder, TextFieldValue textFieldValue, OffsetMapping offsetMapping, TextLayoutResult textLayoutResult, Matrix matrix, Rect rect, Rect rect2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = true;
        }
        if ((n & 0x80) != 0) {
            bl2 = true;
        }
        if ((n & 0x100) != 0) {
            bl3 = true;
        }
        if ((n & 0x200) != 0) {
            bl4 = true;
        }
        return CursorAnchorInfoBuilderKt.build(builder, textFieldValue, offsetMapping, textLayoutResult, matrix, rect, rect2, bl, bl2, bl3, bl4);
    }

    private static final CursorAnchorInfo.Builder setInsertionMarker(CursorAnchorInfo.Builder $this$setInsertionMarker, int selectionStart, OffsetMapping offsetMapping, TextLayoutResult textLayoutResult, Rect innerTextFieldBounds) {
        if (selectionStart < 0) {
            return $this$setInsertionMarker;
        }
        int selectionStartTransformed = offsetMapping.originalToTransformed(selectionStart);
        Rect cursorRect = textLayoutResult.getCursorRect(selectionStartTransformed);
        boolean isTopVisible = CursorAnchorInfoBuilderKt.containsInclusive-Uv8p0NA(innerTextFieldBounds, cursorRect.getTopLeft-F1C5BW0());
        boolean isBottomVisible = CursorAnchorInfoBuilderKt.containsInclusive-Uv8p0NA(innerTextFieldBounds, cursorRect.getBottomLeft-F1C5BW0());
        boolean isRtl = textLayoutResult.getBidiRunDirection(selectionStartTransformed) == ResolvedTextDirection.Rtl;
        int flags = 0;
        if (isTopVisible || isBottomVisible) {
            flags |= 1;
        }
        if (!isTopVisible || !isBottomVisible) {
            flags |= 2;
        }
        if (isRtl) {
            flags |= 4;
        }
        $this$setInsertionMarker.setInsertionMarkerLocation(cursorRect.getLeft(), cursorRect.getTop(), cursorRect.getBottom(), cursorRect.getBottom(), flags);
        return $this$setInsertionMarker;
    }

    private static final CursorAnchorInfo.Builder addCharacterBounds(CursorAnchorInfo.Builder $this$addCharacterBounds, int startOffset, int endOffset, OffsetMapping offsetMapping, TextLayoutResult textLayoutResult, Rect innerTextFieldBounds) {
        int startOffsetTransformed = offsetMapping.originalToTransformed(startOffset);
        int endOffsetTransformed = offsetMapping.originalToTransformed(endOffset);
        float[] array = new float[(endOffsetTransformed - startOffsetTransformed) * 4];
        textLayoutResult.getMultiParagraph().fillBoundingBoxes-8ffj60Q(TextRangeKt.TextRange((int)startOffsetTransformed, (int)endOffsetTransformed), array, 0);
        for (int offset = startOffset; offset < endOffset; ++offset) {
            int offsetTransformed = offsetMapping.originalToTransformed(offset);
            int arrayIndex = 4 * (offsetTransformed - startOffsetTransformed);
            Rect rect = new Rect(array[arrayIndex], array[arrayIndex + 1], array[arrayIndex + 2], array[arrayIndex + 3]);
            int flags = 0;
            if (innerTextFieldBounds.overlaps(rect)) {
                flags |= 1;
            }
            if (!CursorAnchorInfoBuilderKt.containsInclusive-Uv8p0NA(innerTextFieldBounds, rect.getTopLeft-F1C5BW0()) || !CursorAnchorInfoBuilderKt.containsInclusive-Uv8p0NA(innerTextFieldBounds, rect.getBottomRight-F1C5BW0())) {
                flags |= 2;
            }
            if (textLayoutResult.getBidiRunDirection(offsetTransformed) == ResolvedTextDirection.Rtl) {
                flags |= 4;
            }
            $this$addCharacterBounds.addCharacterBounds(offset, rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(), flags);
        }
        return $this$addCharacterBounds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean containsInclusive-Uv8p0NA(Rect $this$containsInclusive_u2dUv8p0NA, long offset) {
        float f = $this$containsInclusive_u2dUv8p0NA.getLeft();
        float f2 = $this$containsInclusive_u2dUv8p0NA.getRight();
        float f3 = Offset.getX-impl((long)offset);
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = $this$containsInclusive_u2dUv8p0NA.getTop();
        f2 = $this$containsInclusive_u2dUv8p0NA.getBottom();
        f3 = Offset.getY-impl((long)offset);
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        return true;
    }
}

