/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import android.os.Build;
import android.view.View;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.geometry.MutableRect;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.AndroidCanvas_androidKt;
import androidx.compose.ui.graphics.AndroidPaint_androidKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasHolder;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.RectangleShapeKt;
import androidx.compose.ui.graphics.ReusableGraphicsLayerScope;
import androidx.compose.ui.graphics.TransformOrigin;
import androidx.compose.ui.layout.GraphicLayerInfo;
import androidx.compose.ui.node.OwnedLayer;
import androidx.compose.ui.platform.AndroidComposeView;
import androidx.compose.ui.platform.DeviceRenderNode;
import androidx.compose.ui.platform.LayerMatrixCache;
import androidx.compose.ui.platform.OutlineResolver;
import androidx.compose.ui.platform.RenderNodeApi23;
import androidx.compose.ui.platform.RenderNodeApi29;
import androidx.compose.ui.platform.RenderNodeLayer;
import androidx.compose.ui.platform.WrapperRenderNodeLayerHelperMethods;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 U2\u00020\u00012\u00020\u0002:\u0002UVB/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u0007H\u0002J\b\u0010,\u001a\u00020\bH\u0016J\u0010\u0010-\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u0007H\u0016J\b\u0010.\u001a\u00020\bH\u0016J\u001d\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u000201H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b2\u00103J\u001d\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u000206H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b7\u00108J\u0018\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u000fH\u0016J%\u0010=\u001a\u0002062\u0006\u0010>\u001a\u0002062\u0006\u0010<\u001a\u00020\u000fH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b?\u0010@J\u001d\u0010A\u001a\u00020\b2\u0006\u00105\u001a\u00020BH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bC\u0010DJ\u001d\u0010E\u001a\u00020\b2\u0006\u0010F\u001a\u00020GH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bH\u0010DJ*\u0010I\u001a\u00020\b2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u001d\u0010J\u001a\u00020\b2\u0006\u00100\u001a\u000201H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bK\u00103J\b\u0010L\u001a\u00020\bH\u0002J\b\u0010M\u001a\u00020\bH\u0016J \u0010N\u001a\u00020\b2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0018R\u000e\u0010$\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010'\u001a\u00020(X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010)\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006W"}, d2={"Landroidx/compose/ui/platform/RenderNodeLayer;", "Landroidx/compose/ui/node/OwnedLayer;", "Landroidx/compose/ui/layout/GraphicLayerInfo;", "ownerView", "Landroidx/compose/ui/platform/AndroidComposeView;", "drawBlock", "Lkotlin/Function1;", "Landroidx/compose/ui/graphics/Canvas;", "", "invalidateParentLayer", "Lkotlin/Function0;", "(Landroidx/compose/ui/platform/AndroidComposeView;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "canvasHolder", "Landroidx/compose/ui/graphics/CanvasHolder;", "drawnWithZ", "", "isDestroyed", "value", "isDirty", "setDirty", "(Z)V", "layerId", "", "getLayerId", "()J", "matrixCache", "Landroidx/compose/ui/platform/LayerMatrixCache;", "Landroidx/compose/ui/platform/DeviceRenderNode;", "mutatedFields", "", "outlineResolver", "Landroidx/compose/ui/platform/OutlineResolver;", "getOwnerView", "()Landroidx/compose/ui/platform/AndroidComposeView;", "ownerViewId", "getOwnerViewId", "renderNode", "softwareLayerPaint", "Landroidx/compose/ui/graphics/Paint;", "transformOrigin", "Landroidx/compose/ui/graphics/TransformOrigin;", "J", "clipRenderNode", "canvas", "destroy", "drawLayer", "invalidate", "inverseTransform", "matrix", "Landroidx/compose/ui/graphics/Matrix;", "inverseTransform-58bKbWc", "([F)V", "isInLayer", "position", "Landroidx/compose/ui/geometry/Offset;", "isInLayer-k-4lQ0M", "(J)Z", "mapBounds", "rect", "Landroidx/compose/ui/geometry/MutableRect;", "inverse", "mapOffset", "point", "mapOffset-8S9VItk", "(JZ)J", "move", "Landroidx/compose/ui/unit/IntOffset;", "move--gyyYBs", "(J)V", "resize", "size", "Landroidx/compose/ui/unit/IntSize;", "resize-ozmzZPI", "reuseLayer", "transform", "transform-58bKbWc", "triggerRepaint", "updateDisplayList", "updateLayerProperties", "scope", "Landroidx/compose/ui/graphics/ReusableGraphicsLayerScope;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "density", "Landroidx/compose/ui/unit/Density;", "Companion", "UniqueDrawingIdApi29", "ui_release"})
@RequiresApi(value=23)
@SourceDebugExtension(value={"SMAP\nRenderNodeLayer.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderNodeLayer.android.kt\nandroidx/compose/ui/platform/RenderNodeLayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,411:1\n1#2:412\n*E\n"})
public final class RenderNodeLayer
implements OwnedLayer,
GraphicLayerInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidComposeView ownerView;
    @Nullable
    private Function1<? super Canvas, Unit> drawBlock;
    @Nullable
    private Function0<Unit> invalidateParentLayer;
    private boolean isDirty;
    @NotNull
    private final OutlineResolver outlineResolver;
    private boolean isDestroyed;
    private boolean drawnWithZ;
    @Nullable
    private Paint softwareLayerPaint;
    @NotNull
    private final LayerMatrixCache<DeviceRenderNode> matrixCache;
    @NotNull
    private final CanvasHolder canvasHolder;
    private long transformOrigin;
    @NotNull
    private final DeviceRenderNode renderNode;
    private int mutatedFields;
    @NotNull
    private static final Function2<DeviceRenderNode, android.graphics.Matrix, Unit> getMatrix = Companion.getMatrix.1.INSTANCE;

    /*
     * WARNING - void declaration
     */
    public RenderNodeLayer(@NotNull AndroidComposeView ownerView, @NotNull Function1<? super Canvas, Unit> drawBlock2, @NotNull Function0<Unit> invalidateParentLayer2) {
        void $this$renderNode_u24lambda_u240;
        DeviceRenderNode deviceRenderNode;
        this.ownerView = ownerView;
        this.drawBlock = drawBlock2;
        this.invalidateParentLayer = invalidateParentLayer2;
        this.outlineResolver = new OutlineResolver(this.ownerView.getDensity());
        this.matrixCache = new LayerMatrixCache<DeviceRenderNode>(getMatrix);
        this.canvasHolder = new CanvasHolder();
        this.transformOrigin = TransformOrigin.Companion.getCenter-SzJe1aQ();
        DeviceRenderNode deviceRenderNode2 = deviceRenderNode = Build.VERSION.SDK_INT >= 29 ? (DeviceRenderNode)new RenderNodeApi29(this.ownerView) : (DeviceRenderNode)new RenderNodeApi23(this.ownerView);
        RenderNodeLayer renderNodeLayer = this;
        boolean bl = false;
        $this$renderNode_u24lambda_u240.setHasOverlappingRendering(true);
        renderNodeLayer.renderNode = deviceRenderNode;
    }

    @NotNull
    public final AndroidComposeView getOwnerView() {
        return this.ownerView;
    }

    private final void setDirty(boolean value) {
        if (value != this.isDirty) {
            this.isDirty = value;
            this.ownerView.notifyLayerIsDirty$ui_release(this, value);
        }
    }

    @Override
    public long getLayerId() {
        return this.renderNode.getUniqueId();
    }

    @Override
    public long getOwnerViewId() {
        return Build.VERSION.SDK_INT >= 29 ? UniqueDrawingIdApi29.getUniqueDrawingId((View)this.ownerView) : -1L;
    }

    @Override
    public void updateLayerProperties(@NotNull ReusableGraphicsLayerScope scope, @NotNull LayoutDirection layoutDirection, @NotNull Density density) {
        boolean isClippingManually;
        boolean bl;
        boolean clipToOutline;
        boolean wasClippingManually;
        int maybeChangedFields = scope.getMutatedFields$ui_release() | this.mutatedFields;
        if ((maybeChangedFields & 0x1000) != 0) {
            this.transformOrigin = scope.getTransformOrigin-SzJe1aQ();
        }
        boolean bl2 = wasClippingManually = this.renderNode.getClipToOutline() && !this.outlineResolver.getOutlineClipSupported();
        if ((maybeChangedFields & 1) != 0) {
            this.renderNode.setScaleX(scope.getScaleX());
        }
        if ((maybeChangedFields & 2) != 0) {
            this.renderNode.setScaleY(scope.getScaleY());
        }
        if ((maybeChangedFields & 4) != 0) {
            this.renderNode.setAlpha(scope.getAlpha());
        }
        if ((maybeChangedFields & 8) != 0) {
            this.renderNode.setTranslationX(scope.getTranslationX());
        }
        if ((maybeChangedFields & 0x10) != 0) {
            this.renderNode.setTranslationY(scope.getTranslationY());
        }
        if ((maybeChangedFields & 0x20) != 0) {
            this.renderNode.setElevation(scope.getShadowElevation());
        }
        if ((maybeChangedFields & 0x40) != 0) {
            this.renderNode.setAmbientShadowColor(ColorKt.toArgb-8_81llA((long)scope.getAmbientShadowColor-0d7_KjU()));
        }
        if ((maybeChangedFields & 0x80) != 0) {
            this.renderNode.setSpotShadowColor(ColorKt.toArgb-8_81llA((long)scope.getSpotShadowColor-0d7_KjU()));
        }
        if ((maybeChangedFields & 0x400) != 0) {
            this.renderNode.setRotationZ(scope.getRotationZ());
        }
        if ((maybeChangedFields & 0x100) != 0) {
            this.renderNode.setRotationX(scope.getRotationX());
        }
        if ((maybeChangedFields & 0x200) != 0) {
            this.renderNode.setRotationY(scope.getRotationY());
        }
        if ((maybeChangedFields & 0x800) != 0) {
            this.renderNode.setCameraDistance(scope.getCameraDistance());
        }
        if ((maybeChangedFields & 0x1000) != 0) {
            this.renderNode.setPivotX(TransformOrigin.getPivotFractionX-impl(this.transformOrigin) * (float)this.renderNode.getWidth());
            this.renderNode.setPivotY(TransformOrigin.getPivotFractionY-impl(this.transformOrigin) * (float)this.renderNode.getHeight());
        }
        boolean bl3 = clipToOutline = scope.getClip() && scope.getShape() != RectangleShapeKt.getRectangleShape();
        if ((maybeChangedFields & 0x6000) != 0) {
            this.renderNode.setClipToOutline(clipToOutline);
            this.renderNode.setClipToBounds(scope.getClip() && scope.getShape() == RectangleShapeKt.getRectangleShape());
        }
        if ((maybeChangedFields & 0x20000) != 0) {
            this.renderNode.setRenderEffect(scope.getRenderEffect());
        }
        if ((maybeChangedFields & 0x8000) != 0) {
            this.renderNode.setCompositingStrategy-aDBOjCE(scope.getCompositingStrategy--NrFUSI());
        }
        if ((maybeChangedFields & 0x6004) != 0) {
            boolean bl4;
            boolean it = bl4 = this.outlineResolver.update(scope.getShape(), this.renderNode.getAlpha(), this.renderNode.getClipToOutline(), this.renderNode.getElevation(), layoutDirection, density);
            boolean bl5 = false;
            this.renderNode.setOutline(this.outlineResolver.getOutline());
            bl = bl4;
        } else {
            bl = false;
        }
        boolean shapeChanged = bl;
        boolean bl6 = isClippingManually = clipToOutline && !this.outlineResolver.getOutlineClipSupported();
        if (wasClippingManually != isClippingManually || isClippingManually && shapeChanged) {
            this.invalidate();
        } else {
            this.triggerRepaint();
        }
        if (!this.drawnWithZ && this.renderNode.getElevation() > 0.0f) {
            Function0<Unit> function0 = this.invalidateParentLayer;
            if (function0 != null) {
                function0.invoke();
            }
        }
        if ((maybeChangedFields & 0x1F1B) != 0) {
            this.matrixCache.invalidate();
        }
        this.mutatedFields = scope.getMutatedFields$ui_release();
    }

    @Override
    public boolean isInLayer-k-4lQ0M(long position) {
        float x = Offset.getX-impl((long)position);
        float y = Offset.getY-impl((long)position);
        if (this.renderNode.getClipToBounds()) {
            return 0.0f <= x && x < (float)this.renderNode.getWidth() && 0.0f <= y && y < (float)this.renderNode.getHeight();
        }
        if (this.renderNode.getClipToOutline()) {
            return this.outlineResolver.isInOutline-k-4lQ0M(position);
        }
        return true;
    }

    @Override
    public void resize-ozmzZPI(long size) {
        int width = IntSize.getWidth-impl((long)size);
        int height = IntSize.getHeight-impl((long)size);
        this.renderNode.setPivotX(TransformOrigin.getPivotFractionX-impl(this.transformOrigin) * (float)width);
        this.renderNode.setPivotY(TransformOrigin.getPivotFractionY-impl(this.transformOrigin) * (float)height);
        if (this.renderNode.setPosition(this.renderNode.getLeft(), this.renderNode.getTop(), this.renderNode.getLeft() + width, this.renderNode.getTop() + height)) {
            this.outlineResolver.update-uvyYCjk(SizeKt.Size((float)width, (float)height));
            this.renderNode.setOutline(this.outlineResolver.getOutline());
            this.invalidate();
            this.matrixCache.invalidate();
        }
    }

    @Override
    public void move--gyyYBs(long position) {
        int oldLeft = this.renderNode.getLeft();
        int oldTop = this.renderNode.getTop();
        int newLeft = IntOffset.getX-impl((long)position);
        int newTop = IntOffset.getY-impl((long)position);
        if (oldLeft != newLeft || oldTop != newTop) {
            if (oldLeft != newLeft) {
                this.renderNode.offsetLeftAndRight(newLeft - oldLeft);
            }
            if (oldTop != newTop) {
                this.renderNode.offsetTopAndBottom(newTop - oldTop);
            }
            this.triggerRepaint();
            this.matrixCache.invalidate();
        }
    }

    @Override
    public void invalidate() {
        if (!this.isDirty && !this.isDestroyed) {
            this.ownerView.invalidate();
            this.setDirty(true);
        }
    }

    private final void triggerRepaint() {
        if (Build.VERSION.SDK_INT >= 26) {
            WrapperRenderNodeLayerHelperMethods.INSTANCE.onDescendantInvalidated(this.ownerView);
        } else {
            this.ownerView.invalidate();
        }
    }

    @Override
    public void drawLayer(@NotNull Canvas canvas) {
        android.graphics.Canvas androidCanvas = AndroidCanvas_androidKt.getNativeCanvas((Canvas)canvas);
        if (androidCanvas.isHardwareAccelerated()) {
            this.updateDisplayList();
            boolean bl = this.drawnWithZ = this.renderNode.getElevation() > 0.0f;
            if (this.drawnWithZ) {
                canvas.enableZ();
            }
            this.renderNode.drawInto(androidCanvas);
            if (this.drawnWithZ) {
                canvas.disableZ();
            }
        } else {
            float left = this.renderNode.getLeft();
            float top = this.renderNode.getTop();
            float right = this.renderNode.getRight();
            float bottom = this.renderNode.getBottom();
            if (this.renderNode.getAlpha() < 1.0f) {
                Paint paint;
                Paint paint2 = this.softwareLayerPaint;
                if (paint2 == null) {
                    Paint paint3;
                    Paint it = paint3 = AndroidPaint_androidKt.Paint();
                    boolean bl = false;
                    this.softwareLayerPaint = it;
                    paint2 = paint3;
                }
                Paint $this$drawLayer_u24lambda_u243 = paint = paint2;
                boolean bl = false;
                $this$drawLayer_u24lambda_u243.setAlpha(this.renderNode.getAlpha());
                Paint paint4 = paint;
                androidCanvas.saveLayer(left, top, right, bottom, paint4.asFrameworkPaint());
            } else {
                canvas.save();
            }
            canvas.translate(left, top);
            canvas.concat-58bKbWc(this.matrixCache.calculateMatrix-GrdbGEg(this.renderNode));
            this.clipRenderNode(canvas);
            Function1<? super Canvas, Unit> function1 = this.drawBlock;
            if (function1 != null) {
                function1.invoke((Object)canvas);
            }
            canvas.restore();
            this.setDirty(false);
        }
    }

    private final void clipRenderNode(Canvas canvas) {
        if (this.renderNode.getClipToOutline() || this.renderNode.getClipToBounds()) {
            this.outlineResolver.clipToOutline(canvas);
        }
    }

    @Override
    public void updateDisplayList() {
        if (this.isDirty || !this.renderNode.getHasDisplayList()) {
            Path clipPath = this.renderNode.getClipToOutline() && !this.outlineResolver.getOutlineClipSupported() ? this.outlineResolver.getClipPath() : null;
            Function1<? super Canvas, Unit> function1 = this.drawBlock;
            if (function1 != null) {
                Function1<? super Canvas, Unit> it = function1;
                boolean bl = false;
                this.renderNode.record(this.canvasHolder, clipPath, it);
            }
            this.setDirty(false);
        }
    }

    @Override
    public void destroy() {
        if (this.renderNode.getHasDisplayList()) {
            this.renderNode.discardDisplayList();
        }
        this.drawBlock = null;
        this.invalidateParentLayer = null;
        this.isDestroyed = true;
        this.setDirty(false);
        this.ownerView.requestClearInvalidObservations();
        this.ownerView.recycle$ui_release(this);
    }

    @Override
    public long mapOffset-8S9VItk(long point, boolean inverse) {
        long l;
        if (inverse) {
            float[] fArray = this.matrixCache.calculateInverseMatrix-bWbORWo(this.renderNode);
            l = fArray != null ? Matrix.map-MK-Hz9U((float[])fArray, (long)point) : Offset.Companion.getInfinite-F1C5BW0();
        } else {
            l = Matrix.map-MK-Hz9U((float[])this.matrixCache.calculateMatrix-GrdbGEg(this.renderNode), (long)point);
        }
        return l;
    }

    @Override
    public void mapBounds(@NotNull MutableRect rect, boolean inverse) {
        if (inverse) {
            float[] matrix = this.matrixCache.calculateInverseMatrix-bWbORWo(this.renderNode);
            if (matrix == null) {
                rect.set(0.0f, 0.0f, 0.0f, 0.0f);
            } else {
                Matrix.map-impl((float[])matrix, (MutableRect)rect);
            }
        } else {
            Matrix.map-impl((float[])this.matrixCache.calculateMatrix-GrdbGEg(this.renderNode), (MutableRect)rect);
        }
    }

    @Override
    public void reuseLayer(@NotNull Function1<? super Canvas, Unit> drawBlock2, @NotNull Function0<Unit> invalidateParentLayer2) {
        this.setDirty(false);
        this.isDestroyed = false;
        this.drawnWithZ = false;
        this.transformOrigin = TransformOrigin.Companion.getCenter-SzJe1aQ();
        this.drawBlock = drawBlock2;
        this.invalidateParentLayer = invalidateParentLayer2;
    }

    @Override
    public void transform-58bKbWc(@NotNull float[] matrix) {
        Matrix.timesAssign-58bKbWc((float[])matrix, (float[])this.matrixCache.calculateMatrix-GrdbGEg(this.renderNode));
    }

    @Override
    public void inverseTransform-58bKbWc(@NotNull float[] matrix) {
        float[] inverse = this.matrixCache.calculateInverseMatrix-bWbORWo(this.renderNode);
        if (inverse != null) {
            Matrix.timesAssign-58bKbWc((float[])matrix, (float[])inverse);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/platform/RenderNodeLayer$Companion;", "", "()V", "getMatrix", "Lkotlin/Function2;", "Landroidx/compose/ui/platform/DeviceRenderNode;", "Landroid/graphics/Matrix;", "", "ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/platform/RenderNodeLayer$UniqueDrawingIdApi29;", "", "()V", "getUniqueDrawingId", "", "view", "Landroid/view/View;", "ui_release"})
    @RequiresApi(value=29)
    private static final class UniqueDrawingIdApi29 {
        @NotNull
        public static final UniqueDrawingIdApi29 INSTANCE = new UniqueDrawingIdApi29();

        private UniqueDrawingIdApi29() {
        }

        @JvmStatic
        @DoNotInline
        public static final long getUniqueDrawingId(@NotNull View view) {
            return view.getUniqueDrawingId();
        }
    }
}

