/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import android.graphics.Region;
import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.contentcapture.ContentCaptureManager;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.platform.AndroidComposeViewAccessibilityDelegateCompat_androidKt;
import androidx.compose.ui.platform.SemanticsNodeWithAdjustedBounds;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsOwner;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0011\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0003*\u00020\fH\u0002\u001a\f\u0010\u0016\u001a\u00020\u0003*\u00020\fH\u0002\u001a\"\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00030\u001aH\u0002\u001a\u0018\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c*\u00020\u001fH\u0000\u001a\f\u0010 \u001a\u00020\u0003*\u00020\fH\u0002\u001a\u0014\u0010!\u001a\u00020\u0003*\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"*\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038G@GX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\"\u0018\u0010\u000b\u001a\u00020\u0003*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\"\u001e\u0010\u000e\u001a\u00020\u0003*\u00020\f8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\r\u00a8\u0006$"}, d2={"DefaultFakeNodeBounds", "Landroidx/compose/ui/geometry/Rect;", "value", "", "DisableContentCapture", "getDisableContentCapture$annotations", "()V", "getDisableContentCapture", "()Z", "setDisableContentCapture", "(Z)V", "isRtl", "Landroidx/compose/ui/semantics/SemanticsNode;", "(Landroidx/compose/ui/semantics/SemanticsNode;)Z", "isVisible", "isVisible$annotations", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "accessibilityEquals", "Landroidx/compose/ui/semantics/AccessibilityAction;", "other", "", "enabled", "excludeLineAndPageGranularities", "findClosestParentNode", "Landroidx/compose/ui/node/LayoutNode;", "selector", "Lkotlin/Function1;", "getAllUncoveredSemanticsNodesToMap", "", "", "Landroidx/compose/ui/platform/SemanticsNodeWithAdjustedBounds;", "Landroidx/compose/ui/semantics/SemanticsOwner;", "isImportantForAccessibility", "propertiesDeleted", "oldConfig", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "ui_release"})
@SourceDebugExtension(value={"SMAP\nAndroidComposeViewAccessibilityDelegateCompat.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidComposeViewAccessibilityDelegateCompat.android.kt\nandroidx/compose/ui/platform/AndroidComposeViewAccessibilityDelegateCompat_androidKt\n+ 2 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,3359:1\n26#2:3360\n26#2:3361\n26#2:3362\n26#2:3363\n26#2:3364\n26#2:3365\n26#2:3366\n26#2:3367\n26#2:3368\n26#2:3369\n26#2:3370\n26#2:3371\n*S KotlinDebug\n*F\n+ 1 AndroidComposeViewAccessibilityDelegateCompat.android.kt\nandroidx/compose/ui/platform/AndroidComposeViewAccessibilityDelegateCompat_androidKt\n*L\n3256#1:3360\n3257#1:3361\n3258#1:3362\n3259#1:3363\n3272#1:3364\n3273#1:3365\n3274#1:3366\n3275#1:3367\n3309#1:3368\n3310#1:3369\n3311#1:3370\n3312#1:3371\n*E\n"})
public final class AndroidComposeViewAccessibilityDelegateCompat_androidKt {
    @NotNull
    private static final Rect DefaultFakeNodeBounds = new Rect(0.0f, 0.0f, 10.0f, 10.0f);

    private static final LayoutNode findClosestParentNode(LayoutNode $this$findClosestParentNode, Function1<? super LayoutNode, Boolean> selector) {
        for (LayoutNode currentParent = $this$findClosestParentNode.getParent$ui_release(); currentParent != null; currentParent = currentParent.getParent$ui_release()) {
            if (!((Boolean)selector.invoke((Object)currentParent)).booleanValue()) continue;
            return currentParent;
        }
        return null;
    }

    private static final boolean enabled(SemanticsNode $this$enabled) {
        return !$this$enabled.getConfig().contains(SemanticsProperties.INSTANCE.getDisabled());
    }

    private static final boolean isImportantForAccessibility(SemanticsNode $this$isImportantForAccessibility) {
        return $this$isImportantForAccessibility.getUnmergedConfig$ui_release().isMergingSemanticsOfDescendants() || $this$isImportantForAccessibility.getUnmergedConfig$ui_release().containsImportantForAccessibility$ui_release();
    }

    private static final boolean isVisible(SemanticsNode $this$isVisible) {
        return !$this$isVisible.isTransparent$ui_release() && !$this$isVisible.getUnmergedConfig$ui_release().contains(SemanticsProperties.INSTANCE.getInvisibleToUser());
    }

    private static /* synthetic */ void isVisible$annotations(SemanticsNode semanticsNode2) {
    }

    private static final boolean propertiesDeleted(SemanticsNode $this$propertiesDeleted, SemanticsConfiguration oldConfig) {
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : oldConfig) {
            if ($this$propertiesDeleted.getConfig().contains(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private static final boolean isRtl(SemanticsNode $this$isRtl) {
        return $this$isRtl.getLayoutInfo().getLayoutDirection() == LayoutDirection.Rtl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean excludeLineAndPageGranularities(SemanticsNode $this$excludeLineAndPageGranularities) {
        if ($this$excludeLineAndPageGranularities.getUnmergedConfig$ui_release().contains(SemanticsActions.INSTANCE.getSetText()) && !Intrinsics.areEqual((Object)SemanticsConfigurationKt.getOrNull($this$excludeLineAndPageGranularities.getUnmergedConfig$ui_release(), SemanticsProperties.INSTANCE.getFocused()), (Object)true)) {
            return true;
        }
        LayoutNode ancestor2 = AndroidComposeViewAccessibilityDelegateCompat_androidKt.findClosestParentNode($this$excludeLineAndPageGranularities.getLayoutNode$ui_release(), (Function1<? super LayoutNode, Boolean>)((Function1)excludeLineAndPageGranularities.ancestor.1.INSTANCE));
        if (ancestor2 == null) return false;
        SemanticsConfiguration semanticsConfiguration = ancestor2.getCollapsedSemantics$ui_release();
        if (semanticsConfiguration == null) return true;
        boolean bl = Intrinsics.areEqual((Object)SemanticsConfigurationKt.getOrNull(semanticsConfiguration, SemanticsProperties.INSTANCE.getFocused()), (Object)true);
        if (bl) return false;
        return true;
    }

    private static final boolean accessibilityEquals(AccessibilityAction<?> $this$accessibilityEquals, Object other) {
        if ($this$accessibilityEquals == other) {
            return true;
        }
        if (!(other instanceof AccessibilityAction)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$accessibilityEquals.getLabel(), (Object)((AccessibilityAction)other).getLabel())) {
            return false;
        }
        if ($this$accessibilityEquals.getAction() == null && ((AccessibilityAction)other).getAction() != null) {
            return false;
        }
        return $this$accessibilityEquals.getAction() == null || ((AccessibilityAction)other).getAction() != null;
    }

    @NotNull
    public static final Map<Integer, SemanticsNodeWithAdjustedBounds> getAllUncoveredSemanticsNodesToMap(@NotNull SemanticsOwner $this$getAllUncoveredSemanticsNodesToMap) {
        SemanticsNode root = $this$getAllUncoveredSemanticsNodesToMap.getUnmergedRootSemanticsNode();
        Map nodes = new LinkedHashMap();
        if (!root.getLayoutNode$ui_release().isPlaced() || !root.getLayoutNode$ui_release().isAttached()) {
            return nodes;
        }
        Rect $this$getAllUncoveredSemanticsNodesToMap_u24lambda_u240 = root.getBoundsInRoot();
        boolean bl = false;
        float $this$fastRoundToInt$iv = $this$getAllUncoveredSemanticsNodesToMap_u24lambda_u240.getLeft();
        boolean $i$f$fastRoundToInt = false;
        int n = Math.round($this$fastRoundToInt$iv);
        $this$fastRoundToInt$iv = $this$getAllUncoveredSemanticsNodesToMap_u24lambda_u240.getTop();
        $i$f$fastRoundToInt = false;
        int n2 = Math.round($this$fastRoundToInt$iv);
        $this$fastRoundToInt$iv = $this$getAllUncoveredSemanticsNodesToMap_u24lambda_u240.getRight();
        $i$f$fastRoundToInt = false;
        int n3 = Math.round($this$fastRoundToInt$iv);
        $this$fastRoundToInt$iv = $this$getAllUncoveredSemanticsNodesToMap_u24lambda_u240.getBottom();
        $i$f$fastRoundToInt = false;
        Region unaccountedSpace = new Region(n, n2, n3, Math.round($this$fastRoundToInt$iv));
        AndroidComposeViewAccessibilityDelegateCompat_androidKt.getAllUncoveredSemanticsNodesToMap$findAllSemanticNodesRecursive(unaccountedSpace, root, nodes, root, new Region());
        return nodes;
    }

    @ExperimentalComposeUiApi
    public static final boolean getDisableContentCapture() {
        return ContentCaptureManager.Companion.isEnabled();
    }

    @ExperimentalComposeUiApi
    public static final void setDisableContentCapture(boolean value) {
        ContentCaptureManager.Companion.setEnabled(value);
    }

    @Deprecated(message="Use ContentCapture.isEnabled instead", replaceWith=@ReplaceWith(expression="!ContentCaptureManager.isEnabled", imports={"androidx.compose.ui.contentcapture.ContentCaptureManager.Companion.isEnabled"}), level=DeprecationLevel.WARNING)
    @ExperimentalComposeUiApi
    public static /* synthetic */ void getDisableContentCapture$annotations() {
    }

    private static final void getAllUncoveredSemanticsNodesToMap$findAllSemanticNodesRecursive(Region unaccountedSpace, SemanticsNode root, Map<Integer, SemanticsNodeWithAdjustedBounds> nodes, SemanticsNode currentNode, Region region) {
        int virtualViewId;
        boolean notAttachedOrPlaced;
        boolean bl = notAttachedOrPlaced = !currentNode.getLayoutNode$ui_release().isPlaced() || !currentNode.getLayoutNode$ui_release().isAttached();
        if (unaccountedSpace.isEmpty() && currentNode.getId() != root.getId() || notAttachedOrPlaced && !currentNode.isFake$ui_release()) {
            return;
        }
        Rect touchBoundsInRoot = currentNode.getTouchBoundsInRoot();
        float $this$fastRoundToInt$iv = touchBoundsInRoot.getLeft();
        boolean $i$f$fastRoundToInt = false;
        int left = Math.round($this$fastRoundToInt$iv);
        float $this$fastRoundToInt$iv2 = touchBoundsInRoot.getTop();
        boolean $i$f$fastRoundToInt2 = false;
        int top = Math.round($this$fastRoundToInt$iv2);
        float $this$fastRoundToInt$iv3 = touchBoundsInRoot.getRight();
        boolean $i$f$fastRoundToInt3 = false;
        int right = Math.round($this$fastRoundToInt$iv3);
        float $this$fastRoundToInt$iv4 = touchBoundsInRoot.getBottom();
        boolean $i$f$fastRoundToInt4 = false;
        int bottom = Math.round($this$fastRoundToInt$iv4);
        region.set(left, top, right, bottom);
        int n = virtualViewId = currentNode.getId() == root.getId() ? -1 : currentNode.getId();
        if (region.op(unaccountedSpace, Region.Op.INTERSECT)) {
            Integer n2 = virtualViewId;
            nodes.put(n2, new SemanticsNodeWithAdjustedBounds(currentNode, region.getBounds()));
            List<SemanticsNode> children = currentNode.getReplacedChildren$ui_release();
            for (int i = children.size() - 1; -1 < i; --i) {
                AndroidComposeViewAccessibilityDelegateCompat_androidKt.getAllUncoveredSemanticsNodesToMap$findAllSemanticNodesRecursive(unaccountedSpace, root, nodes, children.get(i), region);
            }
            if (AndroidComposeViewAccessibilityDelegateCompat_androidKt.isImportantForAccessibility(currentNode)) {
                unaccountedSpace.op(left, top, right, bottom, Region.Op.DIFFERENCE);
            }
        } else if (currentNode.isFake$ui_release()) {
            SemanticsNode parentNode = currentNode.getParent();
            Object object = parentNode;
            Rect boundsForFakeNode = (object != null && (object = ((SemanticsNode)object).getLayoutInfo()) != null ? object.isPlaced() : false) ? parentNode.getBoundsInRoot() : DefaultFakeNodeBounds;
            Map<Integer, SemanticsNodeWithAdjustedBounds> map = nodes;
            Integer n3 = virtualViewId;
            float $this$fastRoundToInt$iv5 = boundsForFakeNode.getLeft();
            boolean $i$f$fastRoundToInt5 = false;
            int n4 = Math.round($this$fastRoundToInt$iv5);
            $this$fastRoundToInt$iv5 = boundsForFakeNode.getTop();
            $i$f$fastRoundToInt5 = false;
            int n5 = Math.round($this$fastRoundToInt$iv5);
            $this$fastRoundToInt$iv5 = boundsForFakeNode.getRight();
            $i$f$fastRoundToInt5 = false;
            int n6 = Math.round($this$fastRoundToInt$iv5);
            $this$fastRoundToInt$iv5 = boundsForFakeNode.getBottom();
            $i$f$fastRoundToInt5 = false;
            SemanticsNodeWithAdjustedBounds semanticsNodeWithAdjustedBounds = new SemanticsNodeWithAdjustedBounds(currentNode, new android.graphics.Rect(n4, n5, n6, Math.round($this$fastRoundToInt$iv5)));
            map.put(n3, semanticsNodeWithAdjustedBounds);
        } else if (virtualViewId == -1) {
            Integer n7 = virtualViewId;
            nodes.put(n7, new SemanticsNodeWithAdjustedBounds(currentNode, region.getBounds()));
        }
    }

    public static final /* synthetic */ boolean access$isRtl(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.isRtl($receiver);
    }

    public static final /* synthetic */ boolean access$isImportantForAccessibility(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.isImportantForAccessibility($receiver);
    }

    public static final /* synthetic */ boolean access$enabled(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.enabled($receiver);
    }

    public static final /* synthetic */ boolean access$isVisible(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.isVisible($receiver);
    }

    public static final /* synthetic */ boolean access$excludeLineAndPageGranularities(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.excludeLineAndPageGranularities($receiver);
    }

    public static final /* synthetic */ LayoutNode access$findClosestParentNode(LayoutNode $receiver, Function1 selector) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.findClosestParentNode($receiver, (Function1<? super LayoutNode, Boolean>)selector);
    }

    public static final /* synthetic */ boolean access$accessibilityEquals(AccessibilityAction $receiver, Object other) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.accessibilityEquals($receiver, other);
    }

    public static final /* synthetic */ boolean access$propertiesDeleted(SemanticsNode $receiver, SemanticsConfiguration oldConfig) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.propertiesDeleted($receiver, oldConfig);
    }
}

