/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.CornerRadiusKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.geometry.RoundRectKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.AndroidPath;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.platform.ShapeContainingUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u0018\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u001d\u00f8\u0001\u0000\u00a2\u0006\u0004\b,\u0010-J:\u0010.\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010/\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\b2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001a\u00f8\u0001\u0000\u00a2\u0006\u0004\b2\u00103J\b\u00104\u001a\u00020'H\u0002J\u0010\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020\u000eH\u0002J\u0010\u00107\u001a\u00020'2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020#H\u0002J0\u0010<\u001a\u00020\b*\u0004\u0018\u00010#2\u0006\u0010=\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020\u001fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b?\u0010@R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u000e\u0010\u0017\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006A"}, d2={"Landroidx/compose/ui/platform/OutlineResolver;", "", "()V", "androidOutline", "Landroid/graphics/Outline;", "getAndroidOutline", "()Landroid/graphics/Outline;", "<set-?>", "", "cacheIsDirty", "getCacheIsDirty$ui_release", "()Z", "cachedOutline", "cachedRrectPath", "Landroidx/compose/ui/graphics/Path;", "clipPath", "getClipPath", "()Landroidx/compose/ui/graphics/Path;", "isSupportedOutline", "outline", "Landroidx/compose/ui/graphics/Outline;", "outlineClipSupported", "getOutlineClipSupported", "outlineNeeded", "outlinePath", "rectSize", "Landroidx/compose/ui/geometry/Size;", "J", "rectTopLeft", "Landroidx/compose/ui/geometry/Offset;", "roundedCornerRadius", "", "tmpOpPath", "tmpPath", "tmpRoundRect", "Landroidx/compose/ui/geometry/RoundRect;", "tmpTouchPointPath", "usePathForClip", "clipToOutline", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "isInOutline", "position", "isInOutline-k-4lQ0M", "(J)Z", "update", "alpha", "elevation", "size", "update-S_szKao", "(Landroidx/compose/ui/graphics/Outline;FZFJ)Z", "updateCache", "updateCacheWithPath", "composePath", "updateCacheWithRect", "rect", "Landroidx/compose/ui/geometry/Rect;", "updateCacheWithRoundRect", "roundRect", "isSameBounds", "offset", "radius", "isSameBounds-4L21HEs", "(Landroidx/compose/ui/geometry/RoundRect;JJF)Z", "ui_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOutlineResolver.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutlineResolver.android.kt\nandroidx/compose/ui/platform/OutlineResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 4 AndroidPath.android.kt\nandroidx/compose/ui/graphics/AndroidPath_androidKt\n*L\n1#1,325:1\n1#2:326\n26#3:327\n26#3:328\n26#3:329\n26#3:330\n26#3:331\n26#3:332\n26#3:333\n26#3:334\n38#4,5:335\n*S KotlinDebug\n*F\n+ 1 OutlineResolver.android.kt\nandroidx/compose/ui/platform/OutlineResolver\n*L\n267#1:327\n268#1:328\n269#1:329\n270#1:330\n280#1:331\n281#1:332\n282#1:333\n283#1:334\n299#1:335,5\n*E\n"})
public final class OutlineResolver {
    private boolean isSupportedOutline = true;
    @NotNull
    private final android.graphics.Outline cachedOutline;
    @Nullable
    private Outline outline;
    @Nullable
    private Path cachedRrectPath;
    @Nullable
    private Path outlinePath;
    private boolean cacheIsDirty;
    private boolean usePathForClip;
    @Nullable
    private Path tmpPath;
    @Nullable
    private RoundRect tmpRoundRect;
    private float roundedCornerRadius;
    private long rectTopLeft;
    private long rectSize;
    private boolean outlineNeeded;
    @Nullable
    private Path tmpTouchPointPath;
    @Nullable
    private Path tmpOpPath;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public OutlineResolver() {
        void $this$cachedOutline_u24lambda_u240;
        android.graphics.Outline outline;
        android.graphics.Outline outline2 = outline = new android.graphics.Outline();
        OutlineResolver outlineResolver = this;
        boolean bl = false;
        $this$cachedOutline_u24lambda_u240.setAlpha(1.0f);
        outlineResolver.cachedOutline = outline;
        this.rectTopLeft = Offset.Companion.getZero-F1C5BW0();
        this.rectSize = Size.Companion.getZero-NH-jbRc();
    }

    public final boolean getCacheIsDirty$ui_release() {
        return this.cacheIsDirty;
    }

    @Nullable
    public final android.graphics.Outline getAndroidOutline() {
        this.updateCache();
        return !this.outlineNeeded || !this.isSupportedOutline ? null : this.cachedOutline;
    }

    public final boolean getOutlineClipSupported() {
        return !this.usePathForClip;
    }

    @Nullable
    public final Path getClipPath() {
        this.updateCache();
        return this.outlinePath;
    }

    public final boolean update-S_szKao(@Nullable Outline outline, float alpha, boolean clipToOutline, float elevation, long size) {
        boolean outlineNeeded;
        boolean outlineChanged;
        this.cachedOutline.setAlpha(alpha);
        boolean bl = outlineChanged = !Intrinsics.areEqual((Object)this.outline, (Object)outline);
        if (outlineChanged) {
            this.outline = outline;
            this.cacheIsDirty = true;
        }
        this.rectSize = size;
        boolean bl2 = outlineNeeded = outline != null && (clipToOutline || elevation > 0.0f);
        if (this.outlineNeeded != outlineNeeded) {
            this.outlineNeeded = outlineNeeded;
            this.cacheIsDirty = true;
        }
        return outlineChanged;
    }

    public final boolean isInOutline-k-4lQ0M(long position) {
        if (!this.outlineNeeded) {
            return true;
        }
        Outline outline = this.outline;
        if (outline == null) {
            return true;
        }
        Outline outline2 = outline;
        return ShapeContainingUtilKt.isInOutline(outline2, Offset.getX-impl((long)position), Offset.getY-impl((long)position), this.tmpTouchPointPath, this.tmpOpPath);
    }

    public final void clipToOutline(@NotNull Canvas canvas) {
        Path targetPath = this.getClipPath();
        if (targetPath != null) {
            Canvas.clipPath-mtrdD-E$default((Canvas)canvas, (Path)targetPath, (int)0, (int)2, null);
        } else if (this.roundedCornerRadius > 0.0f) {
            Path roundRectClipPath = this.tmpPath;
            RoundRect roundRect = this.tmpRoundRect;
            if (roundRectClipPath == null || !this.isSameBounds-4L21HEs(roundRect, this.rectTopLeft, this.rectSize, this.roundedCornerRadius)) {
                roundRect = RoundRectKt.RoundRect-gG7oq9Y((float)Offset.getX-impl((long)this.rectTopLeft), (float)Offset.getY-impl((long)this.rectTopLeft), (float)(Offset.getX-impl((long)this.rectTopLeft) + Size.getWidth-impl((long)this.rectSize)), (float)(Offset.getY-impl((long)this.rectTopLeft) + Size.getHeight-impl((long)this.rectSize)), (long)CornerRadiusKt.CornerRadius$default((float)this.roundedCornerRadius, (float)0.0f, (int)2, null));
                if (roundRectClipPath == null) {
                    roundRectClipPath = AndroidPath_androidKt.Path();
                } else {
                    roundRectClipPath.reset();
                }
                Path.addRoundRect$default((Path)roundRectClipPath, (RoundRect)roundRect, null, (int)2, null);
                this.tmpRoundRect = roundRect;
                this.tmpPath = roundRectClipPath;
            }
            Canvas.clipPath-mtrdD-E$default((Canvas)canvas, (Path)roundRectClipPath, (int)0, (int)2, null);
        } else {
            Canvas.clipRect-N_I0leg$default((Canvas)canvas, (float)Offset.getX-impl((long)this.rectTopLeft), (float)Offset.getY-impl((long)this.rectTopLeft), (float)(Offset.getX-impl((long)this.rectTopLeft) + Size.getWidth-impl((long)this.rectSize)), (float)(Offset.getY-impl((long)this.rectTopLeft) + Size.getHeight-impl((long)this.rectSize)), (int)0, (int)16, null);
        }
    }

    private final void updateCache() {
        if (this.cacheIsDirty) {
            this.rectTopLeft = Offset.Companion.getZero-F1C5BW0();
            this.roundedCornerRadius = 0.0f;
            this.outlinePath = null;
            this.cacheIsDirty = false;
            this.usePathForClip = false;
            Outline outline = this.outline;
            if (outline != null && this.outlineNeeded && Size.getWidth-impl((long)this.rectSize) > 0.0f && Size.getHeight-impl((long)this.rectSize) > 0.0f) {
                this.isSupportedOutline = true;
                Outline outline2 = outline;
                if (outline2 instanceof Outline.Rectangle) {
                    this.updateCacheWithRect(((Outline.Rectangle)outline).getRect());
                } else if (outline2 instanceof Outline.Rounded) {
                    this.updateCacheWithRoundRect(((Outline.Rounded)outline).getRoundRect());
                } else if (outline2 instanceof Outline.Generic) {
                    this.updateCacheWithPath(((Outline.Generic)outline).getPath());
                }
            } else {
                this.cachedOutline.setEmpty();
            }
        }
    }

    private final void updateCacheWithRect(Rect rect) {
        this.rectTopLeft = OffsetKt.Offset((float)rect.getLeft(), (float)rect.getTop());
        this.rectSize = SizeKt.Size((float)rect.getWidth(), (float)rect.getHeight());
        float $this$fastRoundToInt$iv = rect.getLeft();
        boolean $i$f$fastRoundToInt = false;
        int n = Math.round($this$fastRoundToInt$iv);
        $this$fastRoundToInt$iv = rect.getTop();
        $i$f$fastRoundToInt = false;
        int n2 = Math.round($this$fastRoundToInt$iv);
        $this$fastRoundToInt$iv = rect.getRight();
        $i$f$fastRoundToInt = false;
        int n3 = Math.round($this$fastRoundToInt$iv);
        $this$fastRoundToInt$iv = rect.getBottom();
        $i$f$fastRoundToInt = false;
        this.cachedOutline.setRect(n, n2, n3, Math.round($this$fastRoundToInt$iv));
    }

    private final void updateCacheWithRoundRect(RoundRect roundRect) {
        float radius = CornerRadius.getX-impl((long)roundRect.getTopLeftCornerRadius-kKHJgLs());
        this.rectTopLeft = OffsetKt.Offset((float)roundRect.getLeft(), (float)roundRect.getTop());
        this.rectSize = SizeKt.Size((float)roundRect.getWidth(), (float)roundRect.getHeight());
        if (RoundRectKt.isSimple((RoundRect)roundRect)) {
            float $this$fastRoundToInt$iv = roundRect.getLeft();
            boolean $i$f$fastRoundToInt = false;
            int n = Math.round($this$fastRoundToInt$iv);
            $this$fastRoundToInt$iv = roundRect.getTop();
            $i$f$fastRoundToInt = false;
            int n2 = Math.round($this$fastRoundToInt$iv);
            $this$fastRoundToInt$iv = roundRect.getRight();
            $i$f$fastRoundToInt = false;
            int n3 = Math.round($this$fastRoundToInt$iv);
            $this$fastRoundToInt$iv = roundRect.getBottom();
            $i$f$fastRoundToInt = false;
            this.cachedOutline.setRoundRect(n, n2, n3, Math.round($this$fastRoundToInt$iv), radius);
            this.roundedCornerRadius = radius;
        } else {
            Path path = this.cachedRrectPath;
            if (path == null) {
                Path path2;
                Path it = path2 = AndroidPath_androidKt.Path();
                boolean bl = false;
                this.cachedRrectPath = it;
                path = path2;
            }
            Path path3 = path;
            path3.reset();
            Path.addRoundRect$default((Path)path3, (RoundRect)roundRect, null, (int)2, null);
            this.updateCacheWithPath(path3);
        }
    }

    private final void updateCacheWithPath(Path composePath) {
        if (Build.VERSION.SDK_INT > 28 || composePath.isConvex()) {
            Path $this$asAndroidPath$iv = composePath;
            boolean $i$f$asAndroidPath = false;
            if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
                throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
            }
            this.cachedOutline.setConvexPath(((AndroidPath)$this$asAndroidPath$iv).getInternalPath());
            this.usePathForClip = !this.cachedOutline.canClip();
        } else {
            this.isSupportedOutline = false;
            this.cachedOutline.setEmpty();
            this.usePathForClip = true;
        }
        this.outlinePath = composePath;
    }

    private final boolean isSameBounds-4L21HEs(RoundRect $this$isSameBounds_u2d4L21HEs, long offset, long size, float radius) {
        if ($this$isSameBounds_u2d4L21HEs == null || !RoundRectKt.isSimple((RoundRect)$this$isSameBounds_u2d4L21HEs)) {
            return false;
        }
        return $this$isSameBounds_u2d4L21HEs.getLeft() == Offset.getX-impl((long)offset) && $this$isSameBounds_u2d4L21HEs.getTop() == Offset.getY-impl((long)offset) && $this$isSameBounds_u2d4L21HEs.getRight() == Offset.getX-impl((long)offset) + Size.getWidth-impl((long)size) && $this$isSameBounds_u2d4L21HEs.getBottom() == Offset.getY-impl((long)offset) + Size.getHeight-impl((long)size) && CornerRadius.getX-impl((long)$this$isSameBounds_u2d4L21HEs.getTopLeftCornerRadius-kKHJgLs()) == radius;
    }
}

