/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.geometry;

import androidx.compose.Immutable;
import androidx.compose.Stable;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.SizeKt;
import androidx.ui.util.JvmMathHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0087\b\u0018\u0000 F2\u00020\u0001:\u0001FB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J1\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003H\u0007J\u0013\u0010'\u001a\u00020!2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000J\u0006\u0010*\u001a\u00020#J\u0006\u0010+\u001a\u00020#J\u0006\u0010,\u001a\u00020#J\u0006\u0010-\u001a\u00020#J\u0006\u0010.\u001a\u00020#J\u0006\u0010/\u001a\u00020#J\u0013\u00100\u001a\u000201\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b2\u00103J\u0006\u00104\u001a\u00020#J\u0006\u00105\u001a\u00020#J\u0006\u00106\u001a\u00020#J\t\u00107\u001a\u000208H\u00d6\u0001J\u0010\u00109\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003H\u0007J\u0010\u0010:\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000H\u0007J\b\u0010;\u001a\u00020!H\u0007J\b\u0010<\u001a\u00020!H\u0007J\b\u0010=\u001a\u00020!H\u0007J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000J\u000e\u0010?\u001a\u00020!2\u0006\u0010(\u001a\u00020\u0000J\u0010\u0010@\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#H\u0007J\b\u0010A\u001a\u00020BH\u0016J\u0018\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u00032\u0006\u0010E\u001a\u00020\u0003H\u0007R\u001c\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\t\u001a\u0004\b\u000e\u0010\u000bR\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\t\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u001c\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\t\u001a\u0004\b\u0016\u0010\u000bR\u001c\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\t\u001a\u0004\b\u0018\u0010\u000bR\u001c\u0010\u0019\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\t\u001a\u0004\b\u001b\u0010\u000b\u0082\u0002\b\n\u0002\b\u0019\n\u0002\b!\u00a8\u0006G"}, d2={"Landroidx/ui/geometry/Rect;", "", "left", "", "top", "right", "bottom", "(FFFF)V", "getBottom$annotations", "()V", "getBottom", "()F", "height", "getHeight$annotations", "getHeight", "getLeft$annotations", "getLeft", "maxDimension", "getMaxDimension", "minDimension", "getMinDimension", "getRight$annotations", "getRight", "getTop$annotations", "getTop", "width", "getWidth$annotations", "getWidth", "component1", "component2", "component3", "component4", "contains", "", "offset", "Landroidx/ui/geometry/Offset;", "copy", "deflate", "delta", "equals", "other", "expandToInclude", "getBottomCenter", "getBottomLeft", "getBottomRight", "getCenter", "getCenterLeft", "getCenterRight", "getSize", "Landroidx/ui/geometry/Size;", "getSize-B8_uKPY", "()J", "getTopCenter", "getTopLeft", "getTopRight", "hashCode", "", "inflate", "intersect", "isEmpty", "isFinite", "isInfinite", "join", "overlaps", "shift", "toString", "", "translate", "translateX", "translateY", "Companion", "ui-geometry_release"})
@Immutable
public final class Rect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;
    private final float width;
    private final float height;
    private static final Rect zero = new Rect(0.0f, 0.0f, 0.0f, 0.0f);
    private static final float _giantScalar = 1.0E7f;
    private static final Rect largest = Companion.fromLTRB(-Companion.get_giantScalar(), -Companion.get_giantScalar(), Companion.get_giantScalar(), Companion.get_giantScalar());

    public Rect(float left, float top, float right, float bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.width = this.right - this.left;
        this.height = this.bottom - this.top;
    }

    public final float getLeft() {
        return this.left;
    }

    @Stable
    public static /* synthetic */ void getLeft$annotations() {
    }

    public final float getTop() {
        return this.top;
    }

    @Stable
    public static /* synthetic */ void getTop$annotations() {
    }

    public final float getRight() {
        return this.right;
    }

    @Stable
    public static /* synthetic */ void getRight$annotations() {
    }

    public final float getBottom() {
        return this.bottom;
    }

    @Stable
    public static /* synthetic */ void getBottom$annotations() {
    }

    public final float getWidth() {
        return this.width;
    }

    @Stable
    public static /* synthetic */ void getWidth$annotations() {
    }

    public final float getHeight() {
        return this.height;
    }

    @Stable
    public static /* synthetic */ void getHeight$annotations() {
    }

    public final long getSize-B8_uKPY() {
        return SizeKt.Size(this.width, this.height);
    }

    @Stable
    public final boolean isInfinite() {
        return this.left >= Float.POSITIVE_INFINITY || this.top >= Float.POSITIVE_INFINITY || this.right >= Float.POSITIVE_INFINITY || this.bottom >= Float.POSITIVE_INFINITY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Stable
    public final boolean isFinite() {
        float f = this.left;
        boolean bl = false;
        float f2 = f;
        boolean bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        f = this.top;
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl4 = true;
        if (!bl4) return false;
        f = this.right;
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl5 = true;
        if (!bl5) return false;
        f = this.bottom;
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        return true;
    }

    @Stable
    public final boolean isEmpty() {
        return this.left >= this.right || this.top >= this.bottom;
    }

    @Stable
    @NotNull
    public final Rect shift(@NotNull Offset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return Companion.fromLTRB(this.left + offset.getX(), this.top + offset.getY(), this.right + offset.getX(), this.bottom + offset.getY());
    }

    @Stable
    @NotNull
    public final Rect translate(float translateX, float translateY) {
        return Companion.fromLTRB(this.left + translateX, this.top + translateY, this.right + translateX, this.bottom + translateY);
    }

    @Stable
    @NotNull
    public final Rect inflate(float delta) {
        return Companion.fromLTRB(this.left - delta, this.top - delta, this.right + delta, this.bottom + delta);
    }

    @Stable
    @NotNull
    public final Rect deflate(float delta) {
        return this.inflate(-delta);
    }

    @Stable
    @NotNull
    public final Rect intersect(@NotNull Rect other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        float f = this.left;
        float f2 = other.left;
        boolean bl = false;
        float f3 = Math.max(f, f2);
        f = this.top;
        f2 = other.top;
        bl = false;
        float f4 = Math.max(f, f2);
        f = this.right;
        f2 = other.right;
        bl = false;
        float f5 = Math.min(f, f2);
        f = this.bottom;
        f2 = other.bottom;
        bl = false;
        return Companion.fromLTRB(f3, f4, f5, Math.min(f, f2));
    }

    @NotNull
    public final Rect expandToInclude(@NotNull Rect other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        float f = this.left;
        float f2 = other.left;
        boolean bl = false;
        float f3 = Math.min(f, f2);
        f = this.top;
        f2 = other.top;
        bl = false;
        float f4 = Math.min(f, f2);
        f = this.right;
        f2 = other.right;
        bl = false;
        float f5 = Math.max(f, f2);
        f = this.bottom;
        f2 = other.bottom;
        bl = false;
        return Companion.fromLTRB(f3, f4, f5, Math.max(f, f2));
    }

    @NotNull
    public final Rect join(@NotNull Rect other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        return this.expandToInclude(other);
    }

    public final boolean overlaps(@NotNull Rect other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.right <= other.left || other.right <= this.left) {
            return false;
        }
        return !(this.bottom <= other.top) && !(other.bottom <= this.top);
    }

    public final float getMinDimension() {
        float f = this.width;
        boolean bl = false;
        f = Math.abs(f);
        float f2 = this.height;
        boolean bl2 = false;
        f2 = Math.abs(f2);
        bl2 = false;
        return Math.min(f, f2);
    }

    public final float getMaxDimension() {
        float f = this.width;
        boolean bl = false;
        f = Math.abs(f);
        float f2 = this.height;
        boolean bl2 = false;
        f2 = Math.abs(f2);
        bl2 = false;
        return Math.max(f, f2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Offset getTopLeft() {
        void x$iv;
        float f = this.left;
        float y$iv = this.top;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_5 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_5);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        return new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Offset getTopCenter() {
        void x$iv;
        float f = this.left + this.width / 2.0f;
        float y$iv = this.top;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_5 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_5);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        return new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Offset getTopRight() {
        void x$iv;
        float f = this.right;
        float y$iv = this.top;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_5 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_5);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        return new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Offset getCenterLeft() {
        void x$iv;
        float f = this.left;
        float y$iv = this.top + this.height / 2.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_5 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_5);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        return new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Offset getCenter() {
        void x$iv;
        float f = this.left + this.width / 2.0f;
        float y$iv = this.top + this.height / 2.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_5 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_5);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        return new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Offset getCenterRight() {
        void x$iv;
        float f = this.right;
        float y$iv = this.top + this.height / 2.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_5 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_5);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        return new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Offset getBottomLeft() {
        void x$iv;
        float f = this.left;
        float y$iv = this.bottom;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_5 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_5);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        return new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Offset getBottomCenter() {
        void x$iv;
        float f = this.left + this.width / 2.0f;
        float y$iv = this.bottom;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_5 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_5);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        return new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Offset getBottomRight() {
        void x$iv;
        float f = this.right;
        float y$iv = this.bottom;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_5 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_5);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        return new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    public final boolean contains(@NotNull Offset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return offset.getX() >= this.left && offset.getX() < this.right && offset.getY() >= this.top && offset.getY() < this.bottom;
    }

    @NotNull
    public String toString() {
        return "Rect.fromLTRB(" + JvmMathHelpersKt.toStringAsFixed((float)this.left, (int)1) + ", " + JvmMathHelpersKt.toStringAsFixed((float)this.top, (int)1) + ", " + JvmMathHelpersKt.toStringAsFixed((float)this.right, (int)1) + ", " + JvmMathHelpersKt.toStringAsFixed((float)this.bottom, (int)1) + ')';
    }

    public final float component1() {
        return this.left;
    }

    public final float component2() {
        return this.top;
    }

    public final float component3() {
        return this.right;
    }

    public final float component4() {
        return this.bottom;
    }

    @NotNull
    public final Rect copy(float left, float top, float right, float bottom) {
        return new Rect(left, top, right, bottom);
    }

    public static /* synthetic */ Rect copy$default(Rect rect, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = rect.left;
        }
        if ((n & 2) != 0) {
            f2 = rect.top;
        }
        if ((n & 4) != 0) {
            f3 = rect.right;
        }
        if ((n & 8) != 0) {
            f4 = rect.bottom;
        }
        return rect.copy(f, f2, f3, f4);
    }

    public int hashCode() {
        return ((Float.hashCode(this.left) * 31 + Float.hashCode(this.top)) * 31 + Float.hashCode(this.right)) * 31 + Float.hashCode(this.bottom);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rect)) {
            return false;
        }
        Object object = other;
        Rect rect = (Rect)object;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.left), (Object)Float.valueOf(rect.left))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.top), (Object)Float.valueOf(rect.top))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.right), (Object)Float.valueOf(rect.right))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.bottom), (Object)Float.valueOf(rect.bottom));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J(\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J(\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001d"}, d2={"Landroidx/ui/geometry/Rect$Companion;", "", "()V", "_giantScalar", "", "get_giantScalar", "()F", "largest", "Landroidx/ui/geometry/Rect;", "getLargest", "()Landroidx/ui/geometry/Rect;", "zero", "getZero$annotations", "getZero", "fromCircle", "center", "Landroidx/ui/geometry/Offset;", "radius", "fromLTRB", "left", "top", "right", "bottom", "fromLTWH", "width", "height", "fromPoints", "a", "b", "ui-geometry_release"})
    public static final class Companion {
        private Companion() {
        }

        @Stable
        @NotNull
        public final Rect fromLTRB(float left, float top, float right, float bottom) {
            return new Rect(left, top, right, bottom);
        }

        @Stable
        @NotNull
        public final Rect fromLTWH(float left, float top, float width, float height) {
            return new Rect(left, top, left + width, top + height);
        }

        @Stable
        @NotNull
        public final Rect fromCircle(@NotNull Offset center, float radius) {
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            return new Rect(center.getX() - radius, center.getY() - radius, center.getX() + radius, center.getY() + radius);
        }

        @Stable
        @NotNull
        public final Rect fromPoints(@NotNull Offset a, @NotNull Offset b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            float f = a.getX();
            float f2 = b.getX();
            boolean bl = false;
            float f3 = Math.min(f, f2);
            f = a.getY();
            f2 = b.getY();
            bl = false;
            float f4 = Math.min(f, f2);
            f = a.getX();
            f2 = b.getX();
            bl = false;
            float f5 = Math.max(f, f2);
            f = a.getY();
            f2 = b.getY();
            bl = false;
            return new Rect(f3, f4, f5, Math.max(f, f2));
        }

        @NotNull
        public final Rect getZero() {
            return zero;
        }

        @Stable
        public static /* synthetic */ void getZero$annotations() {
        }

        public final float get_giantScalar() {
            return _giantScalar;
        }

        @NotNull
        public final Rect getLargest() {
            return largest;
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

