/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.graphics.AndroidMatrixConversions_androidKt;
import androidx.compose.ui.graphics.DegreesKt;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathFillType;
import androidx.compose.ui.graphics.PathOperation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J \u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020!H\u0016J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\"\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010,J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u000200H\u0016J(\u00101\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u00102\u001a\u00020\u000fH\u0016J\b\u00103\u001a\u00020\u001eH\u0016J8\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020!2\u0006\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020!H\u0016J\b\u0010;\u001a\u00020\u001cH\u0016J\u0018\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020!H\u0016J\u0018\u0010?\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020!H\u0016J*\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\u00012\u0006\u0010B\u001a\u00020\u00012\u0006\u0010C\u001a\u00020DH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\bE\u0010FJ(\u0010G\u001a\u00020\u001e2\u0006\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020!2\u0006\u00108\u001a\u00020!H\u0016J8\u0010H\u001a\u00020\u001e2\u0006\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020!2\u0006\u0010K\u001a\u00020!2\u0006\u0010L\u001a\u00020!2\u0006\u0010M\u001a\u00020!2\u0006\u0010N\u001a\u00020!H\u0016J\u0018\u0010O\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020!2\u0006\u0010Q\u001a\u00020!H\u0016J\u0018\u0010R\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020!2\u0006\u0010Q\u001a\u00020!H\u0016J(\u0010S\u001a\u00020\u001e2\u0006\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020!2\u0006\u0010K\u001a\u00020!2\u0006\u0010L\u001a\u00020!H\u0016J\b\u0010T\u001a\u00020\u001eH\u0016J\b\u0010U\u001a\u00020\u001eH\u0016J\u001a\u0010V\u001a\u00020\u001e2\u0006\u0010W\u001a\u00020XH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\bY\u0010ZJ\u001a\u0010[\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\\\u0010]R*\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006^"}, d2={"Landroidx/compose/ui/graphics/AndroidPath;", "Landroidx/compose/ui/graphics/Path;", "internalPath", "Landroid/graphics/Path;", "(Landroid/graphics/Path;)V", "value", "Landroidx/compose/ui/graphics/PathFillType;", "fillType", "getFillType-Rg-k1Os", "()I", "setFillType-oQ8Xj4U", "(I)V", "getInternalPath", "()Landroid/graphics/Path;", "isConvex", "", "isConvex$annotations", "()V", "()Z", "isEmpty", "mMatrix", "Landroid/graphics/Matrix;", "radii", "", "rectF", "Landroid/graphics/RectF;", "_rectIsValid", "rect", "Landroidx/compose/ui/geometry/Rect;", "addArc", "", "oval", "startAngleDegrees", "", "sweepAngleDegrees", "addArcRad", "startAngleRadians", "sweepAngleRadians", "addOval", "addPath", "path", "offset", "Landroidx/compose/ui/geometry/Offset;", "addPath-Uv8p0NA", "(Landroidx/compose/ui/graphics/Path;J)V", "addRect", "addRoundRect", "roundRect", "Landroidx/compose/ui/geometry/RoundRect;", "arcTo", "forceMoveTo", "close", "cubicTo", "x1", "y1", "x2", "y2", "x3", "y3", "getBounds", "lineTo", "x", "y", "moveTo", "op", "path1", "path2", "operation", "Landroidx/compose/ui/graphics/PathOperation;", "op-N5in7k0", "(Landroidx/compose/ui/graphics/Path;Landroidx/compose/ui/graphics/Path;I)Z", "quadraticBezierTo", "relativeCubicTo", "dx1", "dy1", "dx2", "dy2", "dx3", "dy3", "relativeLineTo", "dx", "dy", "relativeMoveTo", "relativeQuadraticBezierTo", "reset", "rewind", "transform", "matrix", "Landroidx/compose/ui/graphics/Matrix;", "transform-58bKbWc", "([F)V", "translate", "translate-k-4lQ0M", "(J)V", "ui-graphics_release"})
@SourceDebugExtension(value={"SMAP\nAndroidPath.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPath.android.kt\nandroidx/compose/ui/graphics/AndroidPath\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AndroidPath.android.kt\nandroidx/compose/ui/graphics/AndroidPath_androidKt\n*L\n1#1,258:1\n1#2:259\n35#3,5:260\n35#3,5:265\n*S KotlinDebug\n*F\n+ 1 AndroidPath.android.kt\nandroidx/compose/ui/graphics/AndroidPath\n*L\n181#1:260,5\n234#1:265,5\n*E\n"})
public final class AndroidPath
implements Path {
    @NotNull
    private final android.graphics.Path internalPath;
    @Nullable
    private RectF rectF;
    @Nullable
    private float[] radii;
    @Nullable
    private Matrix mMatrix;

    public AndroidPath(@NotNull android.graphics.Path internalPath) {
        this.internalPath = internalPath;
    }

    public /* synthetic */ AndroidPath(android.graphics.Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            path = new android.graphics.Path();
        }
        this(path);
    }

    @NotNull
    public final android.graphics.Path getInternalPath() {
        return this.internalPath;
    }

    @Override
    public int getFillType-Rg-k1Os() {
        if (this.internalPath.getFillType() == Path.FillType.EVEN_ODD) {
            return PathFillType.Companion.getEvenOdd-Rg-k1Os();
        }
        return PathFillType.Companion.getNonZero-Rg-k1Os();
    }

    @Override
    public void setFillType-oQ8Xj4U(int value) {
        this.internalPath.setFillType(PathFillType.equals-impl0(value, PathFillType.Companion.getEvenOdd-Rg-k1Os()) ? Path.FillType.EVEN_ODD : Path.FillType.WINDING);
    }

    @Override
    public void moveTo(float x, float y) {
        this.internalPath.moveTo(x, y);
    }

    @Override
    public void relativeMoveTo(float dx, float dy) {
        this.internalPath.rMoveTo(dx, dy);
    }

    @Override
    public void lineTo(float x, float y) {
        this.internalPath.lineTo(x, y);
    }

    @Override
    public void relativeLineTo(float dx, float dy) {
        this.internalPath.rLineTo(dx, dy);
    }

    @Override
    public void quadraticBezierTo(float x1, float y1, float x2, float y2) {
        this.internalPath.quadTo(x1, y1, x2, y2);
    }

    @Override
    public void relativeQuadraticBezierTo(float dx1, float dy1, float dx2, float dy2) {
        this.internalPath.rQuadTo(dx1, dy1, dx2, dy2);
    }

    @Override
    public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.internalPath.cubicTo(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public void relativeCubicTo(float dx1, float dy1, float dx2, float dy2, float dx3, float dy3) {
        this.internalPath.rCubicTo(dx1, dy1, dx2, dy2, dx3, dy3);
    }

    @Override
    public void arcTo(@NotNull Rect rect, float startAngleDegrees, float sweepAngleDegrees, boolean forceMoveTo) {
        float left = rect.getLeft();
        float top = rect.getTop();
        float right = rect.getRight();
        float bottom = rect.getBottom();
        if (this.rectF == null) {
            this.rectF = new RectF();
        }
        RectF rectF = this.rectF;
        Intrinsics.checkNotNull((Object)rectF);
        rectF.set(left, top, right, bottom);
        RectF rectF2 = this.rectF;
        Intrinsics.checkNotNull((Object)rectF2);
        this.internalPath.arcTo(rectF2, startAngleDegrees, sweepAngleDegrees, forceMoveTo);
    }

    @Override
    public void addRect(@NotNull Rect rect) {
        if (!this._rectIsValid(rect)) {
            boolean bl = false;
            String string = "invalid rect";
            throw new IllegalStateException(string.toString());
        }
        if (this.rectF == null) {
            this.rectF = new RectF();
        }
        RectF rectF = this.rectF;
        Intrinsics.checkNotNull((Object)rectF);
        rectF.set(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom());
        RectF rectF2 = this.rectF;
        Intrinsics.checkNotNull((Object)rectF2);
        this.internalPath.addRect(rectF2, Path.Direction.CCW);
    }

    @Override
    public void addOval(@NotNull Rect oval) {
        if (this.rectF == null) {
            this.rectF = new RectF();
        }
        RectF rectF = this.rectF;
        Intrinsics.checkNotNull((Object)rectF);
        rectF.set(oval.getLeft(), oval.getTop(), oval.getRight(), oval.getBottom());
        RectF rectF2 = this.rectF;
        Intrinsics.checkNotNull((Object)rectF2);
        this.internalPath.addOval(rectF2, Path.Direction.CCW);
    }

    @Override
    public void addArcRad(@NotNull Rect oval, float startAngleRadians, float sweepAngleRadians) {
        this.addArc(oval, DegreesKt.degrees(startAngleRadians), DegreesKt.degrees(sweepAngleRadians));
    }

    @Override
    public void addArc(@NotNull Rect oval, float startAngleDegrees, float sweepAngleDegrees) {
        if (!this._rectIsValid(oval)) {
            boolean bl = false;
            String string = "invalid rect";
            throw new IllegalStateException(string.toString());
        }
        if (this.rectF == null) {
            this.rectF = new RectF();
        }
        RectF rectF = this.rectF;
        Intrinsics.checkNotNull((Object)rectF);
        rectF.set(oval.getLeft(), oval.getTop(), oval.getRight(), oval.getBottom());
        RectF rectF2 = this.rectF;
        Intrinsics.checkNotNull((Object)rectF2);
        this.internalPath.addArc(rectF2, startAngleDegrees, sweepAngleDegrees);
    }

    @Override
    public void addRoundRect(@NotNull RoundRect roundRect) {
        if (this.rectF == null) {
            this.rectF = new RectF();
        }
        RectF rectF = this.rectF;
        Intrinsics.checkNotNull((Object)rectF);
        rectF.set(roundRect.getLeft(), roundRect.getTop(), roundRect.getRight(), roundRect.getBottom());
        if (this.radii == null) {
            this.radii = new float[8];
        }
        Intrinsics.checkNotNull((Object)this.radii);
        float[] $this$addRoundRect_u24lambda_u242 = this.radii;
        boolean bl = false;
        $this$addRoundRect_u24lambda_u242[0] = CornerRadius.getX-impl((long)roundRect.getTopLeftCornerRadius-kKHJgLs());
        $this$addRoundRect_u24lambda_u242[1] = CornerRadius.getY-impl((long)roundRect.getTopLeftCornerRadius-kKHJgLs());
        $this$addRoundRect_u24lambda_u242[2] = CornerRadius.getX-impl((long)roundRect.getTopRightCornerRadius-kKHJgLs());
        $this$addRoundRect_u24lambda_u242[3] = CornerRadius.getY-impl((long)roundRect.getTopRightCornerRadius-kKHJgLs());
        $this$addRoundRect_u24lambda_u242[4] = CornerRadius.getX-impl((long)roundRect.getBottomRightCornerRadius-kKHJgLs());
        $this$addRoundRect_u24lambda_u242[5] = CornerRadius.getY-impl((long)roundRect.getBottomRightCornerRadius-kKHJgLs());
        $this$addRoundRect_u24lambda_u242[6] = CornerRadius.getX-impl((long)roundRect.getBottomLeftCornerRadius-kKHJgLs());
        $this$addRoundRect_u24lambda_u242[7] = CornerRadius.getY-impl((long)roundRect.getBottomLeftCornerRadius-kKHJgLs());
        RectF rectF2 = this.rectF;
        Intrinsics.checkNotNull((Object)rectF2);
        Intrinsics.checkNotNull((Object)this.radii);
        this.internalPath.addRoundRect(rectF2, this.radii, Path.Direction.CCW);
    }

    @Override
    public void addPath-Uv8p0NA(@NotNull Path path, long offset) {
        Path $this$asAndroidPath$iv = path;
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        this.internalPath.addPath(((AndroidPath)$this$asAndroidPath$iv).getInternalPath(), Offset.getX-impl((long)offset), Offset.getY-impl((long)offset));
    }

    @Override
    public void close() {
        this.internalPath.close();
    }

    @Override
    public void reset() {
        this.internalPath.reset();
    }

    @Override
    public void rewind() {
        this.internalPath.rewind();
    }

    @Override
    public void translate-k-4lQ0M(long offset) {
        if (this.mMatrix == null) {
            this.mMatrix = new Matrix();
        } else {
            Matrix matrix = this.mMatrix;
            Intrinsics.checkNotNull((Object)matrix);
            matrix.reset();
        }
        Matrix matrix = this.mMatrix;
        Intrinsics.checkNotNull((Object)matrix);
        matrix.setTranslate(Offset.getX-impl((long)offset), Offset.getY-impl((long)offset));
        Matrix matrix2 = this.mMatrix;
        Intrinsics.checkNotNull((Object)matrix2);
        this.internalPath.transform(matrix2);
    }

    @Override
    public void transform-58bKbWc(@NotNull float[] matrix) {
        if (this.mMatrix == null) {
            this.mMatrix = new Matrix();
        }
        Matrix matrix2 = this.mMatrix;
        Intrinsics.checkNotNull((Object)matrix2);
        AndroidMatrixConversions_androidKt.setFrom-EL8BTi8(matrix2, matrix);
        Matrix matrix3 = this.mMatrix;
        Intrinsics.checkNotNull((Object)matrix3);
        this.internalPath.transform(matrix3);
    }

    @Override
    @NotNull
    public Rect getBounds() {
        if (this.rectF == null) {
            this.rectF = new RectF();
        }
        RectF rectF = this.rectF;
        Intrinsics.checkNotNull((Object)rectF);
        RectF $this$getBounds_u24lambda_u243 = rectF;
        boolean bl = false;
        this.internalPath.computeBounds($this$getBounds_u24lambda_u243, true);
        return new Rect($this$getBounds_u24lambda_u243.left, $this$getBounds_u24lambda_u243.top, $this$getBounds_u24lambda_u243.right, $this$getBounds_u24lambda_u243.bottom);
    }

    @Override
    public boolean op-N5in7k0(@NotNull Path path1, @NotNull Path path2, int operation) {
        int n = operation;
        Path.Op op = PathOperation.equals-impl0(n, PathOperation.Companion.getDifference-b3I0S0c()) ? Path.Op.DIFFERENCE : (PathOperation.equals-impl0(n, PathOperation.Companion.getIntersect-b3I0S0c()) ? Path.Op.INTERSECT : (PathOperation.equals-impl0(n, PathOperation.Companion.getReverseDifference-b3I0S0c()) ? Path.Op.REVERSE_DIFFERENCE : (PathOperation.equals-impl0(n, PathOperation.Companion.getUnion-b3I0S0c()) ? Path.Op.UNION : Path.Op.XOR)));
        Path $this$asAndroidPath$iv = path1;
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        android.graphics.Path path = ((AndroidPath)$this$asAndroidPath$iv).getInternalPath();
        $this$asAndroidPath$iv = path2;
        $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        return this.internalPath.op(path, ((AndroidPath)$this$asAndroidPath$iv).getInternalPath(), op);
    }

    @Override
    public boolean isConvex() {
        return this.internalPath.isConvex();
    }

    public static /* synthetic */ void isConvex$annotations() {
    }

    @Override
    public boolean isEmpty() {
        return this.internalPath.isEmpty();
    }

    private final boolean _rectIsValid(Rect rect) {
        if (!(!Float.isNaN(rect.getLeft()))) {
            boolean $i$a$-check-AndroidPath$_rectIsValid$52 = false;
            String $i$a$-check-AndroidPath$_rectIsValid$52 = "Rect.left is NaN";
            throw new IllegalStateException($i$a$-check-AndroidPath$_rectIsValid$52.toString());
        }
        if (!(!Float.isNaN(rect.getTop()))) {
            boolean $i$a$-check-AndroidPath$_rectIsValid$62 = false;
            String $i$a$-check-AndroidPath$_rectIsValid$62 = "Rect.top is NaN";
            throw new IllegalStateException($i$a$-check-AndroidPath$_rectIsValid$62.toString());
        }
        if (!(!Float.isNaN(rect.getRight()))) {
            boolean $i$a$-check-AndroidPath$_rectIsValid$72 = false;
            String $i$a$-check-AndroidPath$_rectIsValid$72 = "Rect.right is NaN";
            throw new IllegalStateException($i$a$-check-AndroidPath$_rectIsValid$72.toString());
        }
        if (!(!Float.isNaN(rect.getBottom()))) {
            boolean bl = false;
            String string = "Rect.bottom is NaN";
            throw new IllegalStateException(string.toString());
        }
        return true;
    }

    public AndroidPath() {
        this(null, 1, null);
    }
}

