/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.graphics.CanvasHolder;
import androidx.compose.ui.graphics.GraphicsContext;
import androidx.compose.ui.graphics.drawscope.DrawContextKt;
import androidx.compose.ui.graphics.layer.GraphicsLayer;
import androidx.compose.ui.graphics.layer.GraphicsLayerImpl;
import androidx.compose.ui.graphics.layer.GraphicsLayerV23;
import androidx.compose.ui.graphics.layer.GraphicsLayerV29;
import androidx.compose.ui.graphics.layer.GraphicsViewLayer;
import androidx.compose.ui.graphics.layer.LayerManager;
import androidx.compose.ui.graphics.layer.view.DrawChildContainer;
import androidx.compose.ui.graphics.layer.view.ViewLayerContainer;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/ui/graphics/AndroidGraphicsContext;", "Landroidx/compose/ui/graphics/GraphicsContext;", "ownerView", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "layerManager", "Landroidx/compose/ui/graphics/layer/LayerManager;", "lock", "", "viewLayerContainer", "Landroidx/compose/ui/graphics/layer/view/DrawChildContainer;", "createGraphicsLayer", "Landroidx/compose/ui/graphics/layer/GraphicsLayer;", "getUniqueDrawingId", "", "view", "Landroid/view/View;", "obtainViewLayerContainer", "releaseGraphicsLayer", "", "layer", "Companion", "UniqueDrawingIdApi29", "ui-graphics_release"})
final class AndroidGraphicsContext
implements GraphicsContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewGroup ownerView;
    @NotNull
    private final Object lock;
    @NotNull
    private final LayerManager layerManager;
    @Nullable
    private DrawChildContainer viewLayerContainer;
    private static boolean isRenderNodeCompatible = true;

    public AndroidGraphicsContext(@NotNull ViewGroup ownerView) {
        this.ownerView = ownerView;
        this.lock = new Object();
        this.layerManager = new LayerManager(new CanvasHolder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public GraphicsLayer createGraphicsLayer() {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            Object object3;
            boolean bl = false;
            long ownerId = this.getUniqueDrawingId((View)this.ownerView);
            if (Build.VERSION.SDK_INT >= 29) {
                object3 = new GraphicsLayerV29(ownerId, null, null, 6, null);
            } else if (isRenderNodeCompatible && Build.VERSION.SDK_INT >= 23) {
                try {
                    object2 = new GraphicsLayerV23((View)this.ownerView, ownerId, null, null, 12, null);
                }
                catch (Throwable _) {
                    isRenderNodeCompatible = false;
                    object2 = new GraphicsViewLayer(this.obtainViewLayerContainer(this.ownerView), ownerId, null, null, 12, null);
                }
                object3 = object2;
            } else {
                object3 = new GraphicsViewLayer(this.obtainViewLayerContainer(this.ownerView), ownerId, null, null, 12, null);
            }
            GraphicsLayerImpl layerImpl = object3;
            object2 = new GraphicsLayer(layerImpl, this.layerManager);
            GraphicsLayer layer = object2;
            boolean bl2 = false;
            if (Build.VERSION.SDK_INT < 28 && Build.VERSION.SDK_INT >= 23) {
                layer.buildLayer-mL-hObY(DrawContextKt.getDefaultDensity(), LayoutDirection.Ltr, IntSizeKt.IntSize((int)1, (int)1), GraphicsLayerImpl.Companion.getDefaultDrawBlock());
            }
            this.layerManager.persist(layer);
            layer.setSize-ozmzZPI$ui_graphics_release(IntSize.Companion.getZero-YbymL2g());
            Object object4 = object2;
            return object4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseGraphicsLayer(@NotNull GraphicsLayer layer) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            layer.release$ui_graphics_release();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final DrawChildContainer obtainViewLayerContainer(ViewGroup ownerView) {
        DrawChildContainer container = this.viewLayerContainer;
        if (container == null) {
            Context context = ownerView.getContext();
            container = new ViewLayerContainer(context);
            ownerView.addView((View)container);
            this.viewLayerContainer = container;
        }
        return container;
    }

    private final long getUniqueDrawingId(View view) {
        return Build.VERSION.SDK_INT >= 29 ? UniqueDrawingIdApi29.getUniqueDrawingId(view) : -1L;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/graphics/AndroidGraphicsContext$Companion;", "", "()V", "isRenderNodeCompatible", "", "()Z", "setRenderNodeCompatible", "(Z)V", "ui-graphics_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRenderNodeCompatible() {
            return isRenderNodeCompatible;
        }

        public final void setRenderNodeCompatible(boolean bl) {
            isRenderNodeCompatible = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/graphics/AndroidGraphicsContext$UniqueDrawingIdApi29;", "", "()V", "getUniqueDrawingId", "", "view", "Landroid/view/View;", "ui-graphics_release"})
    @RequiresApi(value=29)
    private static final class UniqueDrawingIdApi29 {
        @NotNull
        public static final UniqueDrawingIdApi29 INSTANCE = new UniqueDrawingIdApi29();

        private UniqueDrawingIdApi29() {
        }

        @JvmStatic
        @DoNotInline
        public static final long getUniqueDrawingId(@NotNull View view) {
            return view.getUniqueDrawingId();
        }
    }
}

