/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.layer;

import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasHolder;
import androidx.compose.ui.graphics.layer.GraphicsLayer;
import androidx.compose.ui.graphics.layer.LockHardwareCanvasHelper;
import androidx.core.os.HandlerCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/ui/graphics/layer/LayerManager;", "", "canvasHolder", "Landroidx/compose/ui/graphics/CanvasHolder;", "(Landroidx/compose/ui/graphics/CanvasHolder;)V", "getCanvasHolder", "()Landroidx/compose/ui/graphics/CanvasHolder;", "handler", "Landroid/os/Handler;", "imageReader", "Landroid/media/ImageReader;", "layerList", "Landroidx/collection/MutableObjectList;", "Landroidx/compose/ui/graphics/layer/GraphicsLayer;", "destroy", "", "persist", "layer", "persistLayers", "layers", "Landroidx/collection/ObjectList;", "release", "updateLayerPersistence", "ui-graphics_release"})
@SourceDebugExtension(value={"SMAP\nLayerManager.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerManager.android.kt\nandroidx/compose/ui/graphics/layer/LayerManager\n+ 2 ObjectList.kt\nandroidx/collection/ObjectListKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 AndroidCanvas.android.kt\nandroidx/compose/ui/graphics/CanvasHolder\n+ 5 ObjectList.kt\nandroidx/collection/ObjectList\n*L\n1#1,135:1\n1580#2:136\n1#3:137\n47#4,3:138\n50#4,2:147\n305#5,6:141\n*S KotlinDebug\n*F\n+ 1 LayerManager.android.kt\nandroidx/compose/ui/graphics/layer/LayerManager\n*L\n39#1:136\n100#1:138,3\n100#1:147,2\n103#1:141,6\n*E\n"})
public final class LayerManager {
    @NotNull
    private final CanvasHolder canvasHolder;
    @NotNull
    private final MutableObjectList<GraphicsLayer> layerList;
    @Nullable
    private ImageReader imageReader;
    @NotNull
    private final Handler handler;

    public LayerManager(@NotNull CanvasHolder canvasHolder) {
        this.canvasHolder = canvasHolder;
        boolean $i$f$mutableObjectListOf = false;
        this.layerList = new MutableObjectList(0, 1, null);
        this.handler = HandlerCompat.createAsync((Looper)Looper.getMainLooper(), arg_0 -> LayerManager.handler$lambda$0(this, arg_0));
    }

    @NotNull
    public final CanvasHolder getCanvasHolder() {
        return this.canvasHolder;
    }

    public final void persist(@NotNull GraphicsLayer layer) {
        if (!this.layerList.contains((Object)layer)) {
            this.layerList.add((Object)layer);
            if (!this.handler.hasMessages(0)) {
                this.handler.sendMessageAtFrontOfQueue(Message.obtain());
            }
        }
    }

    public final void release(@NotNull GraphicsLayer layer) {
        if (this.layerList.remove((Object)layer)) {
            layer.discardDisplayList$ui_graphics_release();
        }
    }

    private final void persistLayers(ObjectList<GraphicsLayer> layers) {
        if (Build.VERSION.SDK_INT >= 23 && layers.isNotEmpty()) {
            ImageReader reader;
            Surface surface;
            android.graphics.Canvas canvas;
            ImageReader imageReader = this.imageReader;
            if (imageReader == null) {
                ImageReader imageReader2;
                ImageReader $this$persistLayers_u24lambda_u242 = imageReader2 = ImageReader.newInstance((int)1, (int)1, (int)1, (int)1);
                boolean bl = false;
                $this$persistLayers_u24lambda_u242.setOnImageAvailableListener(LayerManager::persistLayers$lambda$2$lambda$1, this.handler);
                ImageReader it = imageReader2;
                boolean bl2 = false;
                this.imageReader = it;
                imageReader = imageReader2;
            }
            if ((canvas = LockHardwareCanvasHelper.INSTANCE.lockHardwareCanvas(surface = (reader = imageReader).getSurface())).isHardwareAccelerated()) {
                CanvasHolder this_$iv = this.canvasHolder;
                boolean $i$f$drawInto = false;
                android.graphics.Canvas previousCanvas$iv = this_$iv.getAndroidCanvas().getInternalCanvas();
                this_$iv.getAndroidCanvas().setInternalCanvas(canvas);
                Canvas $this$persistLayers_u24lambda_u245 = this_$iv.getAndroidCanvas();
                boolean bl = false;
                canvas.save();
                canvas.clipRect(0, 0, 1, 1);
                ObjectList<GraphicsLayer> this_$iv2 = layers;
                boolean $i$f$forEach = false;
                Object[] content$iv = this_$iv2.content;
                int n = this_$iv2._size;
                for (int i$iv = 0; i$iv < n; ++i$iv) {
                    GraphicsLayer layer = (GraphicsLayer)content$iv[i$iv];
                    boolean bl3 = false;
                    layer.drawForPersistence$ui_graphics_release($this$persistLayers_u24lambda_u245);
                }
                canvas.restore();
                this_$iv.getAndroidCanvas().setInternalCanvas(previousCanvas$iv);
            }
            surface.unlockCanvasAndPost(canvas);
        }
    }

    public final void destroy() {
        ImageReader imageReader = this.imageReader;
        if (imageReader != null) {
            imageReader.close();
        }
        this.imageReader = null;
    }

    public final void updateLayerPersistence() {
        this.destroy();
        this.persistLayers((ObjectList<GraphicsLayer>)((ObjectList)this.layerList));
    }

    private static final boolean handler$lambda$0(LayerManager this$0, Message it) {
        this$0.persistLayers((ObjectList<GraphicsLayer>)((ObjectList)this$0.layerList));
        return true;
    }

    private static final void persistLayers$lambda$2$lambda$1(ImageReader it) {
        block0: {
            ImageReader imageReader = it;
            if (imageReader == null || (imageReader = imageReader.acquireLatestImage()) == null) break block0;
            imageReader.close();
        }
    }
}

