/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.graphics.AndroidGraphicsContext;
import androidx.compose.ui.graphics.CanvasHolder;
import androidx.compose.ui.graphics.GraphicsContext;
import androidx.compose.ui.graphics.layer.GraphicsLayer;
import androidx.compose.ui.graphics.layer.GraphicsLayerImpl;
import androidx.compose.ui.graphics.layer.GraphicsLayerV23;
import androidx.compose.ui.graphics.layer.GraphicsLayerV29;
import androidx.compose.ui.graphics.layer.GraphicsViewLayer;
import androidx.compose.ui.graphics.layer.LayerManager;
import androidx.compose.ui.graphics.layer.view.DrawChildContainer;
import androidx.compose.ui.graphics.layer.view.ViewLayerContainer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u0006\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Landroidx/compose/ui/graphics/AndroidGraphicsContext;", "Landroidx/compose/ui/graphics/GraphicsContext;", "ownerView", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "componentCallback", "androidx/compose/ui/graphics/AndroidGraphicsContext$componentCallback$1", "Landroidx/compose/ui/graphics/AndroidGraphicsContext$componentCallback$1;", "componentCallbackRegistered", "", "layerManager", "Landroidx/compose/ui/graphics/layer/LayerManager;", "lock", "", "predrawListenerRegistered", "viewLayerContainer", "Landroidx/compose/ui/graphics/layer/view/DrawChildContainer;", "createGraphicsLayer", "Landroidx/compose/ui/graphics/layer/GraphicsLayer;", "getUniqueDrawingId", "", "view", "Landroid/view/View;", "obtainViewLayerContainer", "registerComponentCallback", "", "context", "Landroid/content/Context;", "releaseGraphicsLayer", "layer", "unregisterComponentCallback", "Companion", "UniqueDrawingIdApi29", "ui-graphics_release"})
final class AndroidGraphicsContext
implements GraphicsContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewGroup ownerView;
    @NotNull
    private final Object lock;
    @NotNull
    private final LayerManager layerManager;
    @Nullable
    private DrawChildContainer viewLayerContainer;
    private boolean componentCallbackRegistered;
    private boolean predrawListenerRegistered;
    @NotNull
    private final componentCallback.1 componentCallback;
    private static boolean isRenderNodeCompatible = true;

    public AndroidGraphicsContext(@NotNull ViewGroup ownerView) {
        this.ownerView = ownerView;
        this.lock = new Object();
        this.layerManager = new LayerManager(new CanvasHolder());
        this.componentCallback = new ComponentCallbacks2(this){
            final /* synthetic */ AndroidGraphicsContext this$0;
            {
                this.this$0 = $receiver;
            }

            public void onConfigurationChanged(@NotNull Configuration newConfig) {
            }

            public void onLowMemory() {
            }

            public void onTrimMemory(int level) {
                if (level >= 40 && !AndroidGraphicsContext.access$getPredrawListenerRegistered$p(this.this$0)) {
                    AndroidGraphicsContext.access$getLayerManager$p(this.this$0).destroy();
                    AndroidGraphicsContext.access$getOwnerView$p(this.this$0).getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(this.this$0){
                        final /* synthetic */ AndroidGraphicsContext this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public boolean onPreDraw() {
                            AndroidGraphicsContext.access$getLayerManager$p(this.this$0).updateLayerPersistence();
                            AndroidGraphicsContext.access$getOwnerView$p(this.this$0).getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                            AndroidGraphicsContext.access$setPredrawListenerRegistered$p(this.this$0, false);
                            return true;
                        }
                    });
                    AndroidGraphicsContext.access$setPredrawListenerRegistered$p(this.this$0, true);
                }
            }
        };
        if (this.ownerView.isAttachedToWindow()) {
            this.registerComponentCallback(this.ownerView.getContext());
        }
        this.ownerView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(@NotNull View v) {
                this.registerComponentCallback(v.getContext());
            }

            public void onViewDetachedFromWindow(@NotNull View v) {
                this.unregisterComponentCallback(v.getContext());
            }
        });
    }

    private final void registerComponentCallback(Context context) {
        if (!this.componentCallbackRegistered) {
            context.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)this.componentCallback);
            this.componentCallbackRegistered = true;
        }
    }

    private final void unregisterComponentCallback(Context context) {
        if (this.componentCallbackRegistered) {
            context.getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this.componentCallback);
            this.componentCallbackRegistered = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public GraphicsLayer createGraphicsLayer() {
        Object object = this.lock;
        synchronized (object) {
            GraphicsLayer graphicsLayer;
            boolean bl = false;
            long ownerId = this.getUniqueDrawingId((View)this.ownerView);
            GraphicsLayer reusedLayer = this.layerManager.takeFromCache(ownerId);
            if (reusedLayer != null) {
                graphicsLayer = reusedLayer;
            } else {
                GraphicsLayerImpl graphicsLayerImpl;
                if (Build.VERSION.SDK_INT >= 29) {
                    graphicsLayerImpl = new GraphicsLayerV29(null, null, 3, null);
                } else if (isRenderNodeCompatible && Build.VERSION.SDK_INT >= 23) {
                    GraphicsLayerImpl graphicsLayerImpl2;
                    try {
                        graphicsLayerImpl2 = new GraphicsLayerV23((View)this.ownerView, null, null, 6, null);
                    }
                    catch (Throwable _) {
                        isRenderNodeCompatible = false;
                        graphicsLayerImpl2 = new GraphicsViewLayer(this.obtainViewLayerContainer(this.ownerView), null, null, 6, null);
                    }
                    graphicsLayerImpl = graphicsLayerImpl2;
                } else {
                    graphicsLayerImpl = new GraphicsViewLayer(this.obtainViewLayerContainer(this.ownerView), null, null, 6, null);
                }
                GraphicsLayerImpl layerImpl = graphicsLayerImpl;
                graphicsLayer = new GraphicsLayer(layerImpl, this.layerManager, ownerId);
            }
            GraphicsLayer layer = graphicsLayer;
            this.layerManager.persist(layer);
            GraphicsLayer graphicsLayer2 = layer;
            return graphicsLayer2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseGraphicsLayer(@NotNull GraphicsLayer layer) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            layer.release$ui_graphics_release();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final DrawChildContainer obtainViewLayerContainer(ViewGroup ownerView) {
        DrawChildContainer container = this.viewLayerContainer;
        if (container == null) {
            Context context = ownerView.getContext();
            container = new ViewLayerContainer(context);
            ownerView.addView((View)container);
            this.viewLayerContainer = container;
        }
        return container;
    }

    private final long getUniqueDrawingId(View view) {
        return Build.VERSION.SDK_INT >= 29 ? UniqueDrawingIdApi29.getUniqueDrawingId(view) : -1L;
    }

    public static final /* synthetic */ boolean access$getPredrawListenerRegistered$p(AndroidGraphicsContext $this) {
        return $this.predrawListenerRegistered;
    }

    public static final /* synthetic */ LayerManager access$getLayerManager$p(AndroidGraphicsContext $this) {
        return $this.layerManager;
    }

    public static final /* synthetic */ ViewGroup access$getOwnerView$p(AndroidGraphicsContext $this) {
        return $this.ownerView;
    }

    public static final /* synthetic */ void access$setPredrawListenerRegistered$p(AndroidGraphicsContext $this, boolean bl) {
        $this.predrawListenerRegistered = bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/graphics/AndroidGraphicsContext$Companion;", "", "()V", "isRenderNodeCompatible", "", "()Z", "setRenderNodeCompatible", "(Z)V", "ui-graphics_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRenderNodeCompatible() {
            return isRenderNodeCompatible;
        }

        public final void setRenderNodeCompatible(boolean bl) {
            isRenderNodeCompatible = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/graphics/AndroidGraphicsContext$UniqueDrawingIdApi29;", "", "()V", "getUniqueDrawingId", "", "view", "Landroid/view/View;", "ui-graphics_release"})
    @RequiresApi(value=29)
    private static final class UniqueDrawingIdApi29 {
        @NotNull
        public static final UniqueDrawingIdApi29 INSTANCE = new UniqueDrawingIdApi29();

        private UniqueDrawingIdApi29() {
        }

        @JvmStatic
        @DoNotInline
        public static final long getUniqueDrawingId(@NotNull View view) {
            return view.getUniqueDrawingId();
        }
    }
}

