/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.graphics.GraphicsContext;
import androidx.compose.ui.graphics.layer.GraphicsLayer;
import androidx.compose.ui.graphics.layer.GraphicsLayerImpl;
import androidx.compose.ui.graphics.layer.GraphicsLayerV23;
import androidx.compose.ui.graphics.layer.GraphicsLayerV29;
import androidx.compose.ui.graphics.layer.GraphicsViewLayer;
import androidx.compose.ui.graphics.layer.LayerManager;
import androidx.compose.ui.graphics.layer.view.DrawChildContainer;
import androidx.compose.ui.graphics.layer.view.ViewLayerContainer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\bJ\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Landroidx/compose/ui/graphics/AndroidGraphicsContext;", "Landroidx/compose/ui/graphics/GraphicsContext;", "ownerView", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "componentCallback", "Landroid/content/ComponentCallbacks2;", "componentCallbackRegistered", "", "layerManager", "Landroidx/compose/ui/graphics/layer/LayerManager;", "lock", "", "predrawListenerRegistered", "viewLayerContainer", "Landroidx/compose/ui/graphics/layer/view/DrawChildContainer;", "createGraphicsLayer", "Landroidx/compose/ui/graphics/layer/GraphicsLayer;", "getUniqueDrawingId", "", "view", "Landroid/view/View;", "isLayerManagerInitialized", "obtainViewLayerContainer", "registerComponentCallback", "", "context", "Landroid/content/Context;", "releaseGraphicsLayer", "layer", "unregisterComponentCallback", "Companion", "UniqueDrawingIdApi29", "ui-graphics_release"})
@SourceDebugExtension(value={"SMAP\nAndroidGraphicsContext.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidGraphicsContext.android.kt\nandroidx/compose/ui/graphics/AndroidGraphicsContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
final class AndroidGraphicsContext
implements GraphicsContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewGroup ownerView;
    @NotNull
    private final Object lock;
    @Nullable
    private final LayerManager layerManager;
    @Nullable
    private DrawChildContainer viewLayerContainer;
    private boolean componentCallbackRegistered;
    private boolean predrawListenerRegistered;
    @Nullable
    private final ComponentCallbacks2 componentCallback;
    private static boolean isRenderNodeCompatible = true;
    public static final boolean enableLayerPersistence = false;

    public AndroidGraphicsContext(@NotNull ViewGroup ownerView) {
        this.ownerView = ownerView;
        this.lock = new Object();
        this.layerManager = null;
        this.componentCallback = null;
    }

    public final boolean isLayerManagerInitialized() {
        LayerManager layerManager = this.layerManager;
        return layerManager != null ? layerManager.hasImageReader() : false;
    }

    private final void registerComponentCallback(Context context) {
        if (!this.componentCallbackRegistered) {
            context.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)this.componentCallback);
            this.componentCallbackRegistered = true;
        }
    }

    private final void unregisterComponentCallback(Context context) {
        if (this.componentCallbackRegistered) {
            context.getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this.componentCallback);
            this.componentCallbackRegistered = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public GraphicsLayer createGraphicsLayer() {
        Object object = this.lock;
        synchronized (object) {
            GraphicsLayerImpl graphicsLayerImpl;
            boolean bl = false;
            long ownerId = this.getUniqueDrawingId((View)this.ownerView);
            if (Build.VERSION.SDK_INT >= 29) {
                graphicsLayerImpl = new GraphicsLayerV29(ownerId, null, null, 6, null);
            } else if (isRenderNodeCompatible && Build.VERSION.SDK_INT >= 23) {
                GraphicsLayerImpl graphicsLayerImpl2;
                try {
                    graphicsLayerImpl2 = new GraphicsLayerV23((View)this.ownerView, ownerId, null, null, 12, null);
                }
                catch (Throwable _) {
                    isRenderNodeCompatible = false;
                    graphicsLayerImpl2 = new GraphicsViewLayer(this.obtainViewLayerContainer(this.ownerView), ownerId, null, null, 12, null);
                }
                graphicsLayerImpl = graphicsLayerImpl2;
            } else {
                graphicsLayerImpl = new GraphicsViewLayer(this.obtainViewLayerContainer(this.ownerView), ownerId, null, null, 12, null);
            }
            GraphicsLayerImpl layerImpl = graphicsLayerImpl;
            GraphicsLayer layer = new GraphicsLayer(layerImpl, this.layerManager);
            GraphicsLayer graphicsLayer = layer;
            return graphicsLayer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseGraphicsLayer(@NotNull GraphicsLayer layer) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            layer.release$ui_graphics_release();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final DrawChildContainer obtainViewLayerContainer(ViewGroup ownerView) {
        DrawChildContainer container = this.viewLayerContainer;
        if (container == null) {
            Context context = ownerView.getContext();
            container = new ViewLayerContainer(context);
            ownerView.addView((View)container);
            this.viewLayerContainer = container;
        }
        return container;
    }

    private final long getUniqueDrawingId(View view) {
        return Build.VERSION.SDK_INT >= 29 ? UniqueDrawingIdApi29.getUniqueDrawingId(view) : -1L;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/graphics/AndroidGraphicsContext$Companion;", "", "()V", "enableLayerPersistence", "", "isRenderNodeCompatible", "()Z", "setRenderNodeCompatible", "(Z)V", "ui-graphics_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRenderNodeCompatible() {
            return isRenderNodeCompatible;
        }

        public final void setRenderNodeCompatible(boolean bl) {
            isRenderNodeCompatible = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/graphics/AndroidGraphicsContext$UniqueDrawingIdApi29;", "", "()V", "getUniqueDrawingId", "", "view", "Landroid/view/View;", "ui-graphics_release"})
    @RequiresApi(value=29)
    private static final class UniqueDrawingIdApi29 {
        @NotNull
        public static final UniqueDrawingIdApi29 INSTANCE = new UniqueDrawingIdApi29();

        private UniqueDrawingIdApi29() {
        }

        @JvmStatic
        public static final long getUniqueDrawingId(@NotNull View view) {
            return view.getUniqueDrawingId();
        }
    }
}

