/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Region;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.AndroidCanvas;
import androidx.compose.ui.graphics.AndroidCanvas$WhenMappings;
import androidx.compose.ui.graphics.AndroidCanvasKt;
import androidx.compose.ui.graphics.AndroidImageAssetKt;
import androidx.compose.ui.graphics.AndroidPath;
import androidx.compose.ui.graphics.AndroidVertexModeKt;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasUtils;
import androidx.compose.ui.graphics.ClipOp;
import androidx.compose.ui.graphics.ImageAsset;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PointMode;
import androidx.compose.ui.graphics.Vertices;
import androidx.compose.ui.graphics.vectormath.Matrix4;
import androidx.compose.ui.graphics.vectormath.Matrix4Kt;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J0\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0015H\u0016JH\u0010$\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J \u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0016J \u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020-2\u0006\u0010)\u001a\u00020*H\u0016J8\u00103\u001a\u00020\u00152\u0006\u00100\u001a\u0002012\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002052\u0006\u00109\u001a\u0002072\u0006\u0010)\u001a\u00020*H\u0016J \u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020-2\u0006\u0010)\u001a\u00020*H\u0016J&\u0010=\u001a\u00020\u00152\f\u0010>\u001a\b\u0012\u0004\u0012\u00020-0?2\u0006\u0010)\u001a\u00020*2\u0006\u0010@\u001a\u00020AH\u0002J0\u0010B\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010C\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0016J&\u0010D\u001a\u00020\u00152\u0006\u0010E\u001a\u00020F2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020-0?2\u0006\u0010)\u001a\u00020*H\u0016J\u001e\u0010D\u001a\u00020\u00152\f\u0010>\u001a\b\u0012\u0004\u0012\u00020-0?2\u0006\u0010)\u001a\u00020*H\u0002J \u0010G\u001a\u00020\u00152\u0006\u0010>\u001a\u00020H2\u0006\u0010)\u001a\u00020*2\u0006\u0010@\u001a\u00020AH\u0002J \u0010I\u001a\u00020\u00152\u0006\u0010E\u001a\u00020F2\u0006\u0010>\u001a\u00020H2\u0006\u0010)\u001a\u00020*H\u0016J \u0010I\u001a\u00020\u00152\u0006\u0010>\u001a\u00020H2\u0006\u0010)\u001a\u00020*2\u0006\u0010@\u001a\u00020AH\u0002J0\u0010J\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0016J@\u0010K\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010L\u001a\u00020\u001c2\u0006\u0010M\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0016J \u0010N\u001a\u00020\u00152\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010S\u001a\u00020\u0015H\u0016J\b\u0010T\u001a\u00020\u0015H\u0016J\u0010\u0010U\u001a\u00020\u00152\u0006\u0010V\u001a\u00020\u001cH\u0016J\b\u0010W\u001a\u00020\u0015H\u0016J\u0018\u0010X\u001a\u00020\u00152\u0006\u0010Y\u001a\u00020Z2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010[\u001a\u00020\u00152\u0006\u0010\\\u001a\u00020\u001c2\u0006\u0010]\u001a\u00020\u001cH\u0016J\u0018\u0010^\u001a\u00020\u00152\u0006\u0010\\\u001a\u00020\u001c2\u0006\u0010]\u001a\u00020\u001cH\u0016J\u0018\u0010_\u001a\u00020\u00152\u0006\u0010`\u001a\u00020\u001c2\u0006\u0010a\u001a\u00020\u001cH\u0016J\n\u0010b\u001a\u00020c*\u00020\u0019R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R(\u0010\t\u001a\u00060\nj\u0002`\u000b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\b\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006d"}, d2={"Landroidx/compose/ui/graphics/AndroidCanvas;", "Landroidx/compose/ui/graphics/Canvas;", "()V", "dstRect", "Landroid/graphics/Rect;", "getDstRect", "()Landroid/graphics/Rect;", "dstRect$delegate", "Lkotlin/Lazy;", "internalCanvas", "Landroid/graphics/Canvas;", "Landroidx/compose/ui/graphics/NativeCanvas;", "getInternalCanvas$annotations", "getInternalCanvas", "()Landroid/graphics/Canvas;", "setInternalCanvas", "(Landroid/graphics/Canvas;)V", "srcRect", "getSrcRect", "srcRect$delegate", "clipPath", "", "path", "Landroidx/compose/ui/graphics/Path;", "clipOp", "Landroidx/compose/ui/graphics/ClipOp;", "clipRect", "left", "", "top", "right", "bottom", "concat", "matrix4", "Landroidx/compose/ui/graphics/vectormath/Matrix4;", "disableZ", "drawArc", "startAngle", "sweepAngle", "useCenter", "", "paint", "Landroidx/compose/ui/graphics/Paint;", "drawCircle", "center", "Landroidx/compose/ui/geometry/Offset;", "radius", "drawImage", "image", "Landroidx/compose/ui/graphics/ImageAsset;", "topLeftOffset", "drawImageRect", "srcOffset", "Landroidx/compose/ui/unit/IntOffset;", "srcSize", "Landroidx/compose/ui/unit/IntSize;", "dstOffset", "dstSize", "drawLine", "p1", "p2", "drawLines", "points", "", "stepBy", "", "drawOval", "drawPath", "drawPoints", "pointMode", "Landroidx/compose/ui/graphics/PointMode;", "drawRawLines", "", "drawRawPoints", "drawRect", "drawRoundRect", "radiusX", "radiusY", "drawVertices", "vertices", "Landroidx/compose/ui/graphics/Vertices;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "enableZ", "restore", "rotate", "degrees", "save", "saveLayer", "bounds", "Landroidx/compose/ui/geometry/Rect;", "scale", "sx", "sy", "skew", "translate", "dx", "dy", "toRegionOp", "Landroid/graphics/Region$Op;", "ui-graphics_release"})
@PublishedApi
public final class AndroidCanvas
implements Canvas {
    @NotNull
    private android.graphics.Canvas internalCanvas = AndroidCanvasKt.access$getEmptyCanvas$p();
    private final Lazy srcRect$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)srcRect.2.INSTANCE);
    private final Lazy dstRect$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)dstRect.2.INSTANCE);

    @PublishedApi
    public static /* synthetic */ void getInternalCanvas$annotations() {
    }

    @NotNull
    public final android.graphics.Canvas getInternalCanvas() {
        return this.internalCanvas;
    }

    public final void setInternalCanvas(@NotNull android.graphics.Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"<set-?>");
        this.internalCanvas = canvas;
    }

    private final android.graphics.Rect getSrcRect() {
        Lazy lazy = this.srcRect$delegate;
        AndroidCanvas androidCanvas = this;
        Object var3_3 = null;
        boolean bl = false;
        return (android.graphics.Rect)lazy.getValue();
    }

    private final android.graphics.Rect getDstRect() {
        Lazy lazy = this.dstRect$delegate;
        AndroidCanvas androidCanvas = this;
        Object var3_3 = null;
        boolean bl = false;
        return (android.graphics.Rect)lazy.getValue();
    }

    @Override
    public void save() {
        this.internalCanvas.save();
    }

    @Override
    public void restore() {
        this.internalCanvas.restore();
    }

    @Override
    public void saveLayer(@NotNull Rect bounds, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        this.internalCanvas.saveLayer(bounds.getLeft(), bounds.getTop(), bounds.getRight(), bounds.getBottom(), paint2.asFrameworkPaint(), 31);
    }

    @Override
    public void translate(float dx, float dy) {
        this.internalCanvas.translate(dx, dy);
    }

    @Override
    public void scale(float sx, float sy) {
        this.internalCanvas.scale(sx, sy);
    }

    @Override
    public void rotate(float degrees) {
        this.internalCanvas.rotate(degrees);
    }

    @Override
    public void skew(float sx, float sy) {
        this.internalCanvas.skew(sx, sy);
    }

    @Override
    public void concat(@NotNull Matrix4 matrix4) {
        Intrinsics.checkNotNullParameter((Object)matrix4, (String)"matrix4");
        if (!Matrix4Kt.isIdentity(matrix4)) {
            Matrix frameworkMatrix = new Matrix();
            if (matrix4.get(2, 0) != 0.0f || matrix4.get(2, 1) != 0.0f || matrix4.get(2, 0) != 0.0f || matrix4.get(2, 1) != 0.0f || matrix4.get(2, 2) != 1.0f || matrix4.get(2, 3) != 0.0f || matrix4.get(3, 2) != 0.0f) {
                throw (Throwable)new IllegalStateException("Android does not support arbitrary transforms");
            }
            float[] values = new float[]{matrix4.get(0, 0), matrix4.get(1, 0), matrix4.get(3, 0), matrix4.get(0, 1), matrix4.get(1, 1), matrix4.get(3, 1), matrix4.get(0, 3), matrix4.get(1, 3), matrix4.get(3, 3)};
            frameworkMatrix.setValues(values);
            this.internalCanvas.concat(frameworkMatrix);
        }
    }

    @Override
    public void clipRect(float left, float top, float right, float bottom, @NotNull ClipOp clipOp) {
        Intrinsics.checkNotNullParameter((Object)((Object)clipOp), (String)"clipOp");
        this.internalCanvas.clipRect(left, top, right, bottom, this.toRegionOp(clipOp));
    }

    @Override
    public void clipPath(@NotNull Path path2, @NotNull ClipOp clipOp) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)clipOp), (String)"clipOp");
        Path $this$asAndroidPath$iv = path2;
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw (Throwable)new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        this.internalCanvas.clipPath(((AndroidPath)$this$asAndroidPath$iv).getInternalPath(), this.toRegionOp(clipOp));
    }

    @NotNull
    public final Region.Op toRegionOp(@NotNull ClipOp $this$toRegionOp) {
        Region.Op op;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toRegionOp), (String)"$this$toRegionOp");
        switch (AndroidCanvas$WhenMappings.$EnumSwitchMapping$0[$this$toRegionOp.ordinal()]) {
            case 1: {
                op = Region.Op.DIFFERENCE;
                break;
            }
            default: {
                op = Region.Op.INTERSECT;
            }
        }
        return op;
    }

    @Override
    public void drawLine(@NotNull Offset p1, @NotNull Offset p2, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        this.internalCanvas.drawLine(p1.getX(), p1.getY(), p2.getX(), p2.getY(), paint2.asFrameworkPaint());
    }

    @Override
    public void drawRect(float left, float top, float right, float bottom, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        this.internalCanvas.drawRect(left, top, right, bottom, paint2.asFrameworkPaint());
    }

    @Override
    public void drawRoundRect(float left, float top, float right, float bottom, float radiusX, float radiusY, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        this.internalCanvas.drawRoundRect(left, top, right, bottom, radiusX, radiusY, paint2.asFrameworkPaint());
    }

    @Override
    public void drawOval(float left, float top, float right, float bottom, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        this.internalCanvas.drawOval(left, top, right, bottom, paint2.asFrameworkPaint());
    }

    @Override
    public void drawCircle(@NotNull Offset center, float radius, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        this.internalCanvas.drawCircle(center.getX(), center.getY(), radius, paint2.asFrameworkPaint());
    }

    @Override
    public void drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        this.internalCanvas.drawArc(left, top, right, bottom, startAngle, sweepAngle, useCenter, paint2.asFrameworkPaint());
    }

    @Override
    public void drawPath(@NotNull Path path2, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        Path $this$asAndroidPath$iv = path2;
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw (Throwable)new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        this.internalCanvas.drawPath(((AndroidPath)$this$asAndroidPath$iv).getInternalPath(), paint2.asFrameworkPaint());
    }

    @Override
    public void drawImage(@NotNull ImageAsset image2, @NotNull Offset topLeftOffset, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        Intrinsics.checkNotNullParameter((Object)topLeftOffset, (String)"topLeftOffset");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        this.internalCanvas.drawBitmap(AndroidImageAssetKt.asAndroidBitmap(image2), topLeftOffset.getX(), topLeftOffset.getY(), paint2.asFrameworkPaint());
    }

    @Override
    public void drawImageRect(@NotNull ImageAsset image2, @NotNull IntOffset srcOffset, @NotNull IntSize srcSize, @NotNull IntOffset dstOffset, @NotNull IntSize dstSize, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        Intrinsics.checkNotNullParameter((Object)srcOffset, (String)"srcOffset");
        Intrinsics.checkNotNullParameter((Object)srcSize, (String)"srcSize");
        Intrinsics.checkNotNullParameter((Object)dstOffset, (String)"dstOffset");
        Intrinsics.checkNotNullParameter((Object)dstSize, (String)"dstSize");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        android.graphics.Rect rect = this.getSrcRect();
        boolean bl = false;
        boolean bl2 = false;
        android.graphics.Rect rect2 = rect;
        Bitmap bitmap = AndroidImageAssetKt.asAndroidBitmap(image2);
        android.graphics.Canvas canvas = this.internalCanvas;
        boolean bl3 = false;
        $this$apply.left = srcOffset.getX();
        $this$apply.top = srcOffset.getY();
        $this$apply.right = srcOffset.getX() + srcSize.getWidth();
        $this$apply.bottom = srcOffset.getY() + srcSize.getHeight();
        Unit unit = Unit.INSTANCE;
        android.graphics.Rect rect3 = rect;
        rect = this.getDstRect();
        bl = false;
        bl2 = false;
        android.graphics.Rect $this$apply = rect;
        unit = rect3;
        boolean bl4 = false;
        $this$apply.left = dstOffset.getX();
        $this$apply.top = dstOffset.getY();
        $this$apply.right = dstOffset.getX() + dstSize.getWidth();
        $this$apply.bottom = dstOffset.getY() + dstSize.getHeight();
        Unit unit2 = Unit.INSTANCE;
        canvas.drawBitmap(bitmap, (android.graphics.Rect)unit, rect, paint2.asFrameworkPaint());
    }

    @Override
    public void drawPoints(@NotNull PointMode pointMode, @NotNull List<Offset> points, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)((Object)pointMode), (String)"pointMode");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        switch (AndroidCanvas$WhenMappings.$EnumSwitchMapping$1[pointMode.ordinal()]) {
            case 1: {
                this.drawLines(points, paint2, 2);
                break;
            }
            case 2: {
                this.drawLines(points, paint2, 1);
                break;
            }
            case 3: {
                this.drawPoints(points, paint2);
                break;
            }
        }
    }

    @Override
    public void enableZ() {
        CanvasUtils.INSTANCE.enableZ(this.internalCanvas, true);
    }

    @Override
    public void disableZ() {
        CanvasUtils.INSTANCE.enableZ(this.internalCanvas, false);
    }

    private final void drawPoints(List<Offset> points, Paint paint2) {
        List<Offset> $this$fastForEach$iv = points;
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = $this$fastForEach$iv.size() + -1;
        if (n <= n2) {
            do {
                Offset item$iv;
                int index$iv = n++;
                Offset point = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                this.internalCanvas.drawPoint(point.getX(), point.getY(), paint2.asFrameworkPaint());
            } while (n <= n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawLines(List<Offset> points, Paint paint2, int stepBy) {
        if (points.size() >= 2) {
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(points.size() - 1))), (int)stepBy);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void i;
                    Offset p1 = points.get((int)i);
                    Offset p2 = points.get((int)(i + true));
                    this.internalCanvas.drawLine(p1.getX(), p1.getY(), p2.getX(), p2.getY(), paint2.asFrameworkPaint());
                    if (i == n2) break;
                    i += n3;
                }
            }
        }
    }

    @Override
    public void drawRawPoints(@NotNull PointMode pointMode, @NotNull float[] points, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)((Object)pointMode), (String)"pointMode");
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        if (points.length % 2 != 0) {
            throw (Throwable)new IllegalArgumentException("points must have an even number of values");
        }
        switch (AndroidCanvas$WhenMappings.$EnumSwitchMapping$2[pointMode.ordinal()]) {
            case 1: {
                this.drawRawLines(points, paint2, 2);
                break;
            }
            case 2: {
                this.drawRawLines(points, paint2, 1);
                break;
            }
            case 3: {
                this.drawRawPoints(points, paint2, 2);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawRawPoints(float[] points, Paint paint2, int stepBy) {
        if (points.length % 2 == 0) {
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(points.length - 1))), (int)stepBy);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void i;
                    float x = points[i];
                    float y = points[i + true];
                    this.internalCanvas.drawPoint(x, y, paint2.asFrameworkPaint());
                    if (i == n2) break;
                    i += n3;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawRawLines(float[] points, Paint paint2, int stepBy) {
        if (points.length >= 4 && points.length % 2 == 0) {
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(points.length - 3))), (int)(stepBy * 2));
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void i;
                    float x1 = points[i];
                    float y1 = points[i + true];
                    float x2 = points[i + 2];
                    float y2 = points[i + 3];
                    this.internalCanvas.drawLine(x1, y1, x2, y2, paint2.asFrameworkPaint());
                    if (i == n2) break;
                    i += n3;
                }
            }
        }
    }

    @Override
    public void drawVertices(@NotNull Vertices vertices, @NotNull BlendMode blendMode, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)vertices, (String)"vertices");
        Intrinsics.checkNotNullParameter((Object)((Object)blendMode), (String)"blendMode");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        this.internalCanvas.drawVertices(AndroidVertexModeKt.toNativeVertexMode(vertices.getVertexMode()), vertices.getPositions().length, vertices.getPositions(), 0, vertices.getTextureCoordinates(), 0, vertices.getColors(), 0, vertices.getIndices(), 0, vertices.getIndices().length, paint2.asFrameworkPaint());
    }

    @Override
    public void clipRect(@NotNull Rect rect, @NotNull ClipOp clipOp) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)((Object)clipOp), (String)"clipOp");
        Canvas.DefaultImpls.clipRect(this, rect, clipOp);
    }

    @Override
    public void drawRect(@NotNull Rect rect, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        Canvas.DefaultImpls.drawRect(this, rect, paint2);
    }

    @Override
    public void drawOval(@NotNull Rect rect, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        Canvas.DefaultImpls.drawOval(this, rect, paint2);
    }

    @Override
    public void drawArc(@NotNull Rect rect, float startAngle, float sweepAngle, boolean useCenter, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        Canvas.DefaultImpls.drawArc(this, rect, startAngle, sweepAngle, useCenter, paint2);
    }

    @Override
    public void skewRad(float sxRad, float syRad) {
        Canvas.DefaultImpls.skewRad(this, sxRad, syRad);
    }

    @Override
    public void drawArcRad(@NotNull Rect rect, float startAngleRad, float sweepAngleRad, boolean useCenter, @NotNull Paint paint2) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)paint2, (String)"paint");
        Canvas.DefaultImpls.drawArcRad(this, rect, startAngleRad, sweepAngleRad, useCenter, paint2);
    }
}

