/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.os.Build;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/graphics/CanvasUtils;", "", "()V", "inorderBarrierMethod", "Ljava/lang/reflect/Method;", "orderMethodsFetched", "", "reorderBarrierMethod", "enableZ", "", "canvas", "Landroid/graphics/Canvas;", "enable", "ui-graphics_release"})
public final class CanvasUtils {
    private static Method reorderBarrierMethod;
    private static Method inorderBarrierMethod;
    private static boolean orderMethodsFetched;
    public static final CanvasUtils INSTANCE;

    @SuppressLint(value={"SoonBlockedPrivateApi"})
    public final void enableZ(@NotNull Canvas canvas, boolean enable) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (Build.VERSION.SDK_INT >= 29) {
            if (enable) {
                canvas.enableZ();
            } else {
                canvas.disableZ();
            }
        } else {
            if (!orderMethodsFetched) {
                try {
                    if (Build.VERSION.SDK_INT == 28) {
                        Method getDeclaredMethod = Class.class.getDeclaredMethod("getDeclaredMethod", String.class, new Class[0].getClass());
                        reorderBarrierMethod = (Method)getDeclaredMethod.invoke(Canvas.class, "insertReorderBarrier", new Class[0]);
                        inorderBarrierMethod = (Method)getDeclaredMethod.invoke(Canvas.class, "insertInorderBarrier", new Class[0]);
                    } else {
                        reorderBarrierMethod = Canvas.class.getDeclaredMethod("insertReorderBarrier", new Class[0]);
                        inorderBarrierMethod = Canvas.class.getDeclaredMethod("insertInorderBarrier", new Class[0]);
                    }
                    Method method = reorderBarrierMethod;
                    if (method != null) {
                        method.setAccessible(true);
                    }
                    Method method2 = inorderBarrierMethod;
                    if (method2 != null) {
                        method2.setAccessible(true);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                orderMethodsFetched = true;
            }
            try {
                if (enable && reorderBarrierMethod != null) {
                    Method method = reorderBarrierMethod;
                    Intrinsics.checkNotNull((Object)method);
                    method.invoke((Object)canvas, new Object[0]);
                }
                if (!enable && inorderBarrierMethod != null) {
                    Method method = inorderBarrierMethod;
                    Intrinsics.checkNotNull((Object)method);
                    method.invoke((Object)canvas, new Object[0]);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private CanvasUtils() {
    }

    static {
        CanvasUtils canvasUtils;
        INSTANCE = canvasUtils = new CanvasUtils();
    }
}

