/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vectormath;

import androidx.compose.ui.graphics.vectormath.Matrix3$WhenMappings;
import androidx.compose.ui.graphics.vectormath.MatrixColumn;
import androidx.compose.ui.graphics.vectormath.MatrixExtensionsKt;
import androidx.compose.ui.graphics.vectormath.Vector3;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 12\u00020\u0001:\u00011B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B#\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u001a\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000bH\u0086\u0002J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0011\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0086\u0002J\u0019\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020$H\u0086\u0002J\u0019\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020$2\u0006\u0010#\u001a\u00020$H\u0086\u0002J\t\u0010%\u001a\u00020$H\u00d6\u0001J\t\u0010&\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000bH\u0086\u0002J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000bH\u0086\u0002J\u0019\u0010)\u001a\u00020*2\u0006\u0010!\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u0005H\u0086\u0002J!\u0010)\u001a\u00020*2\u0006\u0010!\u001a\u00020$2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u000bH\u0086\u0002J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010+\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000bH\u0086\u0002J\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020/H\u0016J\t\u00100\u001a\u00020\u0000H\u0086\u0002R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011\u00a8\u00062"}, d2={"Landroidx/compose/ui/graphics/vectormath/Matrix3;", "", "m", "(Landroidx/compose/ui/graphics/vectormath/Matrix3;)V", "x", "Landroidx/compose/ui/graphics/vectormath/Vector3;", "y", "z", "(Landroidx/compose/ui/graphics/vectormath/Vector3;Landroidx/compose/ui/graphics/vectormath/Vector3;Landroidx/compose/ui/graphics/vectormath/Vector3;)V", "m3storage", "", "", "getM3storage", "()Ljava/util/List;", "getX", "()Landroidx/compose/ui/graphics/vectormath/Vector3;", "setX", "(Landroidx/compose/ui/graphics/vectormath/Vector3;)V", "getY", "setY", "getZ", "setZ", "component1", "component2", "component3", "copy", "dec", "div", "v", "equals", "", "other", "get", "column", "Landroidx/compose/ui/graphics/vectormath/MatrixColumn;", "row", "", "hashCode", "inc", "minus", "plus", "set", "", "times", "toFloatArray", "", "toString", "", "unaryMinus", "Companion", "ui-graphics_release"})
public final class Matrix3 {
    @NotNull
    private Vector3 x;
    @NotNull
    private Vector3 y;
    @NotNull
    private Vector3 z;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Float> getM3storage() {
        int $i$f$getM3storage = 0;
        Vector3 this_$iv = this.getX();
        boolean $i$f$getV3storage = false;
        Object[] objectArray = new Float[]{Float.valueOf(this_$iv.getX()), Float.valueOf(this_$iv.getY()), Float.valueOf(this_$iv.getZ())};
        this_$iv = this.getY();
        $i$f$getV3storage = false;
        Object[] objectArray2 = new Float[]{Float.valueOf(this_$iv.getX()), Float.valueOf(this_$iv.getY()), Float.valueOf(this_$iv.getZ())};
        this_$iv = this.getZ();
        $i$f$getV3storage = false;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)CollectionsKt.listOf((Object[])objectArray2)), (Iterable)CollectionsKt.listOf((Object[])new Float[]{Float.valueOf(this_$iv.getX()), Float.valueOf(this_$iv.getY()), Float.valueOf(this_$iv.getZ())}));
    }

    @NotNull
    public final Vector3 get(int column) {
        Vector3 vector3;
        switch (column) {
            case 0: {
                vector3 = this.x;
                break;
            }
            case 1: {
                vector3 = this.y;
                break;
            }
            case 2: {
                vector3 = this.z;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("column must be in 0..2");
            }
        }
        return vector3;
    }

    public final float get(int column, int row) {
        return this.get(column).get(row);
    }

    @NotNull
    public final Vector3 get(@NotNull MatrixColumn column) {
        Vector3 vector3;
        Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
        switch (Matrix3$WhenMappings.$EnumSwitchMapping$0[column.ordinal()]) {
            case 1: {
                vector3 = this.x;
                break;
            }
            case 2: {
                vector3 = this.y;
                break;
            }
            case 3: {
                vector3 = this.z;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("column must be X, Y or Z");
            }
        }
        return vector3;
    }

    public final float get(@NotNull MatrixColumn column, int row) {
        Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
        return this.get(column).get(row);
    }

    public final void set(int column, @NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Vector3 this_$iv = this.get(column);
        boolean $i$f$setXyz = false;
        this_$iv.setX(v.getX());
        this_$iv.setY(v.getY());
        this_$iv.setZ(v.getZ());
    }

    public final void set(int column, int row, float v) {
        this.get(column).set(row, v);
    }

    @NotNull
    public final Matrix3 unaryMinus() {
        return new Matrix3(this.x.unaryMinus(), this.y.unaryMinus(), this.z.unaryMinus());
    }

    @NotNull
    public final Matrix3 inc() {
        Matrix3 matrix3 = new Matrix3(this);
        boolean bl = false;
        boolean bl2 = false;
        Matrix3 $this$apply = matrix3;
        boolean bl3 = false;
        Matrix3 matrix32 = $this$apply;
        matrix32.x = matrix32.x.inc();
        Vector3 cfr_ignored_0 = matrix32.x;
        Matrix3 matrix33 = $this$apply;
        matrix33.y = matrix33.y.inc();
        Vector3 cfr_ignored_1 = matrix33.y;
        Matrix3 matrix34 = $this$apply;
        matrix34.z = matrix34.z.inc();
        Vector3 cfr_ignored_2 = matrix34.z;
        return matrix3;
    }

    @NotNull
    public final Matrix3 dec() {
        Matrix3 matrix3 = new Matrix3(this);
        boolean bl = false;
        boolean bl2 = false;
        Matrix3 $this$apply = matrix3;
        boolean bl3 = false;
        Matrix3 matrix32 = $this$apply;
        matrix32.x = matrix32.x.dec();
        Vector3 cfr_ignored_0 = matrix32.x;
        Matrix3 matrix33 = $this$apply;
        matrix33.y = matrix33.y.dec();
        Vector3 cfr_ignored_1 = matrix33.y;
        Matrix3 matrix34 = $this$apply;
        matrix34.z = matrix34.z.dec();
        Vector3 cfr_ignored_2 = matrix34.z;
        return matrix3;
    }

    @NotNull
    public final Matrix3 plus(float v) {
        Vector3 this_$iv = this.x;
        boolean $i$f$plus = false;
        Vector3 vector3 = new Vector3(this_$iv.getX() + v, this_$iv.getY() + v, this_$iv.getZ() + v);
        this_$iv = this.y;
        $i$f$plus = false;
        Vector3 vector32 = new Vector3(this_$iv.getX() + v, this_$iv.getY() + v, this_$iv.getZ() + v);
        this_$iv = this.z;
        $i$f$plus = false;
        return new Matrix3(vector3, vector32, new Vector3(this_$iv.getX() + v, this_$iv.getY() + v, this_$iv.getZ() + v));
    }

    @NotNull
    public final Matrix3 minus(float v) {
        Vector3 this_$iv = this.x;
        boolean $i$f$minus = false;
        Vector3 vector3 = new Vector3(this_$iv.getX() - v, this_$iv.getY() - v, this_$iv.getZ() - v);
        this_$iv = this.y;
        $i$f$minus = false;
        Vector3 vector32 = new Vector3(this_$iv.getX() - v, this_$iv.getY() - v, this_$iv.getZ() - v);
        this_$iv = this.z;
        $i$f$minus = false;
        return new Matrix3(vector3, vector32, new Vector3(this_$iv.getX() - v, this_$iv.getY() - v, this_$iv.getZ() - v));
    }

    @NotNull
    public final Matrix3 times(float v) {
        Vector3 this_$iv = this.x;
        boolean $i$f$times = false;
        Vector3 vector3 = new Vector3(this_$iv.getX() * v, this_$iv.getY() * v, this_$iv.getZ() * v);
        this_$iv = this.y;
        $i$f$times = false;
        Vector3 vector32 = new Vector3(this_$iv.getX() * v, this_$iv.getY() * v, this_$iv.getZ() * v);
        this_$iv = this.z;
        $i$f$times = false;
        return new Matrix3(vector3, vector32, new Vector3(this_$iv.getX() * v, this_$iv.getY() * v, this_$iv.getZ() * v));
    }

    @NotNull
    public final Matrix3 div(float v) {
        Vector3 this_$iv = this.x;
        boolean $i$f$div = false;
        Vector3 vector3 = new Vector3(this_$iv.getX() / v, this_$iv.getY() / v, this_$iv.getZ() / v);
        this_$iv = this.y;
        $i$f$div = false;
        Vector3 vector32 = new Vector3(this_$iv.getX() / v, this_$iv.getY() / v, this_$iv.getZ() / v);
        this_$iv = this.z;
        $i$f$div = false;
        return new Matrix3(vector3, vector32, new Vector3(this_$iv.getX() / v, this_$iv.getY() / v, this_$iv.getZ() / v));
    }

    @NotNull
    public final Matrix3 times(@NotNull Matrix3 m) {
        Vector3 a$iv;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Matrix3 t = MatrixExtensionsKt.transpose(this);
        Vector3 vector3 = t.x;
        Vector3 b$iv = m.x;
        boolean $i$f$dot = false;
        float f = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ();
        a$iv = t.y;
        b$iv = m.x;
        $i$f$dot = false;
        float f2 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ();
        a$iv = t.z;
        b$iv = m.x;
        $i$f$dot = false;
        Vector3 vector32 = new Vector3(f, f2, a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ());
        a$iv = t.x;
        b$iv = m.y;
        $i$f$dot = false;
        float f3 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ();
        a$iv = t.y;
        b$iv = m.y;
        $i$f$dot = false;
        float f4 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ();
        a$iv = t.z;
        b$iv = m.y;
        $i$f$dot = false;
        Vector3 vector33 = new Vector3(f3, f4, a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ());
        a$iv = t.x;
        b$iv = m.z;
        $i$f$dot = false;
        float f5 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ();
        a$iv = t.y;
        b$iv = m.z;
        $i$f$dot = false;
        float f6 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ();
        a$iv = t.z;
        b$iv = m.z;
        $i$f$dot = false;
        return new Matrix3(vector32, vector33, new Vector3(f5, f6, a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ()));
    }

    @NotNull
    public final Vector3 times(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Matrix3 t = MatrixExtensionsKt.transpose(this);
        Vector3 a$iv = t.x;
        boolean $i$f$dot = false;
        float f = a$iv.getX() * v.getX() + a$iv.getY() * v.getY() + a$iv.getZ() * v.getZ();
        a$iv = t.y;
        $i$f$dot = false;
        float f2 = a$iv.getX() * v.getX() + a$iv.getY() * v.getY() + a$iv.getZ() * v.getZ();
        a$iv = t.z;
        $i$f$dot = false;
        return new Vector3(f, f2, a$iv.getX() * v.getX() + a$iv.getY() * v.getY() + a$iv.getZ() * v.getZ());
    }

    @NotNull
    public final float[] toFloatArray() {
        return new float[]{this.x.getX(), this.y.getX(), this.z.getX(), this.x.getY(), this.y.getY(), this.z.getY(), this.x.getZ(), this.y.getZ(), this.z.getZ()};
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n            |" + this.x.getX() + ' ' + this.y.getX() + ' ' + this.z.getX() + "|\n            |" + this.x.getY() + ' ' + this.y.getY() + ' ' + this.z.getY() + "|\n            |" + this.x.getZ() + ' ' + this.y.getZ() + ' ' + this.z.getZ() + "|\n            "));
    }

    @NotNull
    public final Vector3 getX() {
        return this.x;
    }

    public final void setX(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter((Object)vector3, (String)"<set-?>");
        this.x = vector3;
    }

    @NotNull
    public final Vector3 getY() {
        return this.y;
    }

    public final void setY(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter((Object)vector3, (String)"<set-?>");
        this.y = vector3;
    }

    @NotNull
    public final Vector3 getZ() {
        return this.z;
    }

    public final void setZ(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter((Object)vector3, (String)"<set-?>");
        this.z = vector3;
    }

    public Matrix3(@NotNull Vector3 x, @NotNull Vector3 y, @NotNull Vector3 z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public /* synthetic */ Matrix3(Vector3 vector3, Vector3 vector32, Vector3 vector33, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            vector3 = new Vector3(1.0f, 0.0f, 0.0f, 6, null);
        }
        if ((n & 2) != 0) {
            vector32 = new Vector3(0.0f, 1.0f, 0.0f, 5, null);
        }
        if ((n & 4) != 0) {
            vector33 = new Vector3(0.0f, 0.0f, 1.0f, 3, null);
        }
        this(vector3, vector32, vector33);
    }

    public Matrix3() {
        this(null, null, null, 7, null);
    }

    public Matrix3(@NotNull Matrix3 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this(Vector3.copy$default(m.x, 0.0f, 0.0f, 0.0f, 7, null), Vector3.copy$default(m.y, 0.0f, 0.0f, 0.0f, 7, null), Vector3.copy$default(m.z, 0.0f, 0.0f, 0.0f, 7, null));
    }

    @NotNull
    public final Vector3 component1() {
        return this.x;
    }

    @NotNull
    public final Vector3 component2() {
        return this.y;
    }

    @NotNull
    public final Vector3 component3() {
        return this.z;
    }

    @NotNull
    public final Matrix3 copy(@NotNull Vector3 x, @NotNull Vector3 y, @NotNull Vector3 z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return new Matrix3(x, y, z);
    }

    public static /* synthetic */ Matrix3 copy$default(Matrix3 matrix3, Vector3 vector3, Vector3 vector32, Vector3 vector33, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = matrix3.x;
        }
        if ((n & 2) != 0) {
            vector32 = matrix3.y;
        }
        if ((n & 4) != 0) {
            vector33 = matrix3.z;
        }
        return matrix3.copy(vector3, vector32, vector33);
    }

    public int hashCode() {
        Vector3 vector3 = this.x;
        Vector3 vector32 = this.y;
        Vector3 vector33 = this.z;
        return ((vector3 != null ? ((Object)vector3).hashCode() : 0) * 31 + (vector32 != null ? ((Object)vector32).hashCode() : 0)) * 31 + (vector33 != null ? ((Object)vector33).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Matrix3)) break block3;
                Matrix3 matrix3 = (Matrix3)object;
                if (!Intrinsics.areEqual((Object)this.x, (Object)matrix3.x) || !Intrinsics.areEqual((Object)this.y, (Object)matrix3.y) || !Intrinsics.areEqual((Object)this.z, (Object)matrix3.z)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0012\u0010\u0005\u001a\u00020\u00042\n\u0010\u0006\u001a\u00020\u0007\"\u00020\b\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/graphics/vectormath/Matrix3$Companion;", "", "()V", "identity", "Landroidx/compose/ui/graphics/vectormath/Matrix3;", "of", "a", "", "", "ui-graphics_release"})
    public static final class Companion {
        @NotNull
        public final Matrix3 of(float ... a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            boolean bl = a.length >= 9;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return new Matrix3(new Vector3(a[0], a[3], a[6]), new Vector3(a[1], a[4], a[7]), new Vector3(a[2], a[5], a[8]));
        }

        @NotNull
        public final Matrix3 identity() {
            return new Matrix3(null, null, null, 7, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

