/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.DisplayMetrics;
import androidx.compose.ui.graphics.AndroidImageBitmap;
import androidx.compose.ui.graphics.Api26Bitmap;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapConfig;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0001\u001a\f\u0010\u0011\u001a\u00020\u0001*\u00020\u0010H\u0007\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0010\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0006H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0006*\u00020\u0014H\u0000\u00a8\u0006\u0016"}, d2={"ActualImageBitmap", "Landroidx/compose/ui/graphics/ImageBitmap;", "width", "", "height", "config", "Landroidx/compose/ui/graphics/ImageBitmapConfig;", "hasAlpha", "", "colorSpace", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "imageFromResource", "res", "Landroid/content/res/Resources;", "resId", "asAndroidBitmap", "Landroid/graphics/Bitmap;", "asImageAsset", "asImageBitmap", "toBitmapConfig", "Landroid/graphics/Bitmap$Config;", "toImageConfig", "ui-graphics_release"})
public final class AndroidImageBitmapKt {
    @NotNull
    public static final ImageBitmap imageFromResource(@NotNull Resources res, int resId) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)res, (int)resId);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"BitmapFactory.decodeResource(res, resId)");
        return new AndroidImageBitmap(bitmap);
    }

    @NotNull
    public static final ImageBitmap asImageBitmap(@NotNull Bitmap $this$asImageBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$asImageBitmap, (String)"$this$asImageBitmap");
        return new AndroidImageBitmap($this$asImageBitmap);
    }

    @Deprecated(message="Use asImageBitmap instead", replaceWith=@ReplaceWith(imports={"androidx.compose.ui.graphics"}, expression="asImageBitmap()"))
    @NotNull
    public static final ImageBitmap asImageAsset(@NotNull Bitmap $this$asImageAsset) {
        Intrinsics.checkNotNullParameter((Object)$this$asImageAsset, (String)"$this$asImageAsset");
        return AndroidImageBitmapKt.asImageBitmap($this$asImageAsset);
    }

    @NotNull
    public static final ImageBitmap ActualImageBitmap(int width, int height, @NotNull ImageBitmapConfig config, boolean hasAlpha, @NotNull ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        Bitmap.Config bitmapConfig = AndroidImageBitmapKt.toBitmapConfig(config);
        Bitmap bitmap = null;
        if (Build.VERSION.SDK_INT >= 26) {
            bitmap = Api26Bitmap.Companion.createBitmap$ui_graphics_release(width, height, config, hasAlpha, colorSpace);
        } else {
            Bitmap bitmap2 = Bitmap.createBitmap((DisplayMetrics)null, (int)width, (int)height, (Bitmap.Config)bitmapConfig);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"Bitmap.createBitmap(\n   \u2026   bitmapConfig\n        )");
            bitmap = bitmap2;
            bitmap.setHasAlpha(hasAlpha);
        }
        return new AndroidImageBitmap(bitmap);
    }

    @NotNull
    public static final Bitmap asAndroidBitmap(@NotNull ImageBitmap $this$asAndroidBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$asAndroidBitmap, (String)"$this$asAndroidBitmap");
        ImageBitmap imageBitmap = $this$asAndroidBitmap;
        if (!(imageBitmap instanceof AndroidImageBitmap)) {
            throw (Throwable)new UnsupportedOperationException("Unable to obtain android.graphics.Bitmap");
        }
        return ((AndroidImageBitmap)$this$asAndroidBitmap).getBitmap$ui_graphics_release();
    }

    @NotNull
    public static final Bitmap.Config toBitmapConfig(@NotNull ImageBitmapConfig $this$toBitmapConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toBitmapConfig), (String)"$this$toBitmapConfig");
        return $this$toBitmapConfig == ImageBitmapConfig.Argb8888 ? Bitmap.Config.ARGB_8888 : ($this$toBitmapConfig == ImageBitmapConfig.Alpha8 ? Bitmap.Config.ALPHA_8 : ($this$toBitmapConfig == ImageBitmapConfig.Rgb565 ? Bitmap.Config.RGB_565 : (Build.VERSION.SDK_INT >= 26 && $this$toBitmapConfig == ImageBitmapConfig.F16 ? Bitmap.Config.RGBA_F16 : (Build.VERSION.SDK_INT >= 26 && $this$toBitmapConfig == ImageBitmapConfig.Gpu ? Bitmap.Config.HARDWARE : Bitmap.Config.ARGB_8888))));
    }

    @NotNull
    public static final ImageBitmapConfig toImageConfig(@NotNull Bitmap.Config $this$toImageConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$toImageConfig, (String)"$this$toImageConfig");
        return $this$toImageConfig == Bitmap.Config.ALPHA_8 ? ImageBitmapConfig.Alpha8 : ($this$toImageConfig == Bitmap.Config.RGB_565 ? ImageBitmapConfig.Rgb565 : ($this$toImageConfig == Bitmap.Config.ARGB_4444 ? ImageBitmapConfig.Argb8888 : (Build.VERSION.SDK_INT >= 26 && $this$toImageConfig == Bitmap.Config.RGBA_F16 ? ImageBitmapConfig.F16 : (Build.VERSION.SDK_INT >= 26 && $this$toImageConfig == Bitmap.Config.HARDWARE ? ImageBitmapConfig.Gpu : ImageBitmapConfig.Argb8888))));
    }
}

