/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.graphics.BitmapShader;
import android.graphics.LinearGradient;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.AndroidImageBitmapKt;
import androidx.compose.ui.graphics.AndroidTileModeKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.TileMode;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=16, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u001aL\u0010\b\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001aL\u0010\u0014\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a<\u0010\u0019\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u0015\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\rH\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a)\u0010\u001c\u001a\u00020\u001d2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\rH\u0002\u00f8\u0001\u0000\u001a\u0015\u0010\u001e\u001a\u00020\u001f*\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00f8\u0001\u0000*\n\u0010 \"\u00020\u00012\u00020\u0001\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"ActualImageShader", "Landroid/graphics/Shader;", "Landroidx/compose/ui/graphics/Shader;", "image", "Landroidx/compose/ui/graphics/ImageBitmap;", "tileModeX", "Landroidx/compose/ui/graphics/TileMode;", "tileModeY", "ActualLinearGradientShader", "from", "Landroidx/compose/ui/geometry/Offset;", "to", "colors", "", "Landroidx/compose/ui/graphics/Color;", "colorStops", "", "tileMode", "ActualLinearGradientShader-GfyHbQM", "(JJLjava/util/List;Ljava/util/List;Landroidx/compose/ui/graphics/TileMode;)Landroid/graphics/Shader;", "ActualRadialGradientShader", "center", "radius", "ActualRadialGradientShader-cY6o93o", "(JFLjava/util/List;Ljava/util/List;Landroidx/compose/ui/graphics/TileMode;)Landroid/graphics/Shader;", "ActualSweepGradientShader", "ActualSweepGradientShader-GpNgDDw", "(JLjava/util/List;Ljava/util/List;)Landroid/graphics/Shader;", "validateColorStops", "", "toIntArray", "", "Shader", "ui-graphics_release"})
public final class AndroidShaderKt {
    @NotNull
    public static final Shader ActualLinearGradientShader-GfyHbQM(long from, long to, @NotNull List<Color> colors, @Nullable List<Float> colorStops, @NotNull TileMode tileMode) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)((Object)tileMode), (String)"tileMode");
        AndroidShaderKt.validateColorStops(colors, colorStops);
        List<Float> list = colorStops;
        return (Shader)new LinearGradient(Offset.getX-impl((long)from), Offset.getY-impl((long)from), Offset.getX-impl((long)to), Offset.getY-impl((long)to), AndroidShaderKt.toIntArray(colors), list == null ? null : CollectionsKt.toFloatArray((Collection)list), AndroidTileModeKt.toNativeTileMode(tileMode));
    }

    @NotNull
    public static final Shader ActualRadialGradientShader-cY6o93o(long center, float radius, @NotNull List<Color> colors, @Nullable List<Float> colorStops, @NotNull TileMode tileMode) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)((Object)tileMode), (String)"tileMode");
        AndroidShaderKt.validateColorStops(colors, colorStops);
        List<Float> list = colorStops;
        return (Shader)new RadialGradient(Offset.getX-impl((long)center), Offset.getY-impl((long)center), radius, AndroidShaderKt.toIntArray(colors), list == null ? null : CollectionsKt.toFloatArray((Collection)list), AndroidTileModeKt.toNativeTileMode(tileMode));
    }

    @NotNull
    public static final Shader ActualSweepGradientShader-GpNgDDw(long center, @NotNull List<Color> colors, @Nullable List<Float> colorStops) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        AndroidShaderKt.validateColorStops(colors, colorStops);
        List<Float> list = colorStops;
        return (Shader)new SweepGradient(Offset.getX-impl((long)center), Offset.getY-impl((long)center), AndroidShaderKt.toIntArray(colors), list == null ? null : CollectionsKt.toFloatArray((Collection)list));
    }

    @NotNull
    public static final Shader ActualImageShader(@NotNull ImageBitmap image, @NotNull TileMode tileModeX, @NotNull TileMode tileModeY) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)((Object)tileModeX), (String)"tileModeX");
        Intrinsics.checkNotNullParameter((Object)((Object)tileModeY), (String)"tileModeY");
        return (Shader)new BitmapShader(AndroidImageBitmapKt.asAndroidBitmap(image), AndroidTileModeKt.toNativeTileMode(tileModeX), AndroidTileModeKt.toNativeTileMode(tileModeY));
    }

    private static final int[] toIntArray(List<Color> $this$toIntArray) {
        int n = 0;
        int n2 = $this$toIntArray.size();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = ColorKt.toArgb-8_81llA($this$toIntArray.get(n3).unbox-impl());
        }
        return nArray;
    }

    private static final void validateColorStops(List<Color> colors, List<Float> colorStops) {
        if (colorStops == null) {
            if (colors.size() < 2) {
                throw new IllegalArgumentException("colors must have length of at least 2 if colorStops is omitted.");
            }
        } else if (colors.size() != colorStops.size()) {
            throw new IllegalArgumentException("colors and colorStops arguments must have equal length.");
        }
    }
}

