/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.graphics.Bitmap;
import android.os.Build;
import android.util.DisplayMetrics;
import androidx.compose.ui.graphics.AndroidImageBitmap;
import androidx.compose.ui.graphics.Api26Bitmap;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapConfig;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\f\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0006H\u0000\u001a\f\u0010\u0010\u001a\u00020\u0006*\u00020\u000fH\u0000\u00a8\u0006\u0011"}, d2={"ActualImageBitmap", "Landroidx/compose/ui/graphics/ImageBitmap;", "width", "", "height", "config", "Landroidx/compose/ui/graphics/ImageBitmapConfig;", "hasAlpha", "", "colorSpace", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "asAndroidBitmap", "Landroid/graphics/Bitmap;", "asImageBitmap", "toBitmapConfig", "Landroid/graphics/Bitmap$Config;", "toImageConfig", "ui-graphics_release"})
public final class AndroidImageBitmap_androidKt {
    @NotNull
    public static final ImageBitmap asImageBitmap(@NotNull Bitmap $this$asImageBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$asImageBitmap, (String)"<this>");
        return new AndroidImageBitmap($this$asImageBitmap);
    }

    @NotNull
    public static final ImageBitmap ActualImageBitmap(int width, int height, @NotNull ImageBitmapConfig config, boolean hasAlpha, @NotNull ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        Bitmap.Config bitmapConfig = AndroidImageBitmap_androidKt.toBitmapConfig(config);
        Bitmap bitmap = null;
        if (Build.VERSION.SDK_INT >= 26) {
            bitmap = Api26Bitmap.Companion.createBitmap$ui_graphics_release(width, height, config, hasAlpha, colorSpace);
        } else {
            Bitmap bitmap2 = Bitmap.createBitmap((DisplayMetrics)null, (int)width, (int)height, (Bitmap.Config)bitmapConfig);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(\n            null as DisplayMetrics?,\n            width,\n            height,\n            bitmapConfig\n        )");
            bitmap = bitmap2;
            bitmap.setHasAlpha(hasAlpha);
        }
        return new AndroidImageBitmap(bitmap);
    }

    @NotNull
    public static final Bitmap asAndroidBitmap(@NotNull ImageBitmap $this$asAndroidBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$asAndroidBitmap, (String)"<this>");
        ImageBitmap imageBitmap = $this$asAndroidBitmap;
        if (!(imageBitmap instanceof AndroidImageBitmap)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Bitmap");
        }
        return ((AndroidImageBitmap)$this$asAndroidBitmap).getBitmap$ui_graphics_release();
    }

    @NotNull
    public static final Bitmap.Config toBitmapConfig(@NotNull ImageBitmapConfig $this$toBitmapConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toBitmapConfig), (String)"<this>");
        return $this$toBitmapConfig == ImageBitmapConfig.Argb8888 ? Bitmap.Config.ARGB_8888 : ($this$toBitmapConfig == ImageBitmapConfig.Alpha8 ? Bitmap.Config.ALPHA_8 : ($this$toBitmapConfig == ImageBitmapConfig.Rgb565 ? Bitmap.Config.RGB_565 : (Build.VERSION.SDK_INT >= 26 && $this$toBitmapConfig == ImageBitmapConfig.F16 ? Bitmap.Config.RGBA_F16 : (Build.VERSION.SDK_INT >= 26 && $this$toBitmapConfig == ImageBitmapConfig.Gpu ? Bitmap.Config.HARDWARE : Bitmap.Config.ARGB_8888))));
    }

    @NotNull
    public static final ImageBitmapConfig toImageConfig(@NotNull Bitmap.Config $this$toImageConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$toImageConfig, (String)"<this>");
        return $this$toImageConfig == Bitmap.Config.ALPHA_8 ? ImageBitmapConfig.Alpha8 : ($this$toImageConfig == Bitmap.Config.RGB_565 ? ImageBitmapConfig.Rgb565 : ($this$toImageConfig == Bitmap.Config.ARGB_4444 ? ImageBitmapConfig.Argb8888 : (Build.VERSION.SDK_INT >= 26 && $this$toImageConfig == Bitmap.Config.RGBA_F16 ? ImageBitmapConfig.F16 : (Build.VERSION.SDK_INT >= 26 && $this$toImageConfig == Bitmap.Config.HARDWARE ? ImageBitmapConfig.Gpu : ImageBitmapConfig.Argb8888))));
    }
}

