/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.kotlin.KotlinULiteralExpression;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/ui/graphics/lint/ColorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "ui-graphics-lint"})
public final class ColorDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    private static final Issue MissingColorAlphaChannel;
    @NotNull
    private static final Issue InvalidColorHexValue;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)Names.UiGraphics.INSTANCE.getColor().getShortName());
    }

    /*
     * Unable to fully structure code
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        block11: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            if (!PsiUtilsKt.isInPackageName(method, Names.UiGraphics.INSTANCE.getPackageName()) || node.getValueArgumentCount() != 1) break block11;
            argument = (UExpression)CollectionsKt.first((List)node.getValueArguments());
            if (!(argument instanceof KotlinULiteralExpression)) {
                return;
            }
            v0 = argument.getSourcePsi();
            if (v0 == null || (v0 = v0.getText()) == null) {
                return;
            }
            argumentText = v0;
            hexPrefix = "0x";
            hexIndex = StringsKt.indexOf$default((CharSequence)((CharSequence)argumentText), (String)hexPrefix, (int)0, (boolean)true, (int)2, null);
            if (hexIndex != 0) {
                return;
            }
            var9_8 = argumentText;
            var10_10 = hexIndex + hexPrefix.length();
            var11_11 = false;
            v1 = var9_8;
            if (v1 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            v2 = v1.substring(var10_10);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"(this as java.lang.String).substring(startIndex)");
            hexArgument = v2;
            hexLength = StringsKt.replace$default((String)StringsKt.replace$default((String)hexArgument, (String)"_", (String)"", (boolean)false, (int)4, null), (String)"L", (String)"", (boolean)false, (int)4, null).length();
            switch (hexLength) {
                case 8: {
                    return;
                }
                case 6: {
                    var11_12 = hexArgument;
                    $i$f$firstOrNull = false;
                    var13_18 = $this$firstOrNull$iv;
                    for (var14_19 = 0; var14_19 < var13_18.length(); ++var14_19) {
                        it = element$iv = var13_18.charAt(var14_19);
                        $i$a$-firstOrNull-ColorDetector$visitMethodCall$isHexValueLowerCase$1 = false;
                        var18_23 = it;
                        var19_24 = false;
                        if (!(Character.isDigit(var18_23) == false)) continue;
                        v3 = Character.valueOf(element$iv);
                        ** GOTO lbl43
                    }
                    v3 = null;
lbl43:
                    // 2 sources

                    if (v3 == null) ** GOTO lbl-1000
                    $this$firstOrNull$iv = v3.charValue();
                    $i$f$firstOrNull = false;
                    if (Character.isLowerCase($this$firstOrNull$iv)) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                    isHexValueLowerCase = v4;
                    alphaChannel = isHexValueLowerCase != false ? "ff" : "FF";
                    replacement = hexPrefix + alphaChannel + hexArgument;
                    context.report(ColorDetector.MissingColorAlphaChannel, (UElement)node, context.getLocation((UElement)argument), "Missing Color alpha channel", LintFix.create().replace().name("Add `" + alphaChannel + "` alpha channel").text((String)argumentText).with(replacement).autoFix().build());
                    break;
                }
                default: {
                    JavaContext.report$default((JavaContext)context, (Issue)ColorDetector.InvalidColorHexValue, (UElement)((UElement)node), (Location)context.getLocation((UElement)argument), (String)"Invalid Color hex value", null, (int)16, null);
                }
            }
        }
    }

    static {
        Companion = new Companion(null);
        MissingColorAlphaChannel = Issue.Companion.create("MissingColorAlphaChannel", "Missing Color alpha channel", "Creating a Color with a hex value requires a 32 bit value (such as 0xFF000000), with 8 bits being used per channel (ARGB). Not passing a full 32 bit value will result in channels being undefined. For example, passing 0xFF0000 will result in a missing alpha channel, so the color will not appear visible.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ColorDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));
        InvalidColorHexValue = Issue.Companion.create("InvalidColorHexValue", "Invalid Color hex value", "Creating a Color with a hex value requires a 32 bit value (such as 0xFF000000), with 8 bits being used per channel (ARGB). Not passing a full 32 bit value will result in channels being undefined / incorrect.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ColorDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/graphics/lint/ColorDetector$Companion;", "", "()V", "InvalidColorHexValue", "Lcom/android/tools/lint/detector/api/Issue;", "getInvalidColorHexValue", "()Lcom/android/tools/lint/detector/api/Issue;", "MissingColorAlphaChannel", "getMissingColorAlphaChannel", "ui-graphics-lint"})
    public static final class Companion {
        @NotNull
        public final Issue getMissingColorAlphaChannel() {
            return MissingColorAlphaChannel;
        }

        @NotNull
        public final Issue getInvalidColorHexValue() {
            return InvalidColorHexValue;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

