/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.colorspace.Adaptation;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import androidx.compose.ui.graphics.colorspace.RenderIntent;
import androidx.compose.ui.graphics.colorspace.Rgb;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\"\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007B<\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\n\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001b"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector;", "", "source", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "destination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "transformSource", "transformDestination", "renderIntent", "transform", "", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;I[FLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getDestination", "()Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "getRenderIntent-uksYyKA", "()I", "I", "getSource", "r", "", "g", "b", "v", "Companion", "RgbConnector", "ui-graphics_release"})
public class Connector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorSpace source;
    @NotNull
    private final ColorSpace destination;
    @NotNull
    private final ColorSpace transformSource;
    @NotNull
    private final ColorSpace transformDestination;
    private final int renderIntent;
    @Nullable
    private final float[] transform;

    private Connector(ColorSpace source, ColorSpace destination, ColorSpace transformSource, ColorSpace transformDestination, int renderIntent, float[] transform) {
        this.source = source;
        this.destination = destination;
        this.transformSource = transformSource;
        this.transformDestination = transformDestination;
        this.renderIntent = renderIntent;
        this.transform = transform;
    }

    @NotNull
    public final ColorSpace getSource() {
        return this.source;
    }

    @NotNull
    public final ColorSpace getDestination() {
        return this.destination;
    }

    public final int getRenderIntent-uksYyKA() {
        return this.renderIntent;
    }

    private Connector(ColorSpace source, ColorSpace destination, int intent) {
        this(source, destination, ColorModel.equals-impl0(source.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) ? ColorSpaceKt.adapt$default(source, Illuminant.INSTANCE.getD50(), null, 2, null) : source, ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) ? ColorSpaceKt.adapt$default(destination, Illuminant.INSTANCE.getD50(), null, 2, null) : destination, intent, Connector.Companion.computeTransform-YBCOT_4(source, destination, intent), null);
    }

    @NotNull
    public final float[] transform(float r, float g, float b) {
        float[] fArray = new float[]{r, g, b};
        return this.transform(fArray);
    }

    @NotNull
    public float[] transform(@NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float[] xyz = this.transformSource.toXyz(v);
        if (this.transform != null) {
            xyz[0] = xyz[0] * this.transform[0];
            xyz[1] = xyz[1] * this.transform[1];
            xyz[2] = xyz[2] * this.transform[2];
        }
        return this.transformDestination.fromXyz(xyz);
    }

    public /* synthetic */ Connector(ColorSpace source, ColorSpace destination, ColorSpace transformSource, ColorSpace transformDestination, int renderIntent, float[] transform, DefaultConstructorMarker $constructor_marker) {
        this(source, destination, transformSource, transformDestination, renderIntent, transform);
    }

    public /* synthetic */ Connector(ColorSpace source, ColorSpace destination, int intent, DefaultConstructorMarker $constructor_marker) {
        this(source, destination, intent);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\"\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J-\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0011"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector$RgbConnector;", "Landroidx/compose/ui/graphics/colorspace/Connector;", "mSource", "Landroidx/compose/ui/graphics/colorspace/Rgb;", "mDestination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "(Landroidx/compose/ui/graphics/colorspace/Rgb;Landroidx/compose/ui/graphics/colorspace/Rgb;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "mTransform", "", "computeTransform", "source", "destination", "computeTransform-YBCOT_4", "(Landroidx/compose/ui/graphics/colorspace/Rgb;Landroidx/compose/ui/graphics/colorspace/Rgb;I)[F", "transform", "v", "ui-graphics_release"})
    public static final class RgbConnector
    extends Connector {
        @NotNull
        private final Rgb mSource;
        @NotNull
        private final Rgb mDestination;
        @NotNull
        private final float[] mTransform;

        private RgbConnector(Rgb mSource, Rgb mDestination, int intent) {
            super(mSource, mDestination, mSource, mDestination, intent, null, null);
            this.mSource = mSource;
            this.mDestination = mDestination;
            this.mTransform = this.computeTransform-YBCOT_4(this.mSource, this.mDestination, intent);
        }

        @Override
        @NotNull
        public float[] transform(@NotNull float[] v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            v[0] = (float)((Number)this.mSource.getEotf().invoke((Object)v[0])).doubleValue();
            v[1] = (float)((Number)this.mSource.getEotf().invoke((Object)v[1])).doubleValue();
            v[2] = (float)((Number)this.mSource.getEotf().invoke((Object)v[2])).doubleValue();
            ColorSpaceKt.mul3x3Float3(this.mTransform, v);
            v[0] = (float)((Number)this.mDestination.getOetf().invoke((Object)v[0])).doubleValue();
            v[1] = (float)((Number)this.mDestination.getOetf().invoke((Object)v[1])).doubleValue();
            v[2] = (float)((Number)this.mDestination.getOetf().invoke((Object)v[2])).doubleValue();
            return v;
        }

        private final float[] computeTransform-YBCOT_4(Rgb source, Rgb destination, int intent) {
            float[] fArray;
            if (ColorSpaceKt.compare(source.getWhitePoint(), destination.getWhitePoint())) {
                return ColorSpaceKt.mul3x3(destination.getInverseTransform$ui_graphics_release(), source.getTransform$ui_graphics_release());
            }
            float[] transform = source.getTransform$ui_graphics_release();
            float[] inverseTransform = destination.getInverseTransform$ui_graphics_release();
            float[] srcXYZ = source.getWhitePoint().toXyz$ui_graphics_release();
            float[] dstXYZ = destination.getWhitePoint().toXyz$ui_graphics_release();
            if (!ColorSpaceKt.compare(source.getWhitePoint(), Illuminant.INSTANCE.getD50())) {
                float[] fArray2 = Adaptation.Companion.getBradford().getTransform$ui_graphics_release();
                float[] fArray3 = Illuminant.INSTANCE.getD50Xyz$ui_graphics_release();
                fArray = Arrays.copyOf(fArray3, fArray3.length);
                Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(this, size)");
                float[] srcAdaptation = ColorSpaceKt.chromaticAdaptation(fArray2, srcXYZ, fArray);
                transform = ColorSpaceKt.mul3x3(srcAdaptation, source.getTransform$ui_graphics_release());
            }
            if (!ColorSpaceKt.compare(destination.getWhitePoint(), Illuminant.INSTANCE.getD50())) {
                float[] fArray4 = Adaptation.Companion.getBradford().getTransform$ui_graphics_release();
                float[] fArray5 = Illuminant.INSTANCE.getD50Xyz$ui_graphics_release();
                fArray = Arrays.copyOf(fArray5, fArray5.length);
                Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(this, size)");
                float[] dstAdaptation = ColorSpaceKt.chromaticAdaptation(fArray4, dstXYZ, fArray);
                inverseTransform = ColorSpaceKt.inverse3x3(ColorSpaceKt.mul3x3(dstAdaptation, destination.getTransform$ui_graphics_release()));
            }
            if (RenderIntent.equals-impl0(intent, RenderIntent.Companion.getAbsolute-uksYyKA())) {
                float[] fArray6 = new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
                transform = ColorSpaceKt.mul3x3Diag(fArray6, transform);
            }
            return ColorSpaceKt.mul3x3(inverseTransform, transform);
        }

        public /* synthetic */ RgbConnector(Rgb mSource, Rgb mDestination, int intent, DefaultConstructorMarker $constructor_marker) {
            this(mSource, mDestination, intent);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000e\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000f"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector$Companion;", "", "()V", "computeTransform", "", "source", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "destination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "computeTransform-YBCOT_4", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;I)[F", "identity", "Landroidx/compose/ui/graphics/colorspace/Connector;", "identity$ui_graphics_release", "ui-graphics_release"})
    public static final class Companion {
        private Companion() {
        }

        private final float[] computeTransform-YBCOT_4(ColorSpace source, ColorSpace destination, int intent) {
            if (!RenderIntent.equals-impl0(intent, RenderIntent.Companion.getAbsolute-uksYyKA())) {
                return null;
            }
            boolean srcRGB = ColorModel.equals-impl0(source.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw());
            boolean dstRGB = ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw());
            if (srcRGB && dstRGB) {
                return null;
            }
            if (srcRGB || dstRGB) {
                Rgb rgb = (Rgb)(srcRGB ? source : destination);
                float[] srcXYZ = srcRGB ? rgb.getWhitePoint().toXyz$ui_graphics_release() : Illuminant.INSTANCE.getD50Xyz$ui_graphics_release();
                float[] dstXYZ = dstRGB ? rgb.getWhitePoint().toXyz$ui_graphics_release() : Illuminant.INSTANCE.getD50Xyz$ui_graphics_release();
                float[] fArray = new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
                return fArray;
            }
            return null;
        }

        @NotNull
        public final Connector identity$ui_graphics_release(@NotNull ColorSpace source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            int n = RenderIntent.Companion.getRelative-uksYyKA();
            return new Connector(source, n){
                final /* synthetic */ ColorSpace $source;
                {
                    this.$source = $source;
                    super($source, $source, $super_call_param$1, null);
                }

                @NotNull
                public float[] transform(@NotNull float[] v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return v;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

