/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import androidx.compose.ui.test.InputDispatcher;
import androidx.compose.ui.test.VelocityPathFinder;
import androidx.compose.ui.unit.Velocity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ(\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u001d\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\bH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J0\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J8\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\bH\u0002J*\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/test/ImpulseVelocityPathFinder;", "Landroidx/compose/ui/test/VelocityPathFinder;", "startPosition", "Landroidx/compose/ui/geometry/Offset;", "endPosition", "endVelocity", "", "durationMillis", "", "(JJFJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "vx", "", "vy", "calculateOffsetForTime", "velocity", "start", "end", "time", "calculateOffsetForTime-tuRUvjQ", "(J)J", "calculateVelocityFullPath", "T", "d", "x", "computePosition", "t", "searchPath", "Landroidx/compose/ui/test/ImpulseVelocityPathFinder$FittingResult;", "targetVelocity", "FittingResult", "ui-test_release"})
@StabilityInferred(parameters=1)
public final class ImpulseVelocityPathFinder
extends VelocityPathFinder {
    private final long startPosition;
    private final long endPosition;
    private final float endVelocity;
    private final long durationMillis;
    private final double vx;
    private final double vy;
    public static final int $stable;

    private ImpulseVelocityPathFinder(long startPosition, long endPosition, float endVelocity, long durationMillis) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.endVelocity = endVelocity;
        this.durationMillis = durationMillis;
        long delta = Offset.minus-MK-Hz9U((long)this.endPosition, (long)this.startPosition);
        double theta = Math.atan2(Offset.getY-impl((long)delta), Offset.getX-impl((long)delta));
        this.vx = Math.cos(theta) * (double)this.endVelocity / (double)1000;
        this.vy = Math.sin(theta) * (double)this.endVelocity / (double)1000;
    }

    @Override
    public long calculateOffsetForTime-tuRUvjQ(long time) {
        float x = this.calculateOffsetForTime(this.vx, Offset.getX-impl((long)this.startPosition), Offset.getX-impl((long)this.endPosition), time);
        float y = this.calculateOffsetForTime(this.vy, Offset.getY-impl((long)this.startPosition), Offset.getY-impl((long)this.endPosition), time);
        return OffsetKt.Offset((float)x, (float)y);
    }

    private final float calculateOffsetForTime(double velocity, float start, float end, long time) {
        FittingResult result;
        long T = this.durationMillis;
        if (start == end) {
            if (!(Math.abs(velocity) < 0.1)) {
                boolean $i$a$-require-ImpulseVelocityPathFinder$calculateOffsetForTime$32 = false;
                String $i$a$-require-ImpulseVelocityPathFinder$calculateOffsetForTime$32 = "Can't have matching positions, but nonzero velocity";
                throw new IllegalArgumentException($i$a$-require-ImpulseVelocityPathFinder$calculateOffsetForTime$32.toString());
            }
            return start;
        }
        if (Math.abs(velocity) < 0.1) {
            long suggestedDuration = 100L;
            if (!(T >= suggestedDuration)) {
                boolean $i$a$-require-ImpulseVelocityPathFinder$calculateOffsetForTime$42 = false;
                String $i$a$-require-ImpulseVelocityPathFinder$calculateOffsetForTime$42 = "Unable to generate a swipe gesture between " + start + " and " + end + " with duration " + this.durationMillis + " that ends with velocity of " + velocity + " px/s, without going outside of the range [start..end]. Suggested fixes: 1. set duration to " + suggestedDuration + " or higher; ";
                throw new IllegalArgumentException($i$a$-require-ImpulseVelocityPathFinder$calculateOffsetForTime$42.toString());
            }
            float positionAtHorizonStart = (float)((double)end - velocity * (double)100L);
            return time == 0L ? start : (time < T - 100L ? start + (positionAtHorizonStart - start) / (float)(T - 100L) * (float)time : end - (float)(T - time) * (float)velocity);
        }
        if (T <= 100L && (result = this.searchPath(start, end, T, (float)velocity * (float)1000)) != null) {
            long d = result.component1();
            float x = result.component2();
            return this.computePosition(start, end, T, d, x, time);
        }
        if (T > 100L) {
            float xHorizon = (float)((double)end - (double)100L * velocity);
            if (Math.min(start, end) < xHorizon && xHorizon < Math.max(start, end)) {
                return time < T - 100L ? start + (xHorizon - start) / (float)(T - 100L) * (float)time : xHorizon + (end - xHorizon) / (float)100L * (float)(time - (T - 100L));
            }
            FittingResult result2 = this.searchPath(start, end, 100L, (float)velocity * (float)1000);
            if (result2 != null) {
                long d = result2.component1();
                float x = result2.component2();
                return time < T - 100L ? start : this.computePosition(start, end, 100L, d, x, time - (T - 100L));
            }
        }
        throw new IllegalArgumentException("Could not find a path for start=" + start + " end=" + end + " velocity=" + velocity + " T=" + T + ".Try setting velocity=" + (end - start) / (float)T + " or T=" + (double)(end - start) / velocity + ".Typically, T should be 100 ms or longer.");
    }

    private final float computePosition(float start, float end, long T, long d, float x, long t) {
        if (!(0L <= t ? t <= T : false)) {
            boolean bl = false;
            String string = "You must provide 0 <= t <= " + T + ", but received t=" + t + " instead";
            throw new IllegalArgumentException(string.toString());
        }
        if (t < d) {
            return start + (x - start) / (float)d * (float)t;
        }
        return end - (end - x) / (float)(T - d) * (float)(T - t);
    }

    private final float calculateVelocityFullPath(float start, float end, long T, long d, float x) {
        VelocityTracker vt = new VelocityTracker();
        vt.addPosition-Uv8p0NA(0L, OffsetKt.Offset((float)start, (float)0.0f));
        for (long t = InputDispatcher.Companion.getEventPeriodMillis(); t < T; t += InputDispatcher.Companion.getEventPeriodMillis()) {
            float position = this.computePosition(start, end, T, d, x, t);
            vt.addPosition-Uv8p0NA(t, OffsetKt.Offset((float)position, (float)0.0f));
        }
        vt.addPosition-Uv8p0NA(T, OffsetKt.Offset((float)end, (float)0.0f));
        return Velocity.getX-impl((long)vt.calculateVelocity-9UxMQ8M());
    }

    private final FittingResult searchPath(float start, float end, long T, float targetVelocity) {
        float TOLERANCE = 1.0f;
        float step = (Math.max(end, start) - Math.min(end, start)) / 1000.0f;
        for (long d = 1L; d < T; ++d) {
            for (float x = Math.min(start, end); x < Math.max(start, end); x += step) {
                float velocity = this.calculateVelocityFullPath(start, end, T, d, x);
                float diff = Math.abs(targetVelocity - velocity);
                if (!(diff < TOLERANCE)) continue;
                return new FittingResult(d, x);
            }
        }
        return null;
    }

    public /* synthetic */ ImpulseVelocityPathFinder(long startPosition, long endPosition, float endVelocity, long durationMillis, DefaultConstructorMarker $constructor_marker) {
        this(startPosition, endPosition, endVelocity, durationMillis);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/test/ImpulseVelocityPathFinder$FittingResult;", "", "d", "", "x", "", "(JF)V", "getD", "()J", "getX", "()F", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ui-test_release"})
    private static final class FittingResult {
        private final long d;
        private final float x;

        public FittingResult(long d, float x) {
            this.d = d;
            this.x = x;
        }

        public final long getD() {
            return this.d;
        }

        public final float getX() {
            return this.x;
        }

        public final long component1() {
            return this.d;
        }

        public final float component2() {
            return this.x;
        }

        @NotNull
        public final FittingResult copy(long d, float x) {
            return new FittingResult(d, x);
        }

        public static /* synthetic */ FittingResult copy$default(FittingResult fittingResult, long l, float f, int n, Object object) {
            if ((n & 1) != 0) {
                l = fittingResult.d;
            }
            if ((n & 2) != 0) {
                f = fittingResult.x;
            }
            return fittingResult.copy(l, f);
        }

        @NotNull
        public String toString() {
            return "FittingResult(d=" + this.d + ", x=" + this.x + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.d);
            result = result * 31 + Float.hashCode(this.x);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FittingResult)) {
                return false;
            }
            FittingResult fittingResult = (FittingResult)other;
            if (this.d != fittingResult.d) {
                return false;
            }
            return Float.compare(this.x, fittingResult.x) == 0;
        }
    }
}

