/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test.junit4;

import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputForTests;
import androidx.compose.ui.text.input.TextInputService;
import androidx.compose.ui.text.input.TextInputSession;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002JI\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\t0\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\t0\u0018H\u0016\u00f8\u0001\u0000J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0012H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Landroidx/compose/ui/test/junit4/TextInputServiceForTests;", "Landroidx/compose/ui/text/input/TextInputService;", "Landroidx/compose/ui/text/input/TextInputForTests;", "platformTextInputService", "Landroidx/compose/ui/text/input/PlatformTextInputService;", "(Landroidx/compose/ui/text/input/PlatformTextInputService;)V", "session", "Landroidx/compose/ui/test/junit4/TextInputServiceForTests$Session;", "inputTextForTest", "", "text", "", "performEditCommand", "commands", "", "Landroidx/compose/ui/text/input/EditCommand;", "requireSession", "startInput", "Landroidx/compose/ui/text/input/TextInputSession;", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "onEditCommand", "Lkotlin/Function1;", "onImeActionPerformed", "Landroidx/compose/ui/text/input/ImeAction;", "stopInput", "Session", "ui-test-junit4_release"})
public final class TextInputServiceForTests
extends TextInputService
implements TextInputForTests {
    @Nullable
    private Session session;

    public TextInputServiceForTests(@NotNull PlatformTextInputService platformTextInputService) {
        Intrinsics.checkNotNullParameter((Object)platformTextInputService, (String)"platformTextInputService");
        super(platformTextInputService);
    }

    @NotNull
    public TextInputSession startInput(@NotNull TextFieldValue value, @NotNull ImeOptions imeOptions, @NotNull Function1<? super List<? extends EditCommand>, Unit> onEditCommand, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
        Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
        this.session = new Session(imeOptions, onEditCommand, onImeActionPerformed);
        return super.startInput(value, imeOptions, onEditCommand, onImeActionPerformed);
    }

    public void stopInput(@NotNull TextInputSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = null;
        super.stopInput(session);
    }

    public void inputTextForTest(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.performEditCommand(CollectionsKt.listOf((Object)new CommitTextCommand(text, 1)));
    }

    private final void performEditCommand(List<? extends EditCommand> commands) {
        this.requireSession().getOnEditCommand().invoke(commands);
    }

    private final Session requireSession() {
        Session session = this.session;
        if (session == null) {
            throw new IllegalStateException("No input session started. Missing a focus?".toString());
        }
        return session;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B>\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR,\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R)\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005X\u0086\u000e\u00f8\u0001\u0000\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Landroidx/compose/ui/test/junit4/TextInputServiceForTests$Session;", "", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "onEditCommand", "Lkotlin/Function1;", "", "Landroidx/compose/ui/text/input/EditCommand;", "", "onImeActionPerformed", "Landroidx/compose/ui/text/input/ImeAction;", "(Landroidx/compose/ui/text/input/ImeOptions;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getImeOptions", "()Landroidx/compose/ui/text/input/ImeOptions;", "setImeOptions", "(Landroidx/compose/ui/text/input/ImeOptions;)V", "getOnEditCommand", "()Lkotlin/jvm/functions/Function1;", "setOnEditCommand", "(Lkotlin/jvm/functions/Function1;)V", "getOnImeActionPerformed", "setOnImeActionPerformed", "ui-test-junit4_release"})
    private static final class Session {
        @NotNull
        private ImeOptions imeOptions;
        @NotNull
        private Function1<? super List<? extends EditCommand>, Unit> onEditCommand;
        @NotNull
        private Function1<? super ImeAction, Unit> onImeActionPerformed;

        public Session(@NotNull ImeOptions imeOptions, @NotNull Function1<? super List<? extends EditCommand>, Unit> onEditCommand, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
            Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
            Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
            Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
            this.imeOptions = imeOptions;
            this.onEditCommand = onEditCommand;
            this.onImeActionPerformed = onImeActionPerformed;
        }

        @NotNull
        public final ImeOptions getImeOptions() {
            return this.imeOptions;
        }

        public final void setImeOptions(@NotNull ImeOptions imeOptions) {
            Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"<set-?>");
            this.imeOptions = imeOptions;
        }

        @NotNull
        public final Function1<List<? extends EditCommand>, Unit> getOnEditCommand() {
            return this.onEditCommand;
        }

        public final void setOnEditCommand(@NotNull Function1<? super List<? extends EditCommand>, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.onEditCommand = function1;
        }

        @NotNull
        public final Function1<ImeAction, Unit> getOnImeActionPerformed() {
            return this.onImeActionPerformed;
        }

        public final void setOnImeActionPerformed(@NotNull Function1<? super ImeAction, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.onImeActionPerformed = function1;
        }
    }
}

