/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.test.ActionsKt;
import androidx.compose.ui.test.Actions_androidKt;
import androidx.compose.ui.test.ErrorMessagesKt;
import androidx.compose.ui.test.ExperimentalTestApi;
import androidx.compose.ui.test.GestureScope;
import androidx.compose.ui.test.MouseInjectionScope;
import androidx.compose.ui.test.MultiModalInjectionScope;
import androidx.compose.ui.test.MultiModalInjectionScopeImpl;
import androidx.compose.ui.test.SemanticsMatcher;
import androidx.compose.ui.test.SemanticsNodeInteraction;
import androidx.compose.ui.test.TestOwner;
import androidx.compose.ui.test.TouchInjectionScope;
import androidx.compose.ui.test.UtilsKt;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u0002*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0082\b\u001a\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0002*\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0002H\u0002\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0016\u001a%\u0010\u0017\u001a\u00020\u0016*\u00020\u00162\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\u0002\b\u001cH\u0007\u001a%\u0010\u001d\u001a\u00020\u0016*\u00020\u00162\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\u0002\b\u001cH\u0007\u001a#\u0010\u001f\u001a\u00020\u0016*\u00020\u00162\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\u0002\b\u001c\u001a\n\u0010!\u001a\u00020\u0016*\u00020\u0016\u001a\u0012\u0010\"\u001a\u00020\u0016*\u00020\u00162\u0006\u0010#\u001a\u00020$\u001a\u0012\u0010%\u001a\u00020\u0016*\u00020\u00162\u0006\u0010&\u001a\u00020'\u001a\u0012\u0010(\u001a\u00020\u0016*\u00020\u00162\u0006\u0010)\u001a\u00020\u0011\u001a$\u0010*\u001a\u00020\u0016*\u00020\u00162\u0018\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060-0,0+\u001aB\u0010*\u001a\u00020\u0016\"\u000e\b\u0000\u0010.*\b\u0012\u0004\u0012\u00020\u00060/*\u00020\u00162\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H.0,0+2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u0002H.\u0012\u0004\u0012\u00020\u001b0\u0019\u001a+\u00101\u001a\u00020\u001b*\u00020\u00162\u0018\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060-0,0+H\u0007\u00a2\u0006\u0002\b*\u001aI\u00101\u001a\u00020\u001b\"\u000e\b\u0000\u0010.*\b\u0012\u0004\u0012\u00020\u00060/*\u00020\u00162\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H.0,0+2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u0002H.\u0012\u0004\u0012\u00020\u001b0\u0019H\u0007\u00a2\u0006\u0002\b*\u001a#\u00102\u001a\u00020\u0016*\u00020\u00162\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\u0002\b\u001c\u001aC\u00104\u001a\u00020\u001b*\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00022\u001a\u00105\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030+06\"\u0006\u0012\u0002\b\u00030+2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080-H\u0002\u00a2\u0006\u0002\u00109\u001a\u001c\u0010:\u001a\u00020\u001b*\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010;\u001a\u00020\u0016H\u0002\u001a\u0014\u0010<\u001a\u00020\u001b*\u00020\u00022\u0006\u0010=\u001a\u00020>H\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u001a\u0010\b\u001a\u00020\u0006*\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\"\u0018\u0010\t\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0018\u0010\u000b\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\n\"\u0018\u0010\f\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\"\u0018\u0010\r\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\n\"\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0004\u00a8\u0006?"}, d2={"horizontalScrollAxis", "Landroidx/compose/ui/semantics/ScrollAxisRange;", "Landroidx/compose/ui/semantics/SemanticsNode;", "getHorizontalScrollAxis", "(Landroidx/compose/ui/semantics/SemanticsNode;)Landroidx/compose/ui/semantics/ScrollAxisRange;", "isAtEnd", "", "(Landroidx/compose/ui/semantics/ScrollAxisRange;)Z", "isAtStart", "isLazyList", "(Landroidx/compose/ui/semantics/SemanticsNode;)Z", "isReversedHorizontally", "isReversedVertically", "isRtl", "verticalScrollAxis", "getVerticalScrollAxis", "findMatchInDescendants", "Landroidx/compose/ui/test/SemanticsMatcher;", "root", "findMatchInHierarchy", "node", "performClick", "Landroidx/compose/ui/test/SemanticsNodeInteraction;", "performGesture", "block", "Lkotlin/Function1;", "Landroidx/compose/ui/test/GestureScope;", "", "Lkotlin/ExtensionFunctionType;", "performMouseInput", "Landroidx/compose/ui/test/MouseInjectionScope;", "performMultiModalInput", "Landroidx/compose/ui/test/MultiModalInjectionScope;", "performScrollTo", "performScrollToIndex", "index", "", "performScrollToKey", "key", "", "performScrollToNode", "matcher", "performSemanticsAction", "Landroidx/compose/ui/semantics/SemanticsPropertyKey;", "Landroidx/compose/ui/semantics/AccessibilityAction;", "Lkotlin/Function0;", "T", "Lkotlin/Function;", "invocation", "performSemanticsActionUnit", "performTouchInput", "Landroidx/compose/ui/test/TouchInjectionScope;", "requireSemantics", "properties", "", "errorMessage", "", "(Landroidx/compose/ui/test/SemanticsNodeInteraction;Landroidx/compose/ui/semantics/SemanticsNode;[Landroidx/compose/ui/semantics/SemanticsPropertyKey;Lkotlin/jvm/functions/Function0;)V", "scrollToIndex", "nodeInteraction", "scrollToNode", "testOwner", "Landroidx/compose/ui/test/TestOwner;", "ui-test_release"})
public final class ActionsKt {
    @NotNull
    public static final SemanticsNodeInteraction performClick(@NotNull SemanticsNodeInteraction $this$performClick) {
        Intrinsics.checkNotNullParameter((Object)$this$performClick, (String)"<this>");
        return Actions_androidKt.performClickImpl($this$performClick);
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollTo(@NotNull SemanticsNodeInteraction $this$performScrollTo) {
        Intrinsics.checkNotNullParameter((Object)$this$performScrollTo, (String)"<this>");
        ActionsKt.scrollToNode($this$performScrollTo.fetchSemanticsNode("Action performScrollTo() failed."), $this$performScrollTo.getTestContext$ui_test_release().getTestOwner$ui_test_release());
        return $this$performScrollTo;
    }

    private static final void scrollToNode(SemanticsNode $this$scrollToNode, TestOwner testOwner) {
        SemanticsNode semanticsNode = UtilsKt.findClosestParentNode$default($this$scrollToNode, false, scrollToNode.scrollableNode.1.INSTANCE, 1, null);
        if (semanticsNode == null) {
            throw new AssertionError((Object)"Semantic Node has no parent layout with a Scroll SemanticsAction");
        }
        SemanticsNode scrollableNode2 = semanticsNode;
        Rect viewportInParent = LayoutCoordinatesKt.boundsInParent((LayoutCoordinates)scrollableNode2.getLayoutInfo().getCoordinates());
        LayoutCoordinates layoutCoordinates = scrollableNode2.getLayoutInfo().getCoordinates().getParentLayoutCoordinates();
        Offset offset = layoutCoordinates == null ? null : Offset.box-impl((long)LayoutCoordinatesKt.positionInRoot((LayoutCoordinates)layoutCoordinates));
        long parentInRoot = offset == null ? Offset.Companion.getZero-F1C5BW0() : offset.unbox-impl();
        Rect viewport = viewportInParent.translate-k-4lQ0M(parentInRoot);
        Rect target = RectKt.Rect-tz77jQw((long)$this$scrollToNode.getPositionInRoot-F1C5BW0(), (long)IntSizeKt.toSize-ozmzZPI((long)$this$scrollToNode.getSize-YbymL2g()));
        Ref.FloatRef dx = new Ref.FloatRef();
        dx.element = ActionsKt.scrollToNode$scrollDelta(target.getLeft() - viewport.getLeft(), target.getRight() - viewport.getRight());
        if (ActionsKt.isReversedHorizontally(scrollableNode2)) {
            dx.element = -dx.element;
        }
        if (ActionsKt.isRtl(scrollableNode2)) {
            dx.element = -dx.element;
        }
        Ref.FloatRef dy = new Ref.FloatRef();
        dy.element = ActionsKt.scrollToNode$scrollDelta(target.getTop() - viewport.getTop(), target.getBottom() - viewport.getBottom());
        if (ActionsKt.isReversedVertically(scrollableNode2)) {
            dy.element = -dy.element;
        }
        testOwner.runOnUiThread((Function0)new Function0<Boolean>(scrollableNode2, dx, dy){
            final /* synthetic */ SemanticsNode $scrollableNode;
            final /* synthetic */ Ref.FloatRef $dx;
            final /* synthetic */ Ref.FloatRef $dy;
            {
                this.$scrollableNode = $scrollableNode;
                this.$dx = $dx;
                this.$dy = $dy;
                super(0);
            }

            @Nullable
            public final Boolean invoke() {
                Function2 function2 = (Function2)((AccessibilityAction)this.$scrollableNode.getConfig().get(SemanticsActions.INSTANCE.getScrollBy())).getAction();
                return function2 == null ? null : (Boolean)function2.invoke((Object)Float.valueOf(this.$dx.element), (Object)Float.valueOf(this.$dy.element));
            }
        });
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollToIndex(@NotNull SemanticsNodeInteraction $this$performScrollToIndex, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$performScrollToIndex, (String)"<this>");
        ActionsKt.scrollToIndex($this$performScrollToIndex.fetchSemanticsNode("Failed: performScrollToIndex(" + index + ')'), index, $this$performScrollToIndex);
        return $this$performScrollToIndex;
    }

    private static final void scrollToIndex(SemanticsNode $this$scrollToIndex, int index, SemanticsNodeInteraction nodeInteraction) {
        SemanticsPropertyKey[] semanticsPropertyKeyArray = new SemanticsPropertyKey[]{SemanticsActions.INSTANCE.getScrollToIndex()};
        ActionsKt.requireSemantics(nodeInteraction, $this$scrollToIndex, semanticsPropertyKeyArray, (Function0<String>)((Function0)new Function0<String>(index){
            final /* synthetic */ int $index;
            {
                this.$index = $index;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"Failed to scroll to index ", (Object)this.$index);
            }
        }));
        nodeInteraction.getTestContext$ui_test_release().getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Boolean>($this$scrollToIndex, index){
            final /* synthetic */ SemanticsNode $this_scrollToIndex;
            final /* synthetic */ int $index;
            {
                this.$this_scrollToIndex = $receiver;
                this.$index = $index;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Function function = ((AccessibilityAction)this.$this_scrollToIndex.getConfig().get(SemanticsActions.INSTANCE.getScrollToIndex())).getAction();
                Intrinsics.checkNotNull((Object)function);
                return (Boolean)((Function1)function).invoke((Object)this.$index);
            }
        });
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollToKey(@NotNull SemanticsNodeInteraction $this$performScrollToKey, @NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)$this$performScrollToKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SemanticsNode node = $this$performScrollToKey.fetchSemanticsNode("Failed: performScrollToKey(\"" + key + "\")");
        SemanticsPropertyKey[] semanticsPropertyKeyArray = new SemanticsPropertyKey[]{SemanticsProperties.INSTANCE.getIndexForKey(), SemanticsActions.INSTANCE.getScrollToIndex()};
        ActionsKt.requireSemantics($this$performScrollToKey, node, semanticsPropertyKeyArray, (Function0<String>)((Function0)new Function0<String>(key){
            final /* synthetic */ Object $key;
            {
                this.$key = $key;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Failed to scroll to the item identified by \"" + this.$key + '\"';
            }
        }));
        int index = ((Number)((Function1)node.getConfig().get(SemanticsProperties.INSTANCE.getIndexForKey())).invoke(key)).intValue();
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "Failed to scroll to the item identified by \"" + key + "\", couldn't find the key.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$performScrollToKey.getTestContext$ui_test_release().getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Boolean>(node, index){
            final /* synthetic */ SemanticsNode $node;
            final /* synthetic */ int $index;
            {
                this.$node = $node;
                this.$index = $index;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Function function = ((AccessibilityAction)this.$node.getConfig().get(SemanticsActions.INSTANCE.getScrollToIndex())).getAction();
                Intrinsics.checkNotNull((Object)function);
                return (Boolean)((Function1)function).invoke((Object)this.$index);
            }
        });
        return $this$performScrollToKey;
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollToNode(@NotNull SemanticsNodeInteraction $this$performScrollToNode, @NotNull SemanticsMatcher matcher) {
        SemanticsNode it;
        Object v0;
        SemanticsMatcher $this$findMatchInDescendants$iv;
        boolean bl;
        SemanticsNode it$iv;
        boolean $i$f$firstOrNull;
        Iterable $this$firstOrNull$iv$iv;
        boolean $i$f$findMatchInDescendants;
        SemanticsNode root$iv;
        Ref.ObjectRef node;
        block12: {
            Intrinsics.checkNotNullParameter((Object)$this$performScrollToNode, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            node = new Ref.ObjectRef();
            node.element = $this$performScrollToNode.fetchSemanticsNode("Failed: performScrollToNode(" + matcher.getDescription() + ')');
            SemanticsMatcher semanticsMatcher = matcher;
            root$iv = (SemanticsNode)node.element;
            $i$f$findMatchInDescendants = false;
            $this$firstOrNull$iv$iv = root$iv.getChildren();
            $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                it$iv = (SemanticsNode)element$iv$iv;
                bl = false;
                if (!(it$iv.getLayoutInfo().isPlaced() && ActionsKt.findMatchInHierarchy($this$findMatchInDescendants$iv, it$iv) != null)) continue;
                v0 = element$iv$iv;
                break block12;
            }
            v0 = null;
        }
        SemanticsNode semanticsNode = v0;
        if (semanticsNode != null) {
            it = semanticsNode;
            boolean bl2 = false;
            ActionsKt.scrollToNode(it, $this$performScrollToNode.getTestContext$ui_test_release().getTestOwner$ui_test_release());
            return $this$performScrollToNode;
        }
        if (!ActionsKt.isLazyList((SemanticsNode)node.element)) {
            String msg = "No node found that matches " + matcher.getDescription() + " in scrollable container";
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(msg, $this$performScrollToNode.getSelector$ui_test_release(), (SemanticsNode)node.element));
        }
        if (!ActionsKt.isAtStart(ActionsKt.getHorizontalScrollAxis((SemanticsNode)node.element)) || !ActionsKt.isAtStart(ActionsKt.getVerticalScrollAxis((SemanticsNode)node.element))) {
            ActionsKt.scrollToIndex((SemanticsNode)node.element, 0, $this$performScrollToNode);
        }
        while (true) {
            float f;
            float dx;
            float f2;
            Object v2;
            block13: {
                node.element = $this$performScrollToNode.fetchSemanticsNode("Failed: performScrollToNode(" + matcher.getDescription() + ')');
                $this$findMatchInDescendants$iv = matcher;
                root$iv = (SemanticsNode)node.element;
                $i$f$findMatchInDescendants = false;
                $this$firstOrNull$iv$iv = root$iv.getChildren();
                $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    it$iv = (SemanticsNode)element$iv$iv;
                    bl = false;
                    if (!(it$iv.getLayoutInfo().isPlaced() && ActionsKt.findMatchInHierarchy($this$findMatchInDescendants$iv, it$iv) != null)) continue;
                    v2 = element$iv$iv;
                    break block13;
                }
                v2 = null;
            }
            SemanticsNode semanticsNode2 = v2;
            if (semanticsNode2 != null) {
                it = semanticsNode2;
                boolean bl3 = false;
                ActionsKt.scrollToNode(it, $this$performScrollToNode.getTestContext$ui_test_release().getTestOwner$ui_test_release());
                return $this$performScrollToNode;
            }
            if (ActionsKt.isAtEnd(ActionsKt.getHorizontalScrollAxis((SemanticsNode)node.element)) && ActionsKt.isAtEnd(ActionsKt.getVerticalScrollAxis((SemanticsNode)node.element))) {
                String msg = "No node found that matches " + matcher.getDescription() + " in scrollable container";
                throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(msg, $this$performScrollToNode.getSelector$ui_test_release(), (SemanticsNode)node.element));
            }
            long viewPortSize = LayoutCoordinatesKt.boundsInParent((LayoutCoordinates)((SemanticsNode)node.element).getLayoutInfo().getCoordinates()).getSize-NH-jbRc();
            if (ActionsKt.getHorizontalScrollAxis((SemanticsNode)node.element) == null) {
                f2 = 0.0f;
            } else {
                float f3;
                boolean bl4 = false;
                f2 = dx = (f3 = Size.getWidth-impl((long)viewPortSize));
            }
            if (ActionsKt.getVerticalScrollAxis((SemanticsNode)node.element) == null) {
                f = 0.0f;
            } else {
                float f4;
                boolean bl5 = false;
                f = f4 = Size.getHeight-impl((long)viewPortSize);
            }
            float dy = f;
            $this$performScrollToNode.getTestContext$ui_test_release().getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Boolean>((Ref.ObjectRef<SemanticsNode>)node, dx, dy){
                final /* synthetic */ Ref.ObjectRef<SemanticsNode> $node;
                final /* synthetic */ float $dx;
                final /* synthetic */ float $dy;
                {
                    this.$node = $node;
                    this.$dx = $dx;
                    this.$dy = $dy;
                    super(0);
                }

                @Nullable
                public final Boolean invoke() {
                    Function2 function2 = (Function2)((AccessibilityAction)((SemanticsNode)this.$node.element).getConfig().get(SemanticsActions.INSTANCE.getScrollBy())).getAction();
                    return function2 == null ? null : (Boolean)function2.invoke((Object)Float.valueOf(this.$dx), (Object)Float.valueOf(this.$dy));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Replaced by performTouchInput", replaceWith=@ReplaceWith(expression="performTouchInput(block)", imports={"import androidx.compose.ui.test.performGesture"}))
    @NotNull
    public static final SemanticsNodeInteraction performGesture(@NotNull SemanticsNodeInteraction $this$performGesture, @NotNull Function1<? super GestureScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$performGesture, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        SemanticsNode node = $this$performGesture.fetchSemanticsNode("Failed to perform a gesture.");
        GestureScope $this$performGesture_u24lambda_u2d5 = new GestureScope(node, $this$performGesture.getTestContext$ui_test_release());
        boolean bl = false;
        try {
            block.invoke((Object)$this$performGesture_u24lambda_u2d5);
        }
        finally {
            $this$performGesture_u24lambda_u2d5.dispose$ui_test_release();
        }
        return $this$performGesture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SemanticsNodeInteraction performTouchInput(@NotNull SemanticsNodeInteraction $this$performTouchInput, @NotNull Function1<? super TouchInjectionScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$performTouchInput, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        SemanticsNode node = $this$performTouchInput.fetchSemanticsNode("Failed to inject touch input.");
        MultiModalInjectionScopeImpl $this$performTouchInput_u24lambda_u2d6 = new MultiModalInjectionScopeImpl(node, $this$performTouchInput.getTestContext$ui_test_release());
        boolean bl = false;
        try {
            $this$performTouchInput_u24lambda_u2d6.touch(block);
        }
        finally {
            $this$performTouchInput_u24lambda_u2d6.dispose$ui_test_release();
        }
        return $this$performTouchInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExperimentalTestApi
    @NotNull
    public static final SemanticsNodeInteraction performMouseInput(@NotNull SemanticsNodeInteraction $this$performMouseInput, @NotNull Function1<? super MouseInjectionScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$performMouseInput, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        SemanticsNode node = $this$performMouseInput.fetchSemanticsNode("Failed to inject mouse input.");
        MultiModalInjectionScopeImpl $this$performMouseInput_u24lambda_u2d7 = new MultiModalInjectionScopeImpl(node, $this$performMouseInput.getTestContext$ui_test_release());
        boolean bl = false;
        try {
            $this$performMouseInput_u24lambda_u2d7.mouse(block);
        }
        finally {
            $this$performMouseInput_u24lambda_u2d7.dispose$ui_test_release();
        }
        return $this$performMouseInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SemanticsNodeInteraction performMultiModalInput(@NotNull SemanticsNodeInteraction $this$performMultiModalInput, @NotNull Function1<? super MultiModalInjectionScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$performMultiModalInput, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        SemanticsNode node = $this$performMultiModalInput.fetchSemanticsNode("Failed to inject multi-modal input.");
        MultiModalInjectionScopeImpl $this$performMultiModalInput_u24lambda_u2d8 = new MultiModalInjectionScopeImpl(node, $this$performMultiModalInput.getTestContext$ui_test_release());
        boolean bl = false;
        try {
            block.invoke((Object)$this$performMultiModalInput_u24lambda_u2d8);
        }
        finally {
            $this$performMultiModalInput_u24lambda_u2d8.dispose$ui_test_release();
        }
        return $this$performMultiModalInput;
    }

    @Deprecated(message="Replaced with same function, but with SemanticsNodeInteraction as return type", level=DeprecationLevel.HIDDEN)
    @JvmName(name="performSemanticsAction")
    public static final /* synthetic */ void performSemanticsAction(SemanticsNodeInteraction $this$performSemanticsActionUnit, SemanticsPropertyKey key, Function1 invocation) {
        Intrinsics.checkNotNullParameter((Object)$this$performSemanticsActionUnit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
        ActionsKt.performSemanticsAction($this$performSemanticsActionUnit, key, invocation);
    }

    @NotNull
    public static final <T extends Function<? extends Boolean>> SemanticsNodeInteraction performSemanticsAction(@NotNull SemanticsNodeInteraction $this$performSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<T>> key, @NotNull Function1<? super T, Unit> invocation) {
        Intrinsics.checkNotNullParameter((Object)$this$performSemanticsAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(invocation, (String)"invocation");
        SemanticsNode node = $this$performSemanticsAction.fetchSemanticsNode("Failed to perform " + key.getName() + " action.");
        SemanticsPropertyKey[] semanticsPropertyKeyArray = new SemanticsPropertyKey[]{key};
        ActionsKt.requireSemantics($this$performSemanticsAction, node, semanticsPropertyKeyArray, (Function0<String>)((Function0)new Function0<String>(key){
            final /* synthetic */ SemanticsPropertyKey<AccessibilityAction<T>> $key;
            {
                this.$key = $key;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"Failed to perform action ", (Object)this.$key.getName());
            }
        }));
        $this$performSemanticsAction.getTestContext$ui_test_release().getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Unit>(node, key, invocation){
            final /* synthetic */ SemanticsNode $node;
            final /* synthetic */ SemanticsPropertyKey<AccessibilityAction<T>> $key;
            final /* synthetic */ Function1<T, Unit> $invocation;
            {
                this.$node = $node;
                this.$key = $key;
                this.$invocation = $invocation;
                super(0);
            }

            @Nullable
            public final Unit invoke() {
                Unit unit;
                Function function = ((AccessibilityAction)this.$node.getConfig().get(this.$key)).getAction();
                if (function == null) {
                    unit = null;
                } else {
                    Function function2 = function;
                    this.$invocation.invoke((Object)function2);
                    unit = Unit.INSTANCE;
                }
                return unit;
            }
        });
        return $this$performSemanticsAction;
    }

    @Deprecated(message="Replaced with same function, but with SemanticsNodeInteraction as return type", level=DeprecationLevel.HIDDEN)
    @JvmName(name="performSemanticsAction")
    public static final /* synthetic */ void performSemanticsAction(SemanticsNodeInteraction $this$performSemanticsActionUnit, SemanticsPropertyKey key) {
        Intrinsics.checkNotNullParameter((Object)$this$performSemanticsActionUnit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ActionsKt.performSemanticsAction($this$performSemanticsActionUnit, (SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>)key);
    }

    @NotNull
    public static final SemanticsNodeInteraction performSemanticsAction(@NotNull SemanticsNodeInteraction $this$performSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key) {
        Intrinsics.checkNotNullParameter((Object)$this$performSemanticsAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return ActionsKt.performSemanticsAction($this$performSemanticsAction, key, performSemanticsAction.3.INSTANCE);
    }

    private static final boolean isLazyList(SemanticsNode $this$isLazyList) {
        return $this$isLazyList.getConfig().contains(SemanticsActions.INSTANCE.getScrollBy()) && $this$isLazyList.getConfig().contains(SemanticsActions.INSTANCE.getScrollToIndex());
    }

    private static final ScrollAxisRange getHorizontalScrollAxis(SemanticsNode $this$horizontalScrollAxis) {
        return (ScrollAxisRange)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)$this$horizontalScrollAxis.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
    }

    private static final ScrollAxisRange getVerticalScrollAxis(SemanticsNode $this$verticalScrollAxis) {
        return (ScrollAxisRange)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)$this$verticalScrollAxis.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
    }

    private static final boolean isReversedHorizontally(SemanticsNode $this$isReversedHorizontally) {
        boolean bl;
        ScrollAxisRange scrollAxisRange = ActionsKt.getHorizontalScrollAxis($this$isReversedHorizontally);
        return scrollAxisRange == null ? false : (bl = scrollAxisRange.getReverseScrolling());
    }

    private static final boolean isReversedVertically(SemanticsNode $this$isReversedVertically) {
        boolean bl;
        ScrollAxisRange scrollAxisRange = ActionsKt.getVerticalScrollAxis($this$isReversedVertically);
        return scrollAxisRange == null ? false : (bl = scrollAxisRange.getReverseScrolling());
    }

    private static final boolean isAtStart(ScrollAxisRange $this$isAtStart) {
        boolean bl;
        ScrollAxisRange scrollAxisRange = $this$isAtStart;
        if (scrollAxisRange == null) {
            bl = true;
        } else {
            boolean bl2;
            ScrollAxisRange it = scrollAxisRange;
            boolean bl3 = false;
            bl = bl2 = ((Number)$this$isAtStart.getValue().invoke()).floatValue() == 0.0f;
        }
        return bl;
    }

    private static final boolean isAtEnd(ScrollAxisRange $this$isAtEnd) {
        boolean bl;
        ScrollAxisRange scrollAxisRange = $this$isAtEnd;
        if (scrollAxisRange == null) {
            bl = true;
        } else {
            boolean bl2;
            ScrollAxisRange it = scrollAxisRange;
            boolean bl3 = false;
            bl = bl2 = ((Number)$this$isAtEnd.getValue().invoke()).floatValue() == ((Number)$this$isAtEnd.getMaxValue().invoke()).floatValue();
        }
        return bl;
    }

    private static final boolean isRtl(SemanticsNode $this$isRtl) {
        return $this$isRtl.getLayoutInfo().getLayoutDirection() == LayoutDirection.Rtl;
    }

    /*
     * WARNING - void declaration
     */
    private static final void requireSemantics(SemanticsNodeInteraction $this$requireSemantics, SemanticsNode node, SemanticsPropertyKey<?>[] properties, Function0<String> errorMessage) {
        void $this$filterTo$iv$iv;
        SemanticsPropertyKey<?>[] $this$filter$iv = properties;
        boolean $i$f$filter = false;
        SemanticsPropertyKey<?>[] semanticsPropertyKeyArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!(!node.getConfig().contains((SemanticsPropertyKey)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingProperties = (List)destination$iv$iv;
        if (!((Collection)missingProperties).isEmpty()) {
            String msg = (String)errorMessage.invoke() + ", the node is missing [" + CollectionsKt.joinToString$default((Iterable)missingProperties, null, null, null, (int)0, null, null, (int)63, null) + ']';
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(msg, $this$requireSemantics.getSelector$ui_test_release(), node));
        }
    }

    private static final SemanticsNode findMatchInDescendants(SemanticsMatcher $this$findMatchInDescendants, SemanticsNode root) {
        Object v0;
        block1: {
            boolean $i$f$findMatchInDescendants = false;
            Iterable $this$firstOrNull$iv = root.getChildren();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SemanticsNode it = (SemanticsNode)element$iv;
                boolean bl = false;
                if (!(it.getLayoutInfo().isPlaced() && ActionsKt.findMatchInHierarchy($this$findMatchInDescendants, it) != null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final SemanticsNode findMatchInHierarchy(SemanticsMatcher $this$findMatchInHierarchy, SemanticsNode node) {
        SemanticsNode semanticsNode;
        if ($this$findMatchInHierarchy.matches(node)) {
            semanticsNode = node;
        } else {
            Object v1;
            block3: {
                SemanticsMatcher $this$findMatchInDescendants$iv = $this$findMatchInHierarchy;
                boolean $i$f$findMatchInDescendants = false;
                Iterable $this$firstOrNull$iv$iv = node.getChildren();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    SemanticsNode it$iv = (SemanticsNode)element$iv$iv;
                    boolean bl = false;
                    if (!(it$iv.getLayoutInfo().isPlaced() && ActionsKt.findMatchInHierarchy($this$findMatchInDescendants$iv, it$iv) != null)) continue;
                    v1 = element$iv$iv;
                    break block3;
                }
                v1 = null;
            }
            semanticsNode = v1;
        }
        return semanticsNode;
    }

    private static final float scrollToNode$scrollDelta(float a, float b) {
        return Math.signum(a) == Math.signum(b) ? (Math.abs(a) < Math.abs(b) ? a : b) : 0.0f;
    }
}

