/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.view.View;
import android.view.ViewParent;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.node.RootForTest;
import androidx.compose.ui.platform.ViewRootForTest;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.test.AndroidImageHelpers_androidKt;
import androidx.compose.ui.test.SemanticsNodeInteraction;
import androidx.compose.ui.test.UtilsKt;
import androidx.compose.ui.test.android.WindowCapture_androidKt;
import androidx.compose.ui.window.DialogWindowProvider;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"findDialogWindowProviderInParent", "Landroidx/compose/ui/window/DialogWindowProvider;", "view", "Landroid/view/View;", "captureToImage", "Landroidx/compose/ui/graphics/ImageBitmap;", "Landroidx/compose/ui/test/SemanticsNodeInteraction;", "getActivityWindow", "Landroid/view/Window;", "Landroid/content/Context;", "ui-test_release"})
public final class AndroidImageHelpers_androidKt {
    @RequiresApi(value=26)
    @NotNull
    public static final ImageBitmap captureToImage(@NotNull SemanticsNodeInteraction $this$captureToImage) {
        Window window;
        Intrinsics.checkNotNullParameter((Object)$this$captureToImage, (String)"<this>");
        SemanticsNode node = $this$captureToImage.fetchSemanticsNode("Failed to capture a node to bitmap.");
        SemanticsNode popupParentMaybe2 = UtilsKt.findClosestParentNode(node, true, (Function1<? super SemanticsNode, Boolean>)((Function1)captureToImage.popupParentMaybe.1.INSTANCE));
        if (popupParentMaybe2 != null) {
            throw new IllegalArgumentException("The node that is being captured to bitmap is in a popup or is a popup itself. Popups currently cannot be captured to bitmap.");
        }
        RootForTest rootForTest = node.getRoot();
        if (rootForTest == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.compose.ui.platform.ViewRootForTest");
        }
        View view = ((ViewRootForTest)rootForTest).getView();
        SemanticsNode dialogParentNodeMaybe2 = UtilsKt.findClosestParentNode(node, true, (Function1<? super SemanticsNode, Boolean>)((Function1)captureToImage.dialogParentNodeMaybe.1.INSTANCE));
        Window dialogWindow = null;
        if (dialogParentNodeMaybe2 != null) {
            Window window2;
            if (Build.VERSION.SDK_INT < 28) {
                throw new IllegalArgumentException("Cannot currently capture dialogs on API lower than 28!");
            }
            DialogWindowProvider dialogWindowProvider = AndroidImageHelpers_androidKt.findDialogWindowProviderInParent(view);
            Object object = window2 = dialogWindowProvider == null ? null : dialogWindowProvider.getWindow();
            if (window2 == null) {
                throw new IllegalArgumentException("Could not find a dialog window provider to capture its bitmap");
            }
            dialogWindow = window2;
        }
        if ((window = dialogWindow) == null) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
            window = AndroidImageHelpers_androidKt.getActivityWindow(context);
        }
        Window windowToUse = window;
        Rect nodeBounds = node.getBoundsInRoot();
        android.graphics.Rect nodeBoundsRect = new android.graphics.Rect(MathKt.roundToInt((float)nodeBounds.getLeft()), MathKt.roundToInt((float)nodeBounds.getTop()), MathKt.roundToInt((float)nodeBounds.getRight()), MathKt.roundToInt((float)nodeBounds.getBottom()));
        int[] nArray = new int[]{0, 0};
        int[] locationInWindow = nArray;
        view.getLocationInWindow(locationInWindow);
        int x = locationInWindow[0];
        int y = locationInWindow[1];
        nodeBoundsRect.offset(x, y);
        return WindowCapture_androidKt.captureRegionToImage(windowToUse, $this$captureToImage.getTestContext$ui_test_release(), nodeBoundsRect);
    }

    private static final DialogWindowProvider findDialogWindowProviderInParent(View view) {
        if (view instanceof DialogWindowProvider) {
            return (DialogWindowProvider)view;
        }
        ViewParent viewParent = view.getParent();
        if (viewParent == null) {
            return null;
        }
        ViewParent parent = viewParent;
        if (parent instanceof View) {
            return AndroidImageHelpers_androidKt.findDialogWindowProviderInParent((View)parent);
        }
        return null;
    }

    private static final Window getActivityWindow(Context $this$getActivityWindow) {
        Window window = AndroidImageHelpers_androidKt.getActivityWindow$getActivity($this$getActivityWindow).getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getActivity().window");
        return window;
    }

    private static final Activity getActivityWindow$getActivity(Context $this$getActivityWindow_u24getActivity) {
        Activity activity;
        Context context = $this$getActivityWindow_u24getActivity;
        if (context instanceof Activity) {
            activity = (Activity)$this$getActivityWindow_u24getActivity;
        } else if (context instanceof ContextWrapper) {
            Context context2 = ((ContextWrapper)$this$getActivityWindow_u24getActivity).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"this.baseContext");
            activity = AndroidImageHelpers_androidKt.getActivityWindow$getActivity(context2);
        } else {
            throw new IllegalStateException("Context is not an Activity context, but a " + $this$getActivityWindow_u24getActivity.getClass().getSimpleName() + " context. An Activity context is required to get a Window instance");
        }
        return activity;
    }
}

