/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.test.ActionsKt;
import androidx.compose.ui.test.AssertionsKt;
import androidx.compose.ui.test.ErrorMessagesKt;
import androidx.compose.ui.test.ExperimentalTestApi;
import androidx.compose.ui.test.FiltersKt;
import androidx.compose.ui.test.SemanticsNodeInteraction;
import androidx.compose.ui.test.TextActionsKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteAllCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.SetSelectionCommand;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a!\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\r\u001a\u00020\u0001*\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0011"}, d2={"performImeAction", "", "Landroidx/compose/ui/test/SemanticsNodeInteraction;", "performTextClearance", "performTextInput", "text", "", "performTextInputSelection", "selection", "Landroidx/compose/ui/text/TextRange;", "performTextInputSelection-FDrldGo", "(Landroidx/compose/ui/test/SemanticsNodeInteraction;J)V", "performTextReplacement", "sendTextInputCommand", "command", "", "Landroidx/compose/ui/text/input/EditCommand;", "ui-test_release"})
public final class TextActionsKt {
    public static final void performTextClearance(@NotNull SemanticsNodeInteraction $this$performTextClearance) {
        Intrinsics.checkNotNullParameter((Object)$this$performTextClearance, (String)"<this>");
        TextActionsKt.sendTextInputCommand($this$performTextClearance, CollectionsKt.listOf((Object)new DeleteAllCommand()));
    }

    public static final void performTextInput(@NotNull SemanticsNodeInteraction $this$performTextInput, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$performTextInput, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TextActionsKt.sendTextInputCommand($this$performTextInput, CollectionsKt.listOf((Object)new CommitTextCommand(text, 1)));
    }

    @ExperimentalTestApi
    public static final void performTextInputSelection-FDrldGo(@NotNull SemanticsNodeInteraction $this$performTextInputSelection, long selection) {
        Intrinsics.checkNotNullParameter((Object)$this$performTextInputSelection, (String)"$this$performTextInputSelection");
        TextActionsKt.sendTextInputCommand($this$performTextInputSelection, CollectionsKt.listOf((Object)new SetSelectionCommand(TextRange.getMin-impl((long)selection), TextRange.getMax-impl((long)selection))));
    }

    public static final void performTextReplacement(@NotNull SemanticsNodeInteraction $this$performTextReplacement, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$performTextReplacement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object[] objectArray = new EditCommand[]{(EditCommand)new DeleteAllCommand(), (EditCommand)new CommitTextCommand(text, 1)};
        TextActionsKt.sendTextInputCommand($this$performTextReplacement, CollectionsKt.listOf((Object[])objectArray));
    }

    public static final void performImeAction(@NotNull SemanticsNodeInteraction $this$performImeAction) {
        Intrinsics.checkNotNullParameter((Object)$this$performImeAction, (String)"<this>");
        String errorOnFail = "Failed to perform IME action.";
        SemanticsNode node = $this$performImeAction.fetchSemanticsNode(errorOnFail);
        AssertionsKt.assert($this$performImeAction, FiltersKt.hasSetTextAction(), (Function0<String>)((Function0)new Function0<String>(errorOnFail){
            final /* synthetic */ String $errorOnFail;
            {
                this.$errorOnFail = $errorOnFail;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$errorOnFail;
            }
        }));
        int actionSpecified2 = ((ImeAction)node.getConfig().getOrElse(SemanticsProperties.INSTANCE.getImeAction(), (Function0)performImeAction.actionSpecified.1.INSTANCE)).unbox-impl();
        if (ImeAction.equals-impl0((int)actionSpecified2, (int)ImeAction.Companion.getDefault-eUduSuo())) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage("Failed to perform IME action as current node does not specify any.", $this$performImeAction.getSelector$ui_test_release(), node));
        }
        if (!FiltersKt.isFocused().matches(node)) {
            ActionsKt.performClick($this$performImeAction);
        }
        $this$performImeAction.getTestContext$ui_test_release().getTestOwner$ui_test_release().sendImeAction-4L7nppU(node, actionSpecified2);
    }

    public static final void sendTextInputCommand(@NotNull SemanticsNodeInteraction $this$sendTextInputCommand, @NotNull List<? extends EditCommand> command) {
        Intrinsics.checkNotNullParameter((Object)$this$sendTextInputCommand, (String)"<this>");
        Intrinsics.checkNotNullParameter(command, (String)"command");
        String errorOnFail = "Failed to perform text input.";
        SemanticsNode node = $this$sendTextInputCommand.fetchSemanticsNode(errorOnFail);
        AssertionsKt.assert($this$sendTextInputCommand, FiltersKt.hasSetTextAction(), (Function0<String>)((Function0)new Function0<String>(errorOnFail){
            final /* synthetic */ String $errorOnFail;
            {
                this.$errorOnFail = $errorOnFail;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$errorOnFail;
            }
        }));
        if (!FiltersKt.isFocused().matches(node)) {
            ActionsKt.performClick($this$sendTextInputCommand);
        }
        $this$sendTextInputCommand.getTestContext$ui_test_release().getTestOwner$ui_test_release().sendTextInputCommand(node, command);
    }
}

