/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test.android;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.PixelCopy;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.graphics.AndroidImageBitmap_androidKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.test.ComposeTimeoutException;
import androidx.compose.ui.test.MainTestClock;
import androidx.compose.ui.test.TestContext;
import androidx.compose.ui.test.android.FrameCommitCallbackHelper;
import androidx.compose.ui.test.android.PixelCopyHelper;
import androidx.compose.ui.test.android.WindowCapture_androidKt;
import androidx.test.platform.graphics.HardwareRendererCompat;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000F\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a!\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0003\u001a\u001c\u0010\u0011\u001a\u00020\r*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0010H\u0003\u001a\"\u0010\u0013\u001a\u00020\r*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0003H\u0002\u00a8\u0006\u0019"}, d2={"withDrawingEnabled", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "captureRegionToImage", "Landroidx/compose/ui/graphics/ImageBitmap;", "Landroid/view/Window;", "testContext", "Landroidx/compose/ui/test/TestContext;", "boundsInWindow", "Landroid/graphics/Rect;", "forceRedraw", "", "Landroid/view/View;", "generateBitmap", "Landroid/graphics/Bitmap;", "generateBitmapFromPixelCopy", "destBitmap", "waitUntil", "Landroidx/compose/ui/test/MainTestClock;", "timeoutMillis", "", "condition", "", "ui-test_release"})
public final class WindowCapture_androidKt {
    @RequiresApi(value=26)
    @NotNull
    public static final ImageBitmap captureRegionToImage(@NotNull Window $this$captureRegionToImage, @NotNull TestContext testContext, @NotNull Rect boundsInWindow) {
        Intrinsics.checkNotNullParameter((Object)$this$captureRegionToImage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Intrinsics.checkNotNullParameter((Object)boundsInWindow, (String)"boundsInWindow");
        return (ImageBitmap)WindowCapture_androidKt.withDrawingEnabled((Function0)new Function0<ImageBitmap>($this$captureRegionToImage, testContext, boundsInWindow){
            final /* synthetic */ Window $this_captureRegionToImage;
            final /* synthetic */ TestContext $testContext;
            final /* synthetic */ Rect $boundsInWindow;
            {
                this.$this_captureRegionToImage = $receiver;
                this.$testContext = $testContext;
                this.$boundsInWindow = $boundsInWindow;
                super(0);
            }

            @NotNull
            public final ImageBitmap invoke() {
                View view = this.$this_captureRegionToImage.getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"decorView");
                WindowCapture_androidKt.forceRedraw(view, this.$testContext);
                return AndroidImageBitmap_androidKt.asImageBitmap((Bitmap)WindowCapture_androidKt.access$generateBitmap(this.$this_captureRegionToImage, this.$boundsInWindow));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <R> R withDrawingEnabled(Function0<? extends R> block) {
        boolean wasDrawingEnabled = HardwareRendererCompat.isDrawingEnabled();
        try {
            if (!wasDrawingEnabled) {
                HardwareRendererCompat.setDrawingEnabled((boolean)true);
            }
            Object object = block.invoke();
            return (R)object;
        }
        finally {
            if (!wasDrawingEnabled) {
                HardwareRendererCompat.setDrawingEnabled((boolean)false);
            }
        }
    }

    public static final void forceRedraw(@NotNull View $this$forceRedraw, @NotNull TestContext testContext) {
        Intrinsics.checkNotNullParameter((Object)$this$forceRedraw, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Ref.BooleanRef drawDone = new Ref.BooleanRef();
        $this$forceRedraw.getHandler().post(() -> WindowCapture_androidKt.forceRedraw$lambda-1($this$forceRedraw, drawDone));
        WindowCapture_androidKt.waitUntil(testContext.getTestOwner$ui_test_release().getMainClock(), 2000L, (Function0<Boolean>)((Function0)new Function0<Boolean>(drawDone){
            final /* synthetic */ Ref.BooleanRef $drawDone;
            {
                this.$drawDone = $drawDone;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$drawDone.element;
            }
        }));
    }

    @RequiresApi(value=26)
    private static final Bitmap generateBitmap(Window $this$generateBitmap, Rect boundsInWindow) {
        Bitmap destBitmap = Bitmap.createBitmap((int)boundsInWindow.width(), (int)boundsInWindow.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)destBitmap, (String)"destBitmap");
        WindowCapture_androidKt.generateBitmapFromPixelCopy($this$generateBitmap, boundsInWindow, destBitmap);
        return destBitmap;
    }

    @RequiresApi(value=26)
    private static final void generateBitmapFromPixelCopy(Window $this$generateBitmapFromPixelCopy, Rect boundsInWindow, Bitmap destBitmap) {
        CountDownLatch latch = new CountDownLatch(1);
        Ref.IntRef copyResult = new Ref.IntRef();
        PixelCopy.OnPixelCopyFinishedListener onCopyFinished = arg_0 -> WindowCapture_androidKt.generateBitmapFromPixelCopy$lambda-2(copyResult, latch, arg_0);
        PixelCopyHelper.INSTANCE.request($this$generateBitmapFromPixelCopy, boundsInWindow, destBitmap, onCopyFinished, new Handler(Looper.getMainLooper()));
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Failed waiting for PixelCopy!");
        }
        if (copyResult.element != 0) {
            throw new AssertionError((Object)"PixelCopy failed!");
        }
    }

    private static final void waitUntil(MainTestClock $this$waitUntil, long timeoutMillis, Function0<Boolean> condition) {
        long startTime = System.nanoTime();
        while (!((Boolean)condition.invoke()).booleanValue()) {
            if ($this$waitUntil.getAutoAdvance()) {
                $this$waitUntil.advanceTimeByFrame();
            }
            Thread.sleep(10L);
            if (System.nanoTime() - startTime <= timeoutMillis * (long)1000000) continue;
            throw new ComposeTimeoutException("Condition still not satisfied after " + timeoutMillis + " ms");
        }
    }

    private static final void forceRedraw$lambda-1$lambda-0(Ref.BooleanRef $drawDone) {
        Intrinsics.checkNotNullParameter((Object)$drawDone, (String)"$drawDone");
        $drawDone.element = true;
    }

    private static final void forceRedraw$lambda-1(View $this_forceRedraw, Ref.BooleanRef $drawDone) {
        Intrinsics.checkNotNullParameter((Object)$this_forceRedraw, (String)"$this_forceRedraw");
        Intrinsics.checkNotNullParameter((Object)$drawDone, (String)"$drawDone");
        if (Build.VERSION.SDK_INT >= 29 && $this_forceRedraw.isHardwareAccelerated()) {
            ViewTreeObserver viewTreeObserver = $this_forceRedraw.getViewTreeObserver();
            Intrinsics.checkNotNullExpressionValue((Object)viewTreeObserver, (String)"viewTreeObserver");
            FrameCommitCallbackHelper.INSTANCE.registerFrameCommitCallback(viewTreeObserver, () -> WindowCapture_androidKt.forceRedraw$lambda-1$lambda-0($drawDone));
        } else {
            $this_forceRedraw.getViewTreeObserver().addOnDrawListener(new ViewTreeObserver.OnDrawListener($this_forceRedraw, $drawDone){
                private boolean handled;
                final /* synthetic */ View $this_forceRedraw;
                final /* synthetic */ Ref.BooleanRef $drawDone;
                {
                    this.$this_forceRedraw = $receiver;
                    this.$drawDone = $drawDone;
                }

                public final boolean getHandled() {
                    return this.handled;
                }

                public final void setHandled(boolean bl) {
                    this.handled = bl;
                }

                public void onDraw() {
                    if (!this.handled) {
                        this.handled = true;
                        this.$this_forceRedraw.getHandler().postAtFrontOfQueue(() -> forceRedraw.1.2.onDraw$lambda-0(this.$drawDone, this.$this_forceRedraw, this));
                    }
                }

                private static final void onDraw$lambda-0(Ref.BooleanRef $drawDone, View $this_forceRedraw, forceRedraw.1.2 this$0) {
                    Intrinsics.checkNotNullParameter((Object)$drawDone, (String)"$drawDone");
                    Intrinsics.checkNotNullParameter((Object)$this_forceRedraw, (String)"$this_forceRedraw");
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    $drawDone.element = true;
                    $this_forceRedraw.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this$0);
                }
            });
        }
        $this_forceRedraw.invalidate();
    }

    private static final void generateBitmapFromPixelCopy$lambda-2(Ref.IntRef $copyResult, CountDownLatch $latch, int result) {
        Intrinsics.checkNotNullParameter((Object)$copyResult, (String)"$copyResult");
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        $copyResult.element = result;
        $latch.countDown();
    }

    public static final /* synthetic */ Bitmap access$generateBitmap(Window $receiver, Rect boundsInWindow) {
        return WindowCapture_androidKt.generateBitmap($receiver, boundsInWindow);
    }
}

