/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.text.Layout;
import android.text.TextUtils;
import androidx.annotation.IntRange;
import androidx.ui.text.platform.InternalPlatformTextApi;
import androidx.ui.text.platform.LayoutCompatKt;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalPlatformTextApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\rJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aJ\u0010\u0010\u001e\u001a\u00020\r2\b\b\u0001\u0010\u0015\u001a\u00020\rJ\u0010\u0010\u001f\u001a\u00020\r2\b\b\u0001\u0010\u0018\u001a\u00020\rJ\u0010\u0010 \u001a\u00020\r2\b\b\u0001\u0010\u0015\u001a\u00020\rJ\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u001a2\b\b\u0001\u0010\u0015\u001a\u00020\rJ\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Landroidx/ui/text/platform/LayoutHelper;", "", "layout", "Landroid/text/Layout;", "(Landroid/text/Layout;)V", "bidiProcessedParagraphs", "", "getLayout", "()Landroid/text/Layout;", "paragraphBidi", "", "Ljava/text/Bidi;", "paragraphCount", "", "getParagraphCount", "()I", "paragraphEnds", "", "tmpBuffer", "", "analyzeBidi", "paragraphIndex", "getDownstreamHorizontal", "", "offset", "primary", "", "getHorizontalPosition", "usePrimaryDirection", "upstream", "getParagraphEnd", "getParagraphForOffset", "getParagraphStart", "isLineEndSpace", "c", "", "isRTLParagraph", "lineEndToVisibleEnd", "lineEnd", "BidiRun", "ui-text-android_release"})
public final class LayoutHelper {
    private final List<Integer> paragraphEnds;
    private final List<Bidi> paragraphBidi;
    private final boolean[] bidiProcessedParagraphs;
    private char[] tmpBuffer;
    private final int paragraphCount;
    @NotNull
    private final Layout layout;

    @Nullable
    public final Bidi analyzeBidi(int paragraphIndex) {
        int flag;
        Bidi bidi;
        if (this.bidiProcessedParagraphs[paragraphIndex]) {
            return this.paragraphBidi.get(paragraphIndex);
        }
        int paragraphStart = paragraphIndex == 0 ? 0 : ((Number)this.paragraphEnds.get(paragraphIndex - 1)).intValue();
        int paragraphEnd = ((Number)this.paragraphEnds.get(paragraphIndex)).intValue();
        int paragraphLength = paragraphEnd - paragraphStart;
        char[] buffer = this.tmpBuffer;
        buffer = buffer == null || buffer.length < paragraphLength ? new char[paragraphLength] : buffer;
        TextUtils.getChars((CharSequence)this.layout.getText(), (int)paragraphStart, (int)paragraphEnd, (char[])buffer, (int)0);
        Bidi result = Bidi.requiresBidi(buffer, 0, paragraphLength) ? ((bidi = new Bidi(buffer, 0, null, 0, paragraphLength, flag = this.isRTLParagraph(paragraphIndex) ? 1 : 0)).getRunCount() == 1 ? null : bidi) : null;
        this.paragraphBidi.set(paragraphIndex, result);
        this.bidiProcessedParagraphs[paragraphIndex] = true;
        this.tmpBuffer = result != null ? (buffer == this.tmpBuffer ? null : this.tmpBuffer) : buffer;
        return result;
    }

    public final int getParagraphCount() {
        return this.paragraphCount;
    }

    public final int getParagraphForOffset(@IntRange(from=0L) int offset) {
        int n = CollectionsKt.binarySearch$default(this.paragraphEnds, (Comparable)Integer.valueOf(offset), (int)0, (int)0, (int)6, null);
        boolean bl = false;
        boolean bl2 = false;
        int it = n;
        boolean bl3 = false;
        return it < 0 ? -(it + 1) : it + 1;
    }

    public final int getParagraphStart(@IntRange(from=0L) int paragraphIndex) {
        return paragraphIndex == 0 ? 0 : ((Number)this.paragraphEnds.get(paragraphIndex - 1)).intValue();
    }

    public final int getParagraphEnd(@IntRange(from=0L) int paragraphIndex) {
        return ((Number)this.paragraphEnds.get(paragraphIndex)).intValue();
    }

    public final boolean isRTLParagraph(@IntRange(from=0L) int paragraphIndex) {
        int lineNumber = this.layout.getLineForOffset(this.getParagraphStart(paragraphIndex));
        return this.layout.getParagraphDirection(lineNumber) == -1;
    }

    public final float getHorizontalPosition(int offset, boolean usePrimaryDirection, boolean upstream) {
        int n;
        boolean isLeftRequested;
        Object run;
        int index;
        Object[] runs;
        boolean isParaRtl;
        int lineNo;
        block16: {
            int index$iv;
            int n2;
            boolean $i$f$indexOfFirst;
            Object[] $this$indexOfFirst$iv;
            int it;
            int it2;
            int n3;
            Object[] objectArray;
            int n4;
            Bidi lineBidi;
            lineNo = LayoutCompatKt.getLineForOffset(this.layout, offset, upstream);
            int lineStart = this.layout.getLineStart(lineNo);
            int lineEnd = this.layout.getLineEnd(lineNo);
            if (offset != lineStart && offset != lineEnd) {
                return this.getDownstreamHorizontal(offset, usePrimaryDirection);
            }
            if (offset == 0 || offset == this.layout.getText().length()) {
                return this.getDownstreamHorizontal(offset, usePrimaryDirection);
            }
            int paraNo = this.getParagraphForOffset(offset);
            isParaRtl = this.isRTLParagraph(paraNo);
            Bidi bidi = this.analyzeBidi(paraNo);
            Bidi bidi2 = lineBidi = bidi != null ? bidi.createLineBidi(lineStart, this.lineEndToVisibleEnd(lineEnd)) : null;
            if (lineBidi == null || lineBidi.getRunCount() == 1) {
                boolean isStartLeft;
                boolean runDirection = this.layout.isRtlCharAt(lineStart);
                boolean bl = usePrimaryDirection || isParaRtl == runDirection ? !isParaRtl : (isStartLeft = isParaRtl);
                boolean isOffsetLeft22 = offset == lineStart ? isStartLeft : !isStartLeft;
                return isOffsetLeft22 ? this.layout.getLineLeft(lineNo) : this.layout.getLineRight(lineNo);
            }
            int isStartLeft = lineBidi.getRunCount();
            Object[] isOffsetLeft22 = new BidiRun[isStartLeft];
            for (int i = 0; i < isStartLeft; ++i) {
                int n5 = i;
                n4 = i;
                objectArray = isOffsetLeft22;
                n3 = 0;
                BidiRun bidiRun = new BidiRun(lineStart + lineBidi.getRunStart(it2), lineStart + lineBidi.getRunLimit(it2), lineBidi.getRunLevel(it2) % 2 == 1);
                objectArray[n4] = bidiRun;
            }
            runs = isOffsetLeft22;
            int isOffsetLeft22 = lineBidi.getRunCount();
            byte[] byArray = new byte[isOffsetLeft22];
            it2 = 0;
            while (it2 < isOffsetLeft22) {
                n3 = it2;
                n4 = it2++;
                objectArray = byArray;
                boolean bl = false;
                byte by = (byte)lineBidi.getRunLevel(it);
                objectArray[n4] = by;
            }
            byte[] levels = byArray;
            Bidi.reorderVisually(levels, 0, runs, 0, runs.length);
            if (offset == lineStart) {
                int n6;
                block15: {
                    $this$indexOfFirst$iv = runs;
                    $i$f$indexOfFirst = false;
                    it = 0;
                    n2 = $this$indexOfFirst$iv.length;
                    while (it < n2) {
                        Object it3 = $this$indexOfFirst$iv[index$iv];
                        boolean bl = false;
                        if (((BidiRun)it3).getStart() == offset) {
                            n6 = index$iv;
                            break block15;
                        }
                        ++index$iv;
                    }
                    n6 = -1;
                }
                index = n6;
                run = runs[index];
                boolean bl = usePrimaryDirection || isParaRtl == ((BidiRun)run).isRtl() ? !isParaRtl : (isLeftRequested = isParaRtl);
                if (index == 0 && isLeftRequested) {
                    return this.layout.getLineLeft(lineNo);
                }
                if (index == ArraysKt.getLastIndex((Object[])runs) && !isLeftRequested) {
                    return this.layout.getLineRight(lineNo);
                }
                if (isLeftRequested) {
                    return this.layout.getPrimaryHorizontal(((BidiRun)runs[index - 1]).getStart());
                }
                return this.layout.getPrimaryHorizontal(((BidiRun)runs[index + 1]).getStart());
            }
            $this$indexOfFirst$iv = runs;
            $i$f$indexOfFirst = false;
            n2 = $this$indexOfFirst$iv.length;
            for (index$iv = 0; index$iv < n2; ++index$iv) {
                Object it4 = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!(((BidiRun)it4).getEnd() == offset)) continue;
                n = index$iv;
                break block16;
            }
            n = -1;
        }
        index = n;
        run = runs[index];
        boolean bl = usePrimaryDirection || isParaRtl == ((BidiRun)run).isRtl() ? isParaRtl : (isLeftRequested = !isParaRtl);
        if (index == 0 && isLeftRequested) {
            return this.layout.getLineLeft(lineNo);
        }
        if (index == ArraysKt.getLastIndex((Object[])runs) && !isLeftRequested) {
            return this.layout.getLineRight(lineNo);
        }
        if (isLeftRequested) {
            return this.layout.getPrimaryHorizontal(((BidiRun)runs[index - 1]).getEnd());
        }
        return this.layout.getPrimaryHorizontal(((BidiRun)runs[index + 1]).getEnd());
    }

    private final float getDownstreamHorizontal(int offset, boolean primary) {
        return primary ? this.layout.getPrimaryHorizontal(offset) : this.layout.getSecondaryHorizontal(offset);
    }

    private final int lineEndToVisibleEnd(int lineEnd) {
        int visibleEnd;
        for (visibleEnd = lineEnd; visibleEnd > 0 && this.isLineEndSpace(this.layout.getText().charAt(visibleEnd - 1)); --visibleEnd) {
        }
        return visibleEnd;
    }

    public final boolean isLineEndSpace(char c) {
        char c2;
        return c == ' ' || c == '\n' || c == '\u1680' || '\u2000' <= (c2 = c) && '\u200a' >= c2 && c != '\u2007' || c == '\u205f' || c == '\u3000';
    }

    @NotNull
    public final Layout getLayout() {
        return this.layout;
    }

    public LayoutHelper(@NotNull Layout layout) {
        ArrayList<Object> arrayList;
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.layout = layout;
        int paragraphEnd = 0;
        int n = 0;
        List lineFeeds = new ArrayList();
        do {
            CharSequence charSequence = this.layout.getText();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"layout.text");
            paragraphEnd = StringsKt.indexOf$default((CharSequence)charSequence, (char)'\n', (int)paragraphEnd, (boolean)false, (int)4, null);
            paragraphEnd = paragraphEnd < 0 ? this.layout.getText().length() : ++paragraphEnd;
            lineFeeds.add(paragraphEnd);
        } while (paragraphEnd < this.layout.getText().length());
        this.paragraphEnds = lineFeeds;
        n = this.paragraphEnds.size();
        LayoutHelper layoutHelper = this;
        boolean bl = false;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
        boolean bl2 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int n4 = n2++;
            boolean bl3 = false;
            int n5 = n4;
            arrayList = arrayList2;
            boolean bl4 = false;
            Object e = null;
            arrayList.add(e);
        }
        layoutHelper.paragraphBidi = arrayList = (ArrayList<Object>)arrayList2;
        this.bidiProcessedParagraphs = new boolean[this.paragraphEnds.size()];
        this.paragraphCount = this.paragraphEnds.size();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Landroidx/ui/text/platform/LayoutHelper$BidiRun;", "", "start", "", "end", "isRtl", "", "(IIZ)V", "getEnd", "()I", "()Z", "getStart", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "ui-text-android_release"})
    private static final class BidiRun {
        private final int start;
        private final int end;
        private final boolean isRtl;

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final boolean isRtl() {
            return this.isRtl;
        }

        public BidiRun(int start, int end, boolean isRtl) {
            this.start = start;
            this.end = end;
            this.isRtl = isRtl;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        public final boolean component3() {
            return this.isRtl;
        }

        @NotNull
        public final BidiRun copy(int start, int end, boolean isRtl) {
            return new BidiRun(start, end, isRtl);
        }

        public static /* synthetic */ BidiRun copy$default(BidiRun bidiRun, int n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = bidiRun.start;
            }
            if ((n3 & 2) != 0) {
                n2 = bidiRun.end;
            }
            if ((n3 & 4) != 0) {
                bl = bidiRun.isRtl;
            }
            return bidiRun.copy(n, n2, bl);
        }

        @NotNull
        public String toString() {
            return "BidiRun(start=" + this.start + ", end=" + this.end + ", isRtl=" + this.isRtl + ")";
        }

        public int hashCode() {
            int n = (Integer.hashCode(this.start) * 31 + Integer.hashCode(this.end)) * 31;
            int n2 = this.isRtl ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BidiRun)) break block3;
                    BidiRun bidiRun = (BidiRun)object;
                    if (this.start != bidiRun.start || this.end != bidiRun.end || this.isRtl != bidiRun.isRtl) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

