/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform.animation;

import android.text.Layout;
import androidx.ui.text.platform.CharSequenceCharacterIterator;
import androidx.ui.text.platform.InternalPlatformTextApi;
import androidx.ui.text.platform.LayoutCompatKt;
import androidx.ui.text.platform.LayoutHelper;
import androidx.ui.text.platform.animation.Segment;
import androidx.ui.text.platform.animation.SegmentBreaker$WhenMappings;
import androidx.ui.text.platform.animation.SegmentType;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalPlatformTextApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Landroidx/ui/text/platform/animation/SegmentBreaker;", "", "()V", "breakInWords", "", "", "layoutHelper", "Landroidx/ui/text/platform/LayoutHelper;", "breakOffsets", "segmentType", "Landroidx/ui/text/platform/animation/SegmentType;", "breakSegmentWithChar", "Landroidx/ui/text/platform/animation/Segment;", "dropSpaces", "", "breakSegmentWithDocument", "breakSegmentWithLine", "breakSegmentWithParagraph", "breakSegmentWithWord", "breakSegments", "breakWithBreakIterator", "text", "", "breaker", "Ljava/text/BreakIterator;", "ui-text-android_release"})
public final class SegmentBreaker {
    public static final SegmentBreaker INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final List<Integer> breakInWords(LayoutHelper layoutHelper) {
        CharSequence text;
        CharSequence charSequence = text = layoutHelper.getLayout().getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"text");
        BreakIterator breakIterator = BreakIterator.getLineInstance(Locale.getDefault());
        Intrinsics.checkNotNullExpressionValue((Object)breakIterator, (String)"BreakIterator.getLineInstance(Locale.getDefault())");
        List<Integer> words = this.breakWithBreakIterator(charSequence, breakIterator);
        SortedSet set = CollectionsKt.toSortedSet((Iterable)words);
        int n = 0;
        int n2 = layoutHelper.getParagraphCount();
        while (n < n2) {
            void paraIndex;
            if (layoutHelper.analyzeBidi((int)paraIndex) == null) {
            } else {
                Bidi bidi;
                int paragraphStart = layoutHelper.getParagraphStart((int)paraIndex);
                int n3 = 0;
                int n4 = bidi.getRunCount();
                while (n3 < n4) {
                    void i;
                    set.add(bidi.getRunStart((int)i) + paragraphStart);
                    ++i;
                }
            }
            ++paraIndex;
        }
        return CollectionsKt.toList((Iterable)set);
    }

    private final List<Integer> breakWithBreakIterator(CharSequence text, BreakIterator breaker) {
        CharSequenceCharacterIterator iter = new CharSequenceCharacterIterator(text, 0, text.length());
        List res = CollectionsKt.mutableListOf((Object[])new Integer[]{0});
        breaker.setText(iter);
        while (breaker.next() != -1) {
            res.add(breaker.current());
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> breakOffsets(@NotNull LayoutHelper layoutHelper, @NotNull SegmentType segmentType) {
        List list;
        Intrinsics.checkNotNullParameter((Object)layoutHelper, (String)"layoutHelper");
        Intrinsics.checkNotNullParameter((Object)((Object)segmentType), (String)"segmentType");
        Layout layout = layoutHelper.getLayout();
        CharSequence text = layout.getText();
        switch (SegmentBreaker$WhenMappings.$EnumSwitchMapping$0[segmentType.ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object[])new Integer[]{0, text.length()});
                break;
            }
            case 2: {
                List list2 = CollectionsKt.mutableListOf((Object[])new Integer[]{0});
                boolean bl = false;
                boolean bl2 = false;
                List it = list2;
                boolean bl3 = false;
                int n = 0;
                int n2 = layoutHelper.getParagraphCount();
                while (n < n2) {
                    void i;
                    it.add(layoutHelper.getParagraphEnd((int)i));
                    ++i;
                }
                list = list2;
                break;
            }
            case 3: {
                List list3 = CollectionsKt.mutableListOf((Object[])new Integer[]{0});
                boolean bl = false;
                boolean bl4 = false;
                List it = list3;
                boolean bl5 = false;
                int n = layout.getLineCount();
                for (int i = 0; i < n; ++i) {
                    it.add(layout.getLineEnd(i));
                }
                list = list3;
                break;
            }
            case 4: {
                list = this.breakInWords(layoutHelper);
                break;
            }
            case 5: {
                CharSequence charSequence = text;
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"text");
                BreakIterator breakIterator = BreakIterator.getCharacterInstance(Locale.getDefault());
                Intrinsics.checkNotNullExpressionValue((Object)breakIterator, (String)"BreakIterator.getCharact\u2026ance(Locale.getDefault())");
                list = this.breakWithBreakIterator(charSequence, breakIterator);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    @NotNull
    public final List<Segment> breakSegments(@NotNull LayoutHelper layoutHelper, @NotNull SegmentType segmentType, boolean dropSpaces) {
        List<Segment> list;
        Intrinsics.checkNotNullParameter((Object)layoutHelper, (String)"layoutHelper");
        Intrinsics.checkNotNullParameter((Object)((Object)segmentType), (String)"segmentType");
        switch (SegmentBreaker$WhenMappings.$EnumSwitchMapping$1[segmentType.ordinal()]) {
            case 1: {
                list = this.breakSegmentWithDocument(layoutHelper);
                break;
            }
            case 2: {
                list = this.breakSegmentWithParagraph(layoutHelper);
                break;
            }
            case 3: {
                list = this.breakSegmentWithLine(layoutHelper, dropSpaces);
                break;
            }
            case 4: {
                list = this.breakSegmentWithWord(layoutHelper, dropSpaces);
                break;
            }
            case 5: {
                list = this.breakSegmentWithChar(layoutHelper, dropSpaces);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private final List<Segment> breakSegmentWithDocument(LayoutHelper layoutHelper) {
        return CollectionsKt.listOf((Object)new Segment(0, layoutHelper.getLayout().getText().length(), 0, 0, layoutHelper.getLayout().getWidth(), layoutHelper.getLayout().getHeight()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Segment> breakSegmentWithParagraph(LayoutHelper layoutHelper) {
        boolean bl = false;
        List result = new ArrayList();
        Layout layout = layoutHelper.getLayout();
        int n = 0;
        int n2 = layoutHelper.getParagraphCount();
        while (n < n2) {
            void i;
            int paraStart = layoutHelper.getParagraphStart((int)i);
            int paraEnd = layoutHelper.getParagraphEnd((int)i);
            int paraFirstLine = LayoutCompatKt.getLineForOffset(layout, paraStart, false);
            int paraLastLine = LayoutCompatKt.getLineForOffset(layout, paraEnd, true);
            result.add(new Segment(paraStart, paraEnd, 0, layout.getLineTop(paraFirstLine), layout.getWidth(), layout.getLineBottom(paraLastLine)));
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Segment> breakSegmentWithLine(LayoutHelper layoutHelper, boolean dropSpaces) {
        boolean bl = false;
        List result = new ArrayList();
        Layout layout = layoutHelper.getLayout();
        int n = 0;
        int n2 = layoutHelper.getLayout().getLineCount();
        while (n < n2) {
            int n3;
            int n4;
            boolean bl2;
            float f;
            void i;
            int n6 = layout.getLineStart((int)i);
            n6 = layout.getLineEnd((int)i);
            if (dropSpaces) {
                f = layout.getLineLeft((int)i);
                bl2 = false;
                n4 = (int)Math.ceil(f);
            } else {
                n4 = false;
            }
            int n7 = layout.getLineTop((int)i);
            if (dropSpaces) {
                f = layout.getLineRight((int)i);
                bl2 = false;
                n3 = (int)Math.ceil(f);
            } else {
                n3 = layout.getWidth();
            }
            result.add(new Segment(n5, n6, n4, n7, n3, layout.getLineBottom((int)i)));
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Segment> breakSegmentWithWord(LayoutHelper layoutHelper, boolean dropSpaces) {
        List list;
        Layout layout = layoutHelper.getLayout();
        float f = layout.getPaint().measureText(" ");
        boolean bl = false;
        int wsWidth = (int)Math.ceil(f);
        Iterable $this$zipWithNext$iv = this.breakOffsets(layoutHelper, SegmentType.Word);
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list = CollectionsKt.emptyList();
        } else {
            boolean bl2 = false;
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                int lineEnd;
                void end;
                void start;
                Object next$iv = iterator$iv.next();
                int n = ((Number)next$iv).intValue();
                int n2 = ((Number)current$iv).intValue();
                List list2 = result$iv;
                boolean bl3 = false;
                int lineNo = LayoutCompatKt.getLineForOffset(layout, (int)start, false);
                boolean paraRTL = layout.getParagraphDirection(lineNo) == -1;
                boolean runRtl = layout.isRtlCharAt((int)start);
                float f2 = layoutHelper.getHorizontalPosition((int)start, runRtl == paraRTL, false);
                boolean bl4 = false;
                int startPos = (int)Math.ceil(f2);
                float f3 = layoutHelper.getHorizontalPosition((int)end, runRtl == paraRTL, true);
                boolean bl5 = false;
                int endPos = (int)Math.ceil(f3);
                bl5 = false;
                int left = Math.min(startPos, endPos);
                boolean bl6 = false;
                int right = Math.max(startPos, endPos);
                if (dropSpaces && end != false && layout.getText().charAt((int)(end - true)) == ' ' && (lineEnd = layout.getLineEnd(lineNo)) != end) {
                    if (runRtl) {
                        left += wsWidth;
                    } else {
                        right -= wsWidth;
                    }
                }
                Segment segment = new Segment((int)start, (int)end, left, layout.getLineTop(lineNo), right, layout.getLineBottom(lineNo));
                list2.add(segment);
                current$iv = next$iv;
            }
            list = result$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Segment> breakSegmentWithChar(LayoutHelper layoutHelper, boolean dropSpaces) {
        boolean bl = false;
        List res = new ArrayList();
        Iterable $this$zipWithNext$iv = this.breakOffsets(layoutHelper, SegmentType.Character);
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            CollectionsKt.emptyList();
        } else {
            boolean bl2 = false;
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void start;
                void end;
                Object next$iv = iterator$iv.next();
                int n = ((Number)next$iv).intValue();
                int n2 = ((Number)current$iv).intValue();
                List list = result$iv;
                boolean bl3 = false;
                Layout layout = layoutHelper.getLayout();
                if (!dropSpaces || end != start + true || !layoutHelper.isLineEndSpace(layout.getText().charAt((int)start))) {
                    int lineNo = LayoutCompatKt.getLineForOffset(layout, (int)start, false);
                    boolean paraRTL = layout.getParagraphDirection(lineNo) == -1;
                    boolean runRtl = layout.isRtlCharAt((int)start);
                    float f = layoutHelper.getHorizontalPosition((int)start, runRtl == paraRTL, false);
                    boolean bl4 = false;
                    int startPos = (int)Math.ceil(f);
                    float f2 = layoutHelper.getHorizontalPosition((int)end, runRtl == paraRTL, true);
                    boolean bl5 = false;
                    int endPos = (int)Math.ceil(f2);
                    bl4 = false;
                    bl4 = false;
                    res.add(new Segment((int)start, (int)end, Math.min(startPos, endPos), layout.getLineTop(lineNo), Math.max(startPos, endPos), layout.getLineBottom(lineNo)));
                }
                Unit unit = Unit.INSTANCE;
                list.add(unit);
                current$iv = next$iv;
            }
        }
        return res;
    }

    private SegmentBreaker() {
    }

    static {
        SegmentBreaker segmentBreaker;
        INSTANCE = segmentBreaker = new SegmentBreaker();
    }
}

