/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform.style;

import android.graphics.Typeface;
import android.os.Build;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import androidx.annotation.IntRange;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.ui.text.platform.InternalPlatformTextApi;
import androidx.ui.text.platform.style.FontWeightStyleSpanKt;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalPlatformTextApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0015\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Landroidx/ui/text/platform/style/FontWeightStyleSpan;", "Landroid/text/style/MetricAffectingSpan;", "weight", "", "style", "(II)V", "getStyle", "()I", "getWeight", "legacyUpdatePaint", "", "textPaint", "Landroid/text/TextPaint;", "legacyUpdatePaint$ui_text_android_release", "updateDrawState", "updateMeasureState", "updatePaint", "updatePaint$ui_text_android_release", "Companion", "ui-text-android_release"})
public final class FontWeightStyleSpan
extends MetricAffectingSpan {
    private final int weight;
    private final int style;
    public static final int STYLE_NONE = -1;
    public static final int STYLE_NORMAL = 0;
    public static final int STYLE_ITALIC = 2;
    public static final Companion Companion = new Companion(null);

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    @RequiresApi(value=28)
    public final void updatePaint$ui_text_android_release(@NotNull TextPaint textPaint) {
        Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
        oldTypeface = textPaint.getTypeface();
        if (this.weight == 0) ** GOTO lbl-1000
        v0 = oldTypeface;
        if (v0 == null || this.weight != v0.getWeight()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = weightChanged = false;
        }
        if (this.style == -1) ** GOTO lbl-1000
        v2 = oldTypeface;
        if (v2 == null || this.style == 2 != v2.isItalic()) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        styleChanged = v3;
        v4 = needsUpdate = weightChanged != false || styleChanged != false;
        if (!needsUpdate) {
            return;
        }
        if (this.weight != 0) {
            v5 = this.weight;
        } else {
            v6 = oldTypeface;
            v5 = v6 != null ? v6.getWeight() : 400;
        }
        newWeight = v5;
        switch (this.style) {
            case 0: {
                v7 = false;
                break;
            }
            case 2: {
                v7 = true;
                break;
            }
            default: {
                v8 = oldTypeface;
                v7 = v8 != null ? v8.isItalic() : false;
            }
        }
        newItalic = v7;
        textPaint.setTypeface(Typeface.create((Typeface)oldTypeface, (int)newWeight, (boolean)newItalic));
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    public final void legacyUpdatePaint$ui_text_android_release(@NotNull TextPaint textPaint) {
        Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
        oldTypeface = textPaint.getTypeface();
        if (this.weight != 0) ** GOTO lbl-1000
        v0 = oldTypeface;
        if (v0 == null || FontWeightStyleSpanKt.access$isBold(this.weight) != v0.isBold()) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = boldChanged = false;
        }
        if (this.style == -1) ** GOTO lbl-1000
        v2 = oldTypeface;
        if (v2 == null || this.style == 2 != v2.isItalic()) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        styleChanged = v3;
        v4 = needsUpdate = boldChanged != false || styleChanged != false;
        if (!needsUpdate) {
            return;
        }
        if (this.weight != 0) {
            v5 = FontWeightStyleSpanKt.access$isBold(this.weight);
        } else {
            v6 = oldTypeface;
            v5 = v6 != null ? v6.isBold() : false;
        }
        newBold = v5;
        switch (this.style) {
            case 0: {
                v7 = false;
                break;
            }
            case 2: {
                v7 = true;
                break;
            }
            default: {
                v8 = oldTypeface;
                v7 = v8 != null ? v8.isItalic() : false;
            }
        }
        newItalic = v7;
        textPaint.setTypeface(Typeface.create((Typeface)oldTypeface, (int)FontWeightStyleSpanKt.getTypefaceStyle(newBold, newItalic)));
    }

    public void updateDrawState(@NotNull TextPaint textPaint) {
        Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
        if (Build.VERSION.SDK_INT >= 28) {
            this.updatePaint$ui_text_android_release(textPaint);
        } else {
            this.legacyUpdatePaint$ui_text_android_release(textPaint);
        }
    }

    public void updateMeasureState(@NotNull TextPaint textPaint) {
        Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
        if (Build.VERSION.SDK_INT >= 28) {
            this.updatePaint$ui_text_android_release(textPaint);
        } else {
            this.legacyUpdatePaint$ui_text_android_release(textPaint);
        }
    }

    public final int getWeight() {
        return this.weight;
    }

    public final int getStyle() {
        return this.style;
    }

    public FontWeightStyleSpan(@IntRange(from=0L, to=1000L) int weight, int style) {
        this.weight = weight;
        this.style = style;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/ui/text/platform/style/FontWeightStyleSpan$Companion;", "", "()V", "STYLE_ITALIC", "", "STYLE_NONE", "STYLE_NORMAL", "FontStyleMode", "ui-text-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @kotlin.annotation.Retention(value=AnnotationRetention.SOURCE)
        @Retention(value=RetentionPolicy.SOURCE)
        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0081\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/ui/text/platform/style/FontWeightStyleSpan$Companion$FontStyleMode;", "", "ui-text-android_release"})
        public static @interface FontStyleMode {
        }
    }
}

