/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.font;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Typeface;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.TempListUtilsKt;
import androidx.compose.ui.text.font.FontVariation;
import androidx.compose.ui.unit.AndroidDensity_androidKt;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\r\u001a\u00020\u000e*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/compose/ui/text/font/TypefaceCompatApi26;", "", "()V", "threadLocalPaint", "Ljava/lang/ThreadLocal;", "Landroid/graphics/Paint;", "setFontVariationSettings", "Landroid/graphics/Typeface;", "typeface", "variationSettings", "Landroidx/compose/ui/text/font/FontVariation$Settings;", "context", "Landroid/content/Context;", "toAndroidString", "", "ui-text_release"})
@RequiresApi(value=26)
final class TypefaceCompatApi26 {
    @NotNull
    public static final TypefaceCompatApi26 INSTANCE = new TypefaceCompatApi26();
    @NotNull
    private static ThreadLocal<Paint> threadLocalPaint = new ThreadLocal();

    private TypefaceCompatApi26() {
    }

    @ExperimentalTextApi
    @Nullable
    public final Typeface setFontVariationSettings(@Nullable Typeface typeface2, @NotNull FontVariation.Settings variationSettings, @NotNull Context context) {
        if (typeface2 == null) {
            return null;
        }
        if (variationSettings.getSettings().isEmpty()) {
            return typeface2;
        }
        Paint localPaint = threadLocalPaint.get();
        if (localPaint == null) {
            localPaint = new Paint();
            threadLocalPaint.set(localPaint);
        }
        localPaint.setTypeface(typeface2);
        localPaint.setFontVariationSettings(this.toAndroidString(variationSettings, context));
        return localPaint.getTypeface();
    }

    @ExperimentalTextApi
    private final String toAndroidString(FontVariation.Settings $this$toAndroidString, Context context) {
        Density density = AndroidDensity_androidKt.Density((Context)context);
        return TempListUtilsKt.fastJoinToString$default($this$toAndroidString.getSettings(), null, null, null, 0, null, (Function1)new Function1<FontVariation.Setting, CharSequence>(density){
            final /* synthetic */ Density $density;
            {
                this.$density = $density;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull FontVariation.Setting setting) {
                return '\'' + setting.getAxisName() + "' " + setting.toVariationValue(this.$density);
            }
        }, 31, null);
    }
}

