/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.font;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Build;
import androidx.compose.ui.text.font.AndroidPreloadedFont;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontVariation;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.TypefaceBuilderCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B4\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0010\u00a2\u0006\u0002\b\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/text/font/AndroidAssetFont;", "Landroidx/compose/ui/text/font/AndroidPreloadedFont;", "assetManager", "Landroid/content/res/AssetManager;", "path", "", "weight", "Landroidx/compose/ui/text/font/FontWeight;", "style", "Landroidx/compose/ui/text/font/FontStyle;", "variationSettings", "Landroidx/compose/ui/text/font/FontVariation$Settings;", "(Landroid/content/res/AssetManager;Ljava/lang/String;Landroidx/compose/ui/text/font/FontWeight;ILandroidx/compose/ui/text/font/FontVariation$Settings;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getAssetManager", "()Landroid/content/res/AssetManager;", "cacheKey", "getCacheKey", "()Ljava/lang/String;", "getPath", "doLoad", "Landroid/graphics/Typeface;", "context", "Landroid/content/Context;", "doLoad$ui_text_release", "equals", "", "other", "", "hashCode", "", "toString", "ui-text_release"})
public final class AndroidAssetFont
extends AndroidPreloadedFont {
    @NotNull
    private final AssetManager assetManager;
    @NotNull
    private final String path;
    @NotNull
    private final String cacheKey;

    private AndroidAssetFont(AssetManager assetManager, String path, FontWeight weight, int style, FontVariation.Settings variationSettings) {
        super(weight, style, variationSettings, null);
        this.assetManager = assetManager;
        this.path = path;
        this.setTypeface$ui_text_release(this.doLoad$ui_text_release(null));
        this.cacheKey = "asset:" + this.path;
    }

    public /* synthetic */ AndroidAssetFont(AssetManager assetManager, String string, FontWeight fontWeight, int n, FontVariation.Settings settings, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 8) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        this(assetManager, string, fontWeight, n, settings, null);
    }

    @NotNull
    public final AssetManager getAssetManager() {
        return this.assetManager;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Typeface doLoad$ui_text_release(@Nullable Context context) {
        return Build.VERSION.SDK_INT >= 26 ? TypefaceBuilderCompat.INSTANCE.createFromAssets(this.assetManager, this.path, context, this.getVariationSettings()) : Typeface.createFromAsset((AssetManager)this.assetManager, (String)this.path);
    }

    @Override
    @NotNull
    public String getCacheKey() {
        return this.cacheKey;
    }

    @NotNull
    public String toString() {
        return "Font(assetManager, path=" + this.path + ", weight=" + this.getWeight() + ", style=" + FontStyle.toString-impl(this.getStyle-_-LCdwA()) + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AndroidAssetFont)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)((AndroidAssetFont)other).path)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getVariationSettings(), (Object)((AndroidAssetFont)other).getVariationSettings());
    }

    public int hashCode() {
        int result2 = this.path.hashCode();
        result2 = 31 * result2 + this.getVariationSettings().hashCode();
        return result2;
    }

    public /* synthetic */ AndroidAssetFont(AssetManager assetManager, String path, FontWeight weight, int style, FontVariation.Settings variationSettings, DefaultConstructorMarker $constructor_marker) {
        this(assetManager, path, weight, style, variationSettings);
    }
}

