/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import android.text.BoringLayout;
import android.text.Layout;
import android.text.TextDirectionHeuristic;
import android.text.TextPaint;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.android.BoringLayoutFactory;
import androidx.compose.ui.text.android.LayoutIntrinsicsKt;
import androidx.compose.ui.text.android.TextLayoutKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/text/android/LayoutIntrinsics;", "", "charSequence", "", "textPaint", "Landroid/text/TextPaint;", "textDirectionHeuristic", "", "(Ljava/lang/CharSequence;Landroid/text/TextPaint;I)V", "_boringMetrics", "Landroid/text/BoringLayout$Metrics;", "_maxIntrinsicWidth", "", "_minIntrinsicWidth", "boringMetrics", "getBoringMetrics", "()Landroid/text/BoringLayout$Metrics;", "boringMetricsIsInit", "", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "()F", "minIntrinsicWidth", "getMinIntrinsicWidth", "ui-text_release"})
@StabilityInferred(parameters=0)
public final class LayoutIntrinsics {
    @NotNull
    private final CharSequence charSequence;
    @NotNull
    private final TextPaint textPaint;
    private final int textDirectionHeuristic;
    private float _maxIntrinsicWidth;
    private float _minIntrinsicWidth;
    @Nullable
    private BoringLayout.Metrics _boringMetrics;
    private boolean boringMetricsIsInit;
    public static final int $stable = 8;

    public LayoutIntrinsics(@NotNull CharSequence charSequence, @NotNull TextPaint textPaint, int textDirectionHeuristic) {
        this.charSequence = charSequence;
        this.textPaint = textPaint;
        this.textDirectionHeuristic = textDirectionHeuristic;
        this._maxIntrinsicWidth = Float.NaN;
        this._minIntrinsicWidth = Float.NaN;
    }

    @Nullable
    public final BoringLayout.Metrics getBoringMetrics() {
        if (!this.boringMetricsIsInit) {
            TextDirectionHeuristic frameworkTextDir = TextLayoutKt.getTextDirectionHeuristic(this.textDirectionHeuristic);
            this._boringMetrics = BoringLayoutFactory.INSTANCE.measure(this.charSequence, this.textPaint, frameworkTextDir);
            this.boringMetricsIsInit = true;
        }
        return this._boringMetrics;
    }

    public final float getMinIntrinsicWidth() {
        return !Float.isNaN(this._minIntrinsicWidth) ? this._minIntrinsicWidth : (this._minIntrinsicWidth = LayoutIntrinsicsKt.minIntrinsicWidth(this.charSequence, this.textPaint));
    }

    public final float getMaxIntrinsicWidth() {
        float f;
        if (!Float.isNaN(this._maxIntrinsicWidth)) {
            f = this._maxIntrinsicWidth;
        } else {
            Float desiredWidth;
            BoringLayout.Metrics metrics = this.getBoringMetrics();
            Float f2 = desiredWidth = metrics != null ? Float.valueOf(metrics.width) : null;
            if (desiredWidth == null) {
                desiredWidth = Float.valueOf((float)Math.ceil(Layout.getDesiredWidth((CharSequence)this.charSequence, (int)0, (int)this.charSequence.length(), (TextPaint)this.textPaint)));
            }
            if (LayoutIntrinsicsKt.access$shouldIncreaseMaxIntrinsic(desiredWidth.floatValue(), this.charSequence, this.textPaint)) {
                desiredWidth = Float.valueOf(desiredWidth.floatValue() + 0.5f);
            }
            f = this._maxIntrinsicWidth = desiredWidth.floatValue();
        }
        return f;
    }
}

