/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Trace;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextPaint;
import android.text.TextUtils;
import androidx.annotation.Px;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.android.BoringLayoutFactory;
import androidx.compose.ui.text.android.HorizontalPositionCache;
import androidx.compose.ui.text.android.LayoutHelper;
import androidx.compose.ui.text.android.LayoutIntrinsics;
import androidx.compose.ui.text.android.StaticLayoutFactory;
import androidx.compose.ui.text.android.TextAlignmentAdapter;
import androidx.compose.ui.text.android.TextAndroidCanvas;
import androidx.compose.ui.text.android.TextLayout_androidKt;
import androidx.compose.ui.text.android.VerticalPaddings;
import androidx.compose.ui.text.android.style.BaselineShiftSpan;
import androidx.compose.ui.text.android.style.IndentationFixSpan_androidKt;
import androidx.compose.ui.text.android.style.LineHeightStyleSpan;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u00c3\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u000e\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0012\u001a\u00020\t\u0012\b\b\u0002\u0010\u0013\u001a\u00020\t\u0012\b\b\u0002\u0010\u0014\u001a\u00020\t\u0012\b\b\u0002\u0010\u0015\u001a\u00020\t\u0012\b\b\u0002\u0010\u0016\u001a\u00020\t\u0012\b\b\u0002\u0010\u0017\u001a\u00020\t\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0019\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ&\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\t2\u0006\u0010S\u001a\u00020\t2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\tJ\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\tJ\u0010\u0010Z\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\tH\u0002J\u000e\u0010\\\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\tJ\u000e\u0010]\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\tJ\u000e\u0010^\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\tJ\u000e\u0010_\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\tJ\u000e\u0010`\u001a\u00020\t2\u0006\u0010a\u001a\u00020\tJ\u000e\u0010b\u001a\u00020\t2\u0006\u0010a\u001a\u00020\tJ\u000e\u0010c\u001a\u00020\t2\u0006\u0010a\u001a\u00020\tJ\u000e\u0010d\u001a\u00020\t2\u0006\u0010Y\u001a\u00020\tJ\u000e\u0010e\u001a\u00020\t2\u0006\u0010f\u001a\u00020\tJ\u000e\u0010g\u001a\u00020\u00052\u0006\u0010a\u001a\u00020\tJ\u000e\u0010h\u001a\u00020\u00052\u0006\u0010a\u001a\u00020\tJ\u000e\u0010i\u001a\u00020\u00052\u0006\u0010a\u001a\u00020\tJ\u000e\u0010j\u001a\u00020\t2\u0006\u0010a\u001a\u00020\tJ\u000e\u0010k\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\tJ\u000e\u0010l\u001a\u00020\t2\u0006\u0010a\u001a\u00020\tJ\u000e\u0010m\u001a\u00020\u00052\u0006\u0010a\u001a\u00020\tJ\u0016\u0010n\u001a\u00020\t2\u0006\u0010[\u001a\u00020\t2\u0006\u0010o\u001a\u00020\u0005J\u000e\u0010p\u001a\u00020\t2\u0006\u0010[\u001a\u00020\tJ\u0018\u0010q\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\t2\b\b\u0002\u0010r\u001a\u00020\u0010J\u0018\u0010s\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\t2\b\b\u0002\u0010r\u001a\u00020\u0010J\u001e\u0010t\u001a\u00020Q2\u0006\u0010u\u001a\u00020\t2\u0006\u0010v\u001a\u00020\t2\u0006\u0010w\u001a\u00020xJ\r\u0010y\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\bzJ\u000e\u0010{\u001a\u00020\u00102\u0006\u0010a\u001a\u00020\tJ\u000e\u0010|\u001a\u00020\u00102\u0006\u0010Y\u001a\u00020\tJ\u000e\u0010}\u001a\u00020Q2\u0006\u0010~\u001a\u00020\u007fR\u001c\u0010\u001e\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%R\u0011\u0010'\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010%R\u000e\u0010*\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010.\u001a\u00020/8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u0010 \u001a\u0004\b1\u00102R\u001b\u00103\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b5\u00106R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010<\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\"R\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010AR\u0011\u0010B\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0011\u0010E\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bF\u0010DR\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010J\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u001c\u0010M\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bN\u0010 \u001a\u0004\bO\u0010\"\u00a8\u0006\u0080\u0001"}, d2={"Landroidx/compose/ui/text/android/TextLayout;", "", "charSequence", "", "width", "", "textPaint", "Landroid/text/TextPaint;", "alignment", "", "ellipsize", "Landroid/text/TextUtils$TruncateAt;", "textDirectionHeuristic", "lineSpacingMultiplier", "lineSpacingExtra", "includePadding", "", "fallbackLineSpacing", "maxLines", "breakStrategy", "lineBreakStyle", "lineBreakWordStyle", "hyphenationFrequency", "justificationMode", "leftIndents", "", "rightIndents", "layoutIntrinsics", "Landroidx/compose/ui/text/android/LayoutIntrinsics;", "(Ljava/lang/CharSequence;FLandroid/text/TextPaint;ILandroid/text/TextUtils$TruncateAt;IFFZZIIIIII[I[ILandroidx/compose/ui/text/android/LayoutIntrinsics;)V", "bottomPadding", "getBottomPadding$ui_text_release$annotations", "()V", "getBottomPadding$ui_text_release", "()I", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "getFallbackLineSpacing", "height", "getHeight", "getIncludePadding", "isBoringLayout", "lastLineExtra", "lastLineFontMetrics", "Landroid/graphics/Paint$FontMetricsInt;", "layout", "Landroid/text/Layout;", "getLayout$annotations", "getLayout", "()Landroid/text/Layout;", "layoutHelper", "Landroidx/compose/ui/text/android/LayoutHelper;", "getLayoutHelper", "()Landroidx/compose/ui/text/android/LayoutHelper;", "layoutHelper$delegate", "Lkotlin/Lazy;", "getLayoutIntrinsics", "()Landroidx/compose/ui/text/android/LayoutIntrinsics;", "leftPadding", "lineCount", "getLineCount", "lineHeightSpans", "", "Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;", "[Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "()F", "minIntrinsicWidth", "getMinIntrinsicWidth", "rect", "Landroid/graphics/Rect;", "rightPadding", "text", "getText", "()Ljava/lang/CharSequence;", "topPadding", "getTopPadding$ui_text_release$annotations", "getTopPadding$ui_text_release", "fillBoundingBoxes", "", "startOffset", "endOffset", "array", "", "arrayStart", "getBoundingBox", "Landroid/graphics/RectF;", "offset", "getHorizontalPadding", "line", "getLineAscent", "getLineBaseline", "getLineBottom", "getLineDescent", "getLineEllipsisCount", "lineIndex", "getLineEllipsisOffset", "getLineEnd", "getLineForOffset", "getLineForVertical", "vertical", "getLineHeight", "getLineLeft", "getLineRight", "getLineStart", "getLineTop", "getLineVisibleEnd", "getLineWidth", "getOffsetForHorizontal", "horizontal", "getParagraphDirection", "getPrimaryHorizontal", "upstream", "getSecondaryHorizontal", "getSelectionPath", "start", "end", "dest", "Landroid/graphics/Path;", "isFallbackLinespacingApplied", "isFallbackLinespacingApplied$ui_text_release", "isLineEllipsized", "isRtlCharAt", "paint", "canvas", "Landroid/graphics/Canvas;", "ui-text_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTextLayout.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextLayout.android.kt\nandroidx/compose/ui/text/android/TextLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1031:1\n1#2:1032\n*E\n"})
public final class TextLayout {
    private final boolean includePadding;
    private final boolean fallbackLineSpacing;
    @NotNull
    private final LayoutIntrinsics layoutIntrinsics;
    private final boolean didExceedMaxLines;
    @NotNull
    private final Layout layout;
    private final int lineCount;
    private final int topPadding;
    private final int bottomPadding;
    private final float leftPadding;
    private final float rightPadding;
    private final boolean isBoringLayout;
    @Nullable
    private final Paint.FontMetricsInt lastLineFontMetrics;
    private final int lastLineExtra;
    @NotNull
    private final LineHeightStyleSpan[] lineHeightSpans;
    @NotNull
    private final Rect rect;
    @NotNull
    private final Lazy layoutHelper$delegate;
    public static final int $stable = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextLayout(@NotNull CharSequence charSequence, float width, @NotNull TextPaint textPaint, int alignment, @Nullable TextUtils.TruncateAt ellipsize, int textDirectionHeuristic, float lineSpacingMultiplier, @Px float lineSpacingExtra, boolean includePadding, boolean fallbackLineSpacing, int maxLines, int breakStrategy, int lineBreakStyle, int lineBreakWordStyle, int hyphenationFrequency, int justificationMode, @Nullable int[] leftIndents, @Nullable int[] rightIndents, @NotNull LayoutIntrinsics layoutIntrinsics) {
        this.includePadding = includePadding;
        this.fallbackLineSpacing = fallbackLineSpacing;
        this.layoutIntrinsics = layoutIntrinsics;
        this.rect = new Rect();
        int end = charSequence.length();
        TextDirectionHeuristic frameworkTextDir = TextLayout_androidKt.getTextDirectionHeuristic(textDirectionHeuristic);
        Layout.Alignment frameworkAlignment = TextAlignmentAdapter.INSTANCE.get(alignment);
        boolean hasBaselineShiftSpans = charSequence instanceof Spanned ? ((Spanned)charSequence).nextSpanTransition(-1, end, BaselineShiftSpan.class) < end : false;
        Trace.beginSection((String)"TextLayout:initLayout");
        try {
            Layout layout;
            BoringLayout.Metrics boringMetrics = this.layoutIntrinsics.getBoringMetrics();
            int widthInt = (int)Math.ceil(width);
            if (boringMetrics != null && this.layoutIntrinsics.getMaxIntrinsicWidth() <= width && !hasBaselineShiftSpans) {
                this.isBoringLayout = true;
                layout = (Layout)BoringLayoutFactory.INSTANCE.create(charSequence, textPaint, widthInt, boringMetrics, frameworkAlignment, this.includePadding, this.fallbackLineSpacing, ellipsize, widthInt);
            } else {
                this.isBoringLayout = false;
                layout = (Layout)StaticLayoutFactory.INSTANCE.create(charSequence, textPaint, widthInt, 0, charSequence.length(), frameworkTextDir, frameworkAlignment, maxLines, ellipsize, (int)Math.ceil(width), lineSpacingMultiplier, lineSpacingExtra, justificationMode, this.includePadding, this.fallbackLineSpacing, breakStrategy, lineBreakStyle, lineBreakWordStyle, hyphenationFrequency, leftIndents, rightIndents);
            }
            this.layout = layout;
        }
        finally {
            Trace.endSection();
        }
        this.lineCount = Math.min(this.layout.getLineCount(), maxLines);
        int lastLine = this.lineCount - 1;
        this.didExceedMaxLines = this.lineCount < maxLines ? false : this.layout.getEllipsisCount(lastLine) > 0 || this.layout.getLineEnd(lastLine) != charSequence.length();
        long verticalPaddings = TextLayout_androidKt.access$getVerticalPaddings(this);
        this.lineHeightSpans = TextLayout_androidKt.access$getLineHeightSpans(this);
        long lineHeightPaddings = TextLayout_androidKt.access$getLineHeightPaddings(this, this.lineHeightSpans);
        this.topPadding = Math.max(VerticalPaddings.getTopPadding-impl(verticalPaddings), VerticalPaddings.getTopPadding-impl(lineHeightPaddings));
        this.bottomPadding = Math.max(VerticalPaddings.getBottomPadding-impl(verticalPaddings), VerticalPaddings.getBottomPadding-impl(lineHeightPaddings));
        Paint.FontMetricsInt fontMetrics = TextLayout_androidKt.access$getLastLineMetrics(this, textPaint, frameworkTextDir, this.lineHeightSpans);
        this.lastLineExtra = fontMetrics != null ? fontMetrics.bottom - (int)this.getLineHeight(lastLine) : 0;
        this.lastLineFontMetrics = fontMetrics;
        this.leftPadding = IndentationFixSpan_androidKt.getEllipsizedLeftPadding$default(this.layout, lastLine, null, 2, null);
        this.rightPadding = IndentationFixSpan_androidKt.getEllipsizedRightPadding$default(this.layout, lastLine, null, 2, null);
        this.layoutHelper$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<LayoutHelper>(this){
            final /* synthetic */ TextLayout this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LayoutHelper invoke() {
                return new LayoutHelper(this.this$0.getLayout());
            }
        }));
    }

    public /* synthetic */ TextLayout(CharSequence charSequence, float f, TextPaint textPaint, int n, TextUtils.TruncateAt truncateAt, int n2, float f2, float f3, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray, int[] nArray2, LayoutIntrinsics layoutIntrinsics, int n9, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n9 & 8) != 0) {
            n = 0;
        }
        if ((n9 & 0x10) != 0) {
            truncateAt = null;
        }
        if ((n9 & 0x20) != 0) {
            n2 = 2;
        }
        if ((n9 & 0x40) != 0) {
            f2 = 1.0f;
        }
        if ((n9 & 0x80) != 0) {
            f3 = 0.0f;
        }
        if ((n9 & 0x100) != 0) {
            bl = false;
        }
        if ((n9 & 0x200) != 0) {
            bl2 = true;
        }
        if ((n9 & 0x400) != 0) {
            n3 = Integer.MAX_VALUE;
        }
        if ((n9 & 0x800) != 0) {
            n4 = 0;
        }
        if ((n9 & 0x1000) != 0) {
            n5 = 0;
        }
        if ((n9 & 0x2000) != 0) {
            n6 = 0;
        }
        if ((n9 & 0x4000) != 0) {
            n7 = 0;
        }
        if ((n9 & 0x8000) != 0) {
            n8 = 0;
        }
        if ((n9 & 0x10000) != 0) {
            nArray = null;
        }
        if ((n9 & 0x20000) != 0) {
            nArray2 = null;
        }
        if ((n9 & 0x40000) != 0) {
            layoutIntrinsics = new LayoutIntrinsics(charSequence, textPaint, n2);
        }
        this(charSequence, f, textPaint, n, truncateAt, n2, f2, f3, bl, bl2, n3, n4, n5, n6, n7, n8, nArray, nArray2, layoutIntrinsics);
    }

    public final boolean getIncludePadding() {
        return this.includePadding;
    }

    public final boolean getFallbackLineSpacing() {
        return this.fallbackLineSpacing;
    }

    @NotNull
    public final LayoutIntrinsics getLayoutIntrinsics() {
        return this.layoutIntrinsics;
    }

    public final float getMaxIntrinsicWidth() {
        return this.layoutIntrinsics.getMaxIntrinsicWidth();
    }

    public final float getMinIntrinsicWidth() {
        return this.layoutIntrinsics.getMinIntrinsicWidth();
    }

    public final boolean getDidExceedMaxLines() {
        return this.didExceedMaxLines;
    }

    @NotNull
    public final Layout getLayout() {
        return this.layout;
    }

    @VisibleForTesting
    public static /* synthetic */ void getLayout$annotations() {
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    public final int getTopPadding$ui_text_release() {
        return this.topPadding;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTopPadding$ui_text_release$annotations() {
    }

    public final int getBottomPadding$ui_text_release() {
        return this.bottomPadding;
    }

    @VisibleForTesting
    public static /* synthetic */ void getBottomPadding$ui_text_release$annotations() {
    }

    private final LayoutHelper getLayoutHelper() {
        Lazy lazy = this.layoutHelper$delegate;
        return (LayoutHelper)lazy.getValue();
    }

    @NotNull
    public final CharSequence getText() {
        return this.layout.getText();
    }

    public final int getHeight() {
        return (this.didExceedMaxLines ? this.layout.getLineBottom(this.lineCount - 1) : this.layout.getHeight()) + this.topPadding + this.bottomPadding + this.lastLineExtra;
    }

    private final float getHorizontalPadding(int line) {
        return line == this.lineCount - 1 ? this.leftPadding + this.rightPadding : 0.0f;
    }

    public final float getLineLeft(int lineIndex) {
        return this.layout.getLineLeft(lineIndex) + (lineIndex == this.lineCount - 1 ? this.leftPadding : 0.0f);
    }

    public final float getLineRight(int lineIndex) {
        return this.layout.getLineRight(lineIndex) + (lineIndex == this.lineCount - 1 ? this.rightPadding : 0.0f);
    }

    public final float getLineTop(int line) {
        float top = this.layout.getLineTop(line);
        return top + (float)(line == 0 ? 0 : this.topPadding);
    }

    public final float getLineBottom(int line) {
        if (line == this.lineCount - 1 && this.lastLineFontMetrics != null) {
            return (float)this.layout.getLineBottom(line - 1) + (float)this.lastLineFontMetrics.bottom;
        }
        return (float)this.topPadding + (float)this.layout.getLineBottom(line) + (float)(line == this.lineCount - 1 ? this.bottomPadding : 0);
    }

    public final float getLineAscent(int line) {
        return line == this.lineCount - 1 && this.lastLineFontMetrics != null ? (float)this.lastLineFontMetrics.ascent : (float)this.layout.getLineAscent(line);
    }

    public final float getLineBaseline(int line) {
        return (float)this.topPadding + (line == this.lineCount - 1 && this.lastLineFontMetrics != null ? this.getLineTop(line) - (float)this.lastLineFontMetrics.ascent : (float)this.layout.getLineBaseline(line));
    }

    public final float getLineDescent(int line) {
        return line == this.lineCount - 1 && this.lastLineFontMetrics != null ? (float)this.lastLineFontMetrics.descent : (float)this.layout.getLineDescent(line);
    }

    public final float getLineHeight(int lineIndex) {
        return this.getLineBottom(lineIndex) - this.getLineTop(lineIndex);
    }

    public final float getLineWidth(int lineIndex) {
        return this.layout.getLineWidth(lineIndex);
    }

    public final int getLineStart(int lineIndex) {
        return this.layout.getLineStart(lineIndex);
    }

    public final int getLineEnd(int lineIndex) {
        return this.layout.getEllipsisStart(lineIndex) == 0 ? this.layout.getLineEnd(lineIndex) : this.layout.getText().length();
    }

    public final int getLineVisibleEnd(int lineIndex) {
        return this.layout.getEllipsisStart(lineIndex) == 0 ? this.getLayoutHelper().getLineVisibleEnd(lineIndex) : this.layout.getLineStart(lineIndex) + this.layout.getEllipsisStart(lineIndex);
    }

    public final boolean isLineEllipsized(int lineIndex) {
        return TextLayout_androidKt.isLineEllipsized(this.layout, lineIndex);
    }

    public final int getLineEllipsisOffset(int lineIndex) {
        return this.layout.getEllipsisStart(lineIndex);
    }

    public final int getLineEllipsisCount(int lineIndex) {
        return this.layout.getEllipsisCount(lineIndex);
    }

    public final int getLineForVertical(int vertical) {
        return this.layout.getLineForVertical(vertical - this.topPadding);
    }

    public final int getOffsetForHorizontal(int line, float horizontal) {
        return this.layout.getOffsetForHorizontal(line, horizontal + (float)-1 * this.getHorizontalPadding(line));
    }

    public final float getPrimaryHorizontal(int offset, boolean upstream) {
        return this.getLayoutHelper().getHorizontalPosition(offset, true, upstream) + this.getHorizontalPadding(this.getLineForOffset(offset));
    }

    public static /* synthetic */ float getPrimaryHorizontal$default(TextLayout textLayout, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return textLayout.getPrimaryHorizontal(n, bl);
    }

    public final float getSecondaryHorizontal(int offset, boolean upstream) {
        return this.getLayoutHelper().getHorizontalPosition(offset, false, upstream) + this.getHorizontalPadding(this.getLineForOffset(offset));
    }

    public static /* synthetic */ float getSecondaryHorizontal$default(TextLayout textLayout, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return textLayout.getSecondaryHorizontal(n, bl);
    }

    public final int getLineForOffset(int offset) {
        return this.layout.getLineForOffset(offset);
    }

    public final boolean isRtlCharAt(int offset) {
        return this.layout.isRtlCharAt(offset);
    }

    public final int getParagraphDirection(int line) {
        return this.layout.getParagraphDirection(line);
    }

    public final void getSelectionPath(int start, int end, @NotNull Path dest) {
        this.layout.getSelectionPath(start, end, dest);
        if (this.topPadding != 0 && !dest.isEmpty()) {
            dest.offset(0.0f, (float)this.topPadding);
        }
    }

    public final void fillBoundingBoxes(int startOffset, int endOffset, @NotNull float[] array, int arrayStart) {
        int textLength = this.getText().length();
        if (!(startOffset >= 0)) {
            boolean $i$a$-require-TextLayout$fillBoundingBoxes$62 = false;
            String $i$a$-require-TextLayout$fillBoundingBoxes$62 = "startOffset must be > 0";
            throw new IllegalArgumentException($i$a$-require-TextLayout$fillBoundingBoxes$62.toString());
        }
        if (!(startOffset < textLength)) {
            boolean $i$a$-require-TextLayout$fillBoundingBoxes$72 = false;
            String $i$a$-require-TextLayout$fillBoundingBoxes$72 = "startOffset must be less than text length";
            throw new IllegalArgumentException($i$a$-require-TextLayout$fillBoundingBoxes$72.toString());
        }
        if (!(endOffset > startOffset)) {
            boolean $i$a$-require-TextLayout$fillBoundingBoxes$82 = false;
            String $i$a$-require-TextLayout$fillBoundingBoxes$82 = "endOffset must be greater than startOffset";
            throw new IllegalArgumentException($i$a$-require-TextLayout$fillBoundingBoxes$82.toString());
        }
        if (!(endOffset <= textLength)) {
            boolean $i$a$-require-TextLayout$fillBoundingBoxes$92 = false;
            String $i$a$-require-TextLayout$fillBoundingBoxes$92 = "endOffset must be smaller or equal to text length";
            throw new IllegalArgumentException($i$a$-require-TextLayout$fillBoundingBoxes$92.toString());
        }
        int range = endOffset - startOffset;
        int minArraySize = range * 4;
        if (!(array.length - arrayStart >= minArraySize)) {
            boolean $i$a$-require-TextLayout$fillBoundingBoxes$102 = false;
            String $i$a$-require-TextLayout$fillBoundingBoxes$102 = "array.size - arrayStart must be greater or equal than (endOffset - startOffset) * 4";
            throw new IllegalArgumentException($i$a$-require-TextLayout$fillBoundingBoxes$102.toString());
        }
        int firstLine = this.getLineForOffset(startOffset);
        int lastLine = this.getLineForOffset(endOffset - 1);
        HorizontalPositionCache cache = new HorizontalPositionCache(this);
        int arrayOffset = arrayStart;
        int line = firstLine;
        if (line <= lastLine) {
            while (true) {
                int lineStartOffset = this.getLineStart(line);
                int lineEndOffset = this.getLineEnd(line);
                int actualStartOffset = Math.max(startOffset, lineStartOffset);
                int actualEndOffset = Math.min(endOffset, lineEndOffset);
                float lineTop = this.getLineTop(line);
                float lineBottom = this.getLineBottom(line);
                boolean isLtrLine = this.getParagraphDirection(line) == 1;
                boolean isRtlLine = !isLtrLine;
                for (int offset = actualStartOffset; offset < actualEndOffset; ++offset) {
                    boolean isRtlChar = this.isRtlCharAt(offset);
                    float left = 0.0f;
                    float right = 0.0f;
                    if (isLtrLine && !isRtlChar) {
                        left = cache.getPrimaryDownstream(offset);
                        right = cache.getPrimaryUpstream(offset + 1);
                    } else if (isLtrLine && isRtlChar) {
                        right = cache.getSecondaryDownstream(offset);
                        left = cache.getSecondaryUpstream(offset + 1);
                    } else if (isRtlLine && isRtlChar) {
                        right = cache.getPrimaryDownstream(offset);
                        left = cache.getPrimaryUpstream(offset + 1);
                    } else {
                        left = cache.getSecondaryDownstream(offset);
                        right = cache.getSecondaryUpstream(offset + 1);
                    }
                    array[arrayOffset] = left;
                    array[arrayOffset + 1] = lineTop;
                    array[arrayOffset + 2] = right;
                    array[arrayOffset + 3] = lineBottom;
                    arrayOffset += 4;
                }
                if (line == lastLine) break;
                ++line;
            }
        }
    }

    @NotNull
    public final RectF getBoundingBox(int offset) {
        int line = this.getLineForOffset(offset);
        float lineTop = this.getLineTop(line);
        float lineBottom = this.getLineBottom(line);
        boolean isLtrLine = this.getParagraphDirection(line) == 1;
        boolean isRtlChar = this.layout.isRtlCharAt(offset);
        float left = 0.0f;
        float right = 0.0f;
        if (isLtrLine && !isRtlChar) {
            left = this.getPrimaryHorizontal(offset, false);
            right = this.getPrimaryHorizontal(offset + 1, true);
        } else if (isLtrLine && isRtlChar) {
            right = this.getSecondaryHorizontal(offset, false);
            left = this.getSecondaryHorizontal(offset + 1, true);
        } else if (isRtlChar) {
            right = this.getPrimaryHorizontal(offset, false);
            left = this.getPrimaryHorizontal(offset + 1, true);
        } else {
            left = this.getSecondaryHorizontal(offset, false);
            right = this.getSecondaryHorizontal(offset + 1, true);
        }
        return new RectF(left, lineTop, right, lineBottom);
    }

    public final void paint(@NotNull Canvas canvas) {
        if (!canvas.getClipBounds(this.rect)) {
            return;
        }
        if (this.topPadding != 0) {
            canvas.translate(0.0f, (float)this.topPadding);
        }
        TextAndroidCanvas $this$paint_u24lambda_u245 = TextLayout_androidKt.access$getSharedTextAndroidCanvas$p();
        boolean bl = false;
        $this$paint_u24lambda_u245.setCanvas(canvas);
        this.layout.draw((Canvas)$this$paint_u24lambda_u245);
        if (this.topPadding != 0) {
            canvas.translate(0.0f, (float)-1 * (float)this.topPadding);
        }
    }

    public final boolean isFallbackLinespacingApplied$ui_text_release() {
        boolean bl;
        if (this.isBoringLayout) {
            Layout layout = this.layout;
            Intrinsics.checkNotNull((Object)layout, (String)"null cannot be cast to non-null type android.text.BoringLayout");
            bl = BoringLayoutFactory.INSTANCE.isFallbackLineSpacingEnabled((BoringLayout)layout);
        } else {
            Layout layout = this.layout;
            Intrinsics.checkNotNull((Object)layout, (String)"null cannot be cast to non-null type android.text.StaticLayout");
            bl = StaticLayoutFactory.INSTANCE.isFallbackLineSpacingEnabled((StaticLayout)layout, this.fallbackLineSpacing);
        }
        return bl;
    }
}

