/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.Cache;
import androidx.compose.ui.text.ExpireAfterAccessCache;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontListFontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.FileFont;
import androidx.compose.ui.text.platform.LoadedFont;
import androidx.compose.ui.text.platform.PlatformFont;
import androidx.compose.ui.text.platform.ResourceFont;
import java.io.File;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.Typeface_jvmKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0018\u001a\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000eH\u0000\u001a\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0002H\u0002\u001a\f\u0010\u001d\u001a\u00020\u0002*\u00020\u001eH\u0000\u001a\f\u0010\u001f\u001a\u00020\u0002*\u00020 H\u0002\"-\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\" \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006!"}, d2={"GenericFontFamiliesMapping", "", "", "", "getGenericFontFamiliesMapping", "()Ljava/util/Map;", "GenericFontFamiliesMapping$delegate", "Lkotlin/Lazy;", "typefacesCache", "Landroidx/compose/ui/text/Cache;", "Lorg/jetbrains/skia/Typeface;", "getTypefacesCache", "()Landroidx/compose/ui/text/Cache;", "Font", "Landroidx/compose/ui/text/font/Font;", "file", "Ljava/io/File;", "weight", "Landroidx/compose/ui/text/font/FontWeight;", "style", "Landroidx/compose/ui/text/font/FontStyle;", "Font-RetOiIg", "(Ljava/io/File;Landroidx/compose/ui/text/font/FontWeight;I)Landroidx/compose/ui/text/font/Font;", "resource", "(Ljava/lang/String;Landroidx/compose/ui/text/font/FontWeight;I)Landroidx/compose/ui/text/font/Font;", "loadFromTypefacesCache", "font", "typefaceResource", "resourceName", "makeAlias", "Landroidx/compose/ui/text/font/FontListFontFamily;", "toHexString", "", "ui-text"})
@SourceDebugExtension(value={"SMAP\nDesktopFont.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopFont.desktop.kt\nandroidx/compose/ui/text/platform/DesktopFont_desktopKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,265:1\n33#2,6:266\n*S KotlinDebug\n*F\n+ 1 DesktopFont.desktop.kt\nandroidx/compose/ui/text/platform/DesktopFont_desktopKt\n*L\n208#1:266,6\n*E\n"})
public final class DesktopFont_desktopKt {
    @NotNull
    private static final Lazy GenericFontFamiliesMapping$delegate = LazyKt.lazy((Function0)GenericFontFamiliesMapping.2.INSTANCE);
    @NotNull
    private static final Cache<String, Typeface> typefacesCache = new ExpireAfterAccessCache(60000000000L, null, 2, null);

    @NotNull
    public static final Map<String, List<String>> getGenericFontFamiliesMapping() {
        Lazy lazy = GenericFontFamiliesMapping$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public static final Font Font-RetOiIg(@NotNull String resource, @NotNull FontWeight weight, int style) {
        return new ResourceFont(resource, weight, style, null);
    }

    public static /* synthetic */ Font Font-RetOiIg$default(String string, FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return DesktopFont_desktopKt.Font-RetOiIg(string, fontWeight, n);
    }

    @NotNull
    public static final Font Font-RetOiIg(@NotNull File file, @NotNull FontWeight weight, int style) {
        return new FileFont(file, weight, style, null);
    }

    public static /* synthetic */ Font Font-RetOiIg$default(File file, FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return DesktopFont_desktopKt.Font-RetOiIg(file, fontWeight, n);
    }

    @NotNull
    public static final String makeAlias(@NotNull FontListFontFamily $this$makeAlias) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        List<Font> $this$fastForEach$iv = $this$makeAlias.getFonts();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Font item$iv;
            Font font = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            if (!(font instanceof PlatformFont)) continue;
            byte[] byArray = ((PlatformFont)font).getIdentity().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            digest.update(byArray);
        }
        return "-compose-" + DesktopFont_desktopKt.toHexString(digest.digest());
    }

    private static final String toHexString(byte[] $this$toHexString) {
        return ArraysKt.joinToString$default((byte[])$this$toHexString, (CharSequence)"", null, null, (int)0, null, (Function1)toHexString.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final Typeface loadFromTypefacesCache(@NotNull Font font) {
        if (!(font instanceof PlatformFont)) {
            throw new IllegalArgumentException("Unsupported font type: " + font);
        }
        return typefacesCache.get(((PlatformFont)font).getCacheKey$ui_text(), (Function1<String, Typeface>)((Function1)new Function1<String, Typeface>(font){
            final /* synthetic */ Font $font;
            {
                this.$font = $font;
                super(1);
            }

            @NotNull
            public final Typeface invoke(@NotNull String it) {
                Typeface typeface2;
                PlatformFont platformFont = (PlatformFont)this.$font;
                if (platformFont instanceof ResourceFont) {
                    typeface2 = DesktopFont_desktopKt.access$typefaceResource(((ResourceFont)this.$font).getName());
                } else if (platformFont instanceof FileFont) {
                    typeface2 = Typeface_jvmKt.makeFromFile$default((Typeface.Companion)Typeface.Companion, (String)((FileFont)this.$font).getFile().toString(), (int)0, (int)2, null);
                } else if (platformFont instanceof LoadedFont) {
                    typeface2 = Typeface.Companion.makeFromData$default((Typeface.Companion)Typeface.Companion, (Data)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])((LoadedFont)this.$font).getData(), (int)0, (int)0, (int)6, null), (int)0, (int)2, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return typeface2;
            }
        }));
    }

    @NotNull
    public static final Cache<String, Typeface> getTypefacesCache() {
        return typefacesCache;
    }

    private static final Typeface typefaceResource(String resourceName) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new IllegalStateException(("Can't load font from " + resourceName).toString());
        }
        InputStream resource = inputStream;
        byte[] bytes = resource.readAllBytes();
        return Typeface.Companion.makeFromData$default((Typeface.Companion)Typeface.Companion, (Data)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])bytes, (int)0, (int)0, (int)6, null), (int)0, (int)2, null);
    }

    public static final /* synthetic */ Typeface access$typefaceResource(String resourceName) {
        return DesktopFont_desktopKt.typefaceResource(resourceName);
    }
}

