/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontListFontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.GenericFontFamily;
import androidx.compose.ui.text.font.LoadedFontFamily;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.FontLoadResult;
import androidx.compose.ui.text.platform.PlatformFont;
import androidx.compose.ui.text.platform.SkiaBackedTypeface;
import androidx.compose.ui.text.platform.SkiaParagraph_skikoKt;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.paragraph.FontCollection;
import org.jetbrains.skia.paragraph.TypefaceFontProvider;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J.\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006$"}, d2={"Landroidx/compose/ui/text/platform/FontCache;", "", "()V", "fontProvider", "Lorg/jetbrains/skia/paragraph/TypefaceFontProvider;", "fonts", "Lorg/jetbrains/skia/paragraph/FontCollection;", "getFonts$ui_text", "()Lorg/jetbrains/skia/paragraph/FontCollection;", "registered", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "ensureRegistered", "", "fontFamily", "Landroidx/compose/ui/text/font/FontFamily;", "", "typeface", "Lorg/jetbrains/skia/Typeface;", "key", "load", "Landroidx/compose/ui/text/platform/FontLoadResult;", "font", "Landroidx/compose/ui/text/platform/PlatformFont;", "load$ui_text", "loadPlatformTypes", "fontWeight", "Landroidx/compose/ui/text/font/FontWeight;", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "loadPlatformTypes-RetOiIg$ui_text", "(Landroidx/compose/ui/text/font/FontFamily;Landroidx/compose/ui/text/font/FontWeight;I)Landroidx/compose/ui/text/platform/FontLoadResult;", "mapGenericFontFamily", "generic", "Landroidx/compose/ui/text/font/GenericFontFamily;", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPlatformFont.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformFont.skiko.kt\nandroidx/compose/ui/text/platform/FontCache\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,219:1\n37#2,2:220\n*S KotlinDebug\n*F\n+ 1 PlatformFont.skiko.kt\nandroidx/compose/ui/text/platform/FontCache\n*L\n184#1:220,2\n*E\n"})
public final class FontCache {
    @NotNull
    private final FontCollection fonts = new FontCollection();
    @NotNull
    private final TypefaceFontProvider fontProvider = new TypefaceFontProvider();
    @NotNull
    private final HashSet<String> registered;
    public static final int $stable = 8;

    public FontCache() {
        this.fonts.setDefaultFontManager(FontMgr.Companion.getDefault());
        this.fonts.setAssetFontManager((FontMgr)this.fontProvider);
        this.registered = new HashSet();
    }

    @NotNull
    public final FontCollection getFonts$ui_text() {
        return this.fonts;
    }

    private final List<String> mapGenericFontFamily(GenericFontFamily generic) {
        List<String> list = DesktopFont_desktopKt.getGenericFontFamiliesMapping().get(generic.getName());
        if (list == null) {
            throw new IllegalStateException(("Unknown generic font family " + generic.getName()).toString());
        }
        return list;
    }

    @NotNull
    public final FontLoadResult load$ui_text(@NotNull PlatformFont font) {
        Typeface typeface2 = DesktopFont_desktopKt.loadFromTypefacesCache(font);
        this.ensureRegistered(typeface2, font.getCacheKey$ui_text());
        return new FontLoadResult(typeface2, CollectionsKt.listOf((Object)font.getCacheKey$ui_text()));
    }

    @NotNull
    public final FontLoadResult loadPlatformTypes-RetOiIg$ui_text(@NotNull FontFamily fontFamily, @NotNull FontWeight fontWeight, int fontStyle) {
        List<String> aliases = this.ensureRegistered(fontFamily);
        org.jetbrains.skia.FontStyle style = SkiaParagraph_skikoKt.toSkFontStyle-nzbMABs(fontStyle).withWeight(fontWeight.getWeight());
        Collection $this$toTypedArray$iv = aliases;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new FontLoadResult((Typeface)ArraysKt.first((Object[])this.fonts.findTypefaces(thisCollection$iv.toArray(new String[0]), style)), aliases);
    }

    public static /* synthetic */ FontLoadResult loadPlatformTypes-RetOiIg$ui_text$default(FontCache fontCache, FontFamily fontFamily, FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return fontCache.loadPlatformTypes-RetOiIg$ui_text(fontFamily, fontWeight, n);
    }

    private final void ensureRegistered(Typeface typeface2, String key) {
        if (!this.registered.contains(key)) {
            this.fontProvider.registerTypeface(typeface2, key);
            this.registered.add(key);
        }
    }

    private final List<String> ensureRegistered(FontFamily fontFamily) {
        List list;
        FontFamily fontFamily2 = fontFamily;
        if (fontFamily2 instanceof FontListFontFamily) {
            throw new IllegalArgumentException("Don't load FontListFontFamily through ensureRegistered: " + fontFamily);
        }
        if (fontFamily2 instanceof LoadedFontFamily) {
            String alias;
            androidx.compose.ui.text.font.Typeface typeface2 = ((LoadedFontFamily)fontFamily).getTypeface();
            Intrinsics.checkNotNull((Object)typeface2, (String)"null cannot be cast to non-null type androidx.compose.ui.text.platform.SkiaBackedTypeface");
            SkiaBackedTypeface typeface3 = (SkiaBackedTypeface)typeface2;
            String string = typeface3.getAlias();
            if (string == null) {
                string = typeface3.getNativeTypeface().getFamilyName();
            }
            if (!this.registered.contains(alias = string)) {
                this.fontProvider.registerTypeface(typeface3.getNativeTypeface(), alias);
                this.registered.add(alias);
            }
            list = CollectionsKt.listOf((Object)alias);
        } else if (fontFamily2 instanceof GenericFontFamily) {
            list = this.mapGenericFontFamily((GenericFontFamily)fontFamily);
        } else if (Intrinsics.areEqual((Object)fontFamily2, (Object)FontFamily.Companion.getDefault())) {
            list = this.mapGenericFontFamily(FontFamily.Companion.getSansSerif());
        } else {
            throw new IllegalArgumentException("Unknown font family type: " + fontFamily);
        }
        return list;
    }
}

