/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.AndroidPathKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.MultiParagraphIntrinsics;
import androidx.compose.ui.text.MultiParagraphKt;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.ParagraphConstraints;
import androidx.compose.ui.text.ParagraphInfo;
import androidx.compose.ui.text.ParagraphIntrinsicInfo;
import androidx.compose.ui.text.ParagraphKt;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.unit.Density;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BY\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014B)\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0017J\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u000bJ\u000e\u0010;\u001a\u0002042\u0006\u0010:\u001a\u00020\u000bJ\u000e\u0010<\u001a\u0002042\u0006\u0010:\u001a\u00020\u000bJ\u0016\u0010=\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\rJ\u000e\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u000bJ\u000e\u0010A\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020\u000bJ\u000e\u0010B\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\u000bJ\u000e\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020\u001eJ\u000e\u0010E\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u000bJ\u000e\u0010F\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u000bJ\u000e\u0010G\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u000bJ\u000e\u0010H\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020\u000bJ\u000e\u0010I\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u000bJ\u000e\u0010J\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020\u000bJ\u000e\u0010K\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u000bJ\u000e\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u0002092\u0006\u0010:\u001a\u00020\u000bJ\u0016\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\u000b2\u0006\u0010S\u001a\u00020\u000bJ\u000e\u0010T\u001a\u00020U2\u0006\u0010:\u001a\u00020\u000bJ\u000e\u0010V\u001a\u00020\r2\u0006\u0010@\u001a\u00020\u000bJ\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZJ\u0010\u0010[\u001a\u00020X2\u0006\u0010:\u001a\u00020\u000bH\u0002J\u0010\u0010\\\u001a\u00020X2\u0006\u0010:\u001a\u00020\u000bH\u0002J\u0010\u0010]\u001a\u00020X2\u0006\u0010@\u001a\u00020\u000bH\u0002R\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010 R\u0011\u0010'\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010 R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010)R\u0011\u0010-\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010 R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0019\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00102R\u0011\u00106\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010 \u00a8\u0006^"}, d2={"Landroidx/compose/ui/text/MultiParagraph;", "", "annotatedString", "Landroidx/compose/ui/text/AnnotatedString;", "style", "Landroidx/compose/ui/text/TextStyle;", "placeholders", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/Placeholder;", "maxLines", "", "ellipsis", "", "constraints", "Landroidx/compose/ui/text/ParagraphConstraints;", "density", "Landroidx/compose/ui/unit/Density;", "resourceLoader", "Landroidx/compose/ui/text/font/Font$ResourceLoader;", "(Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;IZLandroidx/compose/ui/text/ParagraphConstraints;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/Font$ResourceLoader;)V", "intrinsics", "Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "(Landroidx/compose/ui/text/MultiParagraphIntrinsics;IZLandroidx/compose/ui/text/ParagraphConstraints;)V", "getAnnotatedString", "()Landroidx/compose/ui/text/AnnotatedString;", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "firstBaseline", "", "getFirstBaseline", "()F", "height", "getHeight", "getIntrinsics", "()Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "lastBaseline", "getLastBaseline", "lineCount", "getLineCount", "()I", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "minIntrinsicWidth", "getMinIntrinsicWidth", "paragraphInfoList", "Landroidx/compose/ui/text/ParagraphInfo;", "getParagraphInfoList$ui_text_release", "()Ljava/util/List;", "placeholderRects", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "width", "getWidth", "getBidiRunDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "offset", "getBoundingBox", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineBottom", "lineIndex", "getLineEnd", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineHeight", "getLineLeft", "getLineRight", "getLineStart", "getLineTop", "getLineVisibleEnd", "getLineWidth", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getParagraphDirection", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "end", "getWordBoundary", "Landroidx/compose/ui/text/TextRange;", "isLineEllipsized", "paint", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "requireIndexInRange", "requireIndexInRangeInclusiveEnd", "requireLineIndexInRange", "ui-text_release"})
public final class MultiParagraph {
    private final MultiParagraphIntrinsics intrinsics;
    private final int maxLines;
    private final boolean didExceedMaxLines;
    private final float width;
    private final float height;
    private final int lineCount;
    private final List<Rect> placeholderRects;
    private final List<ParagraphInfo> paragraphInfoList;

    /*
     * WARNING - void declaration
     */
    public MultiParagraph(@NotNull MultiParagraphIntrinsics intrinsics, int maxLines, boolean ellipsis, @NotNull ParagraphConstraints constraints) {
        List list;
        void it;
        boolean bl;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)intrinsics, (String)"intrinsics");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        this.intrinsics = intrinsics;
        this.maxLines = maxLines;
        float currentHeight = 0.0f;
        int currentLineCount = 0;
        boolean didExceedMaxLines = false;
        boolean bl2 = false;
        List paragraphInfoList = new ArrayList();
        List<ParagraphIntrinsicInfo> infoList = this.intrinsics.getInfoList$ui_text_release();
        int n = 0;
        int n2 = infoList.size() + -1;
        if (n <= n2) {
            do {
                int endLineIndex;
                float paragraphBottom;
                int index = n++;
                ParagraphIntrinsicInfo paragraphInfo = infoList.get(index);
                Paragraph paragraph = ParagraphKt.Paragraph(paragraphInfo.getIntrinsics(), this.maxLines - currentLineCount, ellipsis, constraints);
                float paragraphTop = currentHeight;
                currentHeight = paragraphBottom = currentHeight + paragraph.getHeight();
                int startLineIndex = currentLineCount;
                currentLineCount = endLineIndex = startLineIndex + paragraph.getLineCount();
                paragraphInfoList.add(new ParagraphInfo(paragraph, paragraphInfo.getStartIndex(), paragraphInfo.getEndIndex(), startLineIndex, endLineIndex, paragraphTop, paragraphBottom));
                if (!paragraph.getDidExceedMaxLines() && (endLineIndex != this.maxLines || index == CollectionsKt.getLastIndex(this.intrinsics.getInfoList$ui_text_release()))) continue;
                didExceedMaxLines = true;
                break;
            } while (n <= n2);
        }
        this.height = currentHeight;
        this.lineCount = currentLineCount;
        this.didExceedMaxLines = didExceedMaxLines;
        this.paragraphInfoList = paragraphInfoList;
        this.width = constraints.getWidth();
        Iterable iterable = paragraphInfoList;
        MultiParagraph multiParagraph = this;
        boolean $i$f$flatMap = false;
        void index = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            ParagraphInfo paragraphInfo = (ParagraphInfo)element$iv$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            bl = false;
            ParagraphInfo $this$lambda_u2d3_u24lambda_u2d2 = paragraphInfo;
            boolean bl5 = false;
            Iterable $this$map$iv = $this$lambda_u2d3_u24lambda_u2d2.getParagraph().getPlaceholderRects();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Rect rect = (Rect)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl6 = false;
                void var33_48 = it2;
                Rect rect2 = var33_48 == null ? (Rect)null : $this$lambda_u2d3_u24lambda_u2d2.toGlobal((Rect)var33_48);
                collection.add(rect2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        iterable = list2;
        n2 = 0;
        boolean bl7 = false;
        destination$iv$iv = iterable;
        boolean bl8 = false;
        if (it.size() < this.getIntrinsics().getPlaceholders().size()) {
            ArrayList arrayList;
            int n3 = this.getIntrinsics().getPlaceholders().size() - it.size();
            Collection collection = (Collection)it;
            boolean bl9 = false;
            boolean bl10 = false;
            ArrayList arrayList2 = new ArrayList(n3);
            bl = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                int n6 = n4++;
                boolean bl11 = false;
                int $this$mapTo$iv$iv = n6;
                arrayList = arrayList2;
                boolean bl12 = false;
                Iterator iterator = null;
                arrayList.add(iterator);
            }
            arrayList = arrayList2;
            list = CollectionsKt.plus((Collection)collection, (Iterable)arrayList);
        } else {
            list = it;
        }
        multiParagraph.placeholderRects = list2 = list;
    }

    public /* synthetic */ MultiParagraph(MultiParagraphIntrinsics multiParagraphIntrinsics, int n, boolean bl, ParagraphConstraints paragraphConstraints, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(multiParagraphIntrinsics, n, bl, paragraphConstraints);
    }

    @NotNull
    public final MultiParagraphIntrinsics getIntrinsics() {
        return this.intrinsics;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public MultiParagraph(@NotNull AnnotatedString annotatedString, @NotNull TextStyle style, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, int maxLines, boolean ellipsis, @NotNull ParagraphConstraints constraints, @NotNull Density density, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"annotatedString");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this(new MultiParagraphIntrinsics(annotatedString, style, placeholders, density, resourceLoader), maxLines, ellipsis, constraints);
    }

    public /* synthetic */ MultiParagraph(AnnotatedString annotatedString, TextStyle textStyle, List list, int n, boolean bl, ParagraphConstraints paragraphConstraints, Density density, Font.ResourceLoader resourceLoader, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            boolean bl2 = false;
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        this(annotatedString, textStyle, list, n, bl, paragraphConstraints, density, resourceLoader);
    }

    private final AnnotatedString getAnnotatedString() {
        return this.intrinsics.getAnnotatedString();
    }

    public final float getMinIntrinsicWidth() {
        return this.intrinsics.getMaxIntrinsicWidth();
    }

    public final float getMaxIntrinsicWidth() {
        return this.intrinsics.getMaxIntrinsicWidth();
    }

    public final boolean getDidExceedMaxLines() {
        return this.didExceedMaxLines;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getFirstBaseline() {
        return this.paragraphInfoList.isEmpty() ? 0.0f : this.paragraphInfoList.get(0).getParagraph().getFirstBaseline();
    }

    public final float getLastBaseline() {
        float f;
        if (this.paragraphInfoList.isEmpty()) {
            f = 0.0f;
        } else {
            ParagraphInfo paragraphInfo = (ParagraphInfo)CollectionsKt.last(this.paragraphInfoList);
            boolean bl = false;
            boolean bl2 = false;
            ParagraphInfo $this$_get_lastBaseline__u24lambda_u2d0 = paragraphInfo;
            boolean bl3 = false;
            f = $this$_get_lastBaseline__u24lambda_u2d0.toGlobalYPosition($this$_get_lastBaseline__u24lambda_u2d0.getParagraph().getLastBaseline());
        }
        return f;
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    @NotNull
    public final List<Rect> getPlaceholderRects() {
        return this.placeholderRects;
    }

    @NotNull
    public final List<ParagraphInfo> getParagraphInfoList$ui_text_release() {
        return this.paragraphInfoList;
    }

    public final void paint(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        List<ParagraphInfo> $this$fastForEach$iv = this.paragraphInfoList;
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = $this$fastForEach$iv.size() + -1;
        if (n <= n2) {
            do {
                ParagraphInfo item$iv;
                int index$iv = n++;
                ParagraphInfo it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                it.getParagraph().paint(canvas);
                canvas.translate(0.0f, it.getParagraph().getHeight());
            } while (n <= n2);
        }
        canvas.restore();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path getPathForRange(int start, int end) {
        void $this$filterNotTo$iv$iv;
        boolean bl = new IntRange(0, end).contains(start) && end <= this.getAnnotatedString().getText().length();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Start(" + start + ") or End(" + end + ") is out of range [0.." + this.getAnnotatedString().getText().length() + "), or start > end!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (start == end) {
            return AndroidPathKt.Path();
        }
        int paragraphIndex = MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, start);
        Path path = AndroidPathKt.Path();
        Iterable $this$takeWhile$iv = CollectionsKt.drop((Iterable)this.paragraphInfoList, (int)paragraphIndex);
        boolean $i$f$takeWhile = false;
        Iterable list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            ParagraphInfo it = (ParagraphInfo)item$iv;
            boolean bl5 = false;
            if (!(it.getStartIndex() < end)) break;
            ((ArrayList)list$iv).add(item$iv);
        }
        Iterable $this$filterNot$iv = (List)list$iv;
        boolean $i$f$filterNot = false;
        list$iv = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ParagraphInfo it = (ParagraphInfo)element$iv$iv;
            boolean bl6 = false;
            if (it.getStartIndex() == it.getEndIndex()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List $this$fastForEach$iv = (List)destination$iv$iv;
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = $this$fastForEach$iv.size() + -1;
        if (n <= n2) {
            do {
                int index$iv = n++;
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                ParagraphInfo it = (ParagraphInfo)item$iv;
                boolean bl7 = false;
                boolean bl8 = false;
                boolean bl9 = false;
                ParagraphInfo $this$getPathForRange_u24lambda_u2d11_u24lambda_u2d10 = it;
                boolean bl10 = false;
                Path.DefaultImpls.addPath$default((Path)path, (Path)$this$getPathForRange_u24lambda_u2d11_u24lambda_u2d10.toGlobal($this$getPathForRange_u24lambda_u2d11_u24lambda_u2d10.getParagraph().getPathForRange($this$getPathForRange_u24lambda_u2d11_u24lambda_u2d10.toLocalIndex(start), $this$getPathForRange_u24lambda_u2d11_u24lambda_u2d10.toLocalIndex(end))), null, (int)2, null);
            } while (n <= n2);
        }
        return path;
    }

    public final int getLineForVerticalPosition(float vertical) {
        int n;
        int paragraphIndex = vertical <= 0.0f ? 0 : (vertical >= this.height ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByY(this.paragraphInfoList, vertical));
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineForVerticalPosition_u24lambda_u2d12 = paragraphInfo;
        boolean bl3 = false;
        if ($this$getLineForVerticalPosition_u24lambda_u2d12.getLength() == 0) {
            int n2 = 0;
            int n3 = $this$getLineForVerticalPosition_u24lambda_u2d12.getStartIndex() - 1;
            boolean bl4 = false;
            n = Math.max(n2, n3);
        } else {
            n = $this$getLineForVerticalPosition_u24lambda_u2d12.toGlobalLineIndex($this$getLineForVerticalPosition_u24lambda_u2d12.getParagraph().getLineForVerticalPosition($this$getLineForVerticalPosition_u24lambda_u2d12.toLocalYPosition(vertical)));
        }
        return n;
    }

    public final int getOffsetForPosition(@NotNull Offset position) {
        int n;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int paragraphIndex = position.getY() <= 0.0f ? 0 : (position.getY() >= this.height ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByY(this.paragraphInfoList, position.getY()));
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getOffsetForPosition_u24lambda_u2d13 = paragraphInfo;
        boolean bl3 = false;
        if ($this$getOffsetForPosition_u24lambda_u2d13.getLength() == 0) {
            int n2 = 0;
            int n3 = $this$getOffsetForPosition_u24lambda_u2d13.getStartIndex() - 1;
            boolean bl4 = false;
            n = Math.max(n2, n3);
        } else {
            n = $this$getOffsetForPosition_u24lambda_u2d13.toGlobalIndex($this$getOffsetForPosition_u24lambda_u2d13.getParagraph().getOffsetForPosition($this$getOffsetForPosition_u24lambda_u2d13.toLocal(position)));
        }
        return n;
    }

    @NotNull
    public final Rect getBoundingBox(int offset) {
        this.requireIndexInRange(offset);
        int paragraphIndex = MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getBoundingBox_u24lambda_u2d14 = paragraphInfo;
        boolean bl3 = false;
        return $this$getBoundingBox_u24lambda_u2d14.toGlobal($this$getBoundingBox_u24lambda_u2d14.getParagraph().getBoundingBox($this$getBoundingBox_u24lambda_u2d14.toLocalIndex(offset)));
    }

    public final float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getHorizontalPosition_u24lambda_u2d15 = paragraphInfo;
        boolean bl3 = false;
        return $this$getHorizontalPosition_u24lambda_u2d15.getParagraph().getHorizontalPosition($this$getHorizontalPosition_u24lambda_u2d15.toLocalIndex(offset), usePrimaryDirection);
    }

    @NotNull
    public final ResolvedTextDirection getParagraphDirection(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getParagraphDirection_u24lambda_u2d16 = paragraphInfo;
        boolean bl3 = false;
        return $this$getParagraphDirection_u24lambda_u2d16.getParagraph().getParagraphDirection($this$getParagraphDirection_u24lambda_u2d16.toLocalIndex(offset));
    }

    @NotNull
    public final ResolvedTextDirection getBidiRunDirection(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getBidiRunDirection_u24lambda_u2d17 = paragraphInfo;
        boolean bl3 = false;
        return $this$getBidiRunDirection_u24lambda_u2d17.getParagraph().getBidiRunDirection($this$getBidiRunDirection_u24lambda_u2d17.toLocalIndex(offset));
    }

    @NotNull
    public final TextRange getWordBoundary(int offset) {
        this.requireIndexInRange(offset);
        int paragraphIndex = MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getWordBoundary_u24lambda_u2d18 = paragraphInfo;
        boolean bl3 = false;
        return $this$getWordBoundary_u24lambda_u2d18.toGlobal($this$getWordBoundary_u24lambda_u2d18.getParagraph().getWordBoundary($this$getWordBoundary_u24lambda_u2d18.toLocalIndex(offset)));
    }

    @NotNull
    public final Rect getCursorRect(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getCursorRect_u24lambda_u2d19 = paragraphInfo;
        boolean bl3 = false;
        return $this$getCursorRect_u24lambda_u2d19.toGlobal($this$getCursorRect_u24lambda_u2d19.getParagraph().getCursorRect($this$getCursorRect_u24lambda_u2d19.toLocalIndex(offset)));
    }

    public final int getLineForOffset(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineForOffset_u24lambda_u2d20 = paragraphInfo;
        boolean bl3 = false;
        return $this$getLineForOffset_u24lambda_u2d20.toGlobalLineIndex($this$getLineForOffset_u24lambda_u2d20.getParagraph().getLineForOffset($this$getLineForOffset_u24lambda_u2d20.toLocalIndex(offset)));
    }

    public final float getLineLeft(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineLeft_u24lambda_u2d21 = paragraphInfo;
        boolean bl3 = false;
        return $this$getLineLeft_u24lambda_u2d21.getParagraph().getLineLeft($this$getLineLeft_u24lambda_u2d21.toLocalLineIndex(lineIndex));
    }

    public final float getLineRight(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineRight_u24lambda_u2d22 = paragraphInfo;
        boolean bl3 = false;
        return $this$getLineRight_u24lambda_u2d22.getParagraph().getLineRight($this$getLineRight_u24lambda_u2d22.toLocalLineIndex(lineIndex));
    }

    public final float getLineTop(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineTop_u24lambda_u2d23 = paragraphInfo;
        boolean bl3 = false;
        return $this$getLineTop_u24lambda_u2d23.toGlobalYPosition($this$getLineTop_u24lambda_u2d23.getParagraph().getLineTop($this$getLineTop_u24lambda_u2d23.toLocalLineIndex(lineIndex)));
    }

    public final float getLineBottom(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineBottom_u24lambda_u2d24 = paragraphInfo;
        boolean bl3 = false;
        return $this$getLineBottom_u24lambda_u2d24.toGlobalYPosition($this$getLineBottom_u24lambda_u2d24.getParagraph().getLineBottom($this$getLineBottom_u24lambda_u2d24.toLocalLineIndex(lineIndex)));
    }

    public final float getLineHeight(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineHeight_u24lambda_u2d25 = paragraphInfo;
        boolean bl3 = false;
        return $this$getLineHeight_u24lambda_u2d25.getParagraph().getLineHeight($this$getLineHeight_u24lambda_u2d25.toLocalLineIndex(lineIndex));
    }

    public final float getLineWidth(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineWidth_u24lambda_u2d26 = paragraphInfo;
        boolean bl3 = false;
        return $this$getLineWidth_u24lambda_u2d26.getParagraph().getLineWidth($this$getLineWidth_u24lambda_u2d26.toLocalLineIndex(lineIndex));
    }

    public final int getLineStart(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineStart_u24lambda_u2d27 = paragraphInfo;
        boolean bl3 = false;
        return $this$getLineStart_u24lambda_u2d27.toGlobalIndex($this$getLineStart_u24lambda_u2d27.getParagraph().getLineStart($this$getLineStart_u24lambda_u2d27.toLocalLineIndex(lineIndex)));
    }

    public final int getLineEnd(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineEnd_u24lambda_u2d28 = paragraphInfo;
        boolean bl3 = false;
        return $this$getLineEnd_u24lambda_u2d28.toGlobalIndex($this$getLineEnd_u24lambda_u2d28.getParagraph().getLineEnd($this$getLineEnd_u24lambda_u2d28.toLocalLineIndex(lineIndex)));
    }

    public final int getLineVisibleEnd(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineVisibleEnd_u24lambda_u2d29 = paragraphInfo;
        boolean bl3 = false;
        return $this$getLineVisibleEnd_u24lambda_u2d29.toGlobalIndex($this$getLineVisibleEnd_u24lambda_u2d29.getParagraph().getLineEnd($this$getLineVisibleEnd_u24lambda_u2d29.toLocalLineIndex(lineIndex)));
    }

    public final boolean isLineEllipsized(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$isLineEllipsized_u24lambda_u2d30 = paragraphInfo;
        boolean bl3 = false;
        return $this$isLineEllipsized_u24lambda_u2d30.getParagraph().isLineEllipsized(lineIndex);
    }

    private final void requireIndexInRange(int offset) {
        boolean bl = StringsKt.getIndices((CharSequence)this.getAnnotatedString().getText()).contains(offset);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "offset(" + offset + ") is out of bounds [0, " + AnnotatedStringKt.getLength(this.getAnnotatedString()) + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    private final void requireIndexInRangeInclusiveEnd(int offset) {
        boolean bl = new IntRange(0, this.getAnnotatedString().getText().length()).contains(offset);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "offset(" + offset + ") is out of bounds [0, " + AnnotatedStringKt.getLength(this.getAnnotatedString()) + ']';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    private final void requireLineIndexInRange(int lineIndex) {
        boolean bl = RangesKt.until((int)0, (int)this.lineCount).contains(lineIndex);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "lineIndex(" + lineIndex + ") is out of bounds [0, " + lineIndex + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }
}

