/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.text.input.TextInputService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/compose/ui/text/SoftwareKeyboardController;", "", "textInputService", "Landroidx/compose/ui/text/input/TextInputService;", "token", "", "Landroidx/compose/ui/text/input/InputSessionToken;", "(Landroidx/compose/ui/text/input/TextInputService;I)V", "hideSoftwareKeyboard", "", "notifyFocusedRect", "rect", "Landroidx/compose/ui/geometry/Rect;", "showSoftwareKeyboard", "ui-text_release"})
public final class SoftwareKeyboardController {
    private final TextInputService textInputService;
    private final int token;

    public SoftwareKeyboardController(@NotNull TextInputService textInputService, int token) {
        Intrinsics.checkNotNullParameter((Object)textInputService, (String)"textInputService");
        this.textInputService = textInputService;
        this.token = token;
    }

    public final void showSoftwareKeyboard() {
        this.textInputService.showSoftwareKeyboard(this.token);
    }

    public final void hideSoftwareKeyboard() {
        this.textInputService.hideSoftwareKeyboard(this.token);
    }

    public final void notifyFocusedRect(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.textInputService.notifyFocusedRect(this.token, rect);
    }
}

