/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.ShadowKt;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.FontWeightKt;
import androidx.compose.ui.text.intl.LocaleList;
import androidx.compose.ui.text.style.BaselineShift;
import androidx.compose.ui.text.style.BaselineShiftKt;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextGeometricTransform;
import androidx.compose.ui.text.style.TextGeometricTransformKt;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a+\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u0002H\u00072\u0006\u0010\t\u001a\u0002H\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\n\u001a*\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"lerp", "Landroidx/compose/ui/text/SpanStyle;", "start", "stop", "fraction", "", "lerpDiscrete", "T", "a", "b", "(Ljava/lang/Object;Ljava/lang/Object;F)Ljava/lang/Object;", "lerpTextUnitInheritable", "Landroidx/compose/ui/unit/TextUnit;", "t", "lerpTextUnitInheritable-KeuwX78", "(JJF)J", "ui-text_release"})
public final class SpanStyleKt {
    public static final long lerpTextUnitInheritable-KeuwX78(long a, long b, float t) {
        if (TextUnit.isInherit-impl((long)a) || TextUnit.isInherit-impl((long)b)) {
            return SpanStyleKt.lerpDiscrete(TextUnit.box-impl((long)a), TextUnit.box-impl((long)b), t).unbox-impl();
        }
        return TextUnitKt.lerp-KeuwX78((long)a, (long)b, (float)t);
    }

    public static final <T> T lerpDiscrete(T a, T b, float fraction) {
        return (double)fraction < 0.5 ? a : b;
    }

    @NotNull
    public static final SpanStyle lerp(@NotNull SpanStyle start, @NotNull SpanStyle stop, float fraction) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
        long l = ColorKt.lerp-m18UwgE((long)start.getColor-0d7_KjU(), (long)stop.getColor-0d7_KjU(), (float)fraction);
        FontFamily fontFamily = SpanStyleKt.lerpDiscrete(start.getFontFamily(), stop.getFontFamily(), fraction);
        long l2 = SpanStyleKt.lerpTextUnitInheritable-KeuwX78(start.getFontSize-XSAIIZE(), stop.getFontSize-XSAIIZE(), fraction);
        Object object = start.getFontWeight();
        FontWeight fontWeight = object == null ? FontWeight.Companion.getNormal() : object;
        object = stop.getFontWeight();
        FontWeight fontWeight2 = FontWeightKt.lerp(fontWeight, object == null ? FontWeight.Companion.getNormal() : object, fraction);
        object = SpanStyleKt.lerpDiscrete(start.getFontStyle(), stop.getFontStyle(), fraction);
        FontSynthesis fontSynthesis = SpanStyleKt.lerpDiscrete(start.getFontSynthesis(), stop.getFontSynthesis(), fraction);
        String string = SpanStyleKt.lerpDiscrete(start.getFontFeatureSettings(), stop.getFontFeatureSettings(), fraction);
        long l3 = SpanStyleKt.lerpTextUnitInheritable-KeuwX78(start.getLetterSpacing-XSAIIZE(), stop.getLetterSpacing-XSAIIZE(), fraction);
        Object object2 = start.getBaselineShift-5SSeXJ0();
        float f = object2 == null ? BaselineShift.constructor-impl(0.0f) : ((BaselineShift)object2).unbox-impl();
        object2 = stop.getBaselineShift-5SSeXJ0();
        float f2 = BaselineShiftKt.lerp-ylBt8J4(f, object2 == null ? BaselineShift.constructor-impl(0.0f) : ((BaselineShift)object2).unbox-impl(), fraction);
        Object object3 = start.getTextGeometricTransform();
        Object object4 = object3 == null ? TextGeometricTransform.Companion.getNone$ui_text_release() : object3;
        object3 = stop.getTextGeometricTransform();
        object2 = TextGeometricTransformKt.lerp((TextGeometricTransform)object4, (TextGeometricTransform)(object3 == null ? TextGeometricTransform.Companion.getNone$ui_text_release() : object3), fraction);
        object3 = SpanStyleKt.lerpDiscrete(start.getLocaleList(), stop.getLocaleList(), fraction);
        long l4 = ColorKt.lerp-m18UwgE((long)start.getBackground-0d7_KjU(), (long)stop.getBackground-0d7_KjU(), (float)fraction);
        TextDecoration textDecoration = SpanStyleKt.lerpDiscrete(start.getTextDecoration(), stop.getTextDecoration(), fraction);
        Shadow shadow = start.getShadow();
        Shadow shadow2 = shadow == null ? new Shadow(0L, null, 0.0f, 7, null) : shadow;
        shadow = stop.getShadow();
        Shadow shadow3 = ShadowKt.lerp((Shadow)shadow2, (Shadow)(shadow == null ? new Shadow(0L, null, 0.0f, 7, null) : shadow), (float)fraction);
        return new SpanStyle(l, l2, fontWeight2, (FontStyle)((Object)object), fontSynthesis, fontFamily, string, l3, BaselineShift.box-impl(f2), (TextGeometricTransform)object2, (LocaleList)object3, l4, textDecoration, shadow3, null);
    }
}

