/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.unit.IntSize;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010'\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b(J\t\u0010)\u001a\u00020\u0007H\u00c6\u0003J'\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010+\u001a\u00020\n2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001aJ\u000e\u00100\u001a\u00020!2\u0006\u0010/\u001a\u00020\u001aJ\u000e\u00101\u001a\u00020!2\u0006\u0010/\u001a\u00020\u001aJ\u0016\u00102\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\nJ\u000e\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u001aJ\u000e\u00106\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001aJ\u000e\u00107\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001aJ\u000e\u00108\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\u0010J\u000e\u0010:\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u001aJ\u000e\u0010;\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u001aJ\u000e\u0010<\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001aJ\u000e\u0010=\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u001aJ\u000e\u0010>\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001aJ\u000e\u0010?\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020AJ\u000e\u0010B\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001aJ\u0016\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010F\u001a\u00020\u001aJ\u000e\u0010G\u001a\u00020H2\u0006\u0010/\u001a\u00020\u001aJ\t\u0010I\u001a\u00020\u001aH\u00d6\u0001J\u000e\u0010J\u001a\u00020\n2\u0006\u00105\u001a\u00020\u001aJ\t\u0010K\u001a\u00020LH\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0019\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006M"}, d2={"Landroidx/compose/ui/text/TextLayoutResult;", "", "layoutInput", "Landroidx/compose/ui/text/TextLayoutInput;", "multiParagraph", "Landroidx/compose/ui/text/MultiParagraph;", "size", "Landroidx/compose/ui/unit/IntSize;", "(Landroidx/compose/ui/text/TextLayoutInput;Landroidx/compose/ui/text/MultiParagraph;Landroidx/compose/ui/unit/IntSize;)V", "didOverflowHeight", "", "getDidOverflowHeight", "()Z", "didOverflowWidth", "getDidOverflowWidth", "firstBaseline", "", "getFirstBaseline", "()F", "hasVisualOverflow", "getHasVisualOverflow", "lastBaseline", "getLastBaseline", "getLayoutInput", "()Landroidx/compose/ui/text/TextLayoutInput;", "lineCount", "", "getLineCount", "()I", "getMultiParagraph$ui_text_release", "()Landroidx/compose/ui/text/MultiParagraph;", "placeholderRects", "", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "getSize", "()Landroidx/compose/ui/unit/IntSize;", "component1", "component2", "component2$ui_text_release", "component3", "copy", "equals", "other", "getBidiRunDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "offset", "getBoundingBox", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineBottom", "lineIndex", "getLineEnd", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineLeft", "getLineRight", "getLineStart", "getLineTop", "getLineVisibleEnd", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getParagraphDirection", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "end", "getWordBoundary", "Landroidx/compose/ui/text/TextRange;", "hashCode", "isLineEllipsized", "toString", "", "ui-text_release"})
public final class TextLayoutResult {
    private final TextLayoutInput layoutInput;
    private final MultiParagraph multiParagraph;
    private final IntSize size;
    private final float firstBaseline;
    private final float lastBaseline;
    private final List<Rect> placeholderRects;

    public TextLayoutResult(@NotNull TextLayoutInput layoutInput, @NotNull MultiParagraph multiParagraph, @NotNull IntSize size) {
        Intrinsics.checkNotNullParameter((Object)layoutInput, (String)"layoutInput");
        Intrinsics.checkNotNullParameter((Object)multiParagraph, (String)"multiParagraph");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.layoutInput = layoutInput;
        this.multiParagraph = multiParagraph;
        this.size = size;
        this.firstBaseline = this.multiParagraph.getFirstBaseline();
        this.lastBaseline = this.multiParagraph.getLastBaseline();
        this.placeholderRects = this.multiParagraph.getPlaceholderRects();
    }

    @NotNull
    public final TextLayoutInput getLayoutInput() {
        return this.layoutInput;
    }

    @NotNull
    public final MultiParagraph getMultiParagraph$ui_text_release() {
        return this.multiParagraph;
    }

    @NotNull
    public final IntSize getSize() {
        return this.size;
    }

    public final float getFirstBaseline() {
        return this.firstBaseline;
    }

    public final float getLastBaseline() {
        return this.lastBaseline;
    }

    public final boolean getDidOverflowHeight() {
        return this.multiParagraph.getDidExceedMaxLines();
    }

    public final boolean getDidOverflowWidth() {
        return (float)this.size.getWidth() < this.multiParagraph.getWidth();
    }

    public final boolean getHasVisualOverflow() {
        return this.getDidOverflowWidth() || this.getDidOverflowHeight();
    }

    @NotNull
    public final List<Rect> getPlaceholderRects() {
        return this.placeholderRects;
    }

    public final int getLineCount() {
        return this.multiParagraph.getLineCount();
    }

    public final int getLineStart(int lineIndex) {
        return this.multiParagraph.getLineStart(lineIndex);
    }

    public final int getLineEnd(int lineIndex) {
        return this.multiParagraph.getLineEnd(lineIndex);
    }

    public final int getLineVisibleEnd(int lineIndex) {
        return this.multiParagraph.getLineVisibleEnd(lineIndex);
    }

    public final boolean isLineEllipsized(int lineIndex) {
        return this.multiParagraph.isLineEllipsized(lineIndex);
    }

    public final float getLineTop(int lineIndex) {
        return this.multiParagraph.getLineTop(lineIndex);
    }

    public final float getLineBottom(int lineIndex) {
        return this.multiParagraph.getLineBottom(lineIndex);
    }

    public final float getLineLeft(int lineIndex) {
        return this.multiParagraph.getLineLeft(lineIndex);
    }

    public final float getLineRight(int lineIndex) {
        return this.multiParagraph.getLineRight(lineIndex);
    }

    public final int getLineForOffset(int offset) {
        return this.multiParagraph.getLineForOffset(offset);
    }

    public final int getLineForVerticalPosition(float vertical) {
        return this.multiParagraph.getLineForVerticalPosition(vertical);
    }

    public final float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        return this.multiParagraph.getHorizontalPosition(offset, usePrimaryDirection);
    }

    @NotNull
    public final ResolvedTextDirection getParagraphDirection(int offset) {
        return this.multiParagraph.getParagraphDirection(offset);
    }

    @NotNull
    public final ResolvedTextDirection getBidiRunDirection(int offset) {
        return this.multiParagraph.getBidiRunDirection(offset);
    }

    public final int getOffsetForPosition(@NotNull Offset position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.multiParagraph.getOffsetForPosition(position);
    }

    @NotNull
    public final Rect getBoundingBox(int offset) {
        return this.multiParagraph.getBoundingBox(offset);
    }

    @NotNull
    public final TextRange getWordBoundary(int offset) {
        return this.multiParagraph.getWordBoundary(offset);
    }

    @NotNull
    public final Rect getCursorRect(int offset) {
        return this.multiParagraph.getCursorRect(offset);
    }

    @NotNull
    public final Path getPathForRange(int start, int end) {
        return this.multiParagraph.getPathForRange(start, end);
    }

    @NotNull
    public final TextLayoutInput component1() {
        return this.layoutInput;
    }

    @NotNull
    public final MultiParagraph component2$ui_text_release() {
        return this.multiParagraph;
    }

    @NotNull
    public final IntSize component3() {
        return this.size;
    }

    @NotNull
    public final TextLayoutResult copy(@NotNull TextLayoutInput layoutInput, @NotNull MultiParagraph multiParagraph, @NotNull IntSize size) {
        Intrinsics.checkNotNullParameter((Object)layoutInput, (String)"layoutInput");
        Intrinsics.checkNotNullParameter((Object)multiParagraph, (String)"multiParagraph");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return new TextLayoutResult(layoutInput, multiParagraph, size);
    }

    public static /* synthetic */ TextLayoutResult copy$default(TextLayoutResult textLayoutResult, TextLayoutInput textLayoutInput, MultiParagraph multiParagraph, IntSize intSize, int n, Object object) {
        if ((n & 1) != 0) {
            textLayoutInput = textLayoutResult.layoutInput;
        }
        if ((n & 2) != 0) {
            multiParagraph = textLayoutResult.multiParagraph;
        }
        if ((n & 4) != 0) {
            intSize = textLayoutResult.size;
        }
        return textLayoutResult.copy(textLayoutInput, multiParagraph, intSize);
    }

    @NotNull
    public String toString() {
        return "TextLayoutResult(layoutInput=" + this.layoutInput + ", multiParagraph=" + this.multiParagraph + ", size=" + this.size + ')';
    }

    public int hashCode() {
        return (this.layoutInput.hashCode() * 31 + this.multiParagraph.hashCode()) * 31 + this.size.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextLayoutResult)) {
            return false;
        }
        Object object = other;
        TextLayoutResult textLayoutResult = (TextLayoutResult)object;
        if (!Intrinsics.areEqual((Object)this.layoutInput, (Object)textLayoutResult.layoutInput)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.multiParagraph, (Object)textLayoutResult.multiParagraph)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.size, (Object)textLayoutResult.size);
    }
}

