/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.Immutable;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Please use androidx.compose.ui.text.input.TextFieldValue instead", replaceWith=@ReplaceWith(expression="TextFieldValue", imports={"androidx.compose.ui.text.input.TextFieldValue"}))
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0019\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Landroidx/compose/ui/text/input/EditorValue;", "", "text", "", "selection", "Landroidx/compose/ui/text/TextRange;", "composition", "(Ljava/lang/String;Landroidx/compose/ui/text/TextRange;Landroidx/compose/ui/text/TextRange;)V", "getComposition", "()Landroidx/compose/ui/text/TextRange;", "getSelection", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "getSelectedText", "getTextAfterSelection", "maxChars", "", "getTextBeforeSelection", "hashCode", "toString", "ui-text_release"})
@Immutable
public final class EditorValue {
    private final String text;
    private final TextRange selection;
    private final TextRange composition;

    public EditorValue(@NotNull String text, @NotNull TextRange selection, @Nullable TextRange composition) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        this.text = text;
        this.selection = selection;
        this.composition = composition;
    }

    public /* synthetic */ EditorValue(String string, TextRange textRange, TextRange textRange2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            textRange = TextRange.Companion.getZero();
        }
        if ((n & 4) != 0) {
            textRange2 = null;
        }
        this(string, textRange, textRange2);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final TextRange getSelection() {
        return this.selection;
    }

    @Nullable
    public final TextRange getComposition() {
        return this.composition;
    }

    @NotNull
    public final String getTextBeforeSelection(int maxChars) {
        String string = this.text;
        int n = 0;
        int n2 = this.selection.getMin() - maxChars;
        boolean bl = false;
        n = Math.max(n, n2);
        n2 = this.selection.getMin();
        bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final String getTextAfterSelection(int maxChars) {
        String string = this.text;
        int n = this.selection.getMax();
        int n2 = this.selection.getMax() + maxChars;
        int n3 = this.text.length();
        boolean bl = false;
        n2 = Math.min(n2, n3);
        n3 = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final String getSelectedText() {
        return TextRangeKt.substring(this.text, this.selection);
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final TextRange component2() {
        return this.selection;
    }

    @Nullable
    public final TextRange component3() {
        return this.composition;
    }

    @NotNull
    public final EditorValue copy(@NotNull String text, @NotNull TextRange selection, @Nullable TextRange composition) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        return new EditorValue(text, selection, composition);
    }

    public static /* synthetic */ EditorValue copy$default(EditorValue editorValue, String string, TextRange textRange, TextRange textRange2, int n, Object object) {
        if ((n & 1) != 0) {
            string = editorValue.text;
        }
        if ((n & 2) != 0) {
            textRange = editorValue.selection;
        }
        if ((n & 4) != 0) {
            textRange2 = editorValue.composition;
        }
        return editorValue.copy(string, textRange, textRange2);
    }

    @NotNull
    public String toString() {
        return "EditorValue(text=" + this.text + ", selection=" + this.selection + ", composition=" + this.composition + ')';
    }

    public int hashCode() {
        return (this.text.hashCode() * 31 + this.selection.hashCode()) * 31 + (this.composition == null ? 0 : this.composition.hashCode());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EditorValue)) {
            return false;
        }
        Object object = other;
        EditorValue editorValue = (EditorValue)object;
        if (!Intrinsics.areEqual((Object)this.text, (Object)editorValue.text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.selection, (Object)editorValue.selection)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.composition, (Object)editorValue.composition);
    }

    public EditorValue() {
        this(null, null, null, 7, null);
    }
}

