/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.annotation.IntRange;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0001 B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0003H\u0086\u0002J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0000J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006!"}, d2={"Landroidx/compose/ui/text/TextRange;", "", "start", "", "end", "(II)V", "collapsed", "", "getCollapsed", "()Z", "getEnd", "()I", "length", "getLength", "max", "getMax", "min", "getMin", "reversed", "getReversed", "getStart", "component1", "component2", "contains", "other", "offset", "copy", "equals", "hashCode", "intersects", "toString", "", "Companion", "ui-text_release"})
@Immutable
public final class TextRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int start;
    private final int end;
    private static final TextRange Zero = TextRangeKt.TextRange(0);

    public TextRange(@IntRange(from=0L) int start, @IntRange(from=0L) int end) {
        this.start = start;
        this.end = end;
        boolean bl = this.start >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "start cannot be negative. [start: " + this.getStart() + ']';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.end >= 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "end cannot negative. [end: " + this.getEnd() + ']';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public final int getMin() {
        return this.start > this.end ? this.end : this.start;
    }

    public final int getMax() {
        return this.start > this.end ? this.start : this.end;
    }

    public final boolean getCollapsed() {
        return this.start == this.end;
    }

    public final boolean getReversed() {
        return this.start > this.end;
    }

    public final int getLength() {
        return this.getMax() - this.getMin();
    }

    public final boolean intersects(@NotNull TextRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getMin() < other.getMax() && other.getMin() < this.getMax();
    }

    public final boolean contains(@NotNull TextRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getMin() <= other.getMin() && other.getMax() <= this.getMax();
    }

    public final boolean contains(int offset) {
        return RangesKt.until((int)this.getMin(), (int)this.getMax()).contains(offset);
    }

    public final int component1() {
        return this.start;
    }

    public final int component2() {
        return this.end;
    }

    @NotNull
    public final TextRange copy(@IntRange(from=0L) int start, @IntRange(from=0L) int end) {
        return new TextRange(start, end);
    }

    public static /* synthetic */ TextRange copy$default(TextRange textRange, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = textRange.start;
        }
        if ((n3 & 2) != 0) {
            n2 = textRange.end;
        }
        return textRange.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "TextRange(start=" + this.start + ", end=" + this.end + ')';
    }

    public int hashCode() {
        return Integer.hashCode(this.start) * 31 + Integer.hashCode(this.end);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextRange)) {
            return false;
        }
        Object object = other;
        TextRange textRange = (TextRange)object;
        if (this.start != textRange.start) {
            return false;
        }
        return this.end == textRange.end;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/text/TextRange$Companion;", "", "()V", "Zero", "Landroidx/compose/ui/text/TextRange;", "getZero", "()Landroidx/compose/ui/text/TextRange;", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextRange getZero() {
            return Zero;
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

