/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.Stable;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TtsAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u0002./B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\u0002\u0010\nBS\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u00060\u0005\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0096\u0002J\"\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011J*\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011J\"\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u00060\u00052\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011J\b\u0010$\u001a\u00020\u0011H\u0016J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0000H\u0087\u0002J\u001b\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b)\u0010*J\u0018\u0010&\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0011H\u0016J\b\u0010-\u001a\u00020\u0003H\u0016R\"\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00060"}, d2={"Landroidx/compose/ui/text/AnnotatedString;", "", "text", "", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "annotations", "", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAnnotations$ui_text_release", "()Ljava/util/List;", "length", "", "getLength", "()I", "getParagraphStyles", "getSpanStyles", "getText", "()Ljava/lang/String;", "equals", "", "other", "get", "", "index", "getStringAnnotations", "start", "end", "tag", "getTtsAnnotations", "Landroidx/compose/ui/text/TtsAnnotation;", "hashCode", "plus", "subSequence", "range", "Landroidx/compose/ui/text/TextRange;", "subSequence-5zc-tL8", "(J)Landroidx/compose/ui/text/AnnotatedString;", "startIndex", "endIndex", "toString", "Builder", "Range", "ui-text_release"})
@Immutable
public final class AnnotatedString
implements CharSequence {
    @NotNull
    private final String text;
    @NotNull
    private final List<Range<SpanStyle>> spanStyles;
    @NotNull
    private final List<Range<ParagraphStyle>> paragraphStyles;
    @NotNull
    private final List<Range<? extends Object>> annotations;

    public AnnotatedString(@NotNull String text, @NotNull List<Range<SpanStyle>> spanStyles, @NotNull List<Range<ParagraphStyle>> paragraphStyles, @NotNull List<? extends Range<? extends Object>> annotations) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(paragraphStyles, (String)"paragraphStyles");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        this.text = text;
        this.spanStyles = spanStyles;
        this.paragraphStyles = paragraphStyles;
        this.annotations = annotations;
        int lastStyleEnd = 0;
        lastStyleEnd = -1;
        List<Range<ParagraphStyle>> $this$fastForEach$iv = this.paragraphStyles;
        boolean $i$f$fastForEach = false;
        int n = 0;
        n = 0;
        int n2 = $this$fastForEach$iv.size() + -1;
        if (n <= n2) {
            do {
                Range<ParagraphStyle> item$iv;
                int index$iv = n++;
                Range<ParagraphStyle> paragraphStyle = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                boolean bl2 = paragraphStyle.getStart() >= lastStyleEnd;
                boolean bl3 = false;
                boolean bl4 = false;
                if (!bl2) {
                    boolean bl5 = false;
                    String string = "ParagraphStyle should not overlap";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                bl2 = paragraphStyle.getEnd() <= this.getText().length();
                bl3 = false;
                bl4 = false;
                if (!bl2) {
                    boolean bl6 = false;
                    String string = "ParagraphStyle range [" + paragraphStyle.getStart() + ", " + paragraphStyle.getEnd() + ") is out of boundary";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                lastStyleEnd = paragraphStyle.getEnd();
            } while (n <= n2);
        }
    }

    public /* synthetic */ AnnotatedString(String string, List list, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        this(string, list, list2, list3);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final List<Range<SpanStyle>> getSpanStyles() {
        return this.spanStyles;
    }

    @NotNull
    public final List<Range<ParagraphStyle>> getParagraphStyles() {
        return this.paragraphStyles;
    }

    @NotNull
    public final List<Range<? extends Object>> getAnnotations$ui_text_release() {
        return this.annotations;
    }

    public AnnotatedString(@NotNull String text, @NotNull List<Range<SpanStyle>> spanStyles, @NotNull List<Range<ParagraphStyle>> paragraphStyles) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(paragraphStyles, (String)"paragraphStyles");
        boolean bl = false;
        this(text, spanStyles, paragraphStyles, CollectionsKt.emptyList());
    }

    public /* synthetic */ AnnotatedString(String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 2) != 0) {
            bl = false;
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = false;
            list2 = CollectionsKt.emptyList();
        }
        this(string, list, list2);
    }

    public int getLength() {
        return this.text.length();
    }

    public char get(int index) {
        return this.text.charAt(index);
    }

    @Override
    @NotNull
    public AnnotatedString subSequence(int startIndex, int endIndex) {
        boolean bl = startIndex <= endIndex;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "start (" + startIndex + ") should be less or equal to end (" + endIndex + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (startIndex == 0 && endIndex == this.text.length()) {
            return this;
        }
        String string = this.text;
        bl3 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String text = string3;
        return new AnnotatedString(text, AnnotatedStringKt.access$filterRanges(this.spanStyles, startIndex, endIndex), AnnotatedStringKt.access$filterRanges(this.paragraphStyles, startIndex, endIndex), AnnotatedStringKt.access$filterRanges(this.annotations, startIndex, endIndex));
    }

    @NotNull
    public final AnnotatedString subSequence-5zc-tL8(long range) {
        return this.subSequence(TextRange.getMin-impl(range), TextRange.getMax-impl(range));
    }

    @Stable
    @NotNull
    public final AnnotatedString plus(@NotNull AnnotatedString other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Builder builder = new Builder(this);
        boolean bl = false;
        boolean bl2 = false;
        Builder $this$plus_u24lambda_u2d4 = builder;
        boolean bl3 = false;
        $this$plus_u24lambda_u2d4.append(other);
        return $this$plus_u24lambda_u2d4.toAnnotatedString();
    }

    @NotNull
    public final List<Range<String>> getStringAnnotations(@NotNull String tag, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<Range<? extends Object>> $this$fastFilter$iv = this.annotations;
        boolean $i$f$fastFilter = false;
        boolean bl = false;
        ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
        List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
        boolean $i$f$fastForEach = false;
        int n = 0;
        n = 0;
        int n2 = $this$fastForEach$iv$iv.size() + -1;
        if (n <= n2) {
            do {
                Range<? extends Object> item$iv$iv;
                int index$iv$iv = n++;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl2 = false;
                Range<? extends Object> it = it$iv;
                boolean bl3 = false;
                if (!(it.getItem() instanceof String && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                Collection collection = target$iv;
                boolean bl4 = false;
                collection.add(it$iv);
            } while (n <= n2);
        }
        return target$iv;
    }

    @NotNull
    public final List<Range<String>> getStringAnnotations(int start, int end) {
        List<Range<? extends Object>> $this$fastFilter$iv = this.annotations;
        boolean $i$f$fastFilter = false;
        boolean bl = false;
        ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
        List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
        boolean $i$f$fastForEach = false;
        int n = 0;
        n = 0;
        int n2 = $this$fastForEach$iv$iv.size() + -1;
        if (n <= n2) {
            do {
                Range<? extends Object> item$iv$iv;
                int index$iv$iv = n++;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl2 = false;
                Range<? extends Object> it = it$iv;
                boolean bl3 = false;
                if (!(it.getItem() instanceof String && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                Collection collection = target$iv;
                boolean bl4 = false;
                collection.add(it$iv);
            } while (n <= n2);
        }
        return target$iv;
    }

    @NotNull
    public final List<Range<TtsAnnotation>> getTtsAnnotations(int start, int end) {
        List<Range<? extends Object>> $this$fastFilter$iv = this.annotations;
        boolean $i$f$fastFilter = false;
        boolean bl = false;
        ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
        List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
        boolean $i$f$fastForEach = false;
        int n = 0;
        n = 0;
        int n2 = $this$fastForEach$iv$iv.size() + -1;
        if (n <= n2) {
            do {
                Range<? extends Object> item$iv$iv;
                int index$iv$iv = n++;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl2 = false;
                Range<? extends Object> it = it$iv;
                boolean bl3 = false;
                if (!(it.getItem() instanceof TtsAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                Collection collection = target$iv;
                boolean bl4 = false;
                collection.add(it$iv);
            } while (n <= n2);
        }
        return target$iv;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotatedString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((AnnotatedString)other).text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.spanStyles, ((AnnotatedString)other).spanStyles)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paragraphStyles, ((AnnotatedString)other).paragraphStyles)) {
            return false;
        }
        return Intrinsics.areEqual(this.annotations, ((AnnotatedString)other).annotations);
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + ((Object)this.spanStyles).hashCode();
        result = 31 * result + ((Object)this.paragraphStyles).hashCode();
        result = 31 * result + ((Object)this.annotations).hashCode();
        return result;
    }

    @Override
    @NotNull
    public String toString() {
        return this.text;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J<\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Range;", "T", "", "item", "start", "", "end", "(Ljava/lang/Object;II)V", "tag", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Range;", "equals", "", "other", "hashCode", "toString", "ui-text_release"})
    @Immutable
    public static final class Range<T> {
        private final T item;
        private final int start;
        private final int end;
        @NotNull
        private final String tag;

        public Range(T item, int start, int end, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.item = item;
            this.start = start;
            this.end = end;
            this.tag = tag;
            boolean bl = this.start <= this.end;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Reversed range is not supported";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        public final T getItem() {
            return this.item;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public Range(T item, int start, int end) {
            this(item, start, end, "");
        }

        public final T component1() {
            return this.item;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final String component4() {
            return this.tag;
        }

        @NotNull
        public final Range<T> copy(T item, int start, int end, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return new Range<T>(item, start, end, tag);
        }

        public static /* synthetic */ Range copy$default(Range range, Object object, int n, int n2, String string, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                object = range.item;
            }
            if ((n3 & 2) != 0) {
                n = range.start;
            }
            if ((n3 & 4) != 0) {
                n2 = range.end;
            }
            if ((n3 & 8) != 0) {
                string = range.tag;
            }
            return range.copy(object, n, n2, string);
        }

        @NotNull
        public String toString() {
            return "Range(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ')';
        }

        public int hashCode() {
            int result = this.item == null ? 0 : this.item.hashCode();
            result = result * 31 + Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            result = result * 31 + this.tag.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            Range range = (Range)other;
            if (!Intrinsics.areEqual(this.item, range.item)) {
                return false;
            }
            if (this.start != range.start) {
                return false;
            }
            if (this.end != range.end) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tag, (Object)range.tag);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001*B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u001e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u001e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u0018J\u000e\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\bJ\u0016\u0010$\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0011J\u000e\u0010%\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0013J\u000e\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\u0005R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0015j\u0002`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder;", "", "text", "", "(Ljava/lang/String;)V", "Landroidx/compose/ui/text/AnnotatedString;", "(Landroidx/compose/ui/text/AnnotatedString;)V", "capacity", "", "(I)V", "annotations", "", "Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "length", "getLength", "()I", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "spanStyles", "Landroidx/compose/ui/text/SpanStyle;", "styleStack", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addStringAnnotation", "", "tag", "annotation", "start", "end", "addStyle", "style", "append", "char", "", "pop", "index", "pushStringAnnotation", "pushStyle", "pushTtsAnnotation", "ttsAnnotation", "Landroidx/compose/ui/text/TtsAnnotation;", "toAnnotatedString", "MutableRange", "ui-text_release"})
    public static final class Builder {
        @NotNull
        private final StringBuilder text;
        @NotNull
        private final List<MutableRange<SpanStyle>> spanStyles;
        @NotNull
        private final List<MutableRange<ParagraphStyle>> paragraphStyles;
        @NotNull
        private final List<MutableRange<? extends Object>> annotations;
        @NotNull
        private final List<MutableRange<? extends Object>> styleStack;

        public Builder(int capacity) {
            this.text = new StringBuilder(capacity);
            boolean bl = false;
            this.spanStyles = new ArrayList();
            bl = false;
            this.paragraphStyles = new ArrayList();
            bl = false;
            this.annotations = new ArrayList();
            bl = false;
            this.styleStack = new ArrayList();
        }

        public /* synthetic */ Builder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 16;
            }
            this(n);
        }

        public Builder(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this(0, 1, null);
            this.append(text);
        }

        public Builder(@NotNull AnnotatedString text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this(0, 1, null);
            this.append(text);
        }

        public final int getLength() {
            return this.text.length();
        }

        public final void append(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text.append(text);
        }

        public final void append(char c) {
            this.text.append(c);
        }

        public final void append(@NotNull AnnotatedString text) {
            Range<SpanStyle> it;
            Range<Object> item$iv;
            int index$iv;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int start = this.text.length();
            this.text.append(text.getText());
            List<Range<Object>> $this$fastForEach$iv = text.getSpanStyles();
            boolean $i$f$fastForEach = false;
            int n = 0;
            n = 0;
            int n2 = $this$fastForEach$iv.size() + -1;
            if (n <= n2) {
                do {
                    index$iv = n++;
                    it = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl = false;
                    this.addStyle(it.getItem(), start + it.getStart(), start + it.getEnd());
                } while (n <= n2);
            }
            $this$fastForEach$iv = text.getParagraphStyles();
            $i$f$fastForEach = false;
            n = 0;
            n = 0;
            n2 = $this$fastForEach$iv.size() + -1;
            if (n <= n2) {
                do {
                    index$iv = n++;
                    it = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl = false;
                    this.addStyle((ParagraphStyle)((Object)it.getItem()), start + it.getStart(), start + it.getEnd());
                } while (n <= n2);
            }
            $this$fastForEach$iv = text.getAnnotations$ui_text_release();
            $i$f$fastForEach = false;
            n = 0;
            n = 0;
            n2 = $this$fastForEach$iv.size() + -1;
            if (n <= n2) {
                do {
                    index$iv = n++;
                    it = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl = false;
                    this.annotations.add(new MutableRange<SpanStyle>(it.getItem(), start + it.getStart(), start + it.getEnd(), it.getTag()));
                } while (n <= n2);
            }
        }

        public final void addStyle(@NotNull SpanStyle style, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.spanStyles.add(new MutableRange(style, start, end, null, 8, null));
        }

        public final void addStyle(@NotNull ParagraphStyle style, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.paragraphStyles.add(new MutableRange(style, start, end, null, 8, null));
        }

        public final void addStringAnnotation(@NotNull String tag, @NotNull String annotation, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            this.annotations.add(new MutableRange<String>(annotation, start, end, tag));
        }

        public final int pushStyle(@NotNull SpanStyle style) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            MutableRange mutableRange = new MutableRange(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            boolean bl2 = false;
            MutableRange it = mutableRange;
            boolean bl3 = false;
            this.styleStack.add(it);
            this.spanStyles.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStyle(@NotNull ParagraphStyle style) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            MutableRange mutableRange = new MutableRange(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            boolean bl2 = false;
            MutableRange it = mutableRange;
            boolean bl3 = false;
            this.styleStack.add(it);
            this.paragraphStyles.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStringAnnotation(@NotNull String tag, @NotNull String annotation) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            MutableRange mutableRange = new MutableRange(annotation, this.text.length(), 0, tag, 4, null);
            boolean bl = false;
            boolean bl2 = false;
            MutableRange it = mutableRange;
            boolean bl3 = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushTtsAnnotation(@NotNull TtsAnnotation ttsAnnotation) {
            Intrinsics.checkNotNullParameter((Object)ttsAnnotation, (String)"ttsAnnotation");
            MutableRange mutableRange = new MutableRange(ttsAnnotation, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            boolean bl2 = false;
            MutableRange it = mutableRange;
            boolean bl3 = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final void pop() {
            Collection collection = this.styleStack;
            boolean bl = false;
            boolean bl2 = !collection.isEmpty();
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "Nothing to pop.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            MutableRange<? extends Object> item = this.styleStack.remove(this.styleStack.size() - 1);
            item.setEnd(this.text.length());
        }

        public final void pop(int index) {
            boolean bl = index < this.styleStack.size();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = index + " should be less than " + this.styleStack.size();
                throw (Throwable)new IllegalStateException(string.toString());
            }
            while (this.styleStack.size() - 1 >= index) {
                this.pop();
            }
        }

        @NotNull
        public final AnnotatedString toAnnotatedString() {
            List list;
            Object it;
            Collection collection;
            boolean bl;
            Object it$iv;
            Object item$iv$iv;
            int index$iv$iv;
            List<MutableRange<Object>> $this$fastMap$iv;
            Object object = this.text.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"text.toString()");
            String string = object;
            object = this.spanStyles;
            String string2 = string;
            boolean $i$f$fastMap = false;
            boolean bl2 = false;
            ArrayList target$iv22 = new ArrayList($this$fastMap$iv.size());
            List<MutableRange<Object>> $this$fastForEach$iv$iv = $this$fastMap$iv;
            boolean $i$f$fastForEach = false;
            int n = 0;
            n = 0;
            int n2 = $this$fastForEach$iv$iv.size() + -1;
            if (n <= n2) {
                do {
                    index$iv$iv = n++;
                    it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    bl = false;
                    collection = target$iv22;
                    it = (MutableRange)it$iv;
                    boolean bl3 = false;
                    it = ((MutableRange)it).toRange(this.text.length());
                    bl3 = false;
                    collection.add(it);
                } while (n <= n2);
            }
            List list2 = target$iv22;
            $this$fastMap$iv = this.paragraphStyles;
            $i$f$fastMap = false;
            boolean target$iv22 = false;
            ArrayList target$iv32 = new ArrayList($this$fastMap$iv.size());
            $this$fastForEach$iv$iv = $this$fastMap$iv;
            $i$f$fastForEach = false;
            n = 0;
            n = 0;
            n2 = $this$fastForEach$iv$iv.size() + -1;
            if (n <= n2) {
                do {
                    index$iv$iv = n++;
                    it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    bl = false;
                    collection = target$iv32;
                    it = (MutableRange)it$iv;
                    boolean bl4 = false;
                    it = ((MutableRange)it).toRange(this.text.length());
                    bl4 = false;
                    collection.add(it);
                } while (n <= n2);
            }
            List list3 = target$iv32;
            $this$fastMap$iv = this.annotations;
            $i$f$fastMap = false;
            boolean target$iv32 = false;
            ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
            $this$fastForEach$iv$iv = $this$fastMap$iv;
            $i$f$fastForEach = false;
            n = 0;
            n = 0;
            n2 = $this$fastForEach$iv$iv.size() + -1;
            if (n <= n2) {
                do {
                    index$iv$iv = n++;
                    it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    bl = false;
                    collection = target$iv;
                    it = (MutableRange)it$iv;
                    boolean bl5 = false;
                    Range range = ((MutableRange)it).toRange(this.text.length());
                    boolean bl6 = false;
                    collection.add(range);
                } while (n <= n2);
            }
            List list4 = list = (List)target$iv;
            List list5 = list3;
            List list6 = list2;
            String string3 = string2;
            return new AnnotatedString(string3, list6, list5, list4);
        }

        public Builder() {
            this(0, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0014\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J<\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\b\b\u0002\u0010 \u001a\u00020\u0005J\t\u0010!\u001a\u00020\bH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "T", "", "item", "start", "", "end", "tag", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "setEnd", "(I)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "equals", "", "other", "hashCode", "toRange", "Landroidx/compose/ui/text/AnnotatedString$Range;", "defaultEnd", "toString", "ui-text_release"})
        private static final class MutableRange<T> {
            private final T item;
            private final int start;
            private int end;
            @NotNull
            private final String tag;

            public MutableRange(T item, int start, int end, @NotNull String tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                this.item = item;
                this.start = start;
                this.end = end;
                this.tag = tag;
            }

            public /* synthetic */ MutableRange(Object object, int n, int n2, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 4) != 0) {
                    n2 = Integer.MIN_VALUE;
                }
                if ((n3 & 8) != 0) {
                    string = "";
                }
                this(object, n, n2, string);
            }

            public final T getItem() {
                return this.item;
            }

            public final int getStart() {
                return this.start;
            }

            public final int getEnd() {
                return this.end;
            }

            public final void setEnd(int n) {
                this.end = n;
            }

            @NotNull
            public final String getTag() {
                return this.tag;
            }

            @NotNull
            public final Range<T> toRange(int defaultEnd) {
                int end = this.end == Integer.MIN_VALUE ? defaultEnd : this.end;
                boolean bl = end != Integer.MIN_VALUE;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Item.end should be set first";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return new Range<T>(this.item, this.start, end, this.tag);
            }

            public static /* synthetic */ Range toRange$default(MutableRange mutableRange, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = Integer.MIN_VALUE;
                }
                return mutableRange.toRange(n);
            }

            public final T component1() {
                return this.item;
            }

            public final int component2() {
                return this.start;
            }

            public final int component3() {
                return this.end;
            }

            @NotNull
            public final String component4() {
                return this.tag;
            }

            @NotNull
            public final MutableRange<T> copy(T item, int start, int end, @NotNull String tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                return new MutableRange<T>(item, start, end, tag);
            }

            public static /* synthetic */ MutableRange copy$default(MutableRange mutableRange, Object object, int n, int n2, String string, int n3, Object object2) {
                if ((n3 & 1) != 0) {
                    object = mutableRange.item;
                }
                if ((n3 & 2) != 0) {
                    n = mutableRange.start;
                }
                if ((n3 & 4) != 0) {
                    n2 = mutableRange.end;
                }
                if ((n3 & 8) != 0) {
                    string = mutableRange.tag;
                }
                return mutableRange.copy(object, n, n2, string);
            }

            @NotNull
            public String toString() {
                return "MutableRange(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ')';
            }

            public int hashCode() {
                int result = this.item == null ? 0 : this.item.hashCode();
                result = result * 31 + Integer.hashCode(this.start);
                result = result * 31 + Integer.hashCode(this.end);
                result = result * 31 + this.tag.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MutableRange)) {
                    return false;
                }
                MutableRange mutableRange = (MutableRange)other;
                if (!Intrinsics.areEqual(this.item, mutableRange.item)) {
                    return false;
                }
                if (this.start != mutableRange.start) {
                    return false;
                }
                if (this.end != mutableRange.end) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tag, (Object)mutableRange.tag);
            }
        }
    }
}

