/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android.animation;

import android.text.Layout;
import androidx.compose.ui.text.android.CharSequenceCharacterIterator;
import androidx.compose.ui.text.android.InternalPlatformTextApi;
import androidx.compose.ui.text.android.LayoutCompatKt;
import androidx.compose.ui.text.android.LayoutHelper;
import androidx.compose.ui.text.android.animation.Segment;
import androidx.compose.ui.text.android.animation.SegmentType;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalPlatformTextApi
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/text/android/animation/SegmentBreaker;", "", "()V", "breakInWords", "", "", "layoutHelper", "Landroidx/compose/ui/text/android/LayoutHelper;", "breakOffsets", "segmentType", "Landroidx/compose/ui/text/android/animation/SegmentType;", "breakSegmentWithChar", "Landroidx/compose/ui/text/android/animation/Segment;", "dropSpaces", "", "breakSegmentWithDocument", "breakSegmentWithLine", "breakSegmentWithParagraph", "breakSegmentWithWord", "breakSegments", "breakWithBreakIterator", "text", "", "breaker", "Ljava/text/BreakIterator;", "ui-text_release"})
public final class SegmentBreaker {
    @NotNull
    public static final SegmentBreaker INSTANCE = new SegmentBreaker();

    private SegmentBreaker() {
    }

    private final List<Integer> breakInWords(LayoutHelper layoutHelper) {
        CharSequence text = layoutHelper.getLayout().getText();
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        BreakIterator breakIterator = BreakIterator.getLineInstance(Locale.getDefault());
        Intrinsics.checkNotNullExpressionValue((Object)breakIterator, (String)"getLineInstance(Locale.getDefault())");
        List<Integer> words = this.breakWithBreakIterator(text, breakIterator);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n = 0;
        boolean bl = false;
        TreeSet<Integer> $this$breakInWords_u24lambda_u2d1 = treeSet;
        boolean bl2 = false;
        List<Integer> $this$fastForEach$iv = words;
        boolean $i$f$fastForEach = false;
        int n2 = 0;
        n2 = 0;
        int n3 = $this$fastForEach$iv.size() + -1;
        if (n2 <= n3) {
            do {
                int index$iv = n2++;
                Integer item$iv = $this$fastForEach$iv.get(index$iv);
                int it = ((Number)item$iv).intValue();
                boolean bl3 = false;
                $this$breakInWords_u24lambda_u2d1.add(it);
            } while (n2 <= n3);
        }
        TreeSet<Integer> set = treeSet;
        int n4 = 0;
        n = layoutHelper.getParagraphCount();
        if (n4 < n) {
            do {
                int paraIndex;
                if ((bl2 = layoutHelper.analyzeBidi(paraIndex = n4++)) == null) continue;
                Bidi bidi = bl2;
                int paragraphStart = layoutHelper.getParagraphStart(paraIndex);
                int n5 = 0;
                int n6 = bidi.getRunCount();
                if (n5 >= n6) continue;
                do {
                    int i = n5++;
                    set.add(bidi.getRunStart(i) + paragraphStart);
                } while (n5 < n6);
            } while (n4 < n);
        }
        return CollectionsKt.toList((Iterable)set);
    }

    private final List<Integer> breakWithBreakIterator(CharSequence text, BreakIterator breaker) {
        CharSequenceCharacterIterator iter = new CharSequenceCharacterIterator(text, 0, text.length());
        Object[] objectArray = new Integer[]{0};
        List res = CollectionsKt.mutableListOf((Object[])objectArray);
        breaker.setText(iter);
        while (breaker.next() != -1) {
            res.add(breaker.current());
        }
        return res;
    }

    @NotNull
    public final List<Integer> breakOffsets(@NotNull LayoutHelper layoutHelper, @NotNull SegmentType segmentType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)layoutHelper, (String)"layoutHelper");
        Intrinsics.checkNotNullParameter((Object)((Object)segmentType), (String)"segmentType");
        Layout layout = layoutHelper.getLayout();
        CharSequence text = layout.getText();
        SegmentType segmentType2 = segmentType;
        int n = WhenMappings.$EnumSwitchMapping$0[segmentType2.ordinal()];
        switch (n) {
            case 1: {
                Object[] objectArray = new Integer[]{0, text.length()};
                object = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case 2: {
                Object object2 = new Integer[]{0};
                object2 = CollectionsKt.mutableListOf((Object[])object2);
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                int n2 = 0;
                int n3 = layoutHelper.getParagraphCount();
                if (n2 < n3) {
                    do {
                        int i = n2++;
                        it.add(layoutHelper.getParagraphEnd(i));
                    } while (n2 < n3);
                }
                object = object2;
                break;
            }
            case 3: {
                Object object3 = new Integer[]{0};
                object3 = CollectionsKt.mutableListOf((Object[])object3);
                boolean bl = false;
                boolean bl4 = false;
                Object it = object3;
                boolean bl5 = false;
                int n4 = 0;
                int n5 = layout.getLineCount();
                if (n4 < n5) {
                    do {
                        int i = n4++;
                        it.add(layout.getLineEnd(i));
                    } while (n4 < n5);
                }
                object = object3;
                break;
            }
            case 4: {
                object = this.breakInWords(layoutHelper);
                break;
            }
            case 5: {
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                BreakIterator breakIterator = BreakIterator.getCharacterInstance(Locale.getDefault());
                Intrinsics.checkNotNullExpressionValue((Object)breakIterator, (String)"getCharacterInstance(Locale.getDefault())");
                object = this.breakWithBreakIterator(text, breakIterator);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    @NotNull
    public final List<Segment> breakSegments(@NotNull LayoutHelper layoutHelper, @NotNull SegmentType segmentType, boolean dropSpaces) {
        List<Segment> list;
        Intrinsics.checkNotNullParameter((Object)layoutHelper, (String)"layoutHelper");
        Intrinsics.checkNotNullParameter((Object)((Object)segmentType), (String)"segmentType");
        SegmentType segmentType2 = segmentType;
        int n = WhenMappings.$EnumSwitchMapping$0[segmentType2.ordinal()];
        switch (n) {
            case 1: {
                list = this.breakSegmentWithDocument(layoutHelper);
                break;
            }
            case 2: {
                list = this.breakSegmentWithParagraph(layoutHelper);
                break;
            }
            case 3: {
                list = this.breakSegmentWithLine(layoutHelper, dropSpaces);
                break;
            }
            case 4: {
                list = this.breakSegmentWithWord(layoutHelper, dropSpaces);
                break;
            }
            case 5: {
                list = this.breakSegmentWithChar(layoutHelper, dropSpaces);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private final List<Segment> breakSegmentWithDocument(LayoutHelper layoutHelper) {
        return CollectionsKt.listOf((Object)new Segment(0, layoutHelper.getLayout().getText().length(), 0, 0, layoutHelper.getLayout().getWidth(), layoutHelper.getLayout().getHeight()));
    }

    private final List<Segment> breakSegmentWithParagraph(LayoutHelper layoutHelper) {
        boolean bl = false;
        List result = new ArrayList();
        Layout layout = layoutHelper.getLayout();
        int n = 0;
        int n2 = layoutHelper.getParagraphCount();
        if (n < n2) {
            do {
                int i = n++;
                int paraStart = layoutHelper.getParagraphStart(i);
                int paraEnd = layoutHelper.getParagraphEnd(i);
                int paraFirstLine = LayoutCompatKt.getLineForOffset(layout, paraStart, false);
                int paraLastLine = LayoutCompatKt.getLineForOffset(layout, paraEnd, true);
                result.add(new Segment(paraStart, paraEnd, 0, layout.getLineTop(paraFirstLine), layout.getWidth(), layout.getLineBottom(paraLastLine)));
            } while (n < n2);
        }
        return result;
    }

    private final List<Segment> breakSegmentWithLine(LayoutHelper layoutHelper, boolean dropSpaces) {
        boolean bl = false;
        List result = new ArrayList();
        Layout layout = layoutHelper.getLayout();
        int n = 0;
        int n2 = layoutHelper.getLayout().getLineCount();
        if (n < n2) {
            do {
                int n3;
                int n4;
                boolean bl2;
                float f;
                int i = n++;
                int n6 = layout.getLineStart(i);
                n6 = layout.getLineEnd(i);
                if (dropSpaces) {
                    f = layout.getLineLeft(i);
                    bl2 = false;
                    n4 = (int)Math.ceil(f);
                } else {
                    n4 = false;
                }
                int n7 = layout.getLineTop(i);
                if (dropSpaces) {
                    f = layout.getLineRight(i);
                    bl2 = false;
                    n3 = (int)Math.ceil(f);
                } else {
                    n3 = layout.getWidth();
                }
                result.add(new Segment(n5, n6, n4, n7, n3, layout.getLineBottom(i)));
            } while (n < n2);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Segment> breakSegmentWithWord(LayoutHelper layoutHelper, boolean dropSpaces) {
        List list;
        Layout layout = layoutHelper.getLayout();
        float f = layout.getPaint().measureText(" ");
        boolean bl = false;
        int wsWidth = (int)Math.ceil(f);
        List<Integer> $this$fastZipWithNext$iv = this.breakOffsets(layoutHelper, SegmentType.Word);
        boolean $i$f$fastZipWithNext = false;
        boolean bl2 = false;
        if ($this$fastZipWithNext$iv.size() == 0 || $this$fastZipWithNext$iv.size() == 1) {
            list = CollectionsKt.emptyList();
        } else {
            boolean bl3 = false;
            List result$iv = new ArrayList();
            Integer current$iv = $this$fastZipWithNext$iv.get(0);
            int n = 0;
            int n2 = CollectionsKt.getLastIndex($this$fastZipWithNext$iv);
            if (n < n2) {
                do {
                    int lineEnd;
                    void end;
                    void start;
                    int i$iv = n++;
                    Integer next$iv = $this$fastZipWithNext$iv.get(i$iv + 1);
                    int n3 = ((Number)next$iv).intValue();
                    int n4 = ((Number)current$iv).intValue();
                    List list2 = result$iv;
                    boolean bl4 = false;
                    int lineNo = LayoutCompatKt.getLineForOffset(layout, (int)start, false);
                    boolean paraRTL = layout.getParagraphDirection(lineNo) == -1;
                    boolean runRtl = layout.isRtlCharAt((int)start);
                    float f2 = layoutHelper.getHorizontalPosition((int)start, runRtl == paraRTL, false);
                    boolean bl5 = false;
                    int startPos = (int)Math.ceil(f2);
                    float f3 = layoutHelper.getHorizontalPosition((int)end, runRtl == paraRTL, true);
                    boolean bl6 = false;
                    int endPos = (int)Math.ceil(f3);
                    bl6 = false;
                    int left = Math.min(startPos, endPos);
                    boolean bl7 = false;
                    int right = Math.max(startPos, endPos);
                    if (dropSpaces && end != false && layout.getText().charAt((int)(end - true)) == ' ' && (lineEnd = layout.getLineEnd(lineNo)) != end) {
                        if (runRtl) {
                            left += wsWidth;
                        } else {
                            right -= wsWidth;
                        }
                    }
                    Segment segment = new Segment((int)start, (int)end, left, layout.getLineTop(lineNo), right, layout.getLineBottom(lineNo));
                    list2.add(segment);
                    current$iv = next$iv;
                } while (n < n2);
            }
            list = result$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Segment> breakSegmentWithChar(LayoutHelper layoutHelper, boolean dropSpaces) {
        boolean bl = false;
        List res = new ArrayList();
        List<Integer> $this$fastZipWithNext$iv = this.breakOffsets(layoutHelper, SegmentType.Character);
        boolean $i$f$fastZipWithNext = false;
        boolean bl2 = false;
        if ($this$fastZipWithNext$iv.size() == 0 || $this$fastZipWithNext$iv.size() == 1) {
            CollectionsKt.emptyList();
        } else {
            boolean bl3 = false;
            List result$iv = new ArrayList();
            Integer current$iv = $this$fastZipWithNext$iv.get(0);
            int n = 0;
            int n2 = CollectionsKt.getLastIndex($this$fastZipWithNext$iv);
            if (n < n2) {
                do {
                    void start;
                    void end;
                    int i$iv = n++;
                    Integer next$iv = $this$fastZipWithNext$iv.get(i$iv + 1);
                    int n3 = ((Number)next$iv).intValue();
                    int n4 = ((Number)current$iv).intValue();
                    List list = result$iv;
                    boolean bl4 = false;
                    Layout layout = layoutHelper.getLayout();
                    if (!dropSpaces || end != start + true || !layoutHelper.isLineEndSpace(layout.getText().charAt((int)start))) {
                        int lineNo = LayoutCompatKt.getLineForOffset(layout, (int)start, false);
                        boolean paraRTL = layout.getParagraphDirection(lineNo) == -1;
                        boolean runRtl = layout.isRtlCharAt((int)start);
                        float f = layoutHelper.getHorizontalPosition((int)start, runRtl == paraRTL, false);
                        boolean bl5 = false;
                        int startPos = (int)Math.ceil(f);
                        float f2 = layoutHelper.getHorizontalPosition((int)end, runRtl == paraRTL, true);
                        boolean bl6 = false;
                        int endPos = (int)Math.ceil(f2);
                        bl5 = false;
                        bl5 = false;
                        res.add(new Segment((int)start, (int)end, Math.min(startPos, endPos), layout.getLineTop(lineNo), Math.max(startPos, endPos), layout.getLineBottom(lineNo)));
                    }
                    Unit unit = Unit.INSTANCE;
                    list.add(unit);
                    current$iv = next$iv;
                } while (n < n2);
            }
        }
        return res;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SegmentType.values().length];
            nArray[SegmentType.Document.ordinal()] = 1;
            nArray[SegmentType.Paragraph.ordinal()] = 2;
            nArray[SegmentType.Line.ordinal()] = 3;
            nArray[SegmentType.Word.ordinal()] = 4;
            nArray[SegmentType.Character.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

