/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import android.text.BoringLayout;
import android.text.Layout;
import android.text.TextDirectionHeuristic;
import android.text.TextPaint;
import androidx.compose.ui.text.android.BoringLayoutFactory;
import androidx.compose.ui.text.android.InternalPlatformTextApi;
import androidx.compose.ui.text.android.LayoutIntrinsicsKt;
import androidx.compose.ui.text.android.TextLayoutKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalPlatformTextApi
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001d\u0010\t\u001a\u0004\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000e\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u0017"}, d2={"Landroidx/compose/ui/text/android/LayoutIntrinsics;", "", "charSequence", "", "textPaint", "Landroid/text/TextPaint;", "textDirectionHeuristic", "", "(Ljava/lang/CharSequence;Landroid/text/TextPaint;I)V", "boringMetrics", "Landroid/text/BoringLayout$Metrics;", "getBoringMetrics", "()Landroid/text/BoringLayout$Metrics;", "boringMetrics$delegate", "Lkotlin/Lazy;", "maxIntrinsicWidth", "", "getMaxIntrinsicWidth", "()F", "maxIntrinsicWidth$delegate", "minIntrinsicWidth", "getMinIntrinsicWidth", "minIntrinsicWidth$delegate", "ui-text_release"})
public final class LayoutIntrinsics {
    @NotNull
    private final Lazy boringMetrics$delegate;
    @NotNull
    private final Lazy minIntrinsicWidth$delegate;
    @NotNull
    private final Lazy maxIntrinsicWidth$delegate;

    public LayoutIntrinsics(@NotNull CharSequence charSequence, @NotNull TextPaint textPaint, int textDirectionHeuristic) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
        Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
        this.boringMetrics$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<BoringLayout.Metrics>(textDirectionHeuristic, charSequence, textPaint){
            final /* synthetic */ int $textDirectionHeuristic;
            final /* synthetic */ CharSequence $charSequence;
            final /* synthetic */ TextPaint $textPaint;
            {
                this.$textDirectionHeuristic = $textDirectionHeuristic;
                this.$charSequence = $charSequence;
                this.$textPaint = $textPaint;
                super(0);
            }

            @Nullable
            public final BoringLayout.Metrics invoke() {
                TextDirectionHeuristic frameworkTextDir = TextLayoutKt.getTextDirectionHeuristic(this.$textDirectionHeuristic);
                return BoringLayoutFactory.INSTANCE.measure(this.$charSequence, this.$textPaint, frameworkTextDir);
            }
        }));
        this.minIntrinsicWidth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Float>(charSequence, textPaint){
            final /* synthetic */ CharSequence $charSequence;
            final /* synthetic */ TextPaint $textPaint;
            {
                this.$charSequence = $charSequence;
                this.$textPaint = $textPaint;
                super(0);
            }

            public final float invoke() {
                return LayoutIntrinsicsKt.minIntrinsicWidth(this.$charSequence, this.$textPaint);
            }
        }));
        this.maxIntrinsicWidth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Float>(this, charSequence, textPaint){
            final /* synthetic */ LayoutIntrinsics this$0;
            final /* synthetic */ CharSequence $charSequence;
            final /* synthetic */ TextPaint $textPaint;
            {
                this.this$0 = $receiver;
                this.$charSequence = $charSequence;
                this.$textPaint = $textPaint;
                super(0);
            }

            public final float invoke() {
                float desiredWidth;
                Float f;
                BoringLayout.Metrics metrics = this.this$0.getBoringMetrics();
                if (metrics == null) {
                    f = null;
                } else {
                    int n = metrics.width;
                    f = Float.valueOf(n);
                }
                Float f2 = f;
                float f3 = desiredWidth = f2 == null ? Layout.getDesiredWidth((CharSequence)this.$charSequence, (int)0, (int)this.$charSequence.length(), (TextPaint)this.$textPaint) : f2.floatValue();
                if (LayoutIntrinsicsKt.access$shouldIncreaseMaxIntrinsic(desiredWidth, this.$charSequence, this.$textPaint)) {
                    desiredWidth += 0.5f;
                }
                return desiredWidth;
            }
        }));
    }

    @Nullable
    public final BoringLayout.Metrics getBoringMetrics() {
        Lazy lazy = this.boringMetrics$delegate;
        boolean bl = false;
        return (BoringLayout.Metrics)lazy.getValue();
    }

    public final float getMinIntrinsicWidth() {
        Lazy lazy = this.minIntrinsicWidth$delegate;
        boolean bl = false;
        return ((Number)lazy.getValue()).floatValue();
    }

    public final float getMaxIntrinsicWidth() {
        Lazy lazy = this.maxIntrinsicWidth$delegate;
        boolean bl = false;
        return ((Number)lazy.getValue()).floatValue();
    }
}

