/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.font;

import android.graphics.Typeface;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.text.font.AndroidFileDescriptorHelper;
import androidx.compose.ui.text.font.AndroidFont;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/text/font/AndroidFileDescriptorFont;", "Landroidx/compose/ui/text/font/AndroidFont;", "fileDescriptor", "Landroid/os/ParcelFileDescriptor;", "weight", "Landroidx/compose/ui/text/font/FontWeight;", "style", "Landroidx/compose/ui/text/font/FontStyle;", "(Landroid/os/ParcelFileDescriptor;Landroidx/compose/ui/text/font/FontWeight;Landroidx/compose/ui/text/font/FontStyle;)V", "getFileDescriptor", "()Landroid/os/ParcelFileDescriptor;", "getStyle", "()Landroidx/compose/ui/text/font/FontStyle;", "typeface", "Landroid/graphics/Typeface;", "getTypeface", "()Landroid/graphics/Typeface;", "typefaceInternal", "getWeight", "()Landroidx/compose/ui/text/font/FontWeight;", "ui-text_release"})
@RequiresApi(value=26)
public final class AndroidFileDescriptorFont
implements AndroidFont {
    @NotNull
    private final ParcelFileDescriptor fileDescriptor;
    @NotNull
    private final FontWeight weight;
    @NotNull
    private final FontStyle style;
    @NotNull
    private final Typeface typefaceInternal;

    public AndroidFileDescriptorFont(@NotNull ParcelFileDescriptor fileDescriptor, @NotNull FontWeight weight, @NotNull FontStyle style) {
        Intrinsics.checkNotNullParameter((Object)fileDescriptor, (String)"fileDescriptor");
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        this.fileDescriptor = fileDescriptor;
        this.weight = weight;
        this.style = style;
        if (Build.VERSION.SDK_INT < 26) {
            throw new IllegalArgumentException("Cannot create font from file descriptor for SDK < 26");
        }
        this.typefaceInternal = AndroidFileDescriptorHelper.INSTANCE.create(this.fileDescriptor);
    }

    public /* synthetic */ AndroidFileDescriptorFont(ParcelFileDescriptor parcelFileDescriptor, FontWeight fontWeight, FontStyle fontStyle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n & 4) != 0) {
            fontStyle = FontStyle.Normal;
        }
        this(parcelFileDescriptor, fontWeight, fontStyle);
    }

    @NotNull
    public final ParcelFileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    @Override
    @NotNull
    public FontWeight getWeight() {
        return this.weight;
    }

    @Override
    @NotNull
    public FontStyle getStyle() {
        return this.style;
    }

    @Override
    @NotNull
    public Typeface getTypeface() {
        return this.typefaceInternal;
    }
}

