/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.Stable;
import androidx.compose.ui.text.AndroidTextStyle_androidKt;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.PlatformParagraphStyle;
import androidx.compose.ui.text.SpanStyleKt;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.text.style.TextIndent;
import androidx.compose.ui.text.style.TextIndentKt;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a&\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\"\u0013\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"DefaultLineHeight", "Landroidx/compose/ui/unit/TextUnit;", "J", "lerp", "Landroidx/compose/ui/text/ParagraphStyle;", "start", "stop", "fraction", "", "lerpPlatformStyle", "Landroidx/compose/ui/text/PlatformParagraphStyle;", "resolveParagraphStyleDefaults", "style", "direction", "Landroidx/compose/ui/unit/LayoutDirection;", "ui-text_release"})
public final class ParagraphStyleKt {
    private static final long DefaultLineHeight = TextUnit.Companion.getUnspecified-XSAIIZE();

    @Stable
    @NotNull
    public static final ParagraphStyle lerp(@NotNull ParagraphStyle start, @NotNull ParagraphStyle stop, float fraction) {
        TextIndent textIndent;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
        long l = SpanStyleKt.lerpTextUnitInheritable-C3pnCVY(start.getLineHeight-XSAIIZE(), stop.getLineHeight-XSAIIZE(), fraction);
        TextIndent textIndent2 = start.getTextIndent();
        if (textIndent2 == null) {
            textIndent2 = TextIndent.Companion.getNone();
        }
        if ((textIndent = stop.getTextIndent()) == null) {
            textIndent = TextIndent.Companion.getNone();
        }
        return new ParagraphStyle(SpanStyleKt.lerpDiscrete(start.getTextAlign-buA522U(), stop.getTextAlign-buA522U(), fraction), SpanStyleKt.lerpDiscrete(start.getTextDirection-mmuk1to(), stop.getTextDirection-mmuk1to(), fraction), l, TextIndentKt.lerp(textIndent2, textIndent, fraction), ParagraphStyleKt.lerpPlatformStyle(start.getPlatformStyle(), stop.getPlatformStyle(), fraction), SpanStyleKt.lerpDiscrete(start.getLineHeightStyle(), stop.getLineHeightStyle(), fraction), null);
    }

    private static final PlatformParagraphStyle lerpPlatformStyle(PlatformParagraphStyle start, PlatformParagraphStyle stop, float fraction) {
        PlatformParagraphStyle platformParagraphStyle;
        PlatformParagraphStyle startNonNull;
        if (start == null && stop == null) {
            return null;
        }
        PlatformParagraphStyle platformParagraphStyle2 = start;
        if (platformParagraphStyle2 == null) {
            platformParagraphStyle2 = startNonNull = PlatformParagraphStyle.Companion.getDefault();
        }
        if ((platformParagraphStyle = stop) == null) {
            platformParagraphStyle = PlatformParagraphStyle.Companion.getDefault();
        }
        PlatformParagraphStyle stopNonNull = platformParagraphStyle;
        return AndroidTextStyle_androidKt.lerp(startNonNull, stopNonNull, fraction);
    }

    @NotNull
    public static final ParagraphStyle resolveParagraphStyleDefaults(@NotNull ParagraphStyle style, @NotNull LayoutDirection direction) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        TextAlign textAlign = style.getTextAlign-buA522U();
        TextAlign textAlign2 = TextAlign.box-impl(textAlign != null ? textAlign.unbox-impl() : TextAlign.Companion.getStart-e0LSkKk());
        TextDirection textDirection = TextDirection.box-impl(TextStyleKt.resolveTextDirection-Yj3eThk(direction, style.getTextDirection-mmuk1to()));
        long l = TextUnitKt.isUnspecified--R2X_6o((long)style.getLineHeight-XSAIIZE()) ? DefaultLineHeight : style.getLineHeight-XSAIIZE();
        TextIndent textIndent = style.getTextIndent();
        if (textIndent == null) {
            textIndent = TextIndent.Companion.getNone();
        }
        return new ParagraphStyle(textAlign2, textDirection, l, textIndent, style.getPlatformStyle(), style.getLineHeightStyle(), null);
    }
}

